/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.BeforeRunTaskAwareConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption,
BeforeRunTaskAwareConfiguration {
    private NpmRunSettings myRunSettings;

    public NpmRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (project == null) {
            NpmRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            NpmRunConfiguration.$$$reportNull$$$0(1);
        }
        if (name == null) {
            NpmRunConfiguration.$$$reportNull$$$0(2);
        }
        super(project, factory, name);
        this.myRunSettings = NpmRunSettings.builder().build();
    }

    @NotNull
    public NpmRunSettings getRunSettings() {
        NpmRunSettings npmRunSettings = this.myRunSettings;
        if (npmRunSettings == null) {
            NpmRunConfiguration.$$$reportNull$$$0(3);
        }
        return npmRunSettings;
    }

    public void setRunSettings(@NotNull NpmRunSettings runSettings) {
        if (runSettings == null) {
            NpmRunConfiguration.$$$reportNull$$$0(4);
        }
        this.myRunSettings = runSettings;
    }

    public void onNewConfigurationCreated() {
        List<VirtualFile> packageJsonFiles;
        NpmRunSettings runSettings = this.myRunSettings;
        if (runSettings.getPackageJsonSystemIndependentPath().isEmpty() && (packageJsonFiles = NpmScriptsService.getInstance(this.getProject()).detectAllBuildfilesInContentRoots(false)).size() == 1) {
            VirtualFile packageJson = packageJsonFiles.get(0);
            this.myRunSettings = runSettings.toBuilder().setPackageJsonPath(packageJson.getPath()).build();
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            NpmRunConfiguration.$$$reportNull$$$0(5);
        }
        super.readExternal(element);
        this.setRunSettings(NpmRunSettings.readExternal(element));
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            NpmRunConfiguration.$$$reportNull$$$0(6);
        }
        super.writeExternal(element);
        this.myRunSettings.writeExternal(element);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new NpmRunConfigurationEditor(this.getProject());
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NpmRunConfigurationUtil.check(this.getProject(), this.myRunSettings);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            NpmRunConfiguration.$$$reportNull$$$0(7);
        }
        if (environment == null) {
            NpmRunConfiguration.$$$reportNull$$$0(8);
        }
        return new NpmRunProfileState(this.myRunSettings, environment);
    }

    @Nullable
    public String suggestedName() {
        NpmRunSettings runSettings = this.myRunSettings;
        @Nls StringBuilder builder = new StringBuilder();
        String args = runSettings.getArguments().trim();
        if (runSettings.getCommand() == NpmCommand.RUN_SCRIPT) {
            StringUtil.join(runSettings.getScriptNames(), (String)" ", (StringBuilder)builder);
            if (builder.length() == 0) {
                builder.append(runSettings.getCommand().getCliOption());
            }
        } else {
            builder.append(runSettings.getCommand().getCliOption());
        }
        if (!args.isEmpty()) {
            builder.append(" ").append(args);
        }
        return builder.toString();
    }

    @Override
    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.myRunSettings.getInterpreterRef().resolve(this.getProject());
    }

    @Override
    public boolean hasConfiguredDebugAddress() {
        return false;
    }

    public boolean useRunExecutor() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRunSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

