/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.javascript.jest.coverage.JestCoverageEngine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.testing.CoverageProjectDataLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JestCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(JestCoverageRunner.class);
    private String myWorkingDirectory;
    private NodeJsInterpreter myInterpreter;

    JestCoverageRunner() {
    }

    public void setWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public void setInterpreter(@Nullable NodeJsInterpreter interpreter) {
        this.myInterpreter = interpreter;
    }

    @NotNull
    public static JestCoverageRunner getInstance() {
        JestCoverageRunner jestCoverageRunner = Objects.requireNonNull((JestCoverageRunner)CoverageRunner.getInstance(JestCoverageRunner.class));
        if (jestCoverageRunner == null) {
            JestCoverageRunner.$$$reportNull$$$0(0);
        }
        return jestCoverageRunner;
    }

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        if (sessionDataFile == null) {
            JestCoverageRunner.$$$reportNull$$$0(1);
        }
        File basePathDir = this.getBaseDir();
        try {
            return CoverageProjectDataLoader.readProjectData(sessionDataFile, basePathDir, this.myInterpreter);
        }
        catch (Exception e) {
            LOG.warn("Can't read coverage data", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private File getBaseDir() {
        String basePath = this.myWorkingDirectory;
        if (basePath != null) {
            return new File(basePath);
        }
        return new File(".");
    }

    @NotNull
    public String getPresentableName() {
        return "Jest Test Run";
    }

    @NotNull
    public String getId() {
        return "JestJavaScriptTestRunnerCoverage";
    }

    @NotNull
    public String getDataFileExtension() {
        return "info";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            JestCoverageRunner.$$$reportNull$$$0(2);
        }
        return engine instanceof JestCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/coverage/JestCoverageRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/coverage/JestCoverageRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

