/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dataFlow;

import com.intellij.psi.PsiElement;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper$WhenMappings;
import com.intellij.sql.dataFlow.SqlErrorSpecInfo;
import com.intellij.sql.dataFlow.SqlErrorSpecMatch;
import com.intellij.sql.dataFlow.SqlStateInfo;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlErrorSpec;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlConditionDefinition;
import com.intellij.sql.psi.impl.SqlConditionErrorSpec;
import com.intellij.sql.psi.impl.SqlErrorCodeSpec;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlSpecialErrorSpec;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0001H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/dataFlow/SqlErrorSpecHelper;", "", "()V", "getDefaultErrorCode", "sqlState", "Lcom/intellij/sql/dataFlow/SqlStateInfo;", "context", "Lcom/intellij/psi/PsiElement;", "getNotFoundErrorSpec", "Lcom/intellij/sql/dataFlow/SqlErrorSpecInfo;", "getSqlStateByErrorCode", "errorCode", "match", "Lcom/intellij/sql/dataFlow/SqlErrorSpecMatch;", "errorSpec", "pattern", "resolveSpec", "Lcom/intellij/sql/psi/SqlErrorSpec;", "Companion", "intellij.database.sql.core.impl"})
public class SqlErrorSpecHelper {
    @JvmField
    @NotNull
    public static final SqlErrorSpecHelper DEFAULT_INSTANCE;
    @NotNull
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public SqlErrorSpecInfo resolveSpec(@Nullable SqlErrorSpec errorSpec, @Nullable PsiElement context) {
        SqlErrorSpecInfo sqlErrorSpecInfo;
        SqlErrorSpec sqlErrorSpec = errorSpec;
        if (sqlErrorSpec instanceof SqlSpecialErrorSpec) {
            SqlSpecialErrorSpec.Kind kind = ((SqlSpecialErrorSpec)errorSpec).getErrorKind();
            if (kind == null) return null;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)kind), (String)"errorSpec.errorKind ?: return null");
            SqlSpecialErrorSpec.Kind kind2 = kind;
            SqlStateInfo.Wildcard sqlState = new SqlStateInfo.Wildcard(kind2);
            Object errorCode = this.getDefaultErrorCode(sqlState, context);
            sqlErrorSpecInfo = new SqlErrorSpecInfo(sqlState, errorCode);
            return sqlErrorSpecInfo;
        } else if (sqlErrorSpec instanceof SqlErrorCodeSpec) {
            SqlExpression sqlExpression = ((SqlErrorCodeSpec)errorSpec).getErrorCode();
            if (!(sqlExpression instanceof SqlLiteralExpression)) {
                sqlExpression = null;
            }
            SqlLiteralExpression sqlLiteralExpression = (SqlLiteralExpression)sqlExpression;
            if (sqlLiteralExpression == null) return null;
            SqlLiteralExpression literal = sqlLiteralExpression;
            if (literal instanceof SqlStringLiteralExpression) {
                String string = ((SqlStringLiteralExpression)literal).getValue();
                if (string == null) return null;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"literal.value ?: return null");
                String value2 = string;
                SqlStateInfo.Specific sqlState = new SqlStateInfo.Specific(value2);
                Object errorCode = this.getDefaultErrorCode(sqlState, context);
                sqlErrorSpecInfo = new SqlErrorSpecInfo(sqlState, errorCode);
                return sqlErrorSpecInfo;
            } else {
                String string = literal.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"literal.text");
                Integer n = StringsKt.toIntOrNull((String)string);
                if (n == null) return null;
                int errorCode = n;
                SqlStateInfo sqlStateInfo = this.getSqlStateByErrorCode(errorCode);
                if (sqlStateInfo == null) return null;
                SqlStateInfo sqlState = sqlStateInfo;
                sqlErrorSpecInfo = new SqlErrorSpecInfo(sqlState, errorCode);
            }
            return sqlErrorSpecInfo;
        } else {
            if (!(sqlErrorSpec instanceof SqlConditionErrorSpec)) return null;
            PsiElement target = ((SqlConditionErrorSpec)errorSpec).resolve();
            if (target instanceof SqlConditionDefinition) {
                SqlErrorCodeSpec sqlErrorCodeSpec = ((SqlConditionDefinition)target).getErrorSpec();
                if (sqlErrorCodeSpec == null) return null;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlErrorCodeSpec), (String)"target.errorSpec ?: return null");
                SqlErrorCodeSpec targetSpec = sqlErrorCodeSpec;
                sqlErrorSpecInfo = this.resolveSpec(targetSpec, context);
                return sqlErrorSpecInfo;
            } else {
                Object object = target;
                if (object == null) {
                    SqlReferenceImpl sqlReferenceImpl = ((SqlConditionErrorSpec)errorSpec).getReference();
                    Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceImpl, (String)"errorSpec.reference");
                    String string = sqlReferenceImpl.getCanonicalText();
                    boolean bl = false;
                    boolean bl2 = false;
                    String name = string;
                    boolean bl3 = false;
                    SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)errorSpec);
                    Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"SqlImplUtil.getSqlDialectSafe(errorSpec)");
                    if (!sqlLanguageDialectEx.getExceptionNames().contains(name)) return null;
                    String string2 = name;
                    if (string2 == null) return null;
                    string = string2;
                    bl = false;
                    String string3 = string;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toUpperCase();
                    object = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
                }
                if (object == null) return null;
                PsiElement errorCode = object;
                return new SqlErrorSpecInfo(SqlStateInfo.Unknown.INSTANCE, errorCode);
            }
        }
    }

    @Nullable
    public SqlErrorSpecInfo getNotFoundErrorSpec() {
        return null;
    }

    @Nullable
    public Object getDefaultErrorCode(@NotNull SqlStateInfo sqlState, @Nullable PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)sqlState, (String)"sqlState");
        return null;
    }

    @Nullable
    public SqlStateInfo getSqlStateByErrorCode(@NotNull Object errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SqlErrorSpecMatch match(@NotNull SqlErrorSpecInfo errorSpec, @NotNull SqlErrorSpecInfo pattern) {
        boolean bl;
        Object object;
        Object object2;
        void sqlState;
        void patternSqlState;
        Intrinsics.checkNotNullParameter((Object)errorSpec, (String)"errorSpec");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Object object3 = errorSpec;
        SqlStateInfo sqlStateInfo = ((SqlErrorSpecInfo)object3).component1();
        Object errorCode = ((SqlErrorSpecInfo)object3).component2();
        SqlErrorSpecInfo sqlErrorSpecInfo = pattern;
        object3 = sqlErrorSpecInfo.component1();
        Object patternErrorCode = sqlErrorSpecInfo.component2();
        if (patternErrorCode != null && Intrinsics.areEqual((Object)patternErrorCode, (Object)errorCode)) {
            return new SqlErrorSpecMatch.Matched(0);
        }
        if (Intrinsics.areEqual((Object)patternSqlState, (Object)SqlStateInfo.Unknown.INSTANCE) ^ true && Intrinsics.areEqual((Object)patternSqlState, (Object)sqlState)) {
            return new SqlErrorSpecMatch.Matched(1);
        }
        Object v0 = patternSqlState;
        if (!(v0 instanceof SqlStateInfo.Wildcard)) {
            v0 = null;
        }
        if ((object2 = (SqlStateInfo.Wildcard)v0) == null || (object2 = ((SqlStateInfo.Wildcard)object2).getKind()) == null) {
            return SqlErrorSpecMatch.Unmatched.INSTANCE;
        }
        Object patternKind = object2;
        if (Intrinsics.areEqual((Object)sqlState, (Object)SqlStateInfo.Unknown.INSTANCE) && patternKind == SqlSpecialErrorSpec.Kind.OTHERS) {
            return new SqlErrorSpecMatch.Matched(2);
        }
        Object v2 = sqlState;
        if (!(v2 instanceof SqlStateInfo.Specific)) {
            v2 = null;
        }
        if ((object = (SqlStateInfo.Specific)v2) == null || (object = ((SqlStateInfo.Specific)object).getValue()) == null) {
            return SqlErrorSpecMatch.Unmatched.INSTANCE;
        }
        Object sqlStateValue = object;
        switch (SqlErrorSpecHelper$WhenMappings.$EnumSwitchMapping$0[((Enum)patternKind).ordinal()]) {
            case 1: {
                bl = StringsKt.startsWith$default((String)sqlStateValue, (String)"01", (boolean)false, (int)2, null);
                break;
            }
            case 2: {
                bl = StringsKt.startsWith$default((String)sqlStateValue, (String)"02", (boolean)false, (int)2, null);
                break;
            }
            case 3: {
                if (!(StringsKt.startsWith$default((String)sqlStateValue, (String)"00", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sqlStateValue, (String)"01", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sqlStateValue, (String)"02", (boolean)false, (int)2, null))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean matchesWildcard = bl;
        return matchesWildcard ? (SqlErrorSpecMatch)new SqlErrorSpecMatch.Matched(2) : (SqlErrorSpecMatch)SqlErrorSpecMatch.Unmatched.INSTANCE;
    }

    static {
        Companion = new Companion(null);
        DEFAULT_INSTANCE = new SqlErrorSpecHelper();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/dataFlow/SqlErrorSpecHelper$Companion;", "", "()V", "DEFAULT_INSTANCE", "Lcom/intellij/sql/dataFlow/SqlErrorSpecHelper;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

