/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.diagnostic.LogInterceptor;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.DvTreeIcons;
import com.intellij.database.view.HostGroup;
import com.intellij.database.view.NodeGroup;
import com.intellij.database.view.structure.DvExtraNode;
import com.intellij.database.view.structure.DvFilteredFamily;
import com.intellij.database.view.structure.DvFun;
import com.intellij.database.view.structure.DvTreeIconItem;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.structure.DvUnnestFamily;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Color;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor {
    public static final SimpleTextAttributes INACTIVE_LINK_ATTRS = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.derive(SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.getStyle() | 0x200, null, null, null);
    public static final SimpleTextAttributes ACTIVE_LINK_ATTRS = INACTIVE_LINK_ATTRS.derive(INACTIVE_LINK_ATTRS.getStyle() | 0x400, UIUtil.getLabelForeground(), null, null);
    static final String spaceDelimiter = "\u2002";

    public static void updatePresentation(@NotNull PresentationData presentation, @NotNull BasicNode node, @NotNull Project project, @NotNull DatabaseViewOptions viewOptions, @Nullable DvTreeStructureService service, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (node == null) {
            DbNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(2);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(3);
        }
        presentation.clear();
        if (project.isDisposed()) {
            return;
        }
        String nodeText = service != null ? service.presentableNameOf(node) : node.getDisplayName();
        Icon nodeIcon = null;
        if (node instanceof BasicElement) {
            BasicElement e = (BasicElement)node;
            ObjectKind kind = e.getKind();
            nodeIcon = DbPresentation.getIcon(e);
            if (service != null && kind == ObjectKind.BODY) {
                nodeText = DatabaseBundle.message("ObjectKind.body", new Object[0]);
            }
        } else if (node instanceof HostFamily) {
            if (service == null) {
                nodeText = DvFun.getFamilyPresentableName((HostFamily)node);
            }
            nodeIcon = DatabaseIcons.ObjectGroup;
        } else if (node instanceof DvExtraNode) {
            DvExtraNode eNode = (DvExtraNode)node;
            DvTreeIconItem iconItem = eNode.getIconItem();
            if (iconItem != null) {
                nodeIcon = DvTreeIcons.TREE_NODE_ITEMS.get((Object)iconItem);
            }
        } else if (node instanceof NodeGroup) {
            nodeIcon = ((NodeGroup)node).getIcon(false);
        } else if (node instanceof DasObject) {
            nodeText = DbPresentation.getPresentableName((DasObject)((Object)node), false);
        }
        presentation.setIcon(nodeIcon);
        DbNodeDescriptor.setNodePrimaryText(presentation, project, viewOptions, node, nodeText);
        if (node instanceof DataSourceNode) {
            DbNodeDescriptor.updatePresentationForDataSource(presentation, (DataSourceNode)node, project, viewOptions, pathUnderMouse);
        } else if (node instanceof DvTreeLayoutLayer.EmptyScopeLeaf) {
            DbNodeDescriptor.updatePresentationForEmptyScopeLeaf(presentation, (DvTreeLayoutLayer.EmptyScopeLeaf)node, pathUnderMouse);
        } else if (node instanceof DatabaseStructure.EmptyScopeLeaf) {
            DbNodeDescriptor.updatePresentationForEmptyScopeLeaf(presentation, (DatabaseStructure.EmptyScopeLeaf)node, pathUnderMouse);
        } else if (node instanceof Family) {
            int cnt = service != null ? service.countChildrenOf(node) : ((Family)node).size();
            DbNodeDescriptor.showCount(presentation, cnt);
        } else if (node instanceof DvFilteredFamily) {
            int cnt = 0;
            if (service != null) {
                cnt = service.countChildrenOf(node);
            }
            DbNodeDescriptor.showCount(presentation, cnt);
        } else if (node instanceof DvUnnestFamily) {
            int cnt = 0;
            if (service != null) {
                cnt = service.countChildrenOf(node);
            }
            DbNodeDescriptor.showCount(presentation, cnt);
        } else if (node instanceof DatabaseStructure.FamilyGroup) {
            DbNodeDescriptor.showCount(presentation, ((DatabaseStructure.FamilyGroup)node).getSize());
        } else if (node instanceof DatabaseStructure.DbGroup) {
            DbNodeDescriptor.showCount(presentation, ((DatabaseStructure.DbGroup)node).getSize());
        } else if (node instanceof DasObject) {
            DbNodeDescriptor.updatePresentationAdditions(presentation, (DasObject)((Object)node), project, viewOptions, pathUnderMouse);
        }
    }

    public static void updatePresentation(@NotNull PresentationData presentation, @NotNull DasObject element2, @NotNull Project project, @NotNull DatabaseViewOptions viewOptions, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(5);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(6);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(7);
        }
        presentation.clear();
        if (project.isDisposed()) {
            return;
        }
        presentation.setIcon(DbPresentation.getIcon(element2));
        String nodeText = DbPresentation.getPresentableName(element2, false);
        DbNodeDescriptor.setNodePrimaryText(presentation, project, viewOptions, element2, nodeText);
        DbNodeDescriptor.updatePresentationAdditions(presentation, element2, project, viewOptions, pathUnderMouse);
    }

    private static void updatePresentationAdditions(@NotNull PresentationData presentation, @NotNull DasObject element2, @NotNull Project project, @NotNull DatabaseViewOptions viewOptions, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(9);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(10);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(11);
        }
        String comment = DbNodeDescriptor.adjustCommentString(element2.getComment());
        Dbms dbms = element2 instanceof BasicElement ? DbImplUtilCore.getDbms((BasicElement)element2) : Dbms.UNKNOWN;
        DescriptionService service = ModelFacade.forDbms(dbms).getDescriptionService();
        boolean commentsMode = UISettings.getInstance().getShowInplaceComments();
        if (!commentsMode || StringUtil.isEmpty((String)comment)) {
            service.updatePresentation(project, element2, presentation);
        }
        if (element2 instanceof BasicNamespaceOwner) {
            boolean activate = pathUnderMouse != null && element2 == pathUnderMouse.getLastPathComponent();
            DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, element2, project, viewOptions, activate);
        }
        if (StringUtil.isNotEmpty((String)comment)) {
            DbNodeDescriptor.addTooltip(presentation, true, "<pre>" + StringUtil.escapeXmlEntities((String)comment) + "</pre>");
            if (commentsMode) {
                DbNodeDescriptor.addSpaceDelimiter(presentation);
                presentation.addText(comment, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
    }

    public static void updatePresentationForDataSource(@NotNull PresentationData presentation, @NotNull DataSourceNode dsn, @NotNull Project project, @NotNull DatabaseViewOptions viewOptions, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(12);
        }
        if (dsn == null) {
            DbNodeDescriptor.$$$reportNull$$$0(13);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(14);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(15);
        }
        presentation.clear();
        if (project.isDisposed()) {
            return;
        }
        DbDataSource ds = dsn.dbDataSource;
        presentation.setIcon(DbNodeDescriptor.getDataSourceIcon(ds));
        boolean commentsMode = UISettings.getInstance().getShowInplaceComments();
        String nodeText = DbPresentation.getPresentableName(ds, false);
        presentation.setPresentableText(nodeText);
        DbNodeDescriptor.setNodePrimaryText(presentation, project, viewOptions, ds, nodeText);
        String comment = DbNodeDescriptor.adjustCommentString(ds.getComment());
        DbNodeDescriptor.appendCollapsedNamespaces(project, presentation, ds, viewOptions);
        boolean activate = pathUnderMouse != null && dsn == pathUnderMouse.getLastPathComponent();
        DbNodeDescriptor.appendNamespaceChooserLinkWithCounters(presentation, ds, project, viewOptions, activate);
        if (StringUtil.isNotEmpty((String)comment)) {
            DbNodeDescriptor.addTooltip(presentation, true, "<pre>" + StringUtil.escapeXmlEntities((String)comment) + "</pre>");
            if (commentsMode) {
                DbNodeDescriptor.addSpaceDelimiter(presentation);
                presentation.addText(comment, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
    }

    private static void setNodePrimaryText(@NotNull PresentationData presentation, @NotNull Project project, @NotNull DatabaseViewOptions viewOptions, @NotNull Object node, @NotNull @Nls String nodeText) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(16);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(17);
        }
        if (viewOptions == null) {
            DbNodeDescriptor.$$$reportNull$$$0(18);
        }
        if (node == null) {
            DbNodeDescriptor.$$$reportNull$$$0(19);
        }
        if (nodeText == null) {
            DbNodeDescriptor.$$$reportNull$$$0(20);
        }
        String theText = StringUtil.isEmpty((String)nodeText) ? DbPresentation.UNNAMED : nodeText;
        presentation.setPresentableText(theText);
        SimpleTextAttributes style = DbNodeDescriptor.handleErrors(project, presentation, node, viewOptions);
        if (node instanceof DasObject) {
            style = DbNodeDescriptor.handleModified(project, (DasObject)node, style);
        }
        presentation.addText(theText, style);
        DbNodeDescriptor.addSpaceDelimiter(presentation);
    }

    public static void updatePresentationForEmptyScopeLeaf(@NotNull PresentationData presentation, @NotNull DvTreeLayoutLayer.EmptyScopeLeaf leaf, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(21);
        }
        if (leaf == null) {
            DbNodeDescriptor.$$$reportNull$$$0(22);
        }
        ObjectKind leafKind = leaf.getLeafKind();
        DbNodeDescriptor.updatePresentationForEmptyScopeLeaf(presentation, leaf, leafKind, pathUnderMouse);
    }

    public static void updatePresentationForEmptyScopeLeaf(@NotNull PresentationData presentation, @NotNull DatabaseStructure.EmptyScopeLeaf leaf, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(23);
        }
        if (leaf == null) {
            DbNodeDescriptor.$$$reportNull$$$0(24);
        }
        ObjectKind leafKind = leaf.getKind();
        DbNodeDescriptor.updatePresentationForEmptyScopeLeaf(presentation, leaf, leafKind, pathUnderMouse);
    }

    private static void updatePresentationForEmptyScopeLeaf(@NotNull PresentationData presentation, @NotNull Object leaf, @NotNull ObjectKind leafKind, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(25);
        }
        if (leaf == null) {
            DbNodeDescriptor.$$$reportNull$$$0(26);
        }
        if (leafKind == null) {
            DbNodeDescriptor.$$$reportNull$$$0(27);
        }
        presentation.clear();
        presentation.addText(DatabaseBundle.message("label.no.schemas.selected", leafKind.getPluralPresentableName()), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        presentation.addText("  ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        boolean activate = pathUnderMouse != null && leaf == pathUnderMouse.getLastPathComponent();
        DbNodeDescriptor.appendNamespaceChooserLinkWithoutCounters(presentation, activate);
    }

    private static SimpleTextAttributes handleModified(Project project, DasObject element2, SimpleTextAttributes style) {
        BasicSourceAware sa = (BasicSourceAware)ObjectUtils.tryCast((Object)element2, BasicSourceAware.class);
        DbDataSource dataSource2 = sa == null ? null : ((DvTreeStructureService)project.getService(DvTreeStructureService.class)).findDbDataSource(sa);
        VirtualFile file = dataSource2 == null ? null : DbSrcUtils.findDbSrcFile(dataSource2, sa, false);
        FileStatus status = file == null ? null : DbSrcChangesTracker.getFileStatuses().getStatus(file).getStatus();
        return status == null ? style : style.derive(-1, status.getColor(), null, null);
    }

    @Nullable
    private static Icon getDataSourceIcon(@NotNull DbDataSource element2) {
        if (element2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(28);
        }
        Project project = element2.getProject();
        Icon icon = element2.getIcon();
        if (project.isDisposed()) {
            return icon;
        }
        DatabaseSystem delegate = element2.getDelegate();
        if (delegate instanceof LocalDataSource) {
            LocalDataSource lds = (LocalDataSource)delegate;
            if (DataSourceSyncManager.getInstance().isActive(lds) || lds.isLoading()) {
                return AnimatedIcon.Default.INSTANCE;
            }
            int connectionCount = DbImplUtil.isConnected(project, lds) ? DbImplUtil.getActiveConnectionCount(lds) : 0;
            return LogInterceptor.Companion.loggedIcon(connectionCount > 0 ? ExecutionUtil.getLiveIndicator((Icon)icon) : icon, lds);
        }
        if (delegate instanceof SqlDataSource && !((SqlDataSource)delegate).isReady()) {
            return AnimatedIcon.Default.INSTANCE;
        }
        return icon;
    }

    @NotNull
    public static String adjustCommentString(@Nullable String comment) {
        String string = comment == null ? "" : StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true);
        if (string == null) {
            DbNodeDescriptor.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static void appendNamespaceChooserLinkWithCounters(PresentationData presentation, DasObject element2, Project project, DatabaseViewOptions viewOptions, boolean activate) {
        Couple<Integer> counters = DbNodeDescriptor.getNamespaceCounts(project, element2, viewOptions);
        if (counters == null) {
            return;
        }
        int enabled = (Integer)counters.first;
        int total = (Integer)counters.second;
        String text2 = enabled == 0 && total == 0 ? "  ...  " : (enabled != total ? " " + DatabaseBundle.message("namespace.fraction", enabled, total) + " " : " " + enabled + " ");
        DbNodeDescriptor.appendNamespaceChooserLink(presentation, activate, text2);
    }

    private static void appendNamespaceChooserLinkWithoutCounters(PresentationData presentation, boolean activate) {
        DbNodeDescriptor.appendNamespaceChooserLink(presentation, activate, "  ...  ");
    }

    private static void appendNamespaceChooserLink(PresentationData presentation, boolean activate, String text2) {
        presentation.addText(text2, activate ? ACTIVE_LINK_ATTRS : INACTIVE_LINK_ATTRS);
    }

    @Nullable
    private static Couple<Integer> getNamespaceCounts(Project project, DasObject element2, DatabaseViewOptions viewOptions) {
        DbDataSource dataSource2;
        DbDataSource dbDataSource = element2 instanceof DbDataSource ? (DbDataSource)element2 : (dataSource2 = element2 instanceof BasicNamespaceOwner ? ((DvTreeStructureService)project.getService(DvTreeStructureService.class)).findDbDataSource(element2) : null);
        if (dataSource2 == null) {
            return null;
        }
        DasObject root2 = element2 instanceof BasicNamespaceOwner ? element2 : DatabaseStructure.getTopSingleRoot(dataSource2, viewOptions);
        DbElement dbElement = DbImplUtilCore.findElement(dataSource2, root2);
        if (dbElement == null) {
            return null;
        }
        return (Couple)CachedValuesManager.getCachedValue((PsiElement)dbElement, () -> new CachedValueProvider.Result(DbNodeDescriptor.calcNamespaceCounts(dbElement, viewOptions), new Object[]{DbPsiFacade.getInstance(project), viewOptions}));
    }

    @Nullable
    private static Couple<Integer> calcNamespaceCounts(DbElement dbElement, DatabaseViewOptions viewOptions) {
        JBTreeTraverser<DasObject> traverser;
        DbDataSource dataSource2 = dbElement.getDataSource();
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource(dataSource2);
        if (localDataSource == null) {
            return null;
        }
        DbDataSource element2 = dataSource2 == dbElement ? dataSource2 : (DasObject)dbElement.getDelegate();
        DasModel model = localDataSource.getModel();
        TreePattern scope = localDataSource.getIntrospectionScope();
        if (model instanceof BasicModel) {
            JBTreeTraverser tmp2 = ((BasicModel)model).basicTraverser();
            traverser = element2 instanceof BasicNamespaceOwner ? (JBTreeTraverser)tmp2.withRoot((Object)((BasicElement)((Object)element2))) : tmp2;
        } else {
            traverser = model.traverser();
        }
        Condition kindCondition = element2 == dataSource2 && model instanceof BasicModel && ((BasicModel)model).getRoot().familyOf(ObjectKind.DATABASE) != null ? DasUtil.byKind(ObjectKind.DATABASE) : o -> DbImplUtilCore.isSchema(o);
        JBIterable allSchemas = ((JBTreeTraverser)((JBTreeTraverser)traverser.expandAndFilter(DasUtil.byClass(DasNamespace.class))).filter(kindCondition)).filter(DasNamespace.class);
        int enabled = 0;
        int total = 0;
        for (DasNamespace ns : allSchemas) {
            boolean shown = !viewOptions.HIDDEN_KINDS.contains(ns.getKind().code()) && DatabaseModelLoader.matches(ns, scope);
            enabled += shown ? 1 : 0;
            ++total;
        }
        return Couple.of((Object)enabled, (Object)total);
    }

    private static void appendCollapsedNamespaces(Project project, PresentationData presentation, DasObject element2, DatabaseViewOptions options) {
        String textExt;
        DasObject root2;
        DasObject dasObject = options.SHOW_INTERMEDIATE ? element2 : (element2 instanceof DbDataSource ? DatabaseStructure.getTopSingleRoot((DbDataSource)element2, options) : (root2 = element2 instanceof DasNamespace ? DatabaseStructure.getTopSingleRoot(((DvTreeStructureService)project.getService(DvTreeStructureService.class)).findDbDataSource(element2), element2, options) : element2));
        if (root2 != element2 && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root2)))) {
            presentation.addText("(" + textExt + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            DbNodeDescriptor.addSpaceDelimiter(presentation);
        }
    }

    private static void addSpaceDelimiter(PresentationData presentation) {
        presentation.addText(spaceDelimiter, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private static SimpleTextAttributes handleErrors(Project project, PresentationData presentation, Object element2, DatabaseViewOptions viewOptions) {
        SimpleTextAttributes style;
        boolean hasErrors = false;
        boolean hasWarnings = false;
        int connectionCount = -1;
        if (element2 instanceof DbDataSource) {
            LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource((DbDataSource)element2);
            hasErrors = dataSource2 != null && !DbImplUtilCore.canConnectTo(dataSource2);
            hasWarnings = hasErrors;
            if (!hasErrors) {
                for (DataSourceProblem problem : DatabaseConfigValidator.getProblems(project, ((DbDataSource)element2).getDelegate(), null)) {
                    DataSourceProblem.Level level = problem.getLevel();
                    if (level == DataSourceProblem.Level.WARNING) {
                        hasWarnings = true;
                        continue;
                    }
                    if (level != DataSourceProblem.Level.ERROR) continue;
                    hasErrors = true;
                    hasWarnings = true;
                }
            }
            connectionCount = dataSource2 != null && DbImplUtil.isConnected(project, dataSource2) ? DbImplUtil.getActiveConnectionCount(dataSource2) : -1;
        } else if (element2 instanceof BasicSourceAware) {
            hasErrors = ((BasicSourceAware)element2).isInvalid();
        }
        SimpleTextAttributes simpleTextAttributes = style = element2 instanceof DasObject && DbPresentation.isUnnamed((DasObject)element2) ? DbPresentationCore.INFO_ATTRS : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (viewOptions.SHOW_ALL_NAMESPACES && element2 instanceof DasObject && !DbNodeDescriptor.isIntrospected(project, (DasObject)element2)) {
            style = DbPresentationCore.INFO_ATTRS;
        }
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (hasErrors && element2 instanceof LocalDataSource && !DbImplUtilCore.hasDriverFiles((LocalDataSource)element2)) {
            DbNodeDescriptor.addTooltip(presentation, false, DatabaseBundle.message("tooltip.database.driver.files.not.found.open.properties.to.download", new Object[0]));
        }
        if (connectionCount >= 0) {
            DbNodeDescriptor.addTooltip(presentation, false, DatabaseBundle.message("tooltip.choice.connection.connections", connectionCount, connectionCount == 1 ? 0 : 1));
        }
        return style;
    }

    private static boolean isIntrospected(Project project, DasObject element2) {
        BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)element2, BasicNamespace.class);
        if (namespace == null) {
            return true;
        }
        TreePattern scope = DbImplUtilCore.getIntrospectionScope(((DvTreeStructureService)project.getService(DvTreeStructureService.class)).findDbDataSource(element2));
        return DataSourceSchemaMapping.isIntrospected(scope, namespace);
    }

    private static void showCount(@NotNull PresentationData presentation, int count) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(30);
        }
        if (count > 0) {
            @NlsSafe String countStr = Integer.toString(count);
            DbNodeDescriptor.showCount(presentation, countStr);
        }
    }

    private static void showCount(@NotNull PresentationData presentation, @Nullable @NlsSafe String countStr) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(31);
        }
        if (countStr != null) {
            DbNodeDescriptor.addGrayText(presentation, countStr);
        }
    }

    private static void addGrayText(@NotNull PresentationData presentation, @NotNull @Nls String text2) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(32);
        }
        if (text2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(33);
        }
        presentation.addText(text2, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
    }

    private static void addTooltip(PresentationData presentation, boolean before2, @NlsContexts.Tooltip String tooltip) {
        Object result2;
        String cur2 = presentation.getTooltip();
        if (StringUtil.isEmpty((String)cur2)) {
            result2 = tooltip;
        } else {
            String separator = "<p><p>";
            result2 = before2 ? tooltip + separator + cur2 : cur2 + separator + tooltip;
        }
        presentation.setTooltip((String)(((String)result2).startsWith("<html>") ? result2 : "<html>" + (String)result2));
    }

    @Nullable
    public static Object getData(@NonNls @NotNull String dataId, @NotNull Project project, @NotNull Object node) {
        if (dataId == null) {
            DbNodeDescriptor.$$$reportNull$$$0(34);
        }
        if (project == null) {
            DbNodeDescriptor.$$$reportNull$$$0(35);
        }
        if (node == null) {
            DbNodeDescriptor.$$$reportNull$$$0(36);
        }
        boolean isNav = CommonDataKeys.NAVIGATABLE.is(dataId);
        boolean isPsi = CommonDataKeys.PSI_ELEMENT.is(dataId);
        Object x = node;
        if (x instanceof BasicNode) {
            BasicNode bn = (BasicNode)x;
            if (isNav && bn instanceof DataSourceNode) {
                return DbNavigationUtils.createFromTreeNavigatable(((DataSourceNode)bn).dbDataSource);
            }
            if (isPsi && bn instanceof DataSourceNode) {
                return ((DataSourceNode)bn).dbDataSource;
            }
            if (bn instanceof BasicElement) {
                x = DbNodeDescriptor.findDbElementFor((BasicElement)bn, project);
            } else if (bn instanceof HostGroup) {
                x = DbNodeDescriptor.findDbElementFor(((HostGroup)bn).host, project);
            }
        }
        if (VcsDataKeys.VIRTUAL_FILES.is(dataId)) {
            VirtualFile file;
            LocalDataSource ds;
            DbElement e = (DbElement)ObjectUtils.tryCast((Object)x, DbElement.class);
            if (e == null && x instanceof DataSourceNode) {
                e = ((DataSourceNode)x).dbDataSource;
            }
            LocalDataSource localDataSource = ds = e == null ? null : DbImplUtil.getMaybeLocalDataSource(e.getDataSource());
            if (ds != null) {
                String filePath = DbSrcUtils.getPath(e.getProject(), ds, e, ds.getModel(), DbSrcFileSystemCore.ItemType.SRC);
                file = DbSrcFileSystem.getInstance().findFileByPath(filePath);
                if (file == null) {
                    filePath = DbSrcUtils.getPath(e.getProject(), ds, e, ds.getModel(), null);
                    file = DbSrcFileSystem.getInstance().findFileByPath(filePath);
                }
            } else {
                file = null;
            }
            return file == null ? null : Collections.singletonList(file);
        }
        if (x instanceof DbElement && isNav) {
            return DbNavigationUtils.createFromTreeNavigatable((DbElement)x);
        }
        if (x instanceof DataProvider) {
            return ((DataProvider)x).getData(dataId);
        }
        if (!(x instanceof DasObject)) {
            if (isNav && x instanceof Navigatable) {
                return x;
            }
            if (isPsi && x instanceof PsiElement) {
                return x;
            }
            return null;
        }
        if (!isNav && !isPsi) {
            return null;
        }
        DbDataSource dataSource2 = ((DvTreeStructureService)project.getService(DvTreeStructureService.class)).findDbDataSource((DasObject)x);
        if (dataSource2 == null) {
            return null;
        }
        if (isNav) {
            if (x instanceof Navigatable && ((Navigatable)x).canNavigate()) {
                return x;
            }
            DbElement element2 = DbImplUtilCore.findElement(dataSource2, (DasObject)x);
            return element2 == null ? null : DbNavigationUtils.createFromTreeNavigatable(element2);
        }
        if (isPsi) {
            return DbImplUtilCore.findElement(dataSource2, (DasObject)x);
        }
        return null;
    }

    @Nullable
    private static DbElement findDbElementFor(@NotNull BasicElement basicElement, @NotNull Project inProject) {
        if (basicElement == null) {
            DbNodeDescriptor.$$$reportNull$$$0(37);
        }
        if (inProject == null) {
            DbNodeDescriptor.$$$reportNull$$$0(38);
        }
        DvTreeStructureService psiFacade = (DvTreeStructureService)inProject.getService(DvTreeStructureService.class);
        return psiFacade.findDbElement(basicElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 19: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 5: 
            case 9: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsn";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeText";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafKind";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basicElement";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustCommentString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentationAdditions";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentationForDataSource";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setNodePrimaryText";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentationForEmptyScopeLeaf";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceIcon";
                break;
            }
            case 29: {
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showCount";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addGrayText";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findDbElementFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

