/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.SqlUiService;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverCore;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorageCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteClob;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteResultSetMetaData;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcInjectable;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.database.util.VirtualFileDataSourceProvider;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbImplUtilCore {
    public static final Map<String, ObjectKind> FILTER_BY_NAME = ContainerUtil.immutableMapBuilder().put((Object)"table", (Object)ObjectKind.TABLE).put((Object)"vtable", (Object)ObjectKind.VIRTUAL_TABLE).put((Object)"ftable", (Object)ObjectKind.FOREIGN_TABLE).put((Object)"view", (Object)ObjectKind.VIEW).put((Object)"mview", (Object)ObjectKind.MAT_VIEW).put((Object)"routine", (Object)ObjectKind.ROUTINE).put((Object)"aggregate", (Object)ObjectKind.AGGREGATE).put((Object)"package", (Object)ObjectKind.PACKAGE).put((Object)"sequence", (Object)ObjectKind.SEQUENCE).put((Object)"synonym", (Object)ObjectKind.SYNONYM).put((Object)"operator", (Object)ObjectKind.OPERATOR).put((Object)"collation", (Object)ObjectKind.COLLATION).put((Object)"role", (Object)ObjectKind.ROLE).put((Object)"user", (Object)ObjectKind.USER).put((Object)"fdw", (Object)ObjectKind.FOREIGN_DATA_WRAPPER).put((Object)"event", (Object)ObjectKind.SCHEDULED_EVENT).build();
    public static final ThrowableConvertor<RemoteResultSet, List<String>, Exception> RS_AS_STRING_LIST = rs -> {
        ArrayList<String> res2 = new ArrayList<String>();
        while (rs.next()) {
            res2.add(rs.getString(1));
        }
        return res2;
    };
    private static final DbmsExtension<JdbcHelper> JDBC_HELPER_EP = new DbmsExtension("com.intellij.database.jdbcHelper");
    public static final int UNLIMITED_PAGE_SIZE = -1;
    private static final Set<Dbms> SUPPORTS_OFFSET_DBS = ContainerUtil.set((Object[])new Dbms[]{Dbms.CLICKHOUSE, Dbms.MONGO, Dbms.HIVE, Dbms.MYSQL, Dbms.MYSQL_AURORA, Dbms.MARIA, Dbms.COCKROACH, Dbms.POSTGRES, Dbms.GREENPLUM, Dbms.REDSHIFT, Dbms.VERTICA, Dbms.SQLITE, Dbms.BIGQUERY, Dbms.COUCHBASE_QUERY});

    protected DbImplUtilCore() {
    }

    public static boolean isTypeKind(@Nullable ObjectKind kind) {
        return kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.COLLECTION_TYPE || kind == ObjectKind.ALIAS_TYPE || kind == ObjectKind.TABLE_TYPE;
    }

    public static boolean isDataTable(@Nullable DasTable info) {
        if (info == null) {
            return false;
        }
        return DbImplUtilCore.isDataTable(info.getKind());
    }

    public static boolean isDataTable(@Nullable ObjectKind kind) {
        return ArrayUtil.contains((Object)kind, (Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.FOREIGN_TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.VIEW, ObjectKind.MAT_VIEW});
    }

    @NotNull
    public static BasicMetaModel<?> getMetaModel(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(0);
        }
        BasicMetaModel<?> basicMetaModel = ModelFacade.forDbms(dbms).getMetaModel();
        if (basicMetaModel == null) {
            DbImplUtilCore.$$$reportNull$$$0(1);
        }
        return basicMetaModel;
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(2);
        }
        if (dialect.getDbms().isSqlite()) {
            return (DasNamespace)ObjectUtils.tryCast((Object)DasUtil.getSchemaObject(dasObject), DasNamespace.class);
        }
        ObjectKind kind = dialect.getSearchPathObjectKind();
        List path = kind == null ? null : (List)DbImplUtilCore.getMetaModel(dialect.getDbms()).getPathsToRoot(kind).first();
        List pathsToRoot = path == null ? Collections.singletonList(kind) : path;
        return kind == null ? null : (DasNamespace)DasUtil.dasParents(dasObject).filter(DasNamespace.class).find(o -> pathsToRoot.contains(o.getKind()));
    }

    @Nullable
    public static DbDataSource getDbDataSource(@NotNull Project project, @NotNull DasDataSource database) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(3);
        }
        if (database == null) {
            DbImplUtilCore.$$$reportNull$$$0(4);
        }
        return database instanceof DbDataSource ? (DbDataSource)database : DbPsiFacade.getInstance(project).findDataSource(database.getUniqueId());
    }

    public static CascadeRule asCascadeRule(DasForeignKey.RuleAction ac) {
        if (ac == DasForeignKey.RuleAction.CASCADE) {
            return CascadeRule.cascade;
        }
        if (ac == DasForeignKey.RuleAction.NO_ACTION) {
            return CascadeRule.no_action;
        }
        if (ac == DasForeignKey.RuleAction.RESTRICT) {
            return CascadeRule.restrict;
        }
        if (ac == DasForeignKey.RuleAction.SET_DEFAULT) {
            return CascadeRule.set_default;
        }
        if (ac == DasForeignKey.RuleAction.SET_NULL) {
            return CascadeRule.set_null;
        }
        return CascadeRule.no_action;
    }

    @Nullable
    public static Object prepareValue(@NotNull Dbms family, @Nullable Object value2) {
        if (family == null) {
            DbImplUtilCore.$$$reportNull$$$0(5);
        }
        return value2 == null || value2 == ReservedCellValue.NULL ? null : (value2 instanceof JdbcInjectable ? ((JdbcInjectable)value2).injection(family) : (value2 instanceof ObjectFormatter.ImageInfo ? (JdbcInjection)((ObjectFormatter.ImageInfo)value2).bytes : (value2 instanceof ObjectFormatter.TextInfo ? (JdbcInjection)((ObjectFormatter.TextInfo)value2).bytes : (value2 instanceof BitString ? (JdbcInjection)((BitString)value2).getBytes() : (value2 instanceof Date ? DbImplUtilCore.prepareDate((Date)value2) : value2)))));
    }

    @NotNull
    private static Object prepareDate(@NotNull Date value2) {
        if (value2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(6);
        }
        return value2 instanceof Timestamp || value2 instanceof Time ? value2 : new JdbcInjection.DateInjection(JdbcNativeUtil.createSqlDate((Date)value2));
    }

    public static <T extends BasicModElement> ModFamily<T> familyOf(@Nullable BasicModElement element2, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtilCore.$$$reportNull$$$0(7);
        }
        Family res2 = element2 == null ? null : element2.familyOf(kind);
        return res2 != null ? res2 : null;
    }

    public static boolean isSchemaDbMode(BasicModModel model, Dbms family) {
        return model.getRoot().familyOf(ObjectKind.DATABASE) == null && family.isMysql();
    }

    public static void resolveKey(@NotNull BasicModForeignKey fkey, @NotNull List<String> refColNames) {
        BasicTableOrView table;
        if (fkey == null) {
            DbImplUtilCore.$$$reportNull$$$0(8);
        }
        if (refColNames == null) {
            DbImplUtilCore.$$$reportNull$$$0(9);
        }
        if (!refColNames.isEmpty() && (table = fkey.getRefTable()) != null) {
            for (BasicKey key : JBIterable.from(table.familyOf(ObjectKind.KEY)).filter(BasicKey.class)) {
                if (!refColNames.equals(key.getColNames())) continue;
                fkey.setRefKeyName(key.getName());
                return;
            }
        }
        fkey.setRefKeyName(null);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@NotNull DbDataSource dataSource2, @Nullable DasObject dasObject) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(10);
        }
        return DbImplUtilCore.getSearchPathObjectForSwitch(DbImplUtilCore.getMaybeLocalDataSource(dataSource2), DbImplUtilCore.getDatabaseDialect(dataSource2), dasObject);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@Nullable LocalDataSource dataSource2, @NotNull DatabaseDialectEx dialect, @Nullable DasObject dasObject) {
        SchemaControl control;
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(11);
        }
        if (dasObject == null) {
            return null;
        }
        SchemaControl schemaControl = control = dataSource2 == null ? SchemaControl.AUTOMATIC : dataSource2.getSchemaControl();
        if (control != SchemaControl.AUTOMATIC) {
            if (!dialect.getDbms().isPostgres()) {
                return null;
            }
            DasNamespace object = DbImplUtilCore.getSearchPathObject(dialect, dasObject);
            if (dasObject.getKind() == ObjectKind.DATABASE) {
                return (DasNamespace)ObjectUtils.tryCast((Object)dasObject, DasNamespace.class);
            }
            if (object == null || object.getKind() != ObjectKind.SCHEMA) {
                return object;
            }
            return (DasNamespace)ObjectUtils.tryCast((Object)object.getDasParent(), DasNamespace.class);
        }
        return DbImplUtilCore.getSearchPathObject(dialect, dasObject);
    }

    public static DasNamespace getSearchPathObjectForSwitch(@Nullable DbElement element2) {
        return element2 == null ? null : DbImplUtilCore.getSearchPathObjectForSwitch(element2.getDataSource(), element2);
    }

    @Nullable
    public static ObjectPath getSearchPathObject(@NotNull Dbms dbms, @Nullable ObjectPath objectPath) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(12);
        }
        if (objectPath == null) {
            return null;
        }
        if (dbms.isSqlite()) {
            return objectPath.findParent(ObjectKind.SCHEMA, false);
        }
        ObjectKind kind = DbImplUtilCore.getDatabaseDialect(dbms).getSearchPathObjectKind();
        List<ObjectKind> path = kind == null ? null : (List<ObjectKind>)DbImplUtilCore.getMetaModel(dbms).getPathsToRoot(kind).first();
        List<ObjectKind> pathsToRoot = path == null ? Collections.singletonList(kind) : path;
        return kind == null ? null : (ObjectPath)JBIterable.generate((Object)objectPath, p2 -> p2.parent).find(o -> pathsToRoot.contains(o.kind));
    }

    @Nullable
    public static DasNamespace getSearchPathObject(@Nullable DbElement element2) {
        return element2 == null ? null : DbImplUtilCore.getSearchPathObject(DbImplUtilCore.getDatabaseDialect(element2), element2);
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(13);
        }
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)element2.getDataSource().getDatabaseDialect();
        if (databaseDialectEx == null) {
            DbImplUtilCore.$$$reportNull$$$0(14);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DasObject obj) {
        if (obj instanceof PsiElement) {
            return DbImplUtilCore.getDbms((PsiElement)obj);
        }
        if (obj instanceof BasicElement) {
            Dbms dbms = ((BasicElement)obj).getMetaObject().getModel().dbms;
            if (dbms == null) {
                DbImplUtilCore.$$$reportNull$$$0(15);
            }
            return dbms;
        }
        Dbms dbms = Dbms.UNKNOWN;
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(16);
        }
        return dbms;
    }

    @NotNull
    public static Dbms getDbms(@Nullable PsiElement e) {
        if (e instanceof DbElement) {
            return DbImplUtilCore.getDbms((DbElement)e);
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(e);
        Dbms dbms = dialect == null ? Dbms.UNKNOWN : dialect.getDbms();
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(17);
        }
        return dbms;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DbElement element2) {
        Dbms dbms = element2 == null ? Dbms.UNKNOWN : element2.getDataSource().getDbms();
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(18);
        }
        return dbms;
    }

    public static Condition<DasObject> buildFilter(DasDataSource ds) {
        LocalDataSource source = DbImplUtilCore.getMaybeLocalDataSource(ds);
        if (source != null) {
            try {
                Condition<DasObject> c2 = DbImplUtilCore.buildObjectFilter(source);
                if (c2 == null) {
                    return null;
                }
                return o -> o instanceof DasNamespace || c2.value(o);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Condition<DasObject> buildObjectFilter(@NotNull AbstractDataSource ds) throws PatternSyntaxException {
        if (ds == null) {
            DbImplUtilCore.$$$reportNull$$$0(19);
        }
        String filterText = ds instanceof LocalDataSource ? ((LocalDataSource)ds).getObjectPattern() : null;
        return DbImplUtilCore.buildObjectFilter(filterText);
    }

    @Nullable
    public static Condition<DasObject> buildObjectFilter(@Nullable String filterText) throws PatternSyntaxException {
        if (StringUtil.isEmptyOrSpaces((String)filterText)) {
            return null;
        }
        HashMap<ObjectKind, Couple> builders = new HashMap<ObjectKind, Couple>();
        for (Object s2 : StringUtil.split((String)filterText, (String)"||")) {
            StringBuilder target;
            ObjectKind kind;
            String string = ((String)s2).trim();
            if (string.length() == 0) continue;
            int idx = string.indexOf(58);
            boolean exclude = string.charAt(idx + 1) == '-';
            String patternText = string.substring(idx + (exclude ? 2 : 1));
            if (idx < 0 || idx == string.length() - 1) {
                kind = ObjectKind.NONE;
            } else {
                String k = string.substring(0, idx);
                kind = (ObjectKind)ContainerUtil.getOrElse(FILTER_BY_NAME, (Object)k, (Object)ObjectKind.NONE);
                if (kind == ObjectKind.NONE) {
                    exclude = false;
                    patternText = string;
                }
            }
            Couple item = (Couple)builders.get(kind);
            if (item == null) {
                item = Couple.of((Object)new StringBuilder(), (Object)new StringBuilder());
                builders.put(kind, item);
            }
            StringBuilder stringBuilder = target = exclude ? (StringBuilder)item.second : (StringBuilder)item.first;
            if (target.length() != 0) {
                target.append("|");
            }
            target.append(patternText);
        }
        HashMap<ObjectKind, Condition> map2 = new HashMap<ObjectKind, Condition>();
        for (Map.Entry entry : builders.entrySet()) {
            Couple v = (Couple)entry.getValue();
            map2.put((ObjectKind)entry.getKey(), Conditions.and((Condition)((Condition)ObjectUtils.notNull(DbImplUtilCore.makeCondition((CharSequence)v.first), (Object)Conditions.alwaysTrue())), (Condition)Conditions.not((Condition)((Condition)ObjectUtils.notNull(DbImplUtilCore.makeCondition((CharSequence)v.second), (Object)Conditions.alwaysFalse())))));
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map2.entrySet());
        if (map2.size() == 1 && item != null && item.getKey() == ObjectKind.NONE) {
            return Conditions.compose(DasUtil.TO_NAME, (Condition)((Condition)item.getValue()));
        }
        return object -> {
            Condition c2 = object == null ? null : (Condition)map2.get(object.getKind());
            return c2 == null || c2.value((Object)object.getName());
        };
    }

    @Nullable
    public static Condition<String> makeCondition(CharSequence regex) {
        if (StringUtil.isEmpty((CharSequence)regex)) {
            return null;
        }
        Pattern p2 = Pattern.compile(regex.toString(), 2);
        return s2 -> s2 == null || p2.matcher((CharSequence)s2).matches();
    }

    public static boolean isExpandable(@NotNull DasObject obj, @Nullable TreePattern scope) {
        DasObject unw;
        if (obj == null) {
            DbImplUtilCore.$$$reportNull$$$0(20);
        }
        return (unw = (DasObject)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(obj), DasObject.class)) == null || unw instanceof BasicNamespace && ((BasicNamespace)unw).isSubstituted() || DataSourceSchemaMapping.isIntrospected(scope, unw);
    }

    @Contract(value="null -> null")
    public static Object unwrap(@Nullable DasObject object) {
        Object tmp2 = object;
        while (tmp2 != null) {
            if (!(tmp2 instanceof DbElement)) {
                return tmp2;
            }
            tmp2 = ((DbElement)tmp2).getDelegate();
        }
        return object;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable Dbms dbms) {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.chooseNotNull((Object)DbImplUtilCore.guessDatabaseDialect(dbms), (Object)DatabaseDialects.getGenericDialect());
        if (databaseDialectEx == null) {
            DbImplUtilCore.$$$reportNull$$$0(21);
        }
        return databaseDialectEx;
    }

    @Nullable
    public static DatabaseDialectEx guessDatabaseDialect(@Nullable RawConnectionConfig connectionInfo) {
        Dbms dbms = DbImplUtilCore.guessDbms(connectionInfo);
        return DbImplUtilCore.guessDatabaseDialect(dbms);
    }

    @NotNull
    public static CasingProvider getCasingProvider(@Nullable DasObject obj) {
        if (obj instanceof DbElement) {
            return DbImplUtilCore.getCasingProvider(DbImplUtilCore.getMaybeBasicElement(obj));
        }
        if (obj instanceof PsiElement) {
            CasingProvider casingProvider = (CasingProvider)ObjectUtils.notNull((Object)((CasingProvider)DbSqlUtilCore.getSqlDialect((PsiElement)obj)), (Object)DasUtil.NO_CASING_PROVIDER);
            if (casingProvider == null) {
                DbImplUtilCore.$$$reportNull$$$0(22);
            }
            return casingProvider;
        }
        if (obj instanceof BasicElement) {
            CasingProvider casingProvider = (CasingProvider)ObjectUtils.notNull((Object)BasicMixinElement.getCasingProvider((BasicElement)obj), (Object)DasUtil.NO_CASING_PROVIDER);
            if (casingProvider == null) {
                DbImplUtilCore.$$$reportNull$$$0(23);
            }
            return casingProvider;
        }
        CasingProvider casingProvider = DasUtil.NO_CASING_PROVIDER;
        if (casingProvider == null) {
            DbImplUtilCore.$$$reportNull$$$0(24);
        }
        return casingProvider;
    }

    @Nullable
    protected static DatabaseDialectEx guessDatabaseDialect(@Nullable Dbms dbms) {
        return dbms == Dbms.UNKNOWN || dbms == null ? null : DatabaseDialects.findByDbms(dbms);
    }

    @Nullable
    public static DbDataSource getForcedDataSource(@Nullable PsiFile psiFile) {
        DbDataSource res2;
        if (psiFile == null) {
            return null;
        }
        Project project = psiFile.getProject();
        VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = PsiUtilCore.getVirtualFile((PsiElement)InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)psiFile));
        }
        if ((res2 = DbImplUtilCore.getForcedDataSource(project, virtualFile)) != null) {
            return res2;
        }
        res2 = (DbDataSource)DatabaseDataKeysCore.DATA_SOURCE_KEY.get((UserDataHolder)psiFile);
        if (res2 == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return (DbDataSource)DatabaseDataKeysCore.DATA_SOURCE_KEY.get((UserDataHolder)virtualFile);
        }
        return res2 != null && res2.isValid() ? res2 : null;
    }

    @Nullable
    public static DbDataSource getForcedDataSource(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(25);
        }
        if (virtualFile == null) {
            return null;
        }
        DbDataSource element2 = VirtualFileDataSourceProvider.findDataSource(project, virtualFile);
        return element2 != null && element2.isValid() ? element2 : null;
    }

    public static void performSrcOperation(@Nullable Project project, @Nullable DasModel model, @NotNull ModalityState modality, boolean asyncRefresh, @NotNull Runnable runnable) {
        BasicModModel basicModel;
        DbSrcModelStorageCore storage;
        if (modality == null) {
            DbImplUtilCore.$$$reportNull$$$0(26);
        }
        if (runnable == null) {
            DbImplUtilCore.$$$reportNull$$$0(27);
        }
        DbSrcModelStorageCore dbSrcModelStorageCore = storage = (basicModel = (BasicModModel)ObjectUtils.tryCast((Object)model, BasicModModel.class)) == null ? null : (DbSrcModelStorageCore)ObjectUtils.tryCast((Object)basicModel.getTextStorage(), DbSrcModelStorageCore.class);
        if (storage == null) {
            runnable.run();
        } else {
            try (GuardedRef<?> ignored = storage.startWriteSession(project, basicModel, modality, asyncRefresh);){
                runnable.run();
            }
        }
    }

    @Nullable
    public static String getCustomTypeShortDescription(@Nullable Object delegate) {
        JBIterable names;
        if (delegate instanceof DasTypedObject) {
            DataType type = ((DasTypedObject)delegate).getDataType();
            if (type != DataType.UNKNOWN) {
                return DbPresentationCore.arrow() + " " + type;
            }
        } else if (delegate instanceof DasTable && !(names = DasUtil.getColumns((DasTable)delegate).transform(DasUtil.TO_NAME)).isEmpty()) {
            return "(" + StringUtil.join((Iterable)names, (String)", ") + ")";
        }
        return null;
    }

    public static int enumerateDialectName(@Nullable String value2) throws IOException {
        return SqlUiService.getInstance().enumerateDialectName(value2);
    }

    public static String getDialectName(int id) throws IOException {
        return SqlUiService.getInstance().getDialectName(id);
    }

    @NotNull
    public static Dbms guessDbms(@Nullable RawConnectionConfig connectionInfo) {
        Dbms dbms = connectionInfo instanceof DasDataSource ? ((DasDataSource)((Object)connectionInfo)).getDbms() : Dbms.forConnection(connectionInfo);
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(28);
        }
        return dbms;
    }

    public static boolean isRoutine(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtilCore.$$$reportNull$$$0(29);
        }
        return kind == ObjectKind.ROUTINE || kind == ObjectKind.AGGREGATE;
    }

    public static int getPageSize() {
        return DbImplUtilCore.getPageSize(null);
    }

    public static int getPageSize(@Nullable Dbms dbms) {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        return settings.isLimitPageSize() ? DbImplUtilCore.adjustPageSize(settings.getPageSize(), dbms) : -1;
    }

    private static int adjustPageSize(int pageSize, @Nullable Dbms dbms) {
        if (dbms == null || !dbms.is(Dbms.MONGO)) {
            return pageSize;
        }
        int registrySize = Registry.intValue((String)"database.mongodb.page.size.limit", (int)20);
        return Math.min(Math.max(1, registrySize), pageSize);
    }

    public static boolean isPageSizeUnlimited(int pageSize) {
        return pageSize < 1;
    }

    public static boolean isRowId(DataConsumer.Column column2) {
        return column2 != null && column2.attributes.contains((Object)DataConsumer.Column.Attribute.ROW_ID);
    }

    @Nullable
    public static Project getAnyProject() {
        return (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), p2 -> !p2.isDefault());
    }

    public static boolean supportsOffset(@Nullable Dbms dbms) {
        return dbms != null && SUPPORTS_OFFSET_DBS.contains(dbms);
    }

    public static boolean isZonedTimeColumn(@NotNull ColumnDescriptor column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(30);
        }
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(31);
        }
        return DbImplUtilCore.getJdbcHelper(dbms).isZonedTimeColumn(column2.getTypeName());
    }

    public static boolean isZonedTimestampColumn(@NotNull ColumnDescriptor column2, @NotNull Dbms dbms) {
        if (column2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(32);
        }
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(33);
        }
        return DbImplUtilCore.getJdbcHelper(dbms).isZonedTimestampColumn(column2.getTypeName(), column2.getType());
    }

    public static void closeSafe(@Nullable AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static Dbms getDbms(@Nullable DatabaseDriverCore o) {
        if (o == null) {
            Dbms dbms = Dbms.UNKNOWN;
            if (dbms == null) {
                DbImplUtilCore.$$$reportNull$$$0(34);
            }
            return dbms;
        }
        if (o.getForcedDbms() != null) {
            Dbms dbms = o.getForcedDbms();
            if (dbms == null) {
                DbImplUtilCore.$$$reportNull$$$0(35);
            }
            return dbms;
        }
        if (o.isPredefined()) {
            Dbms dbms = Dbms.fromString(o.getId());
            if (dbms == Dbms.DB2) {
                SqlLanguageDialect dialect;
                String dialectId = o.getSqlDialect();
                SqlLanguageDialect sqlLanguageDialect = dialect = dialectId == null ? null : SqlDialects.findDialectById(dialectId);
                if (dialect != null && dialect.getDbms().isDb2()) {
                    Dbms dbms2 = dialect.getDbms();
                    if (dbms2 == null) {
                        DbImplUtilCore.$$$reportNull$$$0(36);
                    }
                    return dbms2;
                }
            }
            Dbms dbms3 = dbms;
            if (dbms3 == null) {
                DbImplUtilCore.$$$reportNull$$$0(37);
            }
            return dbms3;
        }
        Dbms dbms = Dbms.fromString(o.getDriverClass());
        if (dbms == Dbms.UNKNOWN || o.getSqlDialect() == null) {
            Dbms dbms4 = dbms;
            if (dbms4 == null) {
                DbImplUtilCore.$$$reportNull$$$0(38);
            }
            return dbms4;
        }
        if (SqlDialects.isGenericDialect(DbSqlUtilCore.getSqlDialect(dbms))) {
            Dbms dbms5 = dbms;
            if (dbms5 == null) {
                DbImplUtilCore.$$$reportNull$$$0(39);
            }
            return dbms5;
        }
        SqlLanguageDialect dialect = SqlDialects.findDialectById(o.getSqlDialect());
        Dbms dbms6 = dialect == null || SqlDialects.isGenericDialect(dialect) ? dbms : dialect.getDbms();
        if (dbms6 == null) {
            DbImplUtilCore.$$$reportNull$$$0(40);
        }
        return dbms6;
    }

    public static String concatStringResults(DatabaseConnectionCore connection2, Dbms dbms, String query, int forcedColumn, ConcatenationProps props) throws SQLException {
        return DbImplUtilCore.concatStringResults(connection2, dbms, query, forcedColumn, new StringBuilder(), props).toString().trim();
    }

    public static StringBuilder concatStringResults(DatabaseConnectionCore connection2, Dbms dbms, int forcedColumn, String query, StringBuilder sb, ConcatenationProps props) throws SQLException {
        return DbImplUtilCore.concatStringResults(connection2, dbms, query, forcedColumn, sb, props);
    }

    public static StringBuilder concatStringResults(DatabaseConnectionCore connection2, Dbms dbms, String query, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws SQLException {
        SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.allResults((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rs -> DbImplUtilCore.concatStringResults(rs, dbms, forcedColumn, sb, props))));
        return sb;
    }

    private static void concatStringResults(RemoteResultSet rs, Dbms dbms, int forcedColumn, StringBuilder sb, ConcatenationProps props) throws Exception {
        int trimmedLen;
        DataConsumer.Column[] columns = JdbcEngineUtils.getColumnDescriptors(rs, dbms);
        int columnCount = columns.length;
        int start2 = sb.length();
        while (rs.next()) {
            if (start2 != sb.length()) {
                sb.append(props.rowSep);
            }
            int rowStart = sb.length();
            for (int i2 = forcedColumn > 0 ? forcedColumn : 1; i2 <= (forcedColumn > 0 ? forcedColumn : columnCount); ++i2) {
                CharSequence s2 = DbImplUtilCore.extractString(rs.getObject(i2));
                if (s2 == null) continue;
                if (props.lTrim) {
                    s2 = StringUtil.trimLeading((CharSequence)s2);
                }
                if (props.rTrim) {
                    s2 = StringUtil.trimTrailing((CharSequence)s2);
                }
                if (rowStart != sb.length()) {
                    sb.append(props.colSep);
                }
                sb.append(s2);
            }
        }
        for (trimmedLen = sb.length(); trimmedLen != 0 && sb.charAt(trimmedLen - 1) == ' '; --trimmedLen) {
        }
        sb.setLength(trimmedLen);
    }

    @Nullable
    private static CharSequence extractString(@Nullable Object object) throws SQLException {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        if (object instanceof RemoteClob) {
            RemoteClob clob = (RemoteClob)object;
            try {
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (RemoteException re) {
                ExceptionUtil.rethrow((Throwable)RemoteUtil.unwrap((Throwable)re));
            }
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            return clob.getSubString(1L, (int)clob.length());
        }
        return null;
    }

    public static String escapeStr(String value2) {
        return StringUtil.notNullize((String)value2).replace("'", "''");
    }

    @Nullable
    public static Version getDatabaseVersion(@Nullable DasDataSource dataSource2) {
        return dataSource2 == null ? null : dataSource2.getVersion();
    }

    @Nullable
    public static DasNamespace getTopSingleNamespace(@Nullable DasObject object) {
        ObjectKind kind;
        ObjectKind objectKind = kind = object == null ? null : object.getKind();
        if (kind != ObjectKind.ROOT && kind != ObjectKind.DATABASE) {
            return (DasNamespace)DasUtil.dasParents(object).filter(DasNamespace.class).first();
        }
        JBIterable ns = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)object)).expand(Conditions.compose(DasUtil.TO_KIND, k -> k == ObjectKind.ROOT || k == ObjectKind.DATABASE))).traverse();
        DasObject result2 = (DasObject)ns.filter(DasUtil.byKind(ObjectKind.SCHEMA)).single();
        if (result2 == null) {
            result2 = (DasObject)ns.filter(DasUtil.byKind(ObjectKind.DATABASE)).single();
        }
        return result2 instanceof DasNamespace ? (DasNamespace)result2 : null;
    }

    @NotNull
    public static JBTreeTraverser<DasObject> traverseVisibleObjects(@NotNull DasDataSource ds) {
        if (ds == null) {
            DbImplUtilCore.$$$reportNull$$$0(41);
        }
        TreePattern scope = DbImplUtilCore.getIntrospectionScope(ds);
        JBTreeTraverser traverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(ds.getModel().getModelRoots());
        JBTreeTraverser jBTreeTraverser = DbImplUtilCore.traverseVisibleObjects(traverser, scope);
        if (jBTreeTraverser == null) {
            DbImplUtilCore.$$$reportNull$$$0(42);
        }
        return jBTreeTraverser;
    }

    public static <T extends DasObject> JBTreeTraverser<T> traverseVisibleObjects(@NotNull JBTreeTraverser<T> traverser, @Nullable TreePattern scope) {
        if (traverser == null) {
            DbImplUtilCore.$$$reportNull$$$0(43);
        }
        return scope == null ? traverser : (JBTreeTraverser)traverser.expandAndFilter(o -> DataSourceSchemaMapping.isIntrospected(scope, o));
    }

    public static <T> T executeAndGetResult(DatabaseConnectionCore connection2, String query, ThrowableConvertor<RemoteResultSet, T, Exception> result2) throws SQLException {
        return SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.throwableResultsTransformer(result2));
    }

    public static boolean hasUniqueIndex(@NotNull DasTable table) {
        if (table == null) {
            DbImplUtilCore.$$$reportNull$$$0(44);
        }
        return table.getDasChildren(ObjectKind.INDEX).filter(idx -> idx instanceof DasIndex && ((DasIndex)idx).isUnique()).isNotEmpty();
    }

    public static <T> T escapeSql(T value2, boolean needsEscaping, @NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(45);
        }
        return (T)DbImplUtilCore.getJdbcHelper(dbms).escapeSqlRegex(value2, needsEscaping);
    }

    public static boolean isSchema(@NotNull DasObject object) {
        if (object == null) {
            DbImplUtilCore.$$$reportNull$$$0(46);
        }
        return DbImplUtilCore.isSchema(object.getKind());
    }

    public static boolean isSchema(@NotNull ObjectKind kind) {
        if (kind == null) {
            DbImplUtilCore.$$$reportNull$$$0(47);
        }
        return kind == ObjectKind.SCHEMA || kind == ObjectKind.EXTERNAL_SCHEMA;
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(48);
        }
        return dbms == Dbms.UNKNOWN ? null : (DatabaseDriver)JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filter(o -> DbImplUtilCore.getDbms(o) == dbms).sort((o1, o2) -> o1.isPredefined() ? (o2.isPredefined() ? 0 : -1) : (o2.isPredefined() ? 1 : 0)).first();
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull RawConnectionConfig info) {
        if (info == null) {
            DbImplUtilCore.$$$reportNull$$$0(49);
        }
        return DbImplUtilCore.guessDatabaseDriver(DatabaseDriverManager.getInstance().getDrivers(), info);
    }

    @Nullable
    public static DatabaseDriver guessDatabaseDriver(@NotNull Collection<? extends DatabaseDriver> allDrivers, @NotNull RawConnectionConfig info) {
        if (allDrivers == null) {
            DbImplUtilCore.$$$reportNull$$$0(50);
        }
        if (info == null) {
            DbImplUtilCore.$$$reportNull$$$0(51);
        }
        SmartList matchedDrivers = new SmartList();
        if (info.getDriverClass() == null) {
            matchedDrivers.addAll(allDrivers);
        } else {
            for (DatabaseDriver databaseDriver : allDrivers) {
                if (!Objects.equals(info.getDriverClass(), databaseDriver.getDriverClass())) continue;
                matchedDrivers.add(databaseDriver);
            }
        }
        if (matchedDrivers.isEmpty()) {
            return null;
        }
        if (matchedDrivers.size() == 1) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        String url = StringUtil.notNullize((String)info.getUrl());
        ArrayList<DatabaseDriver> arrayList = new ArrayList<DatabaseDriver>(matchedDrivers.size());
        for (DatabaseDriver driver : matchedDrivers) {
            if (!driver.matchesUrl(url)) continue;
            arrayList.add(driver);
        }
        if (arrayList.isEmpty()) {
            return (DatabaseDriver)matchedDrivers.get(0);
        }
        if (arrayList.size() == 1) {
            return (DatabaseDriver)arrayList.get(0);
        }
        return DbImplUtilCore.disambiguate(url, (JBIterable<DatabaseDriver>)JBIterable.from(arrayList));
    }

    @Nullable
    public static DatabaseDriver disambiguate(@NotNull String url, @NotNull JBIterable<DatabaseDriver> drivers) {
        if (url == null) {
            DbImplUtilCore.$$$reportNull$$$0(52);
        }
        if (drivers == null) {
            DbImplUtilCore.$$$reportNull$$$0(53);
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"database.windows.net")) {
            return (DatabaseDriver)drivers.filter(d2 -> DbImplUtilCore.likelyAzureDriver(d2)).append(drivers).first();
        }
        if (StringUtil.containsIgnoreCase((String)url, (String)"redshift.amazonaws.com")) {
            return (DatabaseDriver)drivers.filter(d2 -> DbImplUtilCore.likelyRedshiftDriver(d2)).append(drivers).first();
        }
        return (DatabaseDriver)drivers.filter(d2 -> !DbImplUtilCore.likelyAzureDriver(d2) && !DbImplUtilCore.likelyRedshiftDriver(d2) && !DbImplUtilCore.likelyGreenplumDriver(d2)).append(drivers).first();
    }

    private static boolean likelyRedshiftDriver(DatabaseDriver driver) {
        return DbImplUtilCore.getDbms(driver) == Dbms.REDSHIFT;
    }

    private static boolean likelyGreenplumDriver(DatabaseDriver driver) {
        return DbImplUtilCore.getDbms(driver) == Dbms.GREENPLUM;
    }

    private static boolean likelyAzureDriver(DatabaseDriver driver) {
        return DbImplUtilCore.getDbms(driver) == Dbms.AZURE || StringUtil.containsIgnoreCase((String)driver.getName(), (String)"azure");
    }

    @NotNull
    public static LocalDataSource getLocalDataSource(@Nullable DasDataSource info) {
        DasDataSource dataSource2 = DbImplUtilCore.unwrapDS(info);
        if (dataSource2 instanceof LocalDataSource) {
            LocalDataSource localDataSource = (LocalDataSource)dataSource2;
            if (localDataSource == null) {
                DbImplUtilCore.$$$reportNull$$$0(54);
            }
            return localDataSource;
        }
        throw new AssertionError(info);
    }

    public static Map<String, Object> resultRowAsMap(DatabaseConnectionCore connection2, String query, String ... columnSelection) throws SQLException {
        return SmartStatementFactoryService.getInstance().poweredBy(connection2).simple().noisy().execute(query, StandardResultsProcessors.throwableResultsTransformer(rs -> {
            if (!rs.next()) {
                return Collections.emptyMap();
            }
            try {
                LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
                RemoteResultSetMetaData metaData = rs.getMetaData();
                int count = metaData.getColumnCount();
                for (int i2 = 1; i2 <= count; ++i2) {
                    result2.put(metaData.getColumnName(i2), rs.getObject(i2));
                }
                if (columnSelection.length > 0 && !result2.isEmpty()) {
                    assert (columnSelection.length % 2 == 0);
                    LinkedHashMap map2 = new LinkedHashMap();
                    for (int i3 = 0; i3 < columnSelection.length; i3 += 2) {
                        Object o = result2.get(columnSelection[i3]);
                        if (o == null) continue;
                        map2.put(columnSelection[i3 + 1], o);
                    }
                    result2 = map2;
                }
                return result2;
            }
            catch (Exception exception) {
                return Collections.emptyMap();
            }
        }, Collections.emptyMap()));
    }

    private static String getNameQuotingAware(@NotNull DasObject object, @NotNull NamingService namingService) {
        if (object == null) {
            DbImplUtilCore.$$$reportNull$$$0(55);
        }
        if (namingService == null) {
            DbImplUtilCore.$$$reportNull$$$0(56);
        }
        String name = object.getName();
        return object.isQuoted() ? namingService.enquote(name, object.getKind()) : name;
    }

    @NotNull
    @NonNls
    public static String renderRoutineHeader(@NotNull DasRoutine routine, @NotNull Dbms dbms) {
        if (routine == null) {
            DbImplUtilCore.$$$reportNull$$$0(57);
        }
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(58);
        }
        StringBuilder builder = new StringBuilder();
        NamingService namingService = NamingServices.getNamingService(dbms);
        builder.append((Object)routine.getRoutineKind());
        builder.append(" ");
        builder.append(DbImplUtilCore.getNameQuotingAware(routine, namingService));
        builder.append("(");
        for (DasArgument dasArgument : routine.getArguments()) {
            builder.append(StringUtil.defaultIfEmpty((String)DbImplUtilCore.getNameQuotingAware(dasArgument, namingService), (String)"?"));
            builder.append(" ");
            builder.append(StringUtil.notNullize((String)dasArgument.getDataType().getSpecification()));
        }
        builder.append(")");
        DasArgument returnArgument = routine.getReturnArgument();
        if (returnArgument != null) {
            builder.append(" ");
            builder.append(dbms.isOracle() || dbms.isVertica() ? "return" : "returns");
            builder.append(" ");
            builder.append(StringUtil.notNullize((String)returnArgument.getDataType().getSpecification()));
        }
        String string = builder.toString();
        if (string == null) {
            DbImplUtilCore.$$$reportNull$$$0(59);
        }
        return string;
    }

    @Nullable
    public static LocalDataSource getMaybeLocalDataSource(@Nullable DasDataSource info) {
        DasDataSource dataSource2 = DbImplUtilCore.unwrapDS(info);
        return dataSource2 instanceof LocalDataSource ? (LocalDataSource)dataSource2 : null;
    }

    @Nullable
    public static SqlDataSource getMaybeSqlDataSource(@Nullable DasDataSource info) {
        DasDataSource dataSource2 = DbImplUtilCore.unwrapDS(info);
        return dataSource2 instanceof SqlDataSource ? (SqlDataSource)dataSource2 : null;
    }

    @Nullable
    public static DasDataSource unwrapDS(@Nullable DasDataSource database) {
        DasDataSource o;
        DasDataSource dasDataSource = o = database instanceof DbDataSource ? ((DbDataSource)database).getDelegate() : database;
        if (o == null || o instanceof LocalDataSource || o instanceof SqlDataSource) {
            return o;
        }
        throw new AssertionError(database);
    }

    @Nullable
    public static TreePattern getIntrospectionScope(@Nullable DasDataSource info) {
        LocalDataSource ds = DbImplUtilCore.getMaybeLocalDataSource(info);
        return ds == null ? null : ds.getIntrospectionScope();
    }

    @Nullable
    public static BasicElement getMaybeBasicElement(@Nullable DasObject o) {
        Object delegate = DbImplUtilCore.unwrap(o);
        if (delegate instanceof DasDataSource) {
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)((DasDataSource)delegate).getModel(), BasicModel.class);
            return model == null ? null : model.getRoot();
        }
        return delegate instanceof BasicElement ? (BasicElement)delegate : null;
    }

    @NotNull
    public static JdbcHelper getJdbcHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(60);
        }
        JdbcHelper jdbcHelper = JDBC_HELPER_EP.forDbms(dbms);
        if (jdbcHelper == null) {
            DbImplUtilCore.$$$reportNull$$$0(61);
        }
        return jdbcHelper;
    }

    public static boolean valuesEqual(Object v1, Object v2) {
        return DbImplUtilCore.valuesEqual(v1, v2, null);
    }

    public static boolean valuesEqual(Object v1, Object v2, @Nullable Dbms dbms) {
        ThreeState result2;
        if (v1 == ReservedCellValue.NULL) {
            v1 = null;
        }
        if (v2 == ReservedCellValue.NULL) {
            v2 = null;
        }
        if ((result2 = DbImplUtilCore.simpleEquals(v1, v2)) == ThreeState.UNSURE && (result2 = DbImplUtilCore.numberEquals(v1, v2)) == ThreeState.YES && dbms != null && dbms.is(Dbms.MONGO)) {
            result2 = ThreeState.NO;
        }
        if (result2 == ThreeState.UNSURE) {
            result2 = DbImplUtilCore.arrayEquals(v1, v2);
        }
        if (result2 == ThreeState.UNSURE) {
            result2 = DbImplUtilCore.clobEquals(v1, v2);
        }
        if (result2 == ThreeState.UNSURE) {
            result2 = ThreeState.NO;
        }
        return result2.toBoolean();
    }

    private static ThreeState simpleEquals(Object v1, Object v2) {
        return Comparing.equal((Object)v1, (Object)v2) ? ThreeState.YES : ThreeState.UNSURE;
    }

    private static ThreeState numberEquals(Object v1, Object v2) {
        Number n1 = (Number)ObjectUtils.tryCast((Object)v1, Number.class);
        Number n2 = (Number)ObjectUtils.tryCast((Object)v2, Number.class);
        if (n1 != null && n2 != null) {
            long l1 = n1.longValue();
            long l2 = n2.longValue();
            double d1 = n1.doubleValue();
            double d2 = n2.doubleValue();
            return ThreeState.fromBoolean((l1 == l2 && (d1 == d2 || Double.isNaN(d1) && Double.isNaN(d2)) ? 1 : 0) != 0);
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState arrayEquals(Object v1, Object v2) {
        if (v1 != null && v2 != null && v1.getClass() == v2.getClass() && v1.getClass().isArray()) {
            if (v1 instanceof byte[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((byte[])v1, (byte[])v2));
            }
            if (v1 instanceof char[]) {
                return ThreeState.fromBoolean((boolean)Arrays.equals((char[])v1, (char[])v2));
            }
        }
        return ThreeState.UNSURE;
    }

    private static ThreeState clobEquals(Object v1, Object v2) {
        LobInfo.ClobInfo info1 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v1, LobInfo.ClobInfo.class);
        LobInfo.ClobInfo info2 = (LobInfo.ClobInfo)ObjectUtils.tryCast((Object)v2, LobInfo.ClobInfo.class);
        if (info1 != null && info2 != null) {
            return ThreeState.fromBoolean((!info2.isTruncated() && DbImplUtilCore.clobStringEquals(info1, info2.data) ? 1 : 0) != 0);
        }
        if (info1 != null && v2 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtilCore.clobStringEquals(info1, (String)v2));
        }
        if (info2 != null && v1 instanceof String) {
            return ThreeState.fromBoolean((boolean)DbImplUtilCore.clobStringEquals(info2, (String)v1));
        }
        return ThreeState.UNSURE;
    }

    private static boolean clobStringEquals(@NotNull LobInfo.ClobInfo lob, @Nullable String s2) {
        if (lob == null) {
            DbImplUtilCore.$$$reportNull$$$0(62);
        }
        return !lob.isTruncated() && Objects.equals(lob.data, s2);
    }

    public static DdlBuilder createBuilderForExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(63);
        }
        return new DdlBuilder().withDialect(dialect).qualifyReferences(true).quoteIdentifiers(true);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(64);
        }
        return DbImplUtilCore.createBuilderForUIExec(dbms, null);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(65);
        }
        return DbImplUtilCore.createBuilderForUIExec(dialect, null);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull Dbms dbms, @Nullable DasObject object) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(66);
        }
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(dbms);
        return DbImplUtilCore.createBuilderForUIExec(dialect, object);
    }

    public static boolean omitSchemaQualifier() {
        return Registry.is((String)"database.query.generation.omit.schema.qualifier", (boolean)false);
    }

    public static DdlBuilder createBuilderForUIExec(@NotNull DatabaseDialectEx dialect, @Nullable DasObject object) {
        if (dialect == null) {
            DbImplUtilCore.$$$reportNull$$$0(67);
        }
        DdlBuilder builder = DbImplUtilCore.createBuilderForExec(dialect).qualifyReferences(!DbImplUtilCore.omitSchemaQualifier()).quoteIdentifiers(false);
        DbElement element2 = DbImplUtilCore.getDbElement(object);
        return element2 != null ? builder.withCasingFor(element2) : builder;
    }

    @Nullable
    private static DbElement getDbElement(@Nullable DasObject object) {
        return DasUtil.getParentOfClass(object, DbDataSource.class, false);
    }

    @Nullable
    public static String validateDetectedString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t') continue;
            return null;
        }
        return string;
    }

    @Nullable
    public static Charset guessCharsetFromContent(byte @NotNull [] content) {
        if (content == null) {
            DbImplUtilCore.$$$reportNull$$$0(68);
        }
        if (content.length == 0) {
            return StandardCharsets.UTF_8;
        }
        CharsetToolkit toolkit = new CharsetToolkit(content, Charset.defaultCharset(), false);
        Charset fromBOM = toolkit.guessFromBOM();
        if (fromBOM != null) {
            return fromBOM;
        }
        CharsetToolkit.GuessedEncoding guessedEncoding = toolkit.guessFromContent(content.length);
        switch (guessedEncoding) {
            case SEVEN_BIT: 
            case VALID_UTF8: {
                return StandardCharsets.UTF_8;
            }
        }
        return null;
    }

    public static void setStatementParameter(@NotNull RemotePreparedStatement statement, @NotNull ColumnDescriptor column2, @Nullable Object value2, @NotNull Dbms dbms, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            DbImplUtilCore.$$$reportNull$$$0(69);
        }
        if (column2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(70);
        }
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(71);
        }
        ColumnInfo info = new ColumnInfo(column2.getJavaClassName(), column2.getTypeName(), column2.getType(), idx);
        statement.setObject(DbImplUtilCore.prepareValue(dbms, value2), info, needsEscaping, idx);
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull BasicElement element2) {
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(72);
        }
        return DbImplUtilCore.getModelHelper(DbImplUtilCore.getDbms(element2));
    }

    @NotNull
    public static ModelHelper getModelHelper(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(73);
        }
        ModelHelper modelHelper = ModelFacade.forDbms(dbms).getModelHelper();
        if (modelHelper == null) {
            DbImplUtilCore.$$$reportNull$$$0(74);
        }
        return modelHelper;
    }

    @Nullable
    public static DbDataSource findDataSource(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(75);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            return DbPsiFacade.getInstance(project).findDataSource(DbSrcUtilsCore.getDataSource(file));
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            return dbFile.findDataSource(project);
        }
        return null;
    }

    public static boolean isEditableTable(@NotNull Dbms dbms, @Nullable ObjectKind kind) {
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(76);
        }
        return DmlHelper.Companion.getEP().forDbms(dbms).isEditableTable(kind);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull DbElement element2) {
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(77);
        }
        DbDataSource dataSource2 = element2.getDataSource();
        return DbImplUtilCore.getMetaModel(dataSource2);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull DbDataSource dataSource2) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(78);
        }
        return DbImplUtilCore.getMetaModel((DasDataSource)dataSource2);
    }

    @NotNull
    public static MetaModel getMetaModel(@NotNull DasDataSource dataSource2) {
        BaseModel model;
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(79);
        }
        if ((model = (BaseModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BaseModel.class)) != null) {
            MetaModel metaModel = model.getMetaModel();
            if (metaModel == null) {
                DbImplUtilCore.$$$reportNull$$$0(80);
            }
            return metaModel;
        }
        return DbImplUtilCore.getMetaModel(dataSource2.getDbms());
    }

    public static boolean isInLocalDataSource(@Nullable DbElement element2) {
        DatabaseSystem ds = element2 == null ? null : element2.getDataSource().getDelegate();
        return ds instanceof LocalDataSource;
    }

    public static boolean canConnectTo(@Nullable DbElement element2) {
        DatabaseSystem ds = element2 == null ? null : element2.getDataSource().getDelegate();
        return ds instanceof LocalDataSource && DbImplUtilCore.canConnectTo((LocalDataSource)ds);
    }

    public static boolean isDdlElement(@Nullable DbElement element2) {
        return element2 != null && DbImplUtilCore.getMaybeSqlDataSource(element2.getDataSource()) != null;
    }

    public static boolean hasDriverFiles(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(81);
        }
        return dataSource2.hasDriverFiles();
    }

    public static boolean canConnectTo(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(82);
        }
        if (StringUtil.isEmptyOrSpaces((String)dataSource2.getUrl())) {
            return false;
        }
        if (!DbImplUtilCore.hasDriverFiles(dataSource2)) {
            return false;
        }
        String driverClass = dataSource2.getDriverClass();
        return !StringUtil.isEmptyOrSpaces((String)driverClass);
    }

    @NotNull
    public static Dbms getDbms(@NotNull BasicElement element2) {
        BasicModel model;
        if (element2 == null) {
            DbImplUtilCore.$$$reportNull$$$0(83);
        }
        Dbms dbms = (model = element2.getModel()) == null ? element2.getMetaObject().getModel().dbms : model.getDbms();
        if (dbms == null) {
            DbImplUtilCore.$$$reportNull$$$0(84);
        }
        return dbms;
    }

    @Nullable
    public static DbElement findElement(@Nullable DbDataSource dataSource2, @Nullable DasObject object) {
        if (dataSource2 == null || object == null) {
            return null;
        }
        return dataSource2.findElement(object);
    }

    @Nullable
    public static DbElement findElement(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DbImplUtilCore.$$$reportNull$$$0(85);
        }
        if (DbSrcUtilsCore.isDbSrcFile(file)) {
            return DbSrcUtilsCore.findDbElement(project, file.getPath(), DbElement.class);
        }
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return ((DatabaseElementVirtualFileImpl)file).findElement(project);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 54: 
            case 59: 
            case 61: 
            case 74: 
            case 80: 
            case 84: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 54: 
            case 59: 
            case 61: 
            case 74: 
            case 80: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 54: 
            case 59: 
            case 61: 
            case 74: 
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbImplUtilCore";
                break;
            }
            case 2: 
            case 11: 
            case 63: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: 
            case 25: 
            case 75: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 29: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkey";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refColNames";
                break;
            }
            case 10: 
            case 78: 
            case 79: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 13: 
            case 72: 
            case 77: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 30: 
            case 32: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverser";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 46: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allDrivers";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drivers";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lob";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbImplUtilCore";
                break;
            }
            case 1: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 14: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDbms";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseVisibleObjects";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalDataSource";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "renderRoutineHeader";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcHelper";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetaModel";
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 54: 
            case 59: 
            case 61: 
            case 74: 
            case 80: 
            case 84: {
                break;
            }
            case 2: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDbDataSource";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareDate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "familyOf";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveKey";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPathObjectForSwitch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseDialect";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildObjectFilter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isExpandable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getForcedDataSource";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "performSrcOperation";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isRoutine";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimeColumn";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isZonedTimestampColumn";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "traverseVisibleObjects";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "hasUniqueIndex";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "escapeSql";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isSchema";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "guessDatabaseDriver";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "disambiguate";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getNameQuotingAware";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "renderRoutineHeader";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getJdbcHelper";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "clobStringEquals";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForExec";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createBuilderForUIExec";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "guessCharsetFromContent";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setStatementParameter";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getModelHelper";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isEditableTable";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "hasDriverFiles";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "canConnectTo";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 54: 
            case 59: 
            case 61: 
            case 74: 
            case 80: 
            case 84: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ImmutableMap {
        public static <K, V> ContainerUtil.ImmutableMapBuilder<K, V> put(K key, V value2) {
            return ContainerUtil.immutableMapBuilder().put(key, value2);
        }
    }

    public static abstract class HashingStrategyUnique<T>
    extends JBIterable.SCond<T>
    implements TObjectHashingStrategy<T> {
        private Set<T> myVisited;

        public boolean value(T t) {
            if (this.myVisited == null) {
                this.myVisited = new THashSet((TObjectHashingStrategy)this);
            }
            return this.myVisited.add(t);
        }
    }

    public static class ConcatenationProps {
        public String rowSep;
        public String colSep;
        public boolean lTrim;
        public boolean rTrim;
        public static final ConcatenationProps LINES = new ConcatenationProps("\n", " ", false, false);
        public static final ConcatenationProps TIGHT = new ConcatenationProps("", "", false, false);
        public static final ConcatenationProps NO_CONCAT = LINES;

        public ConcatenationProps(String rowSep, String colSep, boolean lTrim, boolean rTrim) {
            this.rowSep = rowSep;
            this.colSep = colSep;
            this.lTrim = lTrim;
            this.rTrim = rTrim;
        }

        public String toString() {
            return "ConcatenationProps{rowSep='" + this.rowSep + "', colSep='" + this.colSep + "', lTrim=" + this.lTrim + ", rTrim=" + this.rTrim + "}";
        }
    }

    public static enum StringLiteralDecorator {
        CONTAINS("%", "%", true),
        STARTS_WITH(null, "%", true),
        ENDS_WITH("%", null, true),
        MATCHES(null, null, true),
        PLAIN(null, null, false);

        private final String myPrefix;
        private final String mySuffix;
        private final boolean myEscapeSqlRegexSymbols;

        private StringLiteralDecorator(String prefix, String suffix, boolean escapeSqlRegexSymbols) {
            this.myPrefix = prefix;
            this.mySuffix = suffix;
            this.myEscapeSqlRegexSymbols = escapeSqlRegexSymbols;
        }

        @NotNull
        public String decorate(@NotNull String text2, @NotNull Dbms dbms) {
            if (text2 == null) {
                StringLiteralDecorator.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                StringLiteralDecorator.$$$reportNull$$$0(1);
            }
            String string = this.decorate(text2, dbms, null);
            if (string == null) {
                StringLiteralDecorator.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String decorate(@NotNull String text2, @NotNull Dbms dbms, @Nullable JdbcHelper helper) {
            if (text2 == null) {
                StringLiteralDecorator.$$$reportNull$$$0(3);
            }
            if (dbms == null) {
                StringLiteralDecorator.$$$reportNull$$$0(4);
            }
            String string = DbSqlUtilCore.toStringLiteral(text2, dbms, this.myEscapeSqlRegexSymbols, this.myPrefix, this.mySuffix, helper != null ? helper : DbImplUtilCore.getJdbcHelper(dbms));
            if (string == null) {
                StringLiteralDecorator.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbImplUtilCore$StringLiteralDecorator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbImplUtilCore$StringLiteralDecorator";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "decorate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "decorate";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

