/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ui.DataGridDocumentationHelper;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.SyncDateFormat;
import java.awt.Color;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DataSourceUtil {
    private static final SyncDateFormat ourTimestampFormat = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    @Nullable
    public static BeforeRunTaskProvider<BeforeRunTask<?>> getProvider(@NotNull Project project, Key<?> key) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(0);
        }
        for (BeforeRunTaskProvider provider : BeforeRunTaskProvider.EP_NAME.getIterable((AreaInstance)project)) {
            if (provider.getId() != key) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static BeforeRunTaskProvider<BeforeRunTask<?>> getProvider(@NotNull Project project, String key) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(1);
        }
        for (BeforeRunTaskProvider provider : BeforeRunTaskProvider.EP_NAME.getIterable((AreaInstance)project)) {
            if (!provider.getId().toString().equals(key)) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public static <T extends EventListener, U extends T> EventDispatcher<U> eventDispatcher(@NotNull Class<T> listenerClass) {
        if (listenerClass == null) {
            DataSourceUtil.$$$reportNull$$$0(2);
        }
        EventDispatcher eventDispatcher = EventDispatcher.create(listenerClass);
        if (eventDispatcher == null) {
            DataSourceUtil.$$$reportNull$$$0(3);
        }
        return eventDispatcher;
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> performAutoSyncTask(@NotNull LoaderContext context) {
        if (context == null) {
            DataSourceUtil.$$$reportNull$$$0(4);
        }
        return DataSourceUtil.performAutoSyncTask(context, false);
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> performAutoSyncTask(@NotNull LoaderContext context, boolean stopRunning) {
        LocalDataSource dataSource2;
        if (context == null) {
            DataSourceUtil.$$$reportNull$$$0(5);
        }
        if (!DbImplUtilCore.canConnectTo(dataSource2 = context.getDataSource()) || !dataSource2.isAutoSynchronize()) {
            AsyncTask<Object> asyncTask = AsyncTask.completed(null);
            if (asyncTask == null) {
                DataSourceUtil.$$$reportNull$$$0(6);
            }
            return asyncTask;
        }
        AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = AsyncTask.frame(DatabaseBundle.message("progress.title.automatic.synchronisation", context.getDataSource().getName())).computeAsync(AsyncUtil.getEdtExecutor(), () -> {
            AsyncTask.withBgIndicatorIfNeeded(AsyncTask.currentFrame(), context.getProject(), null);
            AsyncTask<DataSourceSyncManager.SyncResult> result2 = DataSourceSyncManager.getInstance().tryPerform(context, stopRunning, true);
            if (result2 == null) {
                return AsyncTask.completed(null);
            }
            result2.whenComplete(null, (r, e) -> {
                if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e)) {
                    DataSourceUtil.showNotification(context.getProject(), dataSource2.getName(), DatabaseBundle.message("notification.content.cancelled", new Object[0]), false, Collections.emptyList());
                } else if (context.getErrorHandler().hasErrors()) {
                    if (context.isOutdatedCheck()) {
                        DataSourceUtil.showOutdatedCheckErrorNotification(context, r == null ? 0L : r.elapsedTime);
                    } else {
                        DataSourceUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
                    }
                }
            });
            return result2;
        });
        if (asyncTask == null) {
            DataSourceUtil.$$$reportNull$$$0(7);
        }
        return asyncTask;
    }

    public static void performAutoSyncTask(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(8);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(9);
        }
        DataSourceUtil.performAutoSyncTask(LoaderContext.loadAll(project, dataSource2));
    }

    @Nls
    @NotNull
    public static String formatDataSourceInfoString(LocalDataSource o) {
        Casing modes = o.getCaseModes();
        NameVersion databaseVersion = o.getDatabaseVersion();
        Dbms effectiveDbms = o.getDbms();
        Dbms actualDbms = Dbms.fromString(databaseVersion.name);
        Version effectiveVersion = o.getVersion();
        Version actualVersion = Version.parse(databaseVersion.version);
        boolean matches = effectiveDbms == actualDbms && (actualVersion != null && actualVersion.eqCoarse(effectiveVersion) || actualVersion == null && databaseVersion.version.contains(effectiveVersion.toString()));
        NameVersion driverVersion = o.getDriverVersion();
        String s1 = DatabaseBundle.message("dataSource.quickInfo.dbmsPhrase", databaseVersion.name, databaseVersion.version);
        String s2 = DatabaseBundle.message("dataSource.quickInfo.caseSensitivity2Phrase", Case.LOWER.apply(modes.plain.name()), Case.LOWER.apply(modes.quoted.name()));
        String s3 = DatabaseBundle.message("dataSource.quickInfo.driverPhrase", driverVersion.name, driverVersion.version, o.getJDBCVersion());
        String s4 = s1 + "\n" + s2 + "\n" + s3;
        if (!matches) {
            String s42 = DatabaseBundle.message("dataSource.quickInfo.effectiveVersion", effectiveDbms.getDisplayName(), effectiveVersion);
            s4 = s4 + "\n" + s42;
        }
        String string = s4;
        if (string == null) {
            DataSourceUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static void showNotification(@NotNull Project project, @NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String message2, boolean error2, List<DatabaseErrorHandler.Fix> fixes) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(11);
        }
        Pair<@NlsContexts.NotificationContent String, HyperlinkListener> pair = DataSourceUtil.truncatePopupMessageIfNeeded(project, message2, error2 ? DatabaseBundle.message("message.title.connection.error", new Object[0]) : title, error2 ? Messages.getErrorIcon() : Messages.getInformationIcon(), fixes);
        NotificationGroup group = error2 ? DatabaseNotifications.DATABASE_VIEW_GROUP : DatabaseNotifications.DATABASE_VIEW_LOG_GROUP;
        group.createNotification(title, (String)pair.first, error2 ? NotificationType.WARNING : NotificationType.INFORMATION).setListener((notification, event) -> ((HyperlinkListener)pair.second).hyperlinkUpdate(event)).notify(project);
    }

    public static Pair<@NlsContexts.NotificationContent String, @Nullable HyperlinkListener> truncatePopupMessageIfNeeded(@NotNull Project project, @NlsContexts.NotificationContent String text2, @NlsContexts.DialogTitle String dialogTitle, Icon icon, List<DatabaseErrorHandler.Fix> fixes) {
        boolean truncate;
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(12);
        }
        int maxLen = 120;
        boolean bl = truncate = text2.length() > maxLen;
        if (!truncate && fixes.isEmpty()) {
            return Pair.create((Object)text2, null);
        }
        HtmlBuilder balloonMessage = new HtmlBuilder();
        if (truncate) {
            balloonMessage.append(text2.substring(0, maxLen));
            balloonMessage.append(" ... ");
            balloonMessage.appendLink("more", DatabaseBundle.message("message.hyperlink.click.for.more", new Object[0]));
        } else {
            balloonMessage.append(text2);
        }
        @NlsSafe String message2 = text2.replace("\t", "  ");
        if (!fixes.isEmpty()) {
            balloonMessage.br();
            for (DatabaseErrorHandler.Fix fix : fixes) {
                balloonMessage.appendLink(fix.getName(), fix.getName());
            }
        }
        return Pair.create((Object)balloonMessage.toString(), e -> {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if ("more".equals(e.getDescription())) {
                Messages.showIdeaMessageDialog((Project)project, (String)message2, (String)dialogTitle, (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)icon, null);
            }
            for (DatabaseErrorHandler.Fix fix : fixes) {
                if (!e.getDescription().equals(fix.getName())) continue;
                DatabaseUiService.getInstance().applyFix(project, fix, null);
            }
        });
    }

    public static void showNotification(LoaderContext context, long elapsedTime) {
        boolean isError = context.getErrorHandler().hasErrors();
        String message2 = StringUtil.notNullize((String)StringUtil.nullize((String)DataSourceUtil.computeMessage(context)), (String)DatabaseBundle.message("notification.content.connection.successful", new Object[0]));
        List<DatabaseErrorHandler.Fix> fixes = context.getErrorHandler().getFixes();
        DataSourceUtil.showNotification(context.getProject(), context.getDataSource().getName(), message2 + DataSourceUtil.getElapsedString(elapsedTime), isError, fixes);
    }

    private static void showOutdatedCheckErrorNotification(LoaderContext context, long elapsedTime) {
        String message2 = DataSourceUtil.computeMessage(context);
        String title = context.getDataSource().getName();
        Pair<String, @Nullable HyperlinkListener> pair = DataSourceUtil.truncatePopupMessageIfNeeded(context.getProject(), message2 + DataSourceUtil.getElapsedString(elapsedTime), DatabaseBundle.message("message.title.connection.error", new Object[0]), Messages.getErrorIcon(), context.getErrorHandler().getFixes());
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, DatabaseBundle.message("notification.content.br.you.can.href.disable.disable.outdated.object.notification", pair.first), NotificationType.WARNING).setListener((notification, event) -> {
            if (pair.second != null) {
                ((HyperlinkListener)pair.second).hyperlinkUpdate(event);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "disable".equals(event.getDescription())) {
                context.getDataSource().setCheckOutdated(false);
                DataSourceStorage.getProjectStorage(context.getProject()).updateDataSource(context.getDataSource());
                notification.expire();
            }
        }).notify(context.getProject());
    }

    @NlsContexts.NotificationContent
    @NotNull
    private static String computeMessage(LoaderContext context) {
        boolean isError = context.getErrorHandler().hasErrors();
        String summary = context.getErrorHandler().getSummary();
        if (isError) {
            String string = DataSourceUtil.escapeAngleBrackets(summary);
            if (string == null) {
                DataSourceUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (context.hasSelection()) {
            List objects2 = JBIterable.from(context.getSelection()).filter(Conditions.notInstanceOf(Class.class)).toList();
            int size = objects2.size();
            Object item = ContainerUtil.getFirstItem((Collection)objects2);
            String itemName = item instanceof String ? (String)item : (item instanceof DasObject ? ((DasObject)item).getName() : null);
            String string = size == 1 && !StringUtil.isEmptyOrSpaces((String)itemName) ? DatabaseBundle.message("notification.content.synchronized", itemName) : DatabaseBundle.message("notification.content.synchronization.successful", new Object[0]);
            if (string == null) {
                DataSourceUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = DataSourceUtil.formatDataSourceInfoString(context.getDataSource()) + "\n\n" + DatabaseBundle.message("notification.content.connection.successful", new Object[0]);
        if (string == null) {
            DataSourceUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static String escapeAngleBrackets(String message2) {
        return message2.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    protected static String getElapsedString(long elapsedTime) {
        return elapsedTime > 1L ? " (" + NlsMessages.formatDuration((long)elapsedTime) + ")" : "";
    }

    @NlsSafe
    @NotNull
    public static String currentTime() {
        String string = "[" + ourTimestampFormat.format(new Date()) + "] ";
        if (string == null) {
            DataSourceUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static boolean isTransactionsSupported(@NotNull Dbms family) {
        if (family == null) {
            DataSourceUtil.$$$reportNull$$$0(17);
        }
        return DbImplUtilCore.getJdbcHelper(family).supportsTransactions();
    }

    @NotNull
    @NlsSafe
    public static String getConsoleTitle(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(18);
        }
        if (file == null) {
            DataSourceUtil.$$$reportNull$$$0(19);
        }
        String string = (String)ReadAction.compute(() -> VfsPresentationUtil.getPresentableNameForUI((Project)project, (VirtualFile)file));
        if (string == null) {
            DataSourceUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    public static boolean isDataSourceValid(@NotNull DbPsiFacade dbFacade, @NotNull DasDataSource dataSource2) {
        if (dbFacade == null) {
            DataSourceUtil.$$$reportNull$$$0(21);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(22);
        }
        return dbFacade.findDataSource(dataSource2.getUniqueId()) != null;
    }

    @NotNull
    public static AsyncTask<DataSourceSyncManager.SyncResult> performManualSyncTask(@NotNull LoaderContext context) {
        AsyncTask<DataSourceSyncManager.SyncResult> result2;
        if (context == null) {
            DataSourceUtil.$$$reportNull$$$0(23);
        }
        if ((result2 = DataSourceSyncManager.getInstance().tryPerform(context, true, true)) == null) {
            AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = AsyncTask.cancelled();
            if (asyncTask == null) {
                DataSourceUtil.$$$reportNull$$$0(24);
            }
            return asyncTask;
        }
        AsyncTask<DataSourceSyncManager.SyncResult> asyncTask = result2.whenComplete(null, (r, e) -> {
            if (!context.getErrorHandler().hasErrors() && AsyncUtil.isCancellation(e)) {
                DataSourceUtil.showNotification(context.getProject(), context.getDataSource().getName(), DatabaseBundle.message("notification.content.cancelled", new Object[0]), false, Collections.emptyList());
            } else {
                DataSourceUtil.showNotification(context, r == null ? 0L : r.elapsedTime);
            }
        });
        if (asyncTask == null) {
            DataSourceUtil.$$$reportNull$$$0(25);
        }
        return asyncTask;
    }

    public static <K, V> V putOrRemove(Map<K, V> m, K k, V v) {
        if (v == null) {
            return m.remove(k);
        }
        return m.put(k, v);
    }

    @Nullable
    public static AsyncTask<DataSourceSyncManager.SyncResult> applyMappings(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(26);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(27);
        }
        return DataSourceSyncManager.getInstance().tryPerform(new LoaderContext(project, dataSource2), false, true);
    }

    public static boolean setNamespacesVisible(Project project, LocalDataSource dataSource2, Iterable<? extends BasicNamespace> selectedValues, boolean visible) {
        return DataSourceUtil.setPathsVisible(project, dataSource2, (Iterable<ObjectPath>)JBIterable.from(selectedValues).map(ObjectPaths::of), visible);
    }

    public static boolean setPathsVisible(Project project, LocalDataSource dataSource2, Iterable<ObjectPath> paths, boolean visible) {
        TreePattern newScope;
        TreePattern objects2 = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(paths).map(TreePatternUtils::create));
        TreePattern scope = dataSource2.getIntrospectionScope();
        TreePattern treePattern = newScope = visible ? TreePatternUtils.union(scope, objects2) : TreePatternUtils.minus(scope, objects2);
        if (scope.equals(newScope)) {
            return false;
        }
        dataSource2.setIntrospectionScope(newScope);
        DbSrcUtils.getDataSourceStorage(dataSource2.isGlobal() ? null : project).updateDataSource(dataSource2);
        DataSourceUtil.applyMappings(project, dataSource2);
        return true;
    }

    public static void resultSetToString(String title, RemoteResultSet resultSet, int size, Dbms dbms, DataExtractor.Text extractor, CharOut out) throws Exception {
        DataConsumer.Column[] columns = JdbcEngineUtils.getColumnDescriptors(resultSet, dbms);
        int maxLobLength = DatabaseSettings.getSettings().getBytesLimitPerValue();
        RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(size, maxLobLength, false);
        List data = resultSet.getObjects(options);
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(data.size());
        if (data.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < data.size(); ++i2) {
            rows.add(DataConsumer.Row.create(i2, (Object[])data.get(i2)));
        }
        out.append(String.format(title, data.size()));
        ExtractorsUtil.extract(out, dbms, Arrays.asList(columns), extractor, rows, new int[0]);
    }

    public static void tryLoadFirstNRows(String title, DatabaseConnection connection2, String query, CharOut sb, int rows) throws Exception {
        if (connection2 == null) {
            return;
        }
        SmartStatements.poweredBy(connection2).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<RemoteResultSet, Exception>)((ThrowableConsumer)rs -> {
            ObjectFormatter converter = new ObjectFormatter(){

                @Override
                @Nullable
                public String objectToString(@Nullable Object o, DataConsumer.Column column2, Dbms dbms, @NotNull ObjectFormatterMode mode) {
                    Object o1;
                    if (mode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((o1 = 1.objectToObject(o, column2, dbms)) instanceof ObjectFormatter.ImageInfo) {
                        ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)o1;
                        String s2 = super.objectToString(info.stripBytes(), column2, dbms, mode);
                        return DataGridDocumentationHelper.createImageRefTag(info, s2);
                    }
                    String s3 = super.objectToString(o1, column2, dbms, mode);
                    return HtmlValuesExtractor.escapeChars(s3);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/util/DataSourceUtil$1", "objectToString"));
                }
            };
            Color color = Objects.requireNonNull(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)EditorColors.DOCUMENTATION_COLOR));
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(color, converter);
            DataSourceUtil.resultSetToString(title, rs, rows, connection2.getDbms(), extractor, sb);
        })));
    }

    public static void tryLoadFirstNRows(DatabaseConnection connection2, String query, StringBuilder sb, int rows) {
        try {
            DataSourceUtil.tryLoadFirstNRows("", connection2, query, CharOut.Util.newSink(sb), rows);
        }
        catch (Exception e) {
            DataSourceUtil.exceptionToHtml(e, "Unable to load table data", sb);
        }
    }

    public static StringBuilder exceptionToHtml(Exception e, String str, StringBuilder sb) {
        sb.append(str).append(":<br>");
        sb.append("<code>").append(e).append("</code><br>");
        return sb;
    }

    @NotNull
    public static Promise<?> promiseFacadeUpdate(@NotNull DbPsiFacade facade, @Nullable Disposable parent2) {
        if (facade == null) {
            DataSourceUtil.$$$reportNull$$$0(28);
        }
        AsyncPromise p2 = new AsyncPromise();
        Disposable listenerDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)((Disposable)ObjectUtils.notNull((Object)parent2, (Object)facade.getProject())), (Disposable)listenerDisposable);
        facade.getProject().getMessageBus().connect(listenerDisposable).subscribe(DbPsiFacade.TOPIC, o -> {
            Disposer.dispose((Disposable)listenerDisposable);
            p2.setResult(null);
        });
        AsyncPromise asyncPromise = p2;
        if (asyncPromise == null) {
            DataSourceUtil.$$$reportNull$$$0(29);
        }
        return asyncPromise;
    }

    public static List<BeforeRunTask<?>> instantiateBeforeTasks(ConsoleRunConfiguration runConfiguration, List<LocalDataSource.BeforeTask> beforeTasks) {
        return ContainerUtil.mapNotNull(beforeTasks, t -> DataSourceUtil.instantiateBeforeRunTask(runConfiguration, t));
    }

    @Nullable
    private static BeforeRunTask<?> instantiateBeforeRunTask(ConsoleRunConfiguration runConfiguration, LocalDataSource.BeforeTask t) {
        BeforeRunTask task2;
        BeforeRunTaskProvider<BeforeRunTask<?>> provider = DataSourceUtil.getProvider(runConfiguration.getProject(), t.providerId);
        BeforeRunTask beforeRunTask = task2 = provider == null ? null : provider.createTask((RunConfiguration)runConfiguration);
        if (task2 != null) {
            if (task2 instanceof PersistentStateComponent) {
                XmlSerializer.deserializeAndLoadState((PersistentStateComponent)((PersistentStateComponent)task2), (Element)t.serialized);
            } else {
                task2.readExternal(t.serialized);
            }
        }
        return task2;
    }

    public static List<LocalDataSource.BeforeTask> storeBeforeTasks(List<BeforeRunTask<?>> beforeTasks) {
        return ContainerUtil.mapNotNull(beforeTasks, t -> DataSourceUtil.storeBeforeRunTask(t));
    }

    @NotNull
    private static LocalDataSource.BeforeTask storeBeforeRunTask(BeforeRunTask<?> task2) {
        Element rt = new Element("task");
        if (task2 instanceof PersistentStateComponent) {
            XmlSerializer.serializeStateInto((PersistentStateComponent)((PersistentStateComponent)task2), (Element)rt);
        } else {
            task2.writeExternal(rt);
        }
        return new LocalDataSource.BeforeTask(task2.getProviderId().toString(), rt);
    }

    @Deprecated
    @Nullable
    public static String getEffectiveUrl(@NotNull Project project, @NotNull RawConnectionConfig dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(30);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(31);
        }
        return dataSource2 instanceof LocalDataSource ? DataSourceUtil.getEffectiveUrl(project, (LocalDataSource)dataSource2) : dataSource2.getUrl();
    }

    @Deprecated
    @Nullable
    public static String getEffectiveUrl(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        DatabaseConnectionInterceptor.ProtoConnection proto;
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(32);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(33);
        }
        return (proto = DataSourceUtil.getProtoConnection(project, dataSource2)) == null ? null : proto.getUrl();
    }

    @Deprecated
    @Nullable
    public static DatabaseConnectionInterceptor.ProtoConnection getProtoConnection(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DataSourceUtil.$$$reportNull$$$0(34);
        }
        if (dataSource2 == null) {
            DataSourceUtil.$$$reportNull$$$0(35);
        }
        try {
            return DatabaseConnectionEstablisher.processInterceptors(ConsoleRunConfiguration.newConfiguration(project), dataSource2, true, false).toFuture().get();
        }
        catch (Exception e) {
            ExceptionUtil.rethrow((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 25: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 25: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerClass";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DataSourceUtil";
                break;
            }
            case 4: 
            case 5: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 22: 
            case 27: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFacade";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DataSourceUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "eventDispatcher";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "performAutoSyncTask";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDataSourceInfoString";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "currentTime";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleTitle";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "performManualSyncTask";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseFacadeUpdate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "eventDispatcher";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 25: 
            case 29: {
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performAutoSyncTask";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "truncatePopupMessageIfNeeded";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTransactionsSupported";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleTitle";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDataSourceValid";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "performManualSyncTask";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyMappings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "promiseFacadeUpdate";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveUrl";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getProtoConnection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 24: 
            case 25: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

