/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.SqlUiService;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.sql.SQLException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.Promise;

public class AsyncUtil {
    private static final Key<Boolean> ASYNC_FRIENDLY = Key.create((String)"ASYNC_FRIENDLY");
    private static final Key<Object> ASYNC_CALL_TRACE = Key.create((String)"ASYNC_CALL_TRACE");

    public static Executor transactionExecutor(@NotNull Disposable d2, @NotNull ModalityState modality) {
        if (d2 == null) {
            AsyncUtil.$$$reportNull$$$0(0);
        }
        if (modality == null) {
            AsyncUtil.$$$reportNull$$$0(1);
        }
        return AsyncUtil.asyncFriendlyExecutor(command -> ((AppUIExecutor)AppUIExecutor.onWriteThread((ModalityState)modality).expireWith(d2)).submit(command));
    }

    public static Executor transactionExecutor(@NotNull Disposable d2) {
        if (d2 == null) {
            AsyncUtil.$$$reportNull$$$0(2);
        }
        return AsyncUtil.transactionExecutor(d2, ModalityState.defaultModalityState());
    }

    public static Executor asyncFriendlyExecutor(@NotNull Executor e) {
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(3);
        }
        ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
        return task2 -> {
            Application application = ApplicationManager.getApplication();
            UserDataHolder dataHolder = application == null || application.isUnitTestMode() ? (UserDataHolder)ObjectUtils.tryCast((Object)indicator, UserDataHolder.class) : null;
            Throwable currentTrace = dataHolder == null ? null : new Throwable();
            ASYNC_CALL_TRACE.set(dataHolder, (Object)currentTrace);
            e.execute(() -> {
                try {
                    AsyncUtil.underProgress(task2, indicator);
                }
                finally {
                    if (currentTrace != null && ASYNC_CALL_TRACE.get(dataHolder) == currentTrace) {
                        ASYNC_CALL_TRACE.set(dataHolder, null);
                    }
                }
            });
        };
    }

    @Nullable
    public static Throwable getAsyncCallTrace(@Nullable ProgressIndicator indicator) {
        if (indicator instanceof UserDataHolder) {
            return (Throwable)ObjectUtils.tryCast((Object)ASYNC_CALL_TRACE.get((UserDataHolder)indicator), Throwable.class);
        }
        return null;
    }

    @Nullable
    public static ProgressIndicator getAsyncFriendlyIndicator() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (AsyncUtil.isAsyncFriendly(indicator)) {
            if (indicator == null || indicator.isRunning()) {
                return indicator;
            }
            return null;
        }
        return null;
    }

    @Contract(value="!null->!null")
    public static Throwable unwrap(@Nullable Throwable e) {
        Throwable first2 = (Throwable)AsyncUtil.traverse(e).skipWhile(o -> o.getCause() != null && (o instanceof CompletionException || o instanceof ExecutionException || o instanceof com.intellij.execution.ExecutionException && o.getCause() instanceof ProcessCanceledException || o instanceof SQLException && (o.getCause().getClass() == RuntimeException.class || o.getCause().getClass() == SQLException.class) || o.getClass() == RuntimeException.class)).first();
        return first2 instanceof CancellationException ? new ProcessCanceledException() : first2;
    }

    @NotNull
    public static @NotNull JBIterable<@NotNull Throwable> traverse(@Nullable Throwable e) {
        JBIterable jBIterable = JBIterable.generate((Object)e, Throwable::getCause);
        if (jBIterable == null) {
            AsyncUtil.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    public static boolean isAsyncFriendly(@Nullable ProgressIndicator indicator) {
        return indicator == null || indicator instanceof EmptyProgressIndicator || indicator instanceof UserDataHolder && ASYNC_FRIENDLY.get((UserDataHolder)indicator) == Boolean.TRUE;
    }

    public static <T extends ProgressIndicator> T markAsyncFriendly(@Nullable T indicator, boolean friendly) {
        if (indicator instanceof UserDataHolder) {
            ASYNC_FRIENDLY.set((UserDataHolder)indicator, (Object)(friendly ? Boolean.TRUE : null));
        }
        return indicator;
    }

    public static <T> CompletionStage<T> supplyAsync(@NotNull Supplier<? extends CompletionStage<T>> s2, @NotNull Executor e) {
        if (s2 == null) {
            AsyncUtil.$$$reportNull$$$0(5);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(6);
        }
        return AsyncUtil.thenComposeAsync(CompletableFuture.completedFuture(null), x -> (CompletionStage)s2.get(), e);
    }

    public static <U, T> CompletionStage<T> thenComposeAsync(@NotNull CompletionStage<? extends U> s2, @NotNull Function<? super U, ? extends CompletionStage<T>> f, @NotNull Executor e) {
        if (s2 == null) {
            AsyncUtil.$$$reportNull$$$0(7);
        }
        if (f == null) {
            AsyncUtil.$$$reportNull$$$0(8);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(9);
        }
        CompletableFuture result2 = new CompletableFuture();
        AsyncUtil.processWhenComplete(s2, result2, r -> e.execute(() -> {
            try {
                AsyncUtil.processWhenComplete((CompletionStage)f.apply((Object)r), result2, result2::complete);
            }
            catch (Throwable th) {
                result2.completeExceptionally(th);
            }
        }));
        return result2;
    }

    public static <U, T> CompletionStage<T> thenHandleAsync(@NotNull CompletionStage<? extends U> s2, @NotNull BiFunction<? super U, ? super Throwable, ? extends CompletionStage<T>> f, @NotNull Executor e) {
        if (s2 == null) {
            AsyncUtil.$$$reportNull$$$0(10);
        }
        if (f == null) {
            AsyncUtil.$$$reportNull$$$0(11);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(12);
        }
        CompletableFuture result2 = new CompletableFuture();
        AsyncUtil.handleWhenComplete(s2, result2, (r, th) -> e.execute(() -> {
            try {
                AsyncUtil.handleWhenComplete((CompletionStage)f.apply((Object)r, (Throwable)th), result2, (r2, th2) -> {
                    if (th2 != null) {
                        result2.completeExceptionally((Throwable)th2);
                    } else {
                        result2.complete(r2);
                    }
                });
            }
            catch (Throwable th22) {
                result2.completeExceptionally(th22);
            }
        }));
        return result2;
    }

    private static <T> void processWhenComplete(@NotNull CompletionStage<T> what, @NotNull CompletableFuture<?> where, @NotNull Consumer<? super T> cons) {
        if (what == null) {
            AsyncUtil.$$$reportNull$$$0(13);
        }
        if (where == null) {
            AsyncUtil.$$$reportNull$$$0(14);
        }
        if (cons == null) {
            AsyncUtil.$$$reportNull$$$0(15);
        }
        AsyncUtil.handleWhenComplete(what, where, (r, th) -> {
            if (th != null) {
                where.completeExceptionally((Throwable)th);
            } else {
                cons.consume(r);
            }
        });
    }

    private static <T> void handleWhenComplete(@NotNull CompletionStage<T> what, @NotNull CompletableFuture<?> where, @NotNull BiConsumer<? super T, ? super Throwable> cons) {
        if (what == null) {
            AsyncUtil.$$$reportNull$$$0(16);
        }
        if (where == null) {
            AsyncUtil.$$$reportNull$$$0(17);
        }
        if (cons == null) {
            AsyncUtil.$$$reportNull$$$0(18);
        }
        try {
            what.whenComplete((r, th) -> {
                try {
                    cons.accept((Object)r, (Throwable)th);
                }
                catch (Throwable ex) {
                    where.completeExceptionally(ex);
                }
            });
        }
        catch (Throwable ex) {
            where.completeExceptionally(ex);
        }
    }

    public static <T> T underProgress(@NotNull Computable<T> r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(19);
        }
        Ref res2 = Ref.create();
        AsyncUtil.underProgress(() -> res2.set(r.compute()), indicator);
        return (T)res2.get();
    }

    public static void underProgress(@NotNull Runnable r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(20);
        }
        ProgressManager.getInstance().executeProcessUnderProgress(r, indicator);
    }

    public static <T> CompletionStage<T> runTask(@NotNull Computable<? extends CompletionStage<T>> r, @NotNull ProgressIndicatorEx indicator) {
        CompletionStage<Object> res2;
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            AsyncUtil.$$$reportNull$$$0(22);
        }
        indicator.start();
        try {
            res2 = AsyncUtil.underProgress(r, (ProgressIndicator)indicator);
        }
        catch (Throwable th) {
            indicator.stop();
            indicator.processFinish();
            return AsyncUtil.exceptional(th);
        }
        if (res2 == null) {
            indicator.stop();
            indicator.processFinish();
            return null;
        }
        return res2.whenComplete((t, throwable) -> {
            indicator.stop();
            indicator.processFinish();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T withAsyncFriendly(@Nullable ProgressIndicator indicator, @NotNull ThrowableComputable<T, E> computable) throws E {
        boolean wasFriendly;
        if (computable == null) {
            AsyncUtil.$$$reportNull$$$0(23);
        }
        if (!(wasFriendly = AsyncUtil.isAsyncFriendly(indicator))) {
            AsyncUtil.markAsyncFriendly(indicator, true);
        }
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (!wasFriendly) {
                AsyncUtil.markAsyncFriendly(indicator, false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static ProgressIndicatorEx createBackgroundIndicator(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String string) {
        void name;
        Project project2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null) {
            AsyncUtil.$$$reportNull$$$0(24);
        }
        if (name == null) {
            AsyncUtil.$$$reportNull$$$0(25);
        }
        return AsyncUtil.createBackgroundIndicator(project2, (String)name, true);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static ProgressIndicatorEx createBackgroundIndicator(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String string, boolean bl) {
        void cancellable;
        void name;
        Project project2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null) {
            AsyncUtil.$$$reportNull$$$0(26);
        }
        if (name == null) {
            AsyncUtil.$$$reportNull$$$0(27);
        }
        return AsyncUtil.markAsyncFriendly(SqlUiService.getInstance().createBackgroundableIndicator(project2, (String)name, (boolean)cancellable), true);
    }

    public static <T> CompletableFuture<T> cancelled() {
        CompletableFuture res2 = new CompletableFuture();
        res2.cancel(false);
        return res2;
    }

    public static <T> CompletableFuture<T> exceptional(@NotNull Throwable th) {
        if (th == null) {
            AsyncUtil.$$$reportNull$$$0(28);
        }
        CompletableFuture res2 = new CompletableFuture();
        res2.completeExceptionally(th);
        return res2;
    }

    public static <T> CompletionStage<T> completed(@Nullable T r, @Nullable Throwable th) {
        return th != null ? AsyncUtil.exceptional(th) : CompletableFuture.completedFuture(r);
    }

    public static <T> void transfer(@NotNull CompletionStage<T> from, @NotNull CompletableFuture<T> to) {
        if (from == null) {
            AsyncUtil.$$$reportNull$$$0(29);
        }
        if (to == null) {
            AsyncUtil.$$$reportNull$$$0(30);
        }
        from.handle((r, th) -> th == null ? to.complete(r) : to.completeExceptionally((Throwable)th));
    }

    public static boolean isCancellation(@Nullable Throwable e) {
        return AsyncUtil.traverse(e).find(o -> o instanceof ProcessCanceledException && o.getCause() == null || o instanceof CancellationException) != null;
    }

    public static void addUnhandledError(@NotNull ErrorHandler errorHandler, @Nullable Throwable e, @Nullable LocalDataSource dataSource2) {
        if (errorHandler == null) {
            AsyncUtil.$$$reportNull$$$0(31);
        }
        if (e == null || AsyncUtil.isCancellation(e)) {
            return;
        }
        Throwable unwrapped = AsyncUtil.unwrap(e);
        errorHandler.addError(JdbcEngineUtils.getErrorMessage(unwrapped, dataSource2, (Consumer<? super DatabaseErrorHandler.Fix>)((Consumer)errorHandler::addFix)), unwrapped);
    }

    public static <T> Promise<T> runAsync(@NotNull Supplier<? extends Promise<T>> s2, @NotNull Executor e) {
        if (s2 == null) {
            AsyncUtil.$$$reportNull$$$0(32);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(33);
        }
        AsyncPromise res2 = new AsyncPromise();
        e.execute(() -> AsyncPromiseKt.catchError((AsyncPromise)res2, () -> AsyncUtil.lambda$runAsync$16((Supplier)s2, res2)));
        return res2;
    }

    public static Executor getPoolExecutor() {
        return AsyncUtil.asyncFriendlyExecutor(arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0));
    }

    public static Executor getEdtExecutor() {
        return AsyncUtil.asyncFriendlyExecutor(UIUtil::invokeLaterIfNeeded);
    }

    public static Executor getNonEdtExecutor() {
        return AsyncUtil.asyncFriendlyExecutor(command -> {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                ApplicationManager.getApplication().executeOnPooledThread(command);
            } else {
                command.run();
            }
        });
    }

    private static /* synthetic */ Object lambda$runAsync$16(Supplier s2, AsyncPromise res2) {
        ((Promise)s2.get()).processed((Promise)res2);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/AsyncUtil";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cons";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/AsyncUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transactionExecutor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asyncFriendlyExecutor";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "supplyAsync";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "thenComposeAsync";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "thenHandleAsync";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processWhenComplete";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleWhenComplete";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "underProgress";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withAsyncFriendly";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createBackgroundIndicator";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "exceptional";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "transfer";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addUnhandledError";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "runAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

