/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.script.generator.ui.ScriptGeneratorTool;
import com.intellij.database.script.generator.ui.ScriptGeneratorUI;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import icons.DatabaseIcons;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0002J$\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorTool;", "", "()V", "toolWindows", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/wm/ToolWindow;", "forgetProjectToolWindow", "", "project", "forgetProjectToolWindow$intellij_database_impl", "obtainDefaultContext", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;", "activate", "", "obtainToolWindow", "show", "model", "Lcom/intellij/database/model/basic/BasicModel;", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "intellij.database.impl"})
public final class ScriptGeneratorTool {
    private static final ConcurrentMap<Project, ToolWindow> toolWindows;
    @NotNull
    public static final ScriptGeneratorTool INSTANCE;

    public final void show(@NotNull Project project, @NotNull BasicModel model, @NotNull Iterable<? extends BasicNode> nodes2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        ScriptGeneratorUI context = this.obtainDefaultContext(project, true);
        context.getMainPanel$intellij_database_impl().setVisible(true);
        context.generate(model, nodes2);
    }

    private final ScriptGeneratorUI obtainDefaultContext(Project project, boolean activate) {
        ToolWindow toolWindow = this.obtainToolWindow(project);
        if (activate) {
            toolWindow.activate((Runnable)obtainDefaultContext.1.INSTANCE);
        }
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        Content content = contentManager.getSelectedContent();
        if (content == null) {
            String string = "Database Scripting UI: no default content";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"toolWindow.contentManage\u2026 UI: no default content\")");
        Content content2 = content;
        ScriptGeneratorUI scriptGeneratorUI = (ScriptGeneratorUI)content2.getUserData(ScriptGeneratorUI.Companion.getContextKey());
        if (scriptGeneratorUI == null) {
            String string = "Database Scripting UI: the default content is not assigned with a context";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)scriptGeneratorUI, (String)"content.getUserData(Scri\u2026assigned with a context\")");
        ScriptGeneratorUI context = scriptGeneratorUI;
        return context;
    }

    private final ToolWindow obtainToolWindow(Project project) {
        String string = DatabaseBundle.message("scriptGen.ui.toolWindowTitle", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"scriptGen.ui.toolWindowTitle\")");
        String title = string;
        ToolWindow toolWindow = toolWindows.computeIfAbsent(project, new Function(project, title){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;

            /*
             * WARNING - void declaration
             */
            public final ToolWindow apply(Project it2) {
                void var3_3;
                ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.$project);
                ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"ToolWindowAnchor.BOTTOM");
                ToolWindow toolWindow = toolWindowManager.registerToolWindow("SQL Generator", false, toolWindowAnchor, (Disposable)this.$project);
                toolWindow.setTitle(this.$title);
                toolWindow.setStripeTitle(this.$title);
                toolWindow.setIcon(DatabaseIcons.ToolWindowSQLGenerator);
                ScriptGeneratorUI defaultContext = new ScriptGeneratorUI(this.$project);
                ContentManager contentManager = toolWindow.getContentManager();
                Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
                ContentManager contentManager2 = contentManager;
                Content content = contentManager2.getFactory().createContent((JComponent)defaultContext.getMainPanel$intellij_database_impl(), "", false);
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"contentManager.factory.c\u2026ext.mainPanel, \"\", false)");
                Content content2 = content;
                content2.setPreferredFocusableComponent((JComponent)defaultContext.getViewer$intellij_database_impl());
                content2.putUserData(ScriptGeneratorUI.Companion.getContextKey(), (Object)defaultContext);
                contentManager2.addContent(content2);
                defaultContext.setContent$intellij_database_impl(content2);
                Disposer.register((Disposable)((Disposable)this.$project), (Disposable)defaultContext);
                return var3_3;
            }
            {
                this.$project = project;
                this.$title = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)toolWindow, (String)"toolWindows.computeIfAbs\u2026t)\n      toolWindow\n    }");
        return toolWindow;
    }

    public final void forgetProjectToolWindow$intellij_database_impl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        toolWindows.remove(project);
    }

    private ScriptGeneratorTool() {
    }

    static {
        ScriptGeneratorTool scriptGeneratorTool;
        INSTANCE = scriptGeneratorTool = new ScriptGeneratorTool();
        toolWindows = new ConcurrentHashMap();
    }
}

