/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMainPanel
extends JBLoadingPanel
implements EditorColorsListener {
    private final DataGrid myGrid;
    private final OnePixelSplitter myHorizontalSplitter;
    private final OnePixelSplitter myVerticalSplitter;
    private final JPanel myPanelWithFirstHeader;
    private final JPanel myCentralPanel;

    public GridMainPanel(@NotNull DataGrid grid) {
        if (grid == null) {
            GridMainPanel.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new BorderLayout(), (Disposable)grid);
        this.myPanelWithFirstHeader = new JPanel(new BorderLayout());
        this.myCentralPanel = new JPanel(new BorderLayout());
        this.myGrid = grid;
        this.add(this.myPanelWithFirstHeader, "Center");
        this.myVerticalSplitter = new OnePixelSplitter(true, 0.7f);
        this.myHorizontalSplitter = new OnePixelSplitter(false, 0.7f);
        this.myPanelWithFirstHeader.add((Component)this.myVerticalSplitter, "Center");
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myHorizontalSplitter);
        this.myHorizontalSplitter.setFirstComponent((JComponent)this.myCentralPanel);
    }

    public Color getBackground() {
        return (Color)ObjectUtils.chooseNotNull(this.myGrid != null ? this.myGrid.getColorsScheme().getDefaultBackground() : null, (Object)UIUtil.getTableBackground());
    }

    @Nullable
    public Component getTopComponent() {
        return GridMainPanel.getComponentAt(this.myPanelWithFirstHeader, "North");
    }

    @Nullable
    public Component getSecondTopComponent() {
        return GridMainPanel.getComponentAt(this.myCentralPanel, "North");
    }

    public void setCenterComponent(@NotNull JComponent component) {
        if (component == null) {
            GridMainPanel.$$$reportNull$$$0(1);
        }
        GridMainPanel.replaceComponentAt(this.myCentralPanel, "Center", component);
    }

    public void setTopComponent(@Nullable Component topComponent) {
        GridMainPanel.replaceComponentAt(this.myPanelWithFirstHeader, "North", topComponent);
    }

    public void setSecondTopComponent(@Nullable Component topComponent) {
        GridMainPanel.replaceComponentAt(this.myCentralPanel, "North", topComponent);
    }

    public void setBottomComponent(@Nullable Component bottomComponent) {
        GridMainPanel.replaceComponentAt(this.myCentralPanel, "South", bottomComponent);
    }

    public void setBottomView(@Nullable JComponent bottomComponent) {
        this.myVerticalSplitter.setSecondComponent(bottomComponent);
    }

    @Nullable
    public JComponent getBottomView() {
        return this.myVerticalSplitter.getSecondComponent();
    }

    @Nullable
    public JComponent getRightView() {
        return this.myHorizontalSplitter.getSecondComponent();
    }

    public void setRightView(@Nullable JComponent component) {
        this.myHorizontalSplitter.setSecondComponent(component);
    }

    private static void replaceComponentAt(@NotNull JPanel panel2, @NotNull String location, @Nullable Component with) {
        Component toReplace;
        if (panel2 == null) {
            GridMainPanel.$$$reportNull$$$0(2);
        }
        if (location == null) {
            GridMainPanel.$$$reportNull$$$0(3);
        }
        if ((toReplace = GridMainPanel.getComponentAt(panel2, location)) != null) {
            panel2.remove(toReplace);
        }
        if (with != null) {
            panel2.add(with, location);
        }
        panel2.revalidate();
        panel2.repaint();
    }

    @Nullable
    private static Component getComponentAt(@NotNull JPanel panel2, @NotNull String location) {
        if (panel2 == null) {
            GridMainPanel.$$$reportNull$$$0(4);
        }
        if (location == null) {
            GridMainPanel.$$$reportNull$$$0(5);
        }
        return ((BorderLayout)panel2.getLayout()).getLayoutComponent(location);
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.myGrid.getColorsScheme().setDelegate(scheme);
    }

    public void removeComponent(JComponent component) {
        if (this.myHorizontalSplitter.getSecondComponent() == component) {
            this.myHorizontalSplitter.setSecondComponent(null);
        } else if (this.myVerticalSplitter.getSecondComponent() == component) {
            this.myVerticalSplitter.setSecondComponent(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/GridMainPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCenterComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceComponentAt";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponentAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

