/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataGridDocumentationProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateAction
extends DumbAwareAction
implements GridAction {
    protected boolean hasKeysToNavigate(DbDataSource databaseSystem, DasTable table) {
        return DataGridDocumentationProvider.hasNavigatableKeys(databaseSystem, table);
    }

    @NotNull
    protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
        EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.FOREIGN, DataGridDocumentationProvider.KeyType.EXPORTED, DataGridDocumentationProvider.KeyType.SELECTED);
        if (enumSet == null) {
            NavigateAction.$$$reportNull$$$0(0);
        }
        return enumSet;
    }

    private static List<DataGridDocumentationProvider.QueryInfo> getQueries(@NotNull DasDataSource dataSource2, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull EnumSet<DataGridDocumentationProvider.KeyType> types) {
        List<DataGridDocumentationProvider.QueryInfo> queries;
        if (dataSource2 == null) {
            NavigateAction.$$$reportNull$$$0(1);
        }
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(2);
        }
        if (selectedRow == null) {
            NavigateAction.$$$reportNull$$$0(3);
        }
        if (types == null) {
            NavigateAction.$$$reportNull$$$0(4);
        }
        return (queries = DataGridDocumentationProvider.buildQueries(dataSource2, dataGrid, selectedRow, types)).isEmpty() && types.remove((Object)DataGridDocumentationProvider.KeyType.SELECTED) ? DataGridDocumentationProvider.buildQueries(dataSource2, dataGrid, selectedRow, types) : queries;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateAction.$$$reportNull$$$0(5);
        }
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DbDataSource dataSource2 = DataGridUtil.getDatabaseSystem(dataGrid);
        DasTable table = DataGridUtilCore.getDatabaseTable(dataGrid);
        boolean visible = e.getProject() != null && table != null && dataSource2 != null;
        boolean enabled = visible && dataGrid.getSelectionModel().getSelectedRowCount() == 1 && this.hasKeysToNavigate(dataSource2, table);
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateAction.$$$reportNull$$$0(6);
        }
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DbDataSource dataSource2 = DataGridUtil.getDatabaseSystem(dataGrid);
        if (dataGrid == null || dataSource2 == null || project == null) {
            return;
        }
        ModelIndex selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        if (!selectedRow.isValid(dataGrid) || dataGrid.getSelectionModel().getSelectedRowCount() != 1) {
            return;
        }
        List<OpenDataFileDescriptor> descriptors = NavigateAction.convertDescriptors(project, NavigateAction.createDescriptorData(dataGrid, dataSource2, this.getKeyTypes()));
        if (descriptors.size() == 1) {
            descriptors.get(0).navigate(true);
            return;
        }
        BaseListPopupStep<OpenDataFileDescriptor> step = NavigateAction.createStep(descriptors, this.getKeyTypes());
        ColoredListCellRenderer<OpenDataFileDescriptor> wrapper = NavigateAction.createRenderer(descriptors);
        ListPopupImpl popup2 = new ListPopupImpl(project, (ListPopupStep)step, (ColoredListCellRenderer)wrapper, descriptors){
            final /* synthetic */ ColoredListCellRenderer val$wrapper;
            final /* synthetic */ List val$descriptors;
            {
                this.val$wrapper = coloredListCellRenderer;
                this.val$descriptors = list;
                super(arg0, arg1);
            }

            protected ListCellRenderer getListElementRenderer() {
                return new PopupListElementRenderer<OpenDataFileDescriptor>((ListPopupImpl)this){

                    protected JComponent createItemComponent() {
                        this.myTextLabel = new ErrorLabel();
                        return val$wrapper;
                    }

                    protected void customizeComponent(JList<? extends OpenDataFileDescriptor> list, OpenDataFileDescriptor value2, boolean isSelected) {
                        val$wrapper.getListCellRendererComponent(list, (Object)value2, val$descriptors.indexOf((Object)value2), isSelected, true);
                    }
                };
            }
        };
        ActionManager actionManager = ActionManager.getInstance();
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)actionManager.getAction("QuickJavaDoc"));
        if (StringUtil.isNotEmpty((String)shortcutText)) {
            popup2.setAdText(DatabaseBundle.message("popup.advertisement.use.in.table", shortcutText));
        }
        popup2.showInBestPositionFor(e.getDataContext());
    }

    @NotNull
    public static List<OpenDataFileDescriptor> convertDescriptors(@NotNull Project project, @NotNull List<DescriptorData> descriptorData) {
        if (project == null) {
            NavigateAction.$$$reportNull$$$0(7);
        }
        if (descriptorData == null) {
            NavigateAction.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.map(descriptorData, data -> new OpenDataFileDescriptor(project, data.file, data.columnNames, data.description, data.values, data.condition));
        if (list == null) {
            NavigateAction.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static ColoredListCellRenderer<OpenDataFileDescriptor> createRenderer(List<OpenDataFileDescriptor> descriptors) {
        HashSet<DbElement> elements = new HashSet<DbElement>(ContainerUtil.filter((Collection)ContainerUtil.map(descriptors, descriptor2 -> DbImplUtilCore.findElement(descriptor2.getProject(), descriptor2.getFile())), el -> el != null));
        final Map<DbElement, @NlsSafe String> uniqueTableNames = NavigateAction.calcUniqueTableNames(elements);
        return new ColoredListCellRenderer<OpenDataFileDescriptor>(){

            protected void customizeCellRenderer(@NotNull JList<? extends OpenDataFileDescriptor> list, OpenDataFileDescriptor value2, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.clear();
                this.setIcon(DatabaseIcons.Table);
                DbElement element2 = DbImplUtilCore.findElement(value2.getProject(), value2.getFile());
                String uniqueName = (String)ObjectUtils.notNull((Object)((String)uniqueTableNames.get(element2)), (Object)value2.getFile().getName());
                this.append(uniqueName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(": ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                this.append(value2.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/run/actions/NavigateAction$2", "customizeCellRenderer"));
            }
        };
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static BaseListPopupStep<OpenDataFileDescriptor> createStep(final List<OpenDataFileDescriptor> descriptors, @NotNull EnumSet<DataGridDocumentationProvider.KeyType> keyTypes) {
        boolean includeFirstRefRows;
        if (keyTypes == null) {
            NavigateAction.$$$reportNull$$$0(10);
        }
        final @NlsContexts.Separator Ref navigateToOnlyRowsSeparator = new Ref();
        final @NlsContexts.Separator Ref navigateToFirstRowSeparator = new Ref();
        boolean bl = includeFirstRefRows = !Registry.is((String)"database.hide.navigate.to.first.referenced.rows");
        if (keyTypes.contains((Object)DataGridDocumentationProvider.KeyType.FOREIGN)) {
            navigateToOnlyRowsSeparator.set((Object)DatabaseBundle.message("separator.referenced.rows.only", new Object[0]));
            navigateToFirstRowSeparator.set((Object)DatabaseBundle.message("separator.first.referenced.row", new Object[0]));
        } else {
            navigateToOnlyRowsSeparator.set((Object)DatabaseBundle.message("separator.referencing.rows.only", new Object[0]));
            navigateToFirstRowSeparator.set((Object)DatabaseBundle.message("separator.first.referencing.row", new Object[0]));
        }
        String popupTitle = includeFirstRefRows ? DatabaseBundle.message("popup.title.choose.target", new Object[0]) : (keyTypes.contains((Object)DataGridDocumentationProvider.KeyType.FOREIGN) && keyTypes.contains((Object)DataGridDocumentationProvider.KeyType.EXPORTED) ? DatabaseBundle.message("popup.title.all.related.rows", new Object[0]) : (keyTypes.contains((Object)DataGridDocumentationProvider.KeyType.FOREIGN) ? DatabaseBundle.message("popup.title.referenced.rows", new Object[0]) : DatabaseBundle.message("popup.title.referencing.rows", new Object[0])));
        BaseListPopupStep<OpenDataFileDescriptor> step = new BaseListPopupStep<OpenDataFileDescriptor>(popupTitle, descriptors){

            public PopupStep<?> onChosen(OpenDataFileDescriptor selectedValue, boolean finalChoice) {
                selectedValue.navigate(true);
                return FINAL_CHOICE;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(OpenDataFileDescriptor value2) {
                if (!includeFirstRefRows) {
                    return null;
                }
                int idx = descriptors.indexOf((Object)value2);
                if (idx == 0) {
                    return new ListSeparator((String)navigateToOnlyRowsSeparator.get());
                }
                if (idx == descriptors.size() / 2) {
                    return new ListSeparator((String)navigateToFirstRowSeparator.get());
                }
                return null;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(OpenDataFileDescriptor value2) {
                String string = value2.getFile().getName() + ": " + value2.getDescription();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$3", "getTextFor"));
            }
        };
        step.setDefaultOptionIndex(0);
        BaseListPopupStep<OpenDataFileDescriptor> baseListPopupStep = step;
        if (baseListPopupStep == null) {
            NavigateAction.$$$reportNull$$$0(11);
        }
        return baseListPopupStep;
    }

    public static @NotNull Map<DbElement, @NlsSafe String> calcUniqueTableNames(@NotNull Set<DbElement> elements) {
        if (elements == null) {
            NavigateAction.$$$reportNull$$$0(12);
        }
        THashMap nameToTables = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (DbElement element2 : elements) {
            nameToTables.computeIfAbsent(element2.getName(), e -> new HashSet()).add(element2);
        }
        HashMap<DbElement, String> map2 = new HashMap<DbElement, String>();
        for (DbElement element3 : elements) {
            Set elementsWithSameName = (Set)nameToTables.get(element3.getName());
            if (elementsWithSameName == null || elementsWithSameName.size() == 1) {
                map2.put(element3, element3.getName());
                continue;
            }
            DbElement parent2 = element3.getParent();
            map2.put(element3, (String)(parent2 == null ? "" : parent2.getName() + ".") + element3.getName());
        }
        HashMap<DbElement, String> hashMap = map2;
        if (hashMap == null) {
            NavigateAction.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @NotNull
    public static List<DescriptorData> createDescriptorData(@NotNull DataGrid dataGrid, @NotNull DasDataSource dataSource2, @NotNull EnumSet<DataGridDocumentationProvider.KeyType> keyTypes) {
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(14);
        }
        if (dataSource2 == null) {
            NavigateAction.$$$reportNull$$$0(15);
        }
        if (keyTypes == null) {
            NavigateAction.$$$reportNull$$$0(16);
        }
        ModelIndex<DataConsumer.Row> selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        ArrayList<DescriptorData> descriptorData = new ArrayList<DescriptorData>();
        List<DataGridDocumentationProvider.QueryInfo> queries = NavigateAction.getQueries(dataSource2, dataGrid, selectedRow, keyTypes);
        boolean includeFirstRefRows = !Registry.is((String)"database.hide.navigate.to.first.referenced.rows");
        for (DataGridDocumentationProvider.QueryInfo info : queries) {
            String path = DatabaseElementVirtualFileImpl.getPath(dataSource2, info.table, false);
            VirtualFile file = DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
            if (file == null) continue;
            String[] formattedValues = DataGridUtil.formatValues(dataGrid, info.columnNames, info.values);
            DescriptorData descriptor2 = new DescriptorData(file, null, null, info.keysAndColumns, DbImplUtil.defaultWhereCondition(info.columnNames, formattedValues, dataSource2.getVersion()));
            if (includeFirstRefRows) {
                descriptorData.add(descriptorData.size() / 2, descriptor2);
                descriptorData.add(new DescriptorData(file, info.columnNames, info.values, info.keysAndColumns, null));
                continue;
            }
            descriptorData.add(descriptor2);
        }
        ArrayList<DescriptorData> arrayList = descriptorData;
        if (arrayList == null) {
            NavigateAction.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorData";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTypes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDescriptors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createStep";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcUniqueTableNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptorData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertDescriptors";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createStep";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcUniqueTableNames";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DescriptorData {
        public final VirtualFile file;
        public final String[] columnNames;
        public final Object[] values;
        public final @NlsActions.ActionDescription String description;
        public final TriConsumer<DdlBuilder, List<DasColumn>, Dbms> condition;

        public DescriptorData(@NotNull VirtualFile file, String @Nullable [] names, Object @Nullable [] values2, @NlsActions.ActionDescription @Nullable String description, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> condition) {
            if (file == null) {
                DescriptorData.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.columnNames = names;
            this.values = values2;
            this.description = description;
            this.condition = condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/NavigateAction$DescriptorData", "<init>"));
        }
    }

    public static class ExportedAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource2, DasTable table) {
            return !ModelRelationManager.getExportedKeys(dataSource2.getProject(), table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.EXPORTED, DataGridDocumentationProvider.KeyType.SELECTED);
            if (enumSet == null) {
                ExportedAction.$$$reportNull$$$0(0);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ExportedAction", "getKeyTypes"));
        }
    }

    public static class ForeignAction
    extends NavigateAction {
        @Override
        protected boolean hasKeysToNavigate(DbDataSource dataSource2, DasTable table) {
            return !ModelRelationManager.getForeignKeys(dataSource2.getProject(), table).isEmpty();
        }

        @Override
        @NotNull
        protected EnumSet<DataGridDocumentationProvider.KeyType> getKeyTypes() {
            EnumSet<DataGridDocumentationProvider.KeyType> enumSet = EnumSet.of(DataGridDocumentationProvider.KeyType.FOREIGN, DataGridDocumentationProvider.KeyType.SELECTED);
            if (enumSet == null) {
                ForeignAction.$$$reportNull$$$0(0);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$ForeignAction", "getKeyTypes"));
        }
    }
}

