/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.DbActionUtils;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/run/actions/CopyQueryToConsoleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/database/run/actions/GridAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.database.impl"})
public final class CopyQueryToConsoleAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(DataGridUtil.getQueryText((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DatabaseGridDataHookUp databaseGridDataHookUp = DataGridUtil.getDatabaseHookUp(grid);
        if (databaseGridDataHookUp == null) {
            return;
        }
        DatabaseGridDataHookUp databaseHookUp = databaseGridDataHookUp;
        DasTable dasTable = DataGridUtil.getDatabaseTable(grid);
        if (dasTable == null) {
            return;
        }
        DasTable table = dasTable;
        DbElement dbElement = DbImplUtilCore.findElement(databaseHookUp.getDataSource(), table);
        if (dbElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dbElement, (String)"DbImplUtilCore.findEleme\u2026aSource, table) ?: return");
        DbElement target = dbElement;
        String string = DataGridUtil.getQueryText((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY));
        if (string == null) {
            return;
        }
        String query = string;
        Editor editor = DbActionUtils.findOrCreateEditor(target, true);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        DbActionUtils.moveCaretToEnd(editor2);
        WriteCommandAction.runWriteCommandAction((Project)editor2.getProject(), null, null, (Runnable)new Runnable(editor2, query){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ String $query;

            public final void run() {
                Document document = this.$editor.getDocument();
                Document document2 = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
                document.insertString(document2.getTextLength(), (CharSequence)this.$query);
            }
            {
                this.$editor = editor;
                this.$query = string;
            }
        }, (PsiFile[])new PsiFile[0]);
    }
}

