/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service
public final class ModelMemoryManager
implements Disposable {
    private final LowMemoryWatcher myMemoryWatcher = LowMemoryWatcher.register(this::compactModels, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ALWAYS);
    private final Set<BasicModModel> myModels = ContainerUtil.createWeakSet();

    public static ModelMemoryManager getInstance() {
        return (ModelMemoryManager)ApplicationManager.getApplication().getService(ModelMemoryManager.class);
    }

    public void dispose() {
        this.myMemoryWatcher.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModel(@NotNull BasicModModel model) {
        if (model == null) {
            ModelMemoryManager.$$$reportNull$$$0(0);
        }
        Set<BasicModModel> set = this.myModels;
        synchronized (set) {
            this.myModels.add(model);
        }
    }

    public void compactModels() {
        for (BasicModModel model : this.alive()) {
            this.compactModel(model);
        }
    }

    public void compactModel(@NotNull BasicModModel model) {
        if (model == null) {
            ModelMemoryManager.$$$reportNull$$$0(1);
        }
        for (BasicElement element2 : model.basicTraverser()) {
            BaseModel.forceUnload(element2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<BasicModModel> alive() {
        ArrayList<BasicModModel> models = new ArrayList<BasicModModel>(this.myModels.size());
        Set<BasicModModel> set = this.myModels;
        synchronized (set) {
            models.addAll(this.myModels);
        }
        ArrayList<BasicModModel> arrayList = models;
        if (arrayList == null) {
            ModelMemoryManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelMemoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelMemoryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "alive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compactModel";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

