/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseStartupActivity;
import com.intellij.database.editor.DatabaseTableFileEditorProvider;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.WeakList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableFileEditor
extends TableEditorBase
implements NavigatableFileEditor,
DataProvider,
DocumentReferenceProvider {
    public static final int UNKNOWN_COLUMN_POSITION = 0;
    public static final int DEFAULT_OR_HIDDEN_COLUMN_POSITION = -1;
    private final VirtualFile myFile;
    private final EditorTableResultPanel myResultPanel;
    private final JPanel myRootPanel;
    private final LoadingManager myLoadingManager;
    private boolean stateWasSet;
    private final long lastOpenedTimestamp;
    @NotNull
    private final JComponent headerComponent;

    public DatabaseTableFileEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull DatabaseTableFileEditorProvider provider) {
        if (project == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myRootPanel = new JPanel(new BorderLayout());
        this.stateWasSet = false;
        this.lastOpenedTimestamp = System.currentTimeMillis();
        this.myFile = file;
        State state = (State)ObjectUtils.tryCast((Object)EditorHistoryManager.getInstance((Project)project).getState(file, (FileEditorProvider)provider), State.class);
        String sessionName = state == null ? null : state.sessionName;
        DataGridSessionClient hookUp = GridDataHookUpManager.getInstance(project).getHookUp(file, (Disposable)this, sessionName);
        this.myResultPanel = new EditorTableResultPanel(project, hookUp){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = DatabaseBundle.message("editor.0", DatabaseTableFileEditor.this.getFile().getPresentableName());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor$1", "getDisplayName"));
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myResultPanel);
        DataGridUtil.setupProgressIndicatingAuditor(this.myResultPanel);
        this.myLoadingManager = DatabaseStartupActivity.DataEditorConfigurator.isSafeToLoadData(project) ? new MyInstantLoadingManager() : new MyDelayedLoadingManager();
        this.myLoadingManager.onInit();
        DataManager.registerDataProvider((JComponent)this.myRootPanel, (DataProvider)this);
        this.headerComponent = DataGridUtil.addGridHeaderComponent(this.myResultPanel, this.myFile);
        this.myRootPanel.add((Component)((Object)this.myResultPanel.getComponent()), "Center");
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.table.editor");
    }

    @NotNull
    public JComponent getHeaderComponent() {
        JComponent jComponent = this.headerComponent;
        if (jComponent == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public DataGrid getDataGrid() {
        EditorTableResultPanel editorTableResultPanel = this.myResultPanel;
        if (editorTableResultPanel == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(5);
        }
        return editorTableResultPanel;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @Override
    public void dispose() {
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(7);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.table.editor";
        }
        return null;
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return Collections.singletonList(DocumentReferenceManager.getInstance().create(this.myFile));
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(8);
        }
        return navigatable instanceof OpenDataFileDescriptor;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(9);
        }
        if (!(navigatable instanceof OpenDataFileDescriptor)) {
            return;
        }
        OpenDataFileDescriptor descriptor2 = (OpenDataFileDescriptor)navigatable;
        descriptor2.setFilterAndLoadData(this.myLoadingManager, this.myResultPanel);
        DeferredLoader.doWhenLoaded(this.myResultPanel, () -> descriptor2.navigateTo(this.myResultPanel));
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(10);
        }
        if (level == FileEditorStateLevel.FULL) {
            State state = new State();
            this.updateColumnAttributes(state.columnAttributes);
            this.updateFilterState(state.filter);
            this.updateSortingState(state.mySorting);
            state.presentationMode = this.myResultPanel.getPresentationMode().name();
            this.updateExtractorFactoryState(state);
            state.transposed = DatabaseSettings.getSettings().getAutoTransposeMode() == DatabaseSettings.AutoTransposeMode.NEVER && this.myResultPanel.getResultView().isTransposed();
            state.projectRestartId = DatabaseStartupActivity.DataEditorConfigurator.getLaunchId(this.getProject());
            GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel = this.myResultPanel.getDataHookup().getPageModel();
            state.pageSize = pageModel.pageSizeSet() ? pageModel.getPageSize() : -2;
            DataGridSessionClient client = DataGridUtil.getDataGridClient(this.myResultPanel);
            state.sessionName = client != null && SessionsUtil.needToSaveSessionName(client.getSession(), client) ? client.getSession().getTitle() : null;
            state.lastOpenedTimestamp = this.lastOpenedTimestamp;
            State state2 = state;
            if (state2 == null) {
                DatabaseTableFileEditor.$$$reportNull$$$0(11);
            }
            return state2;
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(12);
        }
        return fileEditorState;
    }

    private void updateExtractorFactoryState(@NotNull State state) {
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(13);
        }
        DataExtractorFactory.Text globalFactory = DataExtractorProperties.getCurrentExtractorFactory(this.myResultPanel.getProject());
        DataExtractorFactory.Text fileFactory = this.myResultPanel.getExtractorFactory();
        state.extractorFactoryId = DataGridUtil.getDbms(this.myResultPanel).isMongo() && fileFactory.getId().equals("JSON-Groovy.json.groovy") || globalFactory.getId().equals(fileFactory.getId()) ? "" : fileFactory.getId();
    }

    private void updateSortingState(@NotNull State.Sorting sortingState) {
        if (sortingState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(14);
        }
        sortingState.history.clear();
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myResultPanel.getDataHookup().getSortingModel();
        if (sortingModel != null) {
            sortingState.history.addAll(sortingModel.getHistory());
        }
    }

    private void updateFilterState(@NotNull State.Filter filterState) {
        if (filterState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(15);
        }
        filterState.enabled = this.myResultPanel.isFilteringComponentShown();
        GridFilteringModel model = this.myResultPanel.getDataHookup().getFilteringModel();
        filterState.text = model == null ? "" : model.getFilterText();
        filterState.history.clear();
        if (model != null) {
            filterState.history.addAll(model.getHistory());
        }
    }

    private void updateColumnAttributes(@NotNull List<State.Column> columnAttributes) {
        if (columnAttributes == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(16);
        }
        columnAttributes.clear();
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myResultPanel.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        IntUnaryOperator column2View = this.myResultPanel.getRawIndexConverter().column2View();
        for (ModelIndex columnIdx : model.getColumnIndices().asIterable()) {
            DataConsumer.Column column2 = model.getColumn(columnIdx);
            String columnName = column2 != null ? column2.name : null;
            boolean enabled = this.myResultPanel.isColumnEnabled(columnIdx);
            Language contentLanguage = this.myResultPanel.getContentLanguage(columnIdx);
            int position = column2View.applyAsInt(columnIdx.value);
            if (columnName == null || enabled && contentLanguage == Language.ANY && position == columnIdx.value) continue;
            State.Column attributes2 = new State.Column();
            attributes2.name = columnName;
            attributes2.enabled = enabled;
            attributes2.languageId = contentLanguage.getID();
            attributes2.position = DatabaseTableFileEditor.toSerializedPosition(position);
            columnAttributes.add(attributes2);
        }
    }

    private static int toSerializedPosition(int position) {
        if (position == -1) {
            return position;
        }
        return position + 1;
    }

    public static int fromSerializedPosition(int position) {
        if (position == -1) {
            return position;
        }
        return position - 1;
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        boolean transpose;
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(17);
        }
        State s2 = (State)ObjectUtils.tryCast((Object)state, State.class);
        DatabaseSettings settings = DatabaseSettings.getSettings();
        boolean bl = transpose = settings.getAutoTransposeMode() == DatabaseSettings.AutoTransposeMode.ALWAYS;
        if (s2 != null) {
            int pageSize = s2.lastOpenedTimestamp >= settings.getPageSizeUpdatedTimestamp() ? s2.pageSize : (settings.isLimitPageSize() ? DbImplUtil.getPageSize(DataGridUtil.getDbms(this.getDataGrid())) : -1);
            this.myResultPanel.getDataHookup().getPageModel().setPageSize(pageSize);
            this.applyColumnAttributes(s2.columnAttributes);
            this.applyFilterState(s2);
            this.applySortingState(s2);
            this.applyExtractorFactory(s2.extractorFactoryId);
            this.applyPresentationMode(s2.presentationMode);
            transpose |= s2.transposed;
        }
        this.myResultPanel.getResultView().setTransposed(transpose);
        if (!this.stateWasSet && !OpenDataFileDescriptor.isDataLoadedByDescriptor(this.myFile)) {
            RowSortOrder.Type ordering = DatabaseSettings.getSettings().getDefaultTableOrdering();
            if (ordering != null) {
                this.setOrderingText(ordering);
            }
            this.myLoadingManager.onEditorStateApplied();
        }
        this.stateWasSet = true;
    }

    private void setOrderingText(final @NotNull RowSortOrder.Type ordering) {
        DasTable table;
        if (ordering == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(18);
        }
        if ((table = DataGridUtilCore.getDatabaseTable(this.myResultPanel)) != null) {
            DatabaseTableFileEditor.setOrderingText(this.myResultPanel, ordering);
            return;
        }
        final DatabaseGridDataHookUp hookUp = (DatabaseGridDataHookUp)ObjectUtils.tryCast(this.myResultPanel.getDataHookup(), DatabaseGridDataHookUp.class);
        if (hookUp == null) {
            return;
        }
        final MessageBusConnection connection2 = this.myResultPanel.getProject().getMessageBus().connect();
        connection2.subscribe(DataSourceStorage.TOPIC, (Object)new DataSourceStorage.Listener(){

            @Override
            public void dataSourceModelLoaded(@NotNull LocalDataSource dataSource2, @NotNull DasModel model) {
                if (dataSource2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (model == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (dataSource2 == DbImplUtil.getLocalDataSource(hookUp.getDataSource())) {
                    DatabaseTableFileEditor.setOrderingText(DatabaseTableFileEditor.this.myResultPanel, ordering);
                    connection2.disconnect();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/editor/DatabaseTableFileEditor$2";
                objectArray[2] = "dataSourceModelLoaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void setOrderingText(@NotNull DataGrid grid, @NotNull RowSortOrder.Type ordering) {
        Document sortingDocument;
        if (grid == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(19);
        }
        if (ordering == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(20);
        }
        if (ordering == RowSortOrder.Type.UNSORTED) {
            return;
        }
        DasTable table = DataGridUtilCore.getDatabaseTable(grid);
        if (table == null) {
            return;
        }
        JBIterable<String> columnNames = DatabaseTableFileEditor.getColumnsForOrdering(table);
        GridSortingModel sortingModel = grid.getDataHookup().getSortingModel();
        Document document = sortingDocument = sortingModel == null ? null : sortingModel.getDocument();
        if (sortingDocument == null || columnNames == null) {
            return;
        }
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(DataGridUtil.getDatabaseDialect(grid), (DasObject)table);
        List order = columnNames.map(name -> new Pair(name, (Object)ordering)).toList();
        DmlUtilKt.dmlGenerator(DataGridUtil.getDbms(grid)).generate(DmlTaskKt.orderBy(new ColumnsOrderBy(order)).build(builder));
        String statement = builder.getStatement();
        if (StringUtil.isEmptyOrSpaces((String)statement)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> sortingDocument.setText((CharSequence)statement));
    }

    @Nullable
    private static JBIterable<String> getColumnsForOrdering(DasTable table) {
        JBIterable columns;
        Dbms dbms = DbImplUtilCore.getDbms(table);
        if (dbms.is(Dbms.MONGO)) {
            DasTypedObject idColumn = (DasTypedObject)table.getDasChildren(ObjectKind.COLUMN).find(column2 -> column2 instanceof DasTypedObject && "_id".equals(column2.getName()));
            if (idColumn == null) {
                return null;
            }
            columns = JBIterable.of((Object)idColumn);
        } else {
            DasTableKey primaryKey = (DasTableKey)table.getDasChildren(ObjectKind.KEY).find(key -> key instanceof DasTableKey && ((DasTableKey)key).isPrimary());
            if (primaryKey == null) {
                return null;
            }
            columns = JBIterable.from(primaryKey.getColumnsRef().resolveObjects());
        }
        if (columns.size() != 1) {
            return null;
        }
        boolean allColumnsAreNumbers = columns.find(column2 -> {
            Domain domain = DbImplUtil.getDomain(column2);
            return domain == null || (!dbms.is(Dbms.MONGO) || !"ObjectId".equals(domain.simpleName())) && domain.getLogicType() != LogicalType.UNSIGNED_NUMBER && domain.getLogicType() != LogicalType.NUMBER && (domain.getLogicType() != LogicalType.FIXED_POINT_NUMBER || column2.getDataType().getScale() != 0);
        }) == null;
        return allColumnsAreNumbers ? JBIterable.from((Iterable)columns).map(column2 -> column2.getName()) : null;
    }

    private void applyExtractorFactory(String extractorFactoryId) {
        if (extractorFactoryId == null || extractorFactoryId.isEmpty()) {
            return;
        }
        DataExtractorFactory extractorFactory = DataExtractorFactories.findById(extractorFactoryId);
        if (extractorFactory instanceof DataExtractorFactory.Text) {
            this.myResultPanel.setExtractorFactory((DataExtractorFactory.Text)extractorFactory);
        }
    }

    private void applyPresentationMode(String presentationMode) {
        if (presentationMode == null) {
            return;
        }
        try {
            GridPresentationMode mode = GridPresentationMode.valueOf(presentationMode);
            this.myResultPanel.setPresentationMode(mode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void applyColumnAttributes(@Nullable List<State.Column> columnAttributes) {
        if (ContainerUtil.isEmpty(columnAttributes)) {
            return;
        }
        HashMap<String, EditorTableResultPanel.InitialColumnProperties> props = new HashMap<String, EditorTableResultPanel.InitialColumnProperties>(columnAttributes.size());
        for (State.Column attributes2 : columnAttributes) {
            Language contentLanguage = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)attributes2.languageId), (Object)Language.ANY);
            props.put(attributes2.name, new EditorTableResultPanel.InitialColumnProperties(attributes2.enabled, contentLanguage, attributes2.position));
        }
        if (!props.isEmpty()) {
            this.myResultPanel.setInitialColumnProperties(props);
        }
    }

    private boolean shouldRestoreFilter(@NotNull State state) {
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(21);
        }
        return StringUtil.equals((CharSequence)state.projectRestartId, (CharSequence)DatabaseStartupActivity.DataEditorConfigurator.getLaunchId(this.getProject()));
    }

    private void applySortingState(@NotNull State state) {
        State.Sorting sortingState;
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(22);
        }
        if ((sortingState = state.mySorting) == null) {
            return;
        }
        ArrayList<String> history = sortingState.history != null ? sortingState.history : new ArrayList<String>();
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> model = this.myResultPanel.getDataHookup().getSortingModel();
        if (model != null) {
            model.setHistory(history);
        }
    }

    private void applyFilterState(@NotNull State state) {
        State.Filter filterState;
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(23);
        }
        if ((filterState = state.filter) == null) {
            return;
        }
        ArrayList<String> filterHistory = filterState.history != null ? filterState.history : new ArrayList<String>();
        GridFilteringModel model = this.myResultPanel.getDataHookup().getFilteringModel();
        if (model != null) {
            model.setHistory(filterHistory);
        }
        if (!this.shouldRestoreFilter(state)) {
            String whereClause2 = DmlUtilKt.dmlGenerator(DataGridUtil.getDbms(this.getDataGrid())).getEmptyFilterText();
            this.myResultPanel.setFilterText(whereClause2, -1);
            return;
        }
        if (this.myResultPanel.isFilteringComponentShown() != filterState.enabled) {
            this.myResultPanel.toggleFilteringComponent();
        }
        this.myResultPanel.setFilterText(filterState.text, -1);
        if (StringUtil.isNotEmpty((String)filterState.text)) {
            this.myResultPanel.setIgnoreCurrentFilterText(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/DatabaseTableFileEditor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingState";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnAttributes";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGrid";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateExtractorFactoryState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateSortingState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateFilterState";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateColumnAttributes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setOrderingText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreFilter";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applySortingState";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "applyFilterState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDelayedLoadingManager
    implements LoadingManager {
        private MyDelayedLoadingManager() {
        }

        @Override
        public void onInit() {
            DatabaseStartupActivity.DataEditorConfigurator.delayLoading(DatabaseTableFileEditor.this.myResultPanel);
        }

        @Override
        public void onEditorStateApplied() {
        }

        @Override
        public void reload() {
            DatabaseStartupActivity.DataEditorConfigurator.disableLoadingDelay(DatabaseTableFileEditor.this.myResultPanel);
            DeferredLoader.installOn(DatabaseTableFileEditor.this.myResultPanel);
        }
    }

    private class MyInstantLoadingManager
    implements LoadingManager {
        private MyInstantLoadingManager() {
        }

        @Override
        public void onInit() {
        }

        @Override
        public void onEditorStateApplied() {
            DeferredLoader.installOn(DatabaseTableFileEditor.this.myResultPanel);
        }

        @Override
        public void reload() {
            DeferredLoader.installOn(DatabaseTableFileEditor.this.myResultPanel);
        }
    }

    static interface LoadingManager {
        public void onInit();

        public void onEditorStateApplied();

        public void reload();
    }

    private static final class DeferredLoader
    implements Disposable,
    Activatable {
        private static final Map<DatabaseTableGridDataHookUp, DeferredLoader> LOADERS = ConcurrentCollectionFactory.createConcurrentIdentityMap();
        private final DataGridSessionClient mySession;
        private final Collection<DataGrid> myGrids;
        private final ActionCallback myInitialLoadCallback;
        private LoadingState myState;

        private DeferredLoader(@NotNull DataGridSessionClient session2) {
            if (session2 == null) {
                DeferredLoader.$$$reportNull$$$0(0);
            }
            this.myGrids = new WeakList();
            this.myInitialLoadCallback = new ActionCallback();
            this.myState = LoadingState.NONE;
            this.mySession = session2;
            Disposer.register((Disposable)this.mySession, (Disposable)this);
        }

        public static void installOn(@NotNull DataGrid grid) {
            DataGridSessionClient client;
            DeferredLoader loader;
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(1);
            }
            if ((loader = LOADERS.get(client = DeferredLoader.getTableHookUp(grid))) == null) {
                loader = new DeferredLoader(client);
                LOADERS.put(client, loader);
            }
            loader.addGrid(grid);
        }

        public static void doWhenLoaded(@NotNull DataGrid grid, @NotNull Runnable action2) {
            DeferredLoader loader;
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(2);
            }
            if (action2 == null) {
                DeferredLoader.$$$reportNull$$$0(3);
            }
            ActionCallback callback = (loader = LOADERS.get(DeferredLoader.getTableHookUp(grid))) == null ? ActionCallback.DONE : loader.myInitialLoadCallback;
            callback.doWhenDone((Runnable)new DoWhenLoadedActionWrapper(grid, action2));
        }

        @NotNull
        private static DataGridSessionClient getTableHookUp(@NotNull DataGrid grid) {
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(4);
            }
            DataGridSessionClient dataGridSessionClient = (DataGridSessionClient)grid.getDataHookup();
            if (dataGridSessionClient == null) {
                DeferredLoader.$$$reportNull$$$0(5);
            }
            return dataGridSessionClient;
        }

        private void addGrid(@NotNull DataGrid grid) {
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(6);
            }
            this.myGrids.add(grid);
            if (this.myState == LoadingState.NONE) {
                Disposer.register((Disposable)grid, (Disposable)new UiNotifyConnector.Once((Component)((Object)grid.getComponent()), (Activatable)this));
            }
        }

        public void showNotify() {
            if (this.myState != LoadingState.NONE) {
                return;
            }
            this.myState = LoadingState.INITIATED;
            for (DataGrid grid : this.myGrids) {
                DataGridUtil.setProgressMessage(grid, DatabaseBundle.message("DataView.connecting", new Object[0]));
            }
            this.mySession.getProject().getMessageBus().connect((Disposable)this).subscribe(DbPsiFacade.TOPIC, o -> this.update());
            this.update();
        }

        private void update() {
            DbElement element2;
            VirtualFile file = this.mySession.getVirtualFile();
            DbElement dbElement = element2 = file.isValid() ? DbImplUtilCore.findElement(this.mySession.getProject(), file) : null;
            if (element2 == null) {
                return;
            }
            if (this.myState != LoadingState.COMPLETED && DatabaseEditorHelper.isTableDataAvailable(element2)) {
                this.myState = LoadingState.COMPLETED;
                this.loadTable();
            }
        }

        private void loadTable() {
            DataGrid grid = (DataGrid)JBIterable.from(this.myGrids).first();
            final GridRequestSource initialLoadSource = new GridRequestSource(grid == null ? null : new DataGridRequestPlace(grid));
            Disposable initialLoadDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)initialLoadDisposable);
            this.mySession.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){
                private String myErrorMessage;

                @Override
                public void error(@NotNull GridRequestSource source, @Nullable String message2, @Nullable List<DatabaseErrorHandler.Fix> fixes, @Nullable Throwable th) {
                    if (source == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (initialLoadSource == source) {
                        this.myErrorMessage = message2;
                    }
                }

                @Override
                public void updateCountReceived(@NotNull GridRequestSource source, int updateCount2) {
                    if (source == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                @Override
                public void requestFinished(@NotNull GridRequestSource source, boolean success) {
                    if (source == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (initialLoadSource == source) {
                        if (!success) {
                            myInitialLoadCallback.reject(this.myErrorMessage);
                        } else {
                            myInitialLoadCallback.setDone();
                        }
                        Disposer.dispose((Disposable)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "source";
                    objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "error";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateCountReceived";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "requestFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, initialLoadDisposable);
            this.mySession.getLoader().loadFirstPage(initialLoadSource);
        }

        public void dispose() {
            LOADERS.remove(this.mySession);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableHookUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "installOn";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doWhenLoaded";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableHookUp";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addGrid";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DoWhenLoadedActionWrapper
        implements Runnable,
        Disposable {
            private Runnable myAction;

            DoWhenLoadedActionWrapper(@NotNull DataGrid grid, @NotNull Runnable action2) {
                if (grid == null) {
                    DoWhenLoadedActionWrapper.$$$reportNull$$$0(0);
                }
                if (action2 == null) {
                    DoWhenLoadedActionWrapper.$$$reportNull$$$0(1);
                }
                this.myAction = action2;
                Disposer.register((Disposable)grid, (Disposable)this);
            }

            public void dispose() {
                this.myAction = null;
            }

            @Override
            public void run() {
                try {
                    if (this.myAction != null) {
                        this.myAction.run();
                    }
                }
                finally {
                    this.myAction = null;
                    Disposer.dispose((Disposable)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "grid";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$DoWhenLoadedActionWrapper";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        static enum LoadingState {
            NONE,
            INITIATED,
            COMPLETED;

        }
    }

    static class State
    implements FileEditorState,
    Serializable {
        @Attribute(value="lastOpenedTimestamp")
        public long lastOpenedTimestamp = 0L;
        @Attribute(value="presentationMode")
        public String presentationMode = "";
        @Attribute(value="transposed")
        public boolean transposed = false;
        @Attribute(value="sessionName")
        @Nls
        public String sessionName = null;
        @Property(surroundWithTag=false)
        public Filter filter = new Filter();
        @Property(surroundWithTag=false)
        public Sorting mySorting = new Sorting();
        @XCollection(propertyElementName="column-attributes", elementTypes={Column.class})
        public List<Column> columnAttributes = new ArrayList<Column>();
        @Attribute(value="projectRestartId")
        public String projectRestartId = null;
        @Attribute(value="pageSize")
        public int pageSize = -2;
        @Attribute(value="extractor")
        public String extractorFactoryId = "";

        State() {
        }

        public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
            if (otherState == null) {
                State.$$$reportNull$$$0(0);
            }
            if (level == null) {
                State.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "otherState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/editor/DatabaseTableFileEditor$State";
            objectArray[2] = "canBeMergedWith";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        @Tag(value="column")
        static class Column
        implements Serializable {
            @Attribute(value="name")
            public String name = "";
            @Attribute(value="enabled")
            public boolean enabled = true;
            @Attribute(value="languageId")
            public String languageId = Language.ANY.getID();
            @Attribute(value="position")
            public int position;

            Column() {
            }
        }

        @Tag(value="sorting")
        static class Sorting
        implements Serializable {
            @Property(surroundWithTag=false)
            @XCollection(elementName="sort", valueAttributeName="text")
            public List<String> history = new ArrayList<String>();

            Sorting() {
            }
        }

        @Tag(value="filtering")
        static class Filter
        implements Serializable {
            @Attribute(value="enabled")
            public boolean enabled = true;
            @Transient
            public String text = "";
            @Property(surroundWithTag=false)
            @XCollection(elementName="filter", valueAttributeName="text")
            public List<String> history = new ArrayList<String>();

            Filter() {
            }
        }
    }
}

