/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackend;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendFiles;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageV1;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DbSrcStorage {
    private static final ObjectPath ROOT_PATH = ObjectPath.create("", ObjectKind.ROOT);
    public static final String STORAGE_SUBDIR = "storage_v2";
    private final String myProjectId;
    private final String myDataSourceId;
    private final DbSrcBackend myBackend;
    private final AtomicReference<Set<ObjectPath>> myDirtyDirs;
    private final AtomicReference<Set<ObjectPath>> myDirtyDirsRec;
    private final AtomicReference<Set<ObjectPath>> myDirtySrc;
    private final Alarm myFlusher;
    private final boolean myCheckSanity;

    public DbSrcStorage(@Nullable Project project, @NotNull String rootPath, @NotNull String dataSourceId) {
        if (rootPath == null) {
            DbSrcStorage.$$$reportNull$$$0(0);
        }
        if (dataSourceId == null) {
            DbSrcStorage.$$$reportNull$$$0(1);
        }
        this.myDirtyDirs = new AtomicReference<Set>(ContainerUtil.newConcurrentSet());
        this.myDirtyDirsRec = new AtomicReference<Set>(ContainerUtil.newConcurrentSet());
        this.myDirtySrc = new AtomicReference<Set>(ContainerUtil.newConcurrentSet());
        this.myCheckSanity = ApplicationManager.getApplication().isUnitTestMode();
        this.myProjectId = DbSrcUtils.getProjectId(project);
        this.myFlusher = AlarmFactory.getInstance().create(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)(project == null ? ApplicationManager.getApplication() : project));
        this.myDataSourceId = dataSourceId;
        this.myBackend = new DbSrcBackend(rootPath + File.separator + dataSourceId + File.separator + STORAGE_SUBDIR, new DbSrcBackend.Listener(){

            @Override
            public void fileChanged(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type) {
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (DbSrcStorage.this.myDirtySrc.get().add(object)) {
                    this.scheduleFlush();
                }
            }

            @Override
            public void dirChanged(@Nullable ObjectPath object, boolean staging, boolean recursive) {
                if ((recursive ? DbSrcStorage.this.myDirtyDirsRec : DbSrcStorage.this.myDirtyDirs).get().add((ObjectPath)ObjectUtils.chooseNotNull((Object)object, (Object)ROOT_PATH))) {
                    this.scheduleFlush();
                }
            }

            @Override
            public void fileMoved(@NotNull ObjectPath from, @NotNull ObjectPath to) {
                if (from == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (to == null) {
                    1.$$$reportNull$$$0(3);
                }
                DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
                ArrayList<Object> events = new ArrayList<Object>();
                boolean move = from.parent != to.parent;
                boolean rename2 = !from.matches(to);
                for (DbSrcFileSystemCore.ItemTypeOrFolder item : (DbSrcFileSystemCore.ItemTypeOrFolder[])ContainerUtil.ar((Object[])new DbSrcFileSystemCore.ItemTypeOrFolder[]{DbSrcFileSystemCore.ItemType.FOLDER, DbSrcFileSystemCore.ItemType.SRC, DbSrcFileSystemCore.ItemType.USER_BASE, DbSrcFileSystemCore.ItemType.ORIG})) {
                    VirtualFile cached = (VirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)DbSrcStorage.this.getPath((ObjectPath)from, (DbSrcFileSystemCore.ItemTypeOrFolder)item)).first;
                    VirtualFile cachedTarget = (VirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)DbSrcStorage.this.getPath((ObjectPath)to, (DbSrcFileSystemCore.ItemTypeOrFolder)item)).first;
                    if (cached == null) continue;
                    if (cachedTarget != null) {
                        events.add(new VFileDeleteEvent((Object)fs, cachedTarget, false));
                    }
                    if (rename2) {
                        String fromName = DbSrcFileSystem.getFileName(from, item);
                        String toName = DbSrcFileSystem.getFileName(to, item);
                        events.add(new VFilePropertyChangeEvent((Object)fs, cached, "name", (Object)fromName, (Object)toName, false));
                    }
                    if (!move) continue;
                    VirtualFile target = (VirtualFile)VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)DbSrcStorage.this.getPath((ObjectPath)to.parent, (ObjectKind)to.kind)).first;
                    events.add(new VFileMoveEvent((Object)fs, cached, target));
                }
                if (!events.isEmpty()) {
                    PersistentFS.getInstance().processEvents(events);
                }
            }

            private void scheduleFlush() {
                if (DbSrcStorage.this.myFlusher.isDisposed()) {
                    return;
                }
                DbSrcStorage.this.myFlusher.cancelAllRequests();
                DbSrcStorage.this.myFlusher.addRequest(() -> DbSrcStorage.this.flushToFs(false), 800);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "from";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "to";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileChanged";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean migrate(@NotNull DasModel model) {
        String v1Path;
        if (model == null) {
            DbSrcStorage.$$$reportNull$$$0(2);
        }
        if (DbSrcStorageV1.exists(v1Path = StringUtil.trimEnd((String)this.myBackend.getRoot(), (String)(File.separator + STORAGE_SUBDIR)))) {
            try {
                DbSrcStorageV1.migrate(this, v1Path, model);
                this.flushToFs(false);
                DbSrcStorageV1.LOG.info("Migrated storage for " + this.myDataSourceId);
                FileUtil.createDirectory((File)new File(this.myBackend.getRoot()));
            }
            catch (Throwable e) {
                DbSrcStorageV1.LOG.warn(e);
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getDataSourceId() {
        String string = this.myDataSourceId;
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean hasGroup(@Nullable ObjectPath object, @NotNull ObjectKind group) {
        if (group == null) {
            DbSrcStorage.$$$reportNull$$$0(4);
        }
        return this.myBackend.hasGroup(object, group, false) || this.myBackend.hasGroup(object, group, true);
    }

    public boolean hasChildren(@Nullable ObjectPath object) {
        return this.myBackend.hasChildren(object, false) || this.myBackend.hasChildren(object, true);
    }

    @Nullable
    public FileAttributes getSrcAttributes(@NotNull ObjectPath object, @NotNull DbSrcFileSystemCore.ItemType type, boolean force) {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(5);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(6);
        }
        if (type == DbSrcFileSystemCore.ItemType.ORIG) {
            if (!force && this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) == null) {
                return null;
            }
            return DbSrcStorage.overrideWritable(this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.ORIGINAL), false);
        }
        if (type == DbSrcFileSystemCore.ItemType.USER_BASE) {
            if (!force && this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) == null) {
                return null;
            }
            return DbSrcStorage.overrideWritable(this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER_BASE), false);
        }
        if (type == DbSrcFileSystemCore.ItemType.SRC) {
            FileAttributes baseAttrs = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.ORIGINAL);
            FileAttributes attrs = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER);
            if (attrs == null || baseAttrs == null) {
                return attrs == null ? DbSrcStorage.overrideWritable(baseAttrs, true) : attrs;
            }
            return attrs;
        }
        return null;
    }

    public void listGroups(@Nullable ObjectPath object, @NotNull Consumer<? super ObjectKind> consumer2) {
        if (consumer2 == null) {
            DbSrcStorage.$$$reportNull$$$0(7);
        }
        this.myBackend.listGroups(object, false, consumer2);
        this.myBackend.listGroups(object, true, consumer2);
    }

    public void list(@Nullable ObjectPath object, @NotNull ObjectKind group, @NotNull ListingConsumer consumer2) {
        if (group == null) {
            DbSrcStorage.$$$reportNull$$$0(8);
        }
        if (consumer2 == null) {
            DbSrcStorage.$$$reportNull$$$0(9);
        }
        this.myBackend.list(object, group, false, consumer2);
        this.myBackend.list(object, group, true, consumer2);
    }

    public void putUserContent(@NotNull ObjectPath object, byte @Nullable [] content) throws IOException {
        boolean differs;
        DbSrcStorageDsMetadata.MetaData metaData;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(10);
        }
        if ((metaData = this.myBackend.getMetaData(object)) == null) {
            metaData = DbSrcStorageDsMetadata.MetaData.EMPTY;
        }
        int hc = metaData.contentHash == 0 ? 0 : DbSrcUtilsCore.StringHashBuilder.hashStep(0, content);
        boolean bl = differs = content == null || !this.myCheckSanity && hc != metaData.contentHash;
        if (!differs) {
            try (InputStream stream = this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.ORIGINAL);){
                boolean bl2 = differs = stream == null;
                if (!differs) {
                    differs = DbSrcUtils.contentDiffers(stream, content);
                    if (this.myCheckSanity && hc != metaData.contentHash && !differs) {
                        throw new AssertionError((Object)"wrong hash code stored");
                    }
                }
            }
            catch (FileNotFoundException e) {
                differs = true;
            }
        }
        if (!differs) {
            content = null;
        }
        if (content == null) {
            this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER_BASE, null, null);
        }
        this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER, content, null);
    }

    private void putContentOrRemove(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, byte @Nullable [] content, @Nullable DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        boolean remove;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(11);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(12);
        }
        boolean bl = remove = content == null && DbSrcStorageDsMetadata.MetaData.isEmpty(metaData) && !this.myBackend.hasChildren(object, DbSrcBackendUtils.isStaging(type));
        if (remove && (type != DbSrcBackendUtils.SrcType.USER_BASE || this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) == null)) {
            this.myBackend.dropObject(object, DbSrcBackendUtils.isStaging(type));
        } else {
            this.myBackend.putContent(object, type, content, metaData);
        }
    }

    public void setTimestamp(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, long timestamp) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(13);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(14);
        }
        this.myBackend.setTimestamp(object, type, timestamp);
    }

    public void dropObject(@NotNull ObjectPath object, boolean original) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(15);
        }
        if (original) {
            this.introduceUserBases(object);
        }
        this.myBackend.dropObject(object, !original);
    }

    private void introduceUserBases(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(16);
        }
        this.introduceUserBase(object);
        this.myBackend.listGroups(object, true, (Consumer<? super ObjectKind>)((Consumer)kind -> this.myBackend.list(object, (ObjectKind)kind, true, (child, type) -> {
            if (type == DbSrcBackendUtils.SrcType.USER) {
                this.introduceUserBases(child);
            }
        })));
    }

    private void introduceUserBase(@NotNull ObjectPath object) {
        boolean hasUserChanges;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(17);
        }
        boolean bl = hasUserChanges = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) != null;
        if (hasUserChanges) {
            try {
                byte[] original = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL);
                if (original != null) {
                    this.myBackend.putContent(object, DbSrcBackendUtils.SrcType.USER_BASE, original, null);
                }
            }
            catch (IOException e) {
                DbSrcBackendFiles.LOG.warn("Backup removed user-modified object: " + object, (Throwable)e);
            }
        }
    }

    public void removeBaseContent(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(18);
        }
        this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER_BASE, null, null);
    }

    public void putOriginalContent(@NotNull ObjectPath object, byte @Nullable [] content, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        boolean shouldExist;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(19);
        }
        if (metaData == null) {
            DbSrcStorage.$$$reportNull$$$0(20);
        }
        int hash = content == null ? 0 : DbSrcUtilsCore.StringHashBuilder.hashStep(0, content);
        DbSrcStorageDsMetadata.MetaData curMetaData = this.myBackend.getMetaData(object);
        DbSrcStorageDsMetadata.MetaData newMetaData = new DbSrcStorageDsMetadata.MetaData(metaData.srcVersion, hash, metaData.offsets, metaData.kinds, metaData.introContentVersion, metaData.genContentVersion);
        boolean looksSimilar = newMetaData.equals(curMetaData);
        boolean exists = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.ORIGINAL) != null;
        boolean bl = shouldExist = content != null;
        if (looksSimilar && exists == shouldExist) {
            return;
        }
        try (DbSrcBackendFiles.Locker lock = this.myBackend.writeLock();){
            boolean addUserBase;
            this.removeContentIfMatched(object, DbSrcBackendUtils.SrcType.USER, content);
            if (this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER) != null) {
                addUserBase = this.myBackend.getSrcAttributes(object, DbSrcBackendUtils.SrcType.USER_BASE) == null;
                this.removeContentIfMatched(object, DbSrcBackendUtils.SrcType.USER_BASE, content);
            } else {
                addUserBase = false;
                this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER_BASE, null, null);
            }
            if (addUserBase) {
                this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.USER_BASE, this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL), null);
            }
            this.putContentOrRemove(object, DbSrcBackendUtils.SrcType.ORIGINAL, content, newMetaData);
        }
    }

    private void removeContentIfMatched(@NotNull ObjectPath object, DbSrcBackendUtils.SrcType type, byte @Nullable [] content) throws IOException {
        boolean differs;
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(21);
        }
        if (content == null) {
            return;
        }
        try (InputStream stream = this.myBackend.getContentInputStream(object, type);){
            differs = stream == null || DbSrcUtils.contentDiffers(stream, content);
        }
        catch (FileNotFoundException ignore) {
            differs = true;
        }
        if (!differs) {
            this.putContentOrRemove(object, type, null, null);
        }
    }

    @Nullable
    public OutputStream getContentOutputStream(final @NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(22);
        }
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    DbSrcStorage.this.putUserContent(object, this.toByteArray());
                }
            }
        };
    }

    public void moveAll(@NotNull ObjectPath from, @NotNull ObjectPath to) throws IOException {
        if (from == null) {
            DbSrcStorage.$$$reportNull$$$0(23);
        }
        if (to == null) {
            DbSrcStorage.$$$reportNull$$$0(24);
        }
        this.myBackend.moveAll(from, to);
    }

    public void putMetaData(@NotNull ObjectPath path, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (path == null) {
            DbSrcStorage.$$$reportNull$$$0(25);
        }
        if (metaData == null) {
            DbSrcStorage.$$$reportNull$$$0(26);
        }
        this.myBackend.putMetaData(path, false, metaData);
    }

    @Nullable
    public DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull ObjectPath path) {
        if (path == null) {
            DbSrcStorage.$$$reportNull$$$0(27);
        }
        return this.myBackend.getMetaData(path);
    }

    @NotNull
    public String getRoot() {
        String string = this.myBackend.getRoot();
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(28);
        }
        return string;
    }

    public byte @Nullable [] getContent(@NotNull ObjectPath object, @NotNull DbSrcFileSystemCore.ItemType type) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(29);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(30);
        }
        if (type == DbSrcFileSystemCore.ItemType.ORIG) {
            return this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
        if (type == DbSrcFileSystemCore.ItemType.USER_BASE) {
            byte[] content = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.USER_BASE);
            if (content == null) {
                content = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL);
            }
            return content;
        }
        if (type == DbSrcFileSystemCore.ItemType.SRC) {
            byte[] content = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.USER);
            if (content == null) {
                content = this.myBackend.getContent(object, DbSrcBackendUtils.SrcType.ORIGINAL);
            }
            return content;
        }
        return null;
    }

    @Nullable
    public InputStream getContentInputStream(@NotNull ObjectPath object, @NotNull DbSrcFileSystemCore.ItemType type) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(31);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(32);
        }
        if (type == DbSrcFileSystemCore.ItemType.ORIG) {
            return this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
        if (type == DbSrcFileSystemCore.ItemType.USER_BASE) {
            try {
                InputStream stream = this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.USER_BASE);
                if (stream != null) {
                    return stream;
                }
            }
            catch (FileNotFoundException stream) {
                // empty catch block
            }
            return this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
        if (type == DbSrcFileSystemCore.ItemType.SRC) {
            try {
                InputStream stream = this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.USER);
                if (stream != null) {
                    return stream;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return this.myBackend.getContentInputStream(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
        return null;
    }

    public void finish() {
        this.myBackend.finish();
    }

    public void drop() {
        this.myBackend.drop();
    }

    @TestOnly
    public void resetCaches() {
        this.myBackend.resetCaches();
    }

    @TestOnly
    public DbSrcBackend getBackend() {
        return this.myBackend;
    }

    public void flushToFs(boolean async) {
        Set<ObjectPath> dirtySrc = this.myDirtySrc.getAndSet(ContainerUtil.newConcurrentSet());
        Set<ObjectPath> dirtyDirs = this.myDirtyDirs.getAndSet(ContainerUtil.newConcurrentSet());
        Set<ObjectPath> dirtyDirsRec = this.myDirtyDirsRec.getAndSet(ContainerUtil.newConcurrentSet());
        DbSrcFileSystem fs = DbSrcFileSystem.getInstance();
        HashSet<Object> needSynchronise = new HashSet<Object>();
        for (ObjectPath path : dirtySrc) {
            for (int i2 = 0; i2 < 2; ++i2) {
                NewVirtualFile p2;
                Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)this.getPath(path, i2 == 0 ? DbSrcFileSystemCore.ItemType.SRC : DbSrcFileSystemCore.ItemType.ORIG));
                VirtualFile vfile = (VirtualFile)ObjectUtils.chooseNotNull((Object)((NewVirtualFile)cached.first), (Object)((NewVirtualFile)cached.second));
                if (vfile == null || !needSynchronise.add(vfile)) continue;
                boolean recursive = cached.first == null;
                VfsUtil.markDirty((boolean)recursive, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
                NewVirtualFile newVirtualFile = p2 = cached.first == null ? null : ((NewVirtualFile)cached.first).getParent();
                if (p2 == null || !needSynchronise.add(p2)) continue;
                VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{p2});
            }
        }
        for (int i3 = 0; i3 < 2; ++i3) {
            boolean recursive = i3 == 0;
            for (ObjectPath path : recursive ? dirtyDirsRec : dirtyDirs) {
                if (path == ROOT_PATH) {
                    path = null;
                }
                Pair cached = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)fs, (String)this.getPath(path, DbSrcFileSystemCore.ItemType.FOLDER));
                VirtualFile vfile = (VirtualFile)ObjectUtils.chooseNotNull((Object)((NewVirtualFile)cached.first), (Object)((NewVirtualFile)cached.second));
                if (vfile == null || !needSynchronise.add(vfile)) continue;
                VfsUtil.markDirty((recursive && cached.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{vfile});
            }
        }
        if (!needSynchronise.isEmpty()) {
            RefreshQueue.getInstance().refresh(async, true, null, needSynchronise);
        }
    }

    @NotNull
    private String getPath(@Nullable ObjectPath path, @NotNull DbSrcFileSystemCore.ItemTypeOrFolder t) {
        if (t == null) {
            DbSrcStorage.$$$reportNull$$$0(33);
        }
        String string = DbSrcFileSystem.getPathFromNormalized(this.myProjectId, this.myDataSourceId, path, t);
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private String getPath(@Nullable ObjectPath path, @NotNull ObjectKind group) {
        if (group == null) {
            DbSrcStorage.$$$reportNull$$$0(35);
        }
        String string = DbSrcFileSystem.getPathFromNormalized(this.myProjectId, this.myDataSourceId, path, group);
        if (string == null) {
            DbSrcStorage.$$$reportNull$$$0(36);
        }
        return string;
    }

    public void consume(DbSrcStorage src) throws IOException {
        src.myBackend.finish();
        try (DbSrcBackendFiles.Locker lock1 = this.myBackend.writeLock();
             DbSrcBackendFiles.Locker lock2 = src.myBackend.writeLock();){
            this.moveArea(src, false);
            this.moveArea(src, true);
            this.myBackend.resetCaches();
            src.myBackend.drop();
        }
    }

    private void moveArea(DbSrcStorage src, boolean staging) throws IOException {
        this.myBackend.dropObject(null, staging);
        File srcDir = DbSrcBackendUtils.getDir(src.myBackend.getRoot(), staging, null, null, null).toFile();
        File dstDir = DbSrcBackendUtils.getDir(this.myBackend.getRoot(), staging, null, null, null).toFile();
        if (srcDir.exists()) {
            FileUtil.copyDir((File)srcDir, (File)dstDir);
        }
    }

    private static FileAttributes overrideWritable(@Nullable FileAttributes attrs, boolean writable) {
        if (attrs == null || attrs.isWritable() == writable) {
            return attrs;
        }
        return new FileAttributes(attrs.isDirectory(), attrs.isSpecial(), attrs.isSymLink(), attrs.isHidden(), attrs.length, attrs.lastModified, writable, attrs.areChildrenCaseSensitive());
    }

    @NotNull
    private static <T> Collection<T> cheapConcat(@Nullable List<T> l1, @Nullable List<T> l2) {
        boolean e2;
        boolean e1 = l1 == null || l1.isEmpty();
        boolean bl = e2 = l2 == null || l2.isEmpty();
        if (e1 && e2) {
            Set set = Collections.emptySet();
            if (set == null) {
                DbSrcStorage.$$$reportNull$$$0(37);
            }
            return set;
        }
        if (e1) {
            List<T> list = l2;
            if (list == null) {
                DbSrcStorage.$$$reportNull$$$0(38);
            }
            return list;
        }
        if (e2) {
            List<T> list = l1;
            if (list == null) {
                DbSrcStorage.$$$reportNull$$$0(39);
            }
            return list;
        }
        HashSet<T> res2 = new HashSet<T>();
        res2.addAll(l1);
        res2.addAll(l2);
        HashSet<T> hashSet = res2;
        if (hashSet == null) {
            DbSrcStorage.$$$reportNull$$$0(40);
        }
        return hashSet;
    }

    @TestOnly
    void putContentDirect(@NotNull ObjectPath object, @NotNull DbSrcBackendUtils.SrcType type, byte @Nullable [] content) throws IOException {
        if (object == null) {
            DbSrcStorage.$$$reportNull$$$0(41);
        }
        if (type == null) {
            DbSrcStorage.$$$reportNull$$$0(42);
        }
        this.myBackend.putContent(object, type, content, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 28: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 28: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 28: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorage";
                break;
            }
            case 4: 
            case 8: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 29: 
            case 31: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 6: 
            case 12: 
            case 14: 
            case 30: 
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceId";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "cheapConcat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 3: 
            case 28: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "listGroups";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putUserContent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putContentOrRemove";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "dropObject";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "introduceUserBases";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "introduceUserBase";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeBaseContent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "putOriginalContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeContentIfMatched";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getContentOutputStream";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "moveAll";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getContentInputStream";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "putContentDirect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 28: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ListingConsumer {
        public void consume(@NotNull ObjectPath var1, @NotNull DbSrcBackendUtils.SrcTypeOrFolder var2);
    }
}

