/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcExtensions {

    public static class FilePresentation
    implements FileIconProvider,
    EditorTabTitleProvider {
        @Nullable
        public Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
            if (file == null) {
                FilePresentation.$$$reportNull$$$0(0);
            }
            return DbSrcUtilsCore.isDbSrcFile(file) ? DbSrcUtils.getIcon(project, file.getPath()) : null;
        }

        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                FilePresentation.$$$reportNull$$$0(1);
            }
            if (file == null) {
                FilePresentation.$$$reportNull$$$0(2);
            }
            boolean oneDatasource = DataSourceStorage.getProjectStorage(project).getDataSourcesImpl().skip(1).isEmpty();
            return DbSrcUtilsCore.isDbSrcFile(file) ? DbSrcUtilsCore.getEditorTabTitle(project, file, !oneDatasource, DatabaseSettings.getSettings().shortenTabNames) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcExtensions$FilePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getIcon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEditorTabTitle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UsageTypeExtension
    implements UsageTypeProvider {
        private static final ConcurrentMap<ObjectKind, UsageType> ourUsageTypes = ConcurrentFactoryMap.createMap(key -> new UsageType(DatabaseBundle.message("usage.in.0", StringUtil.capitalize((String)key.getPluralPresentableName()))));

        @Nullable
        public UsageType getUsageType(@NotNull PsiElement element2) {
            VirtualFile file;
            if (element2 == null) {
                UsageTypeExtension.$$$reportNull$$$0(0);
            }
            ObjectKind kind = DbSrcUtilsCore.isDbSrcFile(file = PsiUtilCore.getVirtualFile((PsiElement)element2)) ? DbSrcUtils.getKind(file.getPath()) : null;
            return kind == null ? null : (UsageType)ourUsageTypes.get(kind);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/srcStorage/DbSrcExtensions$UsageTypeExtension", "getUsageType"));
        }
    }
}

