/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabasePasswordField;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.ui.DatabaseAuthPanel;
import com.intellij.database.dataSource.url.ui.PasswordStorageComponent;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DatabaseCredentialsAuthProviderUi {
    private static Function<? super DatabaseAuthPanel, Boolean> ourCredentialsInterceptor = null;

    @TestOnly
    public static void setCredentialsInterceptor(Function<? super DatabaseAuthPanel, Boolean> di) {
        ourCredentialsInterceptor = di;
    }

    public static void askCredentials(@NlsContexts.DialogMessage @Nullable String message2, boolean error2, LocalDataSource dataSource2, Project project, DatabaseCredentials dc) {
        boolean ok;
        DatabaseAuthPanel auth = new DatabaseAuthPanel(project, dataSource2, dc);
        auth.reset(dataSource2, false);
        DatabaseAuthProvider.AuthWidget widget = auth.getAuthWidget();
        if (widget != null) {
            widget.forceSave();
        }
        if (ourCredentialsInterceptor == null) {
            auth.getComponent().setBorder((Border)JBUI.Borders.emptyTop((int)12));
            DialogBuilder builder = DatabaseCredentialsUi.prepareDialog(project, (error2 ? MessageType.ERROR : MessageType.WARNING).getDefaultIcon(), auth.getComponent(), DatabaseBundle.message("dialog.title.connecting.to", dataSource2.getName()), StringUtil.notNullize((String)message2));
            builder.setPreferredFocusComponent(auth.getPreferredFocusedComponent());
            ok = builder.show() == 0;
        } else {
            ok = (Boolean)ourCredentialsInterceptor.fun((Object)auth);
        }
        if (!ok) {
            throw new ProcessCanceledException();
        }
        auth.save(dataSource2, true);
    }

    public static class UserWidget
    implements DatabaseAuthProvider.AuthWidget {
        protected JBTextField myUserField;
        private JComponent myPanel;

        protected JPanel createPanel() {
            JPanel panel2 = new JPanel((LayoutManager)new GridLayoutManager(1, 6));
            this.addUserField(panel2, 0);
            return panel2;
        }

        protected void addUserField(JComponent panel2, int row) {
            JBLabel userLabel = new JBLabel(DatabaseBundle.message("database.auth.user.label", new Object[0]));
            this.myUserField = new JBTextField();
            panel2.add((Component)userLabel, UrlPropertiesPanel.createLabelConstraints(row, 0, userLabel.getPreferredSize().getWidth()));
            panel2.add((Component)this.myUserField, UrlPropertiesPanel.createSimpleConstraints(row, 1, 3));
        }

        @Override
        public void save(@NotNull LocalDataSource dataSource2, boolean copyCredentials) {
            if (dataSource2 == null) {
                UserWidget.$$$reportNull$$$0(0);
            }
            this.getComponent();
            dataSource2.setUsername(this.getUserName());
        }

        @Override
        public void reset(@NotNull LocalDataSource dataSource2, boolean resetCredentials) {
            if (dataSource2 == null) {
                UserWidget.$$$reportNull$$$0(1);
            }
            this.getComponent();
            this.myUserField.setText(dataSource2.getUsername());
        }

        @Nullable
        public String getUserName() {
            return this.myUserField.getText();
        }

        @Override
        public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                UserWidget.$$$reportNull$$$0(2);
            }
            this.getComponent();
            this.myUserField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabaseCredentialsAuthProviderUi$UserWidget$1", "textChanged"));
                }
            });
        }

        @Override
        @NotNull
        public JComponent getComponent() {
            if (this.myPanel == null) {
                this.myPanel = this.createPanel();
            }
            JComponent jComponent = this.myPanel;
            if (jComponent == null) {
                UserWidget.$$$reportNull$$$0(3);
            }
            return jComponent;
        }

        @Override
        public void hidePassword() {
        }

        @Override
        public void reloadCredentials() {
        }

        public void setUser(@NotNull String username) {
            if (username == null) {
                UserWidget.$$$reportNull$$$0(4);
            }
            this.myUserField.setText(username);
        }

        @Override
        public boolean isPasswordChanged() {
            return false;
        }

        @Override
        @NotNull
        public JComponent getPreferredFocusedComponent() {
            JBTextField jBTextField = this.myUserField;
            if (jBTextField == null) {
                UserWidget.$$$reportNull$$$0(5);
            }
            return jBTextField;
        }

        @Override
        public void forceSave() {
        }

        @Override
        public void updateFromUrl(@NotNull ParametersHolder holder) {
            String userFromParser;
            if (holder == null) {
                UserWidget.$$$reportNull$$$0(6);
            }
            if (StringUtil.isNotEmpty((String)(userFromParser = holder.getParameter("user"))) && !Objects.equals(this.getUserName(), userFromParser)) {
                this.setUser(userFromParser);
            }
        }

        @Override
        public void updateUrl(@NotNull MutableParametersHolder model) {
            if (model == null) {
                UserWidget.$$$reportNull$$$0(7);
            }
            model.setParameter("user", "");
            model.setParameter("password", "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseCredentialsAuthProviderUi$UserWidget";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "username";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseCredentialsAuthProviderUi$UserWidget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredFocusedComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setUser";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFromUrl";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "updateUrl";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class UserPassWidget
    extends UserWidget {
        private final DatabaseCredentials myCredentials;
        private final LocalDataSource myDataSource;
        private DatabasePasswordField myPasswordField;
        private PasswordStorageComponent myPasswordStorage;

        public UserPassWidget(@NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource2) {
            if (credentials == null) {
                UserPassWidget.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                UserPassWidget.$$$reportNull$$$0(1);
            }
            this.myCredentials = credentials;
            this.myDataSource = dataSource2;
        }

        @Override
        protected JPanel createPanel() {
            JPanel panel2 = new JPanel((LayoutManager)new GridLayoutManager(2, 6));
            this.addUserField(panel2, 0);
            this.addPasswordField(panel2, 1);
            return panel2;
        }

        protected void addPasswordField(JPanel panel2, int row) {
            this.myPasswordField = new DatabasePasswordField(this.myCredentials, this.myDataSource){

                @Override
                @Nullable
                protected OneTimeString extractPassword(@NotNull DatabaseCredentials credentials, @NotNull DasDataSource dataSource2) {
                    if (credentials == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (dataSource2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return credentials.getPassword(dataSource2);
                }

                @Override
                protected void setPassword(@NotNull DatabaseCredentials credentials, @NotNull DasDataSource dataSource2, @Nullable OneTimeString password) {
                    if (credentials == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (dataSource2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    credentials.setPassword(dataSource2, password);
                }

                @Override
                protected LocalDataSource getActualTarget() {
                    LocalDataSource copy = myDataSource.copy(true);
                    copy.setPasswordStorage(myPasswordStorage.getStorage());
                    return copy;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "credentials";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "dataSource";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseCredentialsAuthProviderUi$UserPassWidget$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "extractPassword";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setPassword";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myPasswordStorage = new PasswordStorageComponent();
            JBLabel passwordLabel = new JBLabel(DatabaseBundle.message("database.auth.password.label", new Object[0]));
            panel2.add((Component)passwordLabel, UrlPropertiesPanel.createLabelConstraints(row, 0, passwordLabel.getPreferredSize().getWidth()));
            panel2.add((Component)this.myPasswordField.getComponent(), UrlPropertiesPanel.createSimpleConstraints(row, 1, 3));
            JBLabel rememberLabel = new JBLabel(DatabaseBundle.message("database.auth.password.storage.label", new Object[0]));
            rememberLabel.setBorder(UrlPropertiesPanel.innerLabelBorder());
            panel2.add((Component)rememberLabel, UrlPropertiesPanel.createLabelConstraints(row, 4, rememberLabel.getPreferredSize().getWidth()));
            panel2.add((Component)this.myPasswordStorage.getComponent(), UrlPropertiesPanel.createConstraints(row, 5, 1, 0, 1, -2, true));
        }

        @Override
        public void save(@NotNull LocalDataSource dataSource2, boolean copyCredentials) {
            if (dataSource2 == null) {
                UserPassWidget.$$$reportNull$$$0(2);
            }
            super.save(dataSource2, copyCredentials);
            dataSource2.setPasswordStorage(this.myPasswordStorage.getStorage());
            if (copyCredentials) {
                this.myPasswordField.save(dataSource2);
            }
        }

        @Override
        public void reset(@NotNull LocalDataSource dataSource2, boolean resetCredentials) {
            if (dataSource2 == null) {
                UserPassWidget.$$$reportNull$$$0(3);
            }
            super.reset(dataSource2, resetCredentials);
            this.setPasswordStorage(dataSource2.getPasswordStorage());
            if (resetCredentials) {
                this.myPasswordField.setPassword(null);
            }
        }

        public void setPasswordStorage(@NotNull LocalDataSource.Storage storage) {
            if (storage == null) {
                UserPassWidget.$$$reportNull$$$0(4);
            }
            this.myPasswordStorage.setPasswordStorage(storage);
        }

        @Override
        public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                UserPassWidget.$$$reportNull$$$0(5);
            }
            super.onChanged(r);
            this.myPasswordField.getComponent().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DatabaseCredentialsAuthProviderUi$UserPassWidget$2", "textChanged"));
                }
            });
        }

        @Override
        public void hidePassword() {
            this.myPasswordField.moveToStorage();
        }

        @Override
        public void reloadCredentials() {
            this.myPasswordField.changedInStorage();
        }

        public void setPassword(@Nullable String password) {
            this.myPasswordField.setPassword(password);
        }

        @Override
        public boolean isPasswordChanged() {
            return this.myPasswordField.isModified();
        }

        @Nullable
        public OneTimeString getPassword() {
            char[] password = this.myPasswordField.getPassword();
            return password == null ? null : new OneTimeString(password);
        }

        @Override
        public void forceSave() {
            if (this.myPasswordField.getPassword() == null) {
                this.myPasswordField.setPassword("");
            }
        }

        @Override
        public void updateFromUrl(@NotNull ParametersHolder holder) {
            if (holder == null) {
                UserPassWidget.$$$reportNull$$$0(6);
            }
            String passwordFromParser = holder.getParameter("password");
            super.updateFromUrl(holder);
            if (StringUtil.isNotEmpty((String)passwordFromParser)) {
                this.setPassword(passwordFromParser);
            }
        }

        @TestOnly
        public String getVisiblePassword() {
            char[] chars = this.myPasswordField.getPasswordOpt();
            return chars == null ? null : new String(chars);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/DatabaseCredentialsAuthProviderUi$UserPassWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setPasswordStorage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onChanged";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateFromUrl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

