/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.credentialStore.Credentials;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceFacade;
import com.intellij.database.dataSource.DataSourceGeneralPanel;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DataSourceSchemasPanel;
import com.intellij.database.dataSource.DataSourceSshSslPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionComponent;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.DynamicJdbcUrlEditor;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.ui.AdvancedPropertiesPanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DataSourceConfigurable
extends AbstractDataSourceConfigurable<LocalDataSourceManager, LocalDataSource>
implements DataSourceFacade {
    private static final Key<Boolean> RESET_CONNECTION_YES_FOR_ALL_KEY = Key.create((String)"RESET_CONNECTION_YES_FOR_ALL_KEY");
    public static final Key<Function<LocalDataSource, Collection<DatabaseDriver>>> DRIVER_VARIANTS_PROVIDER = Key.create((String)"DRIVER_VARIANTS_PROVIDER");
    @NlsContexts.TabTitle
    public final String ADVANCED = DatabaseBundle.message("DataSourceConfigurable.tab.advanced", new Object[0]);
    private final JPanel myPanel = new JPanel(new BorderLayout(0, 5));
    private JBTabbedPane myTabbedPane;
    private final LocalDataSource myTempDataSource;
    private long myLastSaveStamp;
    private Couple<DataSourceInfo> myConnectionInfo;
    private DataSourceTestConnectionComponent myTestConnectionComponent;
    private DatabaseNameComponent myNameComponent;
    private DataSourceGeneralPanel myGeneralPanel;
    private DataSourceSchemasPanel mySchemasPanel;
    private DataSourceOptionsPanel myOptionsPanel;
    private DataSourceSshSslPanel mySshSslPanel;
    private AdvancedPropertiesPanel myAdvancedPanel;
    private boolean myGlobal;

    public DataSourceConfigurable(LocalDataSourceManager manager, LocalDataSource dataSource2, Project project) {
        super(manager, dataSource2, project);
        this.myTempDataSource = dataSource2.copy(true);
    }

    public void updateDatabaseInfo(@NotNull LocalDataSource source) {
        if (source == null) {
            DataSourceConfigurable.$$$reportNull$$$0(0);
        }
        this.myConnectionInfo = Couple.of((Object)((LocalDataSource)this.myDataSource).getInfo(), (Object)source.getInfo());
    }

    public DataSourceInfo getDatabaseInfo() {
        DataSourceInfo main = ((LocalDataSource)this.myDataSource).getInfo();
        return Objects.equals(Pair.getFirst(this.myConnectionInfo), main) ? (DataSourceInfo)this.myConnectionInfo.second : main;
    }

    @Override
    @NotNull
    public LocalDataSource getTempDataSource() {
        long curStamp = this.myController.getModificationTracker().getModificationCount();
        if (curStamp != this.myLastSaveStamp) {
            this.myLastSaveStamp = curStamp;
            this.saveData(this.myTempDataSource, false, true);
        } else {
            this.myTempDataSource.getInfo().copyFrom(this.getDatabaseInfo());
        }
        LocalDataSource localDataSource = this.myTempDataSource;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(1);
        }
        return localDataSource;
    }

    @NotNull
    public LocalDataSource getTempDataSourceForConnection() {
        LocalDataSource ds = ((LocalDataSource)this.myDataSource).copy(true);
        this.saveData(ds, true, true);
        LocalDataSource localDataSource = ds;
        if (localDataSource == null) {
            DataSourceConfigurable.$$$reportNull$$$0(2);
        }
        return localDataSource;
    }

    @TestOnly
    @Nullable
    public AsyncTask<?> testConnection(boolean checkConfiguration) {
        return this.myTestConnectionComponent.testConnection(checkConfiguration);
    }

    @NotNull
    public DynamicJdbcUrlEditor getUrlEditor() {
        DynamicJdbcUrlEditor dynamicJdbcUrlEditor = this.myGeneralPanel.getUrlEditor();
        if (dynamicJdbcUrlEditor == null) {
            DataSourceConfigurable.$$$reportNull$$$0(3);
        }
        return dynamicJdbcUrlEditor;
    }

    public void hidePasswords() {
        this.myGeneralPanel.hidePassword();
        this.mySshSslPanel.hidePassword();
    }

    public void reloadCredentials() {
        DatabaseAuthProvider.AuthWidget widget = this.myGeneralPanel.getUrlEditor().getAuthPanel().getAuthWidget();
        if (widget != null) {
            widget.reloadCredentials();
        }
        this.mySshSslPanel.reloadCredentials();
    }

    private JComponent createCenterPanel() {
        this.myNameComponent = new DatabaseNameComponent(this, this.myController, true);
        this.myGeneralPanel = new DataSourceGeneralPanel(this);
        this.mySchemasPanel = new DataSourceSchemasPanel(this);
        this.myOptionsPanel = new DataSourceOptionsPanel(this);
        this.myAdvancedPanel = new AdvancedPropertiesPanel(this.myProject, ((LocalDataSource)this.myDataSource).getDriverProperties(), this, this.myController);
        this.mySshSslPanel = new DataSourceSshSslPanel(this.myProject, (LocalDataSource)this.myDataSource, this);
        this.myTestConnectionComponent = new DataSourceTestConnectionComponent(this);
        this.myPanel.add((Component)this.myNameComponent.getComponent(), "North");
        this.myTabbedPane = new JBTabbedPane(1);
        this.myTabbedPane.setTabComponentInsets(null);
        this.myPanel.add((Component)this.myTabbedPane, "Center");
        this.myTabbedPane.addTab(DatabaseBundle.message("DataSourceConfigurable.tab.general", new Object[0]), (Component)this.myGeneralPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message("DataSourceConfigurable.tab.options", new Object[0]), (Component)this.myOptionsPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message("DataSourceConfigurable.tab.ssh.ssl", new Object[0]), (Component)this.mySshSslPanel.getComponent());
        this.myTabbedPane.addTab(DatabaseBundle.message("DataSourceConfigurable.tab.schemas", new Object[0]), (Component)this.mySchemasPanel.getComponent());
        this.myTabbedPane.addTab(this.ADVANCED, (Component)this.myAdvancedPanel.getComponent());
        DataSourceConfigurable.initTabbedPane(this.myTabbedPane, this.myController);
        return this.myPanel;
    }

    @Override
    public void beforeShowNotify() {
        super.beforeShowNotify();
        this.myTabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(this.myTabbedPane, this.myController));
    }

    @Override
    public void onUserActivity() {
        this.saveGeneralSettings(this.myTempDataSource, false, true);
        this.myTestConnectionComponent.setStatus(null, null, false);
        this.mySshSslPanel.getSshPanel().updateInfoLabel();
        this.myGeneralPanel.updateDriverLink();
        this.myGeneralPanel.onActivity();
    }

    public static void initTabbedPane(@NotNull JBTabbedPane tabbedPane, @NotNull DatabaseConfigEditor controller) {
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(4);
        }
        if (controller == null) {
            DataSourceConfigurable.$$$reportNull$$$0(5);
        }
        UIUtil.uiChildren((Component)tabbedPane).consumeEach(UIUtil::removeScrollBorder);
        tabbedPane.setSelectedIndex(DataSourceConfigurable.getDefaultTabIndex(tabbedPane, controller));
        tabbedPane.addChangeListener(e -> {
            int index2 = tabbedPane.getSelectedIndex();
            controller.putUserData(DatabaseConfigEditor.SELECTED_TAB_KEY, Pair.create((Object)(index2 < 0 ? null : tabbedPane.getTitleAt(index2)), (Object)index2));
        });
    }

    public static int getDefaultTabIndex(@NotNull JBTabbedPane tabbedPane, @NotNull DatabaseConfigEditor controller) {
        Pair p2;
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(6);
        }
        if (controller == null) {
            DataSourceConfigurable.$$$reportNull$$$0(7);
        }
        if ((p2 = (Pair)controller.getUserData(DatabaseConfigEditor.SELECTED_TAB_KEY)) == null) {
            return 0;
        }
        if ((Integer)p2.second < tabbedPane.getTabCount() && (Integer)p2.second >= 0 && Objects.equals(p2.first, tabbedPane.getTitleAt(((Integer)p2.second).intValue()))) {
            return (Integer)p2.second;
        }
        String title = (String)p2.first;
        int idx = DataSourceConfigurable.findTabIndex(tabbedPane, title);
        return idx == -1 ? 0 : idx;
    }

    public static int findTabIndex(@NotNull JBTabbedPane tabbedPane, String title) {
        if (tabbedPane == null) {
            DataSourceConfigurable.$$$reportNull$$$0(8);
        }
        for (int i2 = tabbedPane.getTabCount() - 1; i2 > 0; --i2) {
            if (!Objects.equals(title, tabbedPane.getTitleAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    @NlsSafe
    public String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    public void setGeneratedName(@NotNull String name) {
        if (name == null) {
            DataSourceConfigurable.$$$reportNull$$$0(9);
        }
        this.myNameComponent.setGeneratedName(name);
    }

    @Override
    public void saveData(@NotNull LocalDataSource dataSource2, boolean copyCredentials, boolean actual) {
        if (dataSource2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(10);
        }
        dataSource2.getInfo().copyFrom(this.getDatabaseInfo());
        this.saveGeneralSettings(dataSource2, copyCredentials, actual);
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.saveData(dataSource2);
        }
        if (this.myAdvancedPanel != null) {
            this.myAdvancedPanel.saveDataSource(dataSource2);
        }
        if (this.mySshSslPanel != null) {
            this.mySshSslPanel.saveData(dataSource2, copyCredentials);
        }
    }

    public void saveGeneralSettings(@NotNull LocalDataSource dataSource2, boolean copyCredentials, boolean actual) {
        if (dataSource2 == null) {
            DataSourceConfigurable.$$$reportNull$$$0(11);
        }
        dataSource2.setGlobal(this.myGlobal);
        this.myNameComponent.save(dataSource2);
        this.myGeneralPanel.saveSettings(dataSource2, copyCredentials, actual);
        this.mySchemasPanel.saveSettings(dataSource2);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    private String getDimensionServiceKey() {
        return "com.intellij.database.dataSource.DataSourceConfigurable";
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "Connecting_to_a_database";
    }

    @Nullable
    public JComponent createComponent() {
        return this.createCenterPanel();
    }

    public void apply() throws ConfigurationException {
        int ret;
        LocalDataSource tempDataSource = ((LocalDataSource)this.myDataSource).copy(true);
        this.saveData(tempDataSource, true, true);
        String error2 = StringUtil.isEmpty((String)tempDataSource.getDriverClass()) ? DatabaseBundle.message("error.text.database.driver.not.configured", new Object[0]) : null;
        if (error2 != null && (ret = ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)DatabaseBundle.message("message.title.invalid.datasource", new Object[0]), (String)DatabaseBundle.message("confirmation.text.error.occurred.save.datasource", error2)).icon(Messages.getErrorIcon())).show()) != 0) {
            return;
        }
        boolean newDataSource = this.isNewDataSource();
        boolean isGlobalChanged = !newDataSource && tempDataSource.isGlobal() != ((LocalDataSource)this.myDataSource).isGlobal();
        boolean isUrlChanged = !Comparing.strEqual((String)tempDataSource.getUrl(), (String)((LocalDataSource)this.myDataSource).getUrl());
        DataSourceSshTunnelConfiguration prevSshConfiguration = ((LocalDataSource)this.myDataSource).getSshConfiguration();
        boolean isAuthChanged = !this.equalCredentials(tempDataSource) || !DataSourceSshTunnelConfiguration.equal(tempDataSource.getSshConfiguration(), prevSshConfiguration) || !DataSourceSslConfiguration.equal(tempDataSource.getSslCfg(), ((LocalDataSource)this.myDataSource).getSslCfg());
        boolean resetConnections = isAuthChanged || tempDataSource.isSingleConnection() != ((LocalDataSource)this.myDataSource).isSingleConnection() || !Objects.equals(tempDataSource.getDriverClass(), ((LocalDataSource)this.myDataSource).getDriverClass()) || !tempDataSource.getClasspathElements().equals(((LocalDataSource)this.myDataSource).getClasspathElements()) || !tempDataSource.getConnectionProperties().equals(((LocalDataSource)this.myDataSource).getConnectionProperties()) || !Objects.equals(tempDataSource.getVmOptions(), ((LocalDataSource)this.myDataSource).getVmOptions()) || !tempDataSource.getVmEnv().equals(((LocalDataSource)this.myDataSource).getVmEnv()) || !tempDataSource.getAdditionalProperties().equals(((LocalDataSource)this.myDataSource).getAdditionalProperties());
        boolean isSchemaChanged = newDataSource || isAuthChanged || isUrlChanged || tempDataSource.isAutoSynchronize() && !((LocalDataSource)this.myDataSource).isAutoSynchronize() || !this.equalCredentials(tempDataSource) || !Comparing.equal((Object)this.myTempDataSource.getIntrospectionScope(), (Object)((LocalDataSource)this.myDataSource).getIntrospectionScope()) || !Comparing.strEqual((String)tempDataSource.getObjectPattern(), (String)((LocalDataSource)this.myDataSource).getObjectPattern());
        this.saveData((LocalDataSource)this.myDataSource, true, false);
        this.applyCredentials(tempDataSource);
        this.myGeneralPanel.onApply();
        this.mySshSslPanel.onApply();
        this.myNameComponent.apply((AbstractDataSource)this.myDataSource);
        this.updateDatabaseInfo(tempDataSource);
        if (isGlobalChanged) {
            this.myController.onChangesApplied(indicator -> {
                try {
                    indicator.setText(DatabaseBundle.message("progress.text.moving.storage", ((LocalDataSource)this.myDataSource).getName()));
                    if (((LocalDataSource)this.myDataSource).isGlobal()) {
                        DbSrcUtils.moveStorage((LocalDataSource)this.myDataSource, this.getProject(), null);
                    } else {
                        DbSrcUtils.moveStorage((LocalDataSource)this.myDataSource, null, this.getProject());
                    }
                }
                catch (IOException e) {
                    DbUIUtil.createNotification(this.myDataSource, DatabaseBundle.message("notification.content.failed.to.move.storage", e.getMessage()), NotificationType.ERROR).notify(this.myProject);
                }
            });
        }
        JdbcDriverManager manager = JdbcDriverManager.getDriverManager(this.myProject);
        if (resetConnections && !manager.getActiveConfigurations((LocalDataSource)this.myDataSource).isEmpty()) {
            boolean yesForAll;
            int answer = Boolean.TRUE.equals(this.myController.getUserData(RESET_CONNECTION_YES_FOR_ALL_KEY)) ? 0 : Messages.showYesNoCancelDialog((Component)this.myPanel, (String)DatabaseBundle.message("DataSourceConfigurable.apply.reconnect", ((LocalDataSource)this.myDataSource).getName()), (String)DatabaseBundle.message("DataSourceConfigurable.apply.title", new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (String)CommonBundle.getYesForAllButtonText(), (Icon)Messages.getQuestionIcon());
            boolean bl = yesForAll = answer == 2;
            if (yesForAll) {
                this.myController.putUserData(RESET_CONNECTION_YES_FOR_ALL_KEY, true);
            }
            if (answer == 0 || yesForAll) {
                this.myController.onChangesApplied(indicator -> {
                    this.myController.putUserData(RESET_CONNECTION_YES_FOR_ALL_KEY, null);
                    manager.releaseDriver((LocalDataSource)this.myDataSource, null);
                });
            }
        }
        if (isUrlChanged) {
            ((LocalDataSource)this.myDataSource).getInfo().dbms = null;
        }
        if (isSchemaChanged && DbImplUtilCore.canConnectTo((LocalDataSource)this.myDataSource)) {
            this.myController.onChangesApplied(indicator -> DataSourceUtil.performAutoSyncTask(LoaderContext.loadAll(this.myProject, (LocalDataSource)this.myDataSource), true));
        }
        if (newDataSource) {
            if (((LocalDataSourceManager)this.myManager).getDataSources().isEmpty() && SqlPsiFacade.getInstance((Project)this.getProject()).getConfiguredDefaultDialect() == null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    LocalDataSource ds = (LocalDataSource)ContainerUtil.find(((LocalDataSourceManager)this.myManager).getDataSources(), o -> !SqlDialects.isGenericDialect(DbSqlUtilCore.getSqlDialect(o)));
                    SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)this.getProject());
                    if (ds != null && psiFacade.getConfiguredDefaultDialect() == null) {
                        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect(ds);
                        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message("notification.title.default.sql.dialect", new Object[0]), DatabaseBundle.message("notification.content.you.can.set.as.default.sql.dialect", dialect.getDisplayName()), NotificationType.INFORMATION).setListener((notification, event) -> {
                            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                if ("set".equals(event.getDescription())) {
                                    psiFacade.setDialectMapping(null, dialect);
                                } else if ("configure".equals(event.getDescription())) {
                                    psiFacade.openDialectsConfigurable(Collections.emptyList());
                                }
                            }
                        }).notify(this.getProject());
                    }
                }, ModalityState.NON_MODAL);
            }
            ((LocalDataSourceManager)this.myManager).addDataSource((LocalDataSource)this.myDataSource);
        } else {
            ((LocalDataSourceManager)this.myManager).fireDataSourceUpdated((LocalDataSource)this.myDataSource);
        }
    }

    private void applyCredentials(LocalDataSource tempDataSource) {
        DatabaseCredentials dc = DatabaseCredentials.getInstance();
        DatabaseCredentials local = this.myController.getSecretService();
        dc.setPassword(this.myDataSource, local.getPassword(tempDataSource));
        dc.setSslPassphrase(this.myDataSource, local.getSslPassphrase(tempDataSource));
    }

    public void resetFromTemp() {
        ((SettingsEditor)this.myController).bulkUpdate(() -> {
            this.myGeneralPanel.reset(this.myTempDataSource, false);
            this.mySchemasPanel.reset(this.myTempDataSource);
        });
    }

    @Override
    public void init() {
        ((SettingsEditor)this.myController).bulkUpdate(() -> this.reset((LocalDataSource)this.getTarget(), false));
    }

    @Override
    protected void reset(@NotNull LocalDataSource o) {
        if (o == null) {
            DataSourceConfigurable.$$$reportNull$$$0(12);
        }
        this.reset(o, true);
    }

    @Override
    public JComponent getCommonBar() {
        return this.myTestConnectionComponent.getComponent();
    }

    public void reset(@NotNull LocalDataSource o, boolean resetCredentials) {
        if (o == null) {
            DataSourceConfigurable.$$$reportNull$$$0(13);
        }
        this.myConnectionInfo = o.getInfo().equals(((LocalDataSource)this.myDataSource).getInfo()) ? null : Couple.of((Object)((LocalDataSource)this.myDataSource).getInfo(), (Object)o.getInfo());
        this.setGlobal(o.isGlobal());
        this.myGeneralPanel.reset(o, resetCredentials);
        this.myAdvancedPanel.resetDataSource(o);
        this.myNameComponent.reset(o, (Computable<String>)((Computable)() -> this.myGeneralPanel.generateNameFromParameters()));
        this.mySshSslPanel.reset(o, resetCredentials);
        this.myOptionsPanel.reset(o);
        this.mySchemasPanel.reset(o);
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        LocalDataSource tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((LocalDataSource)this.myDataSource).getName())) {
            return true;
        }
        if (!tempDataSource.equalConfiguration((LocalDataSource)this.myDataSource)) {
            return true;
        }
        if (this.myGeneralPanel.isPasswordChanged()) {
            return true;
        }
        if (this.mySshSslPanel.isSslPassphraseChanged()) {
            return true;
        }
        return this.myNameComponent.isModified();
    }

    private boolean equalCredentials(LocalDataSource d1) {
        Credentials c2;
        Credentials c1;
        LocalDataSource d2 = (LocalDataSource)this.myDataSource;
        if (d1.getPasswordStorage() != d2.getPasswordStorage()) {
            return false;
        }
        if (!Objects.equals(d1.getUsername(), d2.getUsername())) {
            return false;
        }
        DatabaseCredentials cre1 = this.getSecretService();
        DatabaseCredentials cre2 = DatabaseCredentials.getInstance();
        return !this.myGeneralPanel.isPasswordChanged() || Comparing.equal((Object)(c1 = cre1.getCredentials(d1)), (Object)(c2 = cre2.getCredentials(d2)));
    }

    @Override
    public void showErrorNotification(String message2, @NotNull Object id) {
        if (id == null) {
            DataSourceConfigurable.$$$reportNull$$$0(14);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myController.showErrorNotification(this, id, message2 == null ? null : "Error", message2, new Object[0]));
    }

    public void setDriver(@Nullable DatabaseDriver driver) {
        DatabaseDriver prevActualDriver = this.myGeneralPanel.getActualDriver();
        this.myGeneralPanel.setDriver(driver);
        DatabaseDriver newActualDriver = this.myGeneralPanel.getActualDriver();
        if (prevActualDriver != newActualDriver) {
            this.myAdvancedPanel.migrateDriver(prevActualDriver, newActualDriver);
        }
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public void actualizeDriver() {
        this.setDriver(this.getDriver());
    }

    @Nullable
    DatabaseDriver getDriver() {
        return this.myGeneralPanel.getDriver();
    }

    @Override
    @Nullable
    public StatelessJdbcUrlParser getActiveParser() {
        return this.myGeneralPanel.getUrlEditorModel().getMeaningfulParser();
    }

    @NotNull
    public ParametersHolder getActualParameter() {
        UrlEditorModel urlEditorModel = this.myGeneralPanel.getUrlEditorModel();
        if (urlEditorModel == null) {
            DataSourceConfigurable.$$$reportNull$$$0(15);
        }
        return urlEditorModel;
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading mode) {
        if (mode == null) {
            DataSourceConfigurable.$$$reportNull$$$0(16);
        }
        if (this.myOptionsPanel != null) {
            this.myOptionsPanel.setSourceLoading(mode);
        }
    }

    @TestOnly
    @Nullable
    public DatabaseAuthProvider.AuthWidget getAuthWidget() {
        return this.myGeneralPanel.getUrlEditor().getAuthPanel().getAuthWidget();
    }

    public String getUrl() {
        return this.myGeneralPanel.getUrlEditor().getUrl();
    }

    @TestOnly
    public void setUrl(String url) {
        this.myGeneralPanel.getUrlEditor().setUrl(url, false);
    }

    public void setExtraProperty(String name, String value2) {
        this.myGeneralPanel.getUrlEditor().setExtraProperty(name, value2);
    }

    @NotNull
    public JComponent selectAdvancedPanel() {
        int index2 = DataSourceConfigurable.findTabIndex(this.myTabbedPane, this.ADVANCED);
        if (index2 != -1) {
            this.myTabbedPane.setSelectedIndex(index2);
        }
        JPanel jPanel = this.myAdvancedPanel.getComponent();
        if (jPanel == null) {
            DataSourceConfigurable.$$$reportNull$$$0(17);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedPane";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSourceForConnection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlEditor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "selectAdvancedPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateDatabaseInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 15: 
            case 17: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initTabbedPane";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTabIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTabIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setGeneratedName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveGeneralSettings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

