/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.Dbms;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseErrorHandlerSink;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteResultSetMetaData;
import com.intellij.database.remote.jdbc.helpers.CassJdbcHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcEngineUtils {
    public static final Logger LOG = Logger.getInstance(JdbcEngineUtils.class);

    private JdbcEngineUtils() {
    }

    @Contract(value="null, _, _ -> false")
    public static boolean shouldValueBeInlined(@Nullable Object object, @NotNull String typeName, Dbms dbms) {
        if (typeName == null) {
            JdbcEngineUtils.$$$reportNull$$$0(0);
        }
        return dbms.is(Dbms.MONGO) || dbms.isCassandra() && object instanceof String && !CassJdbcHelper.hasCodec((String)typeName);
    }

    public static <T extends AutoValueDescriptor> boolean shouldParticipateInInsert(@NotNull Dbms dbms, @NotNull T column2) {
        if (dbms == null) {
            JdbcEngineUtils.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            JdbcEngineUtils.$$$reportNull$$$0(2);
        }
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(dbms);
        return !(column2.isComputed() || column2.isAutogenerated() && !dialect.supportsInsertDefaultIntoAutoVal() || column2.hasDefault() && dbms.isSqlite());
    }

    @NlsSafe
    @NotNull
    public static String getErrorMessage(Throwable th, @Nullable LocalDataSource dataSource2) {
        return JdbcEngineUtils.getErrorMessage(th, dataSource2, null);
    }

    @NlsSafe
    @NotNull
    public static String getErrorMessage(Throwable th, @Nullable LocalDataSource dataSource2, @Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        if (th instanceof ProcessCanceledException) {
            return "";
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)th);
        if (cause instanceof OutOfMemoryError) {
            LOG.info(cause);
        } else if (!(cause instanceof SuppressUserStackTrace || cause instanceof UnsupportedOperationException || cause instanceof IOException || cause instanceof ExecutionException || cause instanceof UnsafeUpdateRolledBackException)) {
            try {
                ExceptionUtil.getUserStackTrace((Throwable)cause, (Logger)LOG);
            }
            catch (AssertionError e) {
                String string = cause.toString();
                if (string == null) {
                    JdbcEngineUtils.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        DatabaseErrorHandler handler = DatabaseErrorHandler.EP.forDbms(dataSource2 == null ? Dbms.UNKNOWN : dataSource2.getDbms());
        String string = handler.getErrorMessage(dataSource2, th, cause, DatabaseErrorHandlerSink.EMPTY).trim();
        if (string == null) {
            JdbcEngineUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static DataConsumer.Column[] getColumnDescriptors(@NotNull RemoteResultSet resultSet, @NotNull Dbms dbms) throws Exception {
        if (resultSet == null) {
            JdbcEngineUtils.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            JdbcEngineUtils.$$$reportNull$$$0(6);
        }
        RemoteResultSetMetaData metaData = resultSet.getMetaData();
        int count = metaData.getColumnCount();
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[count];
        int columnNum = 0;
        for (int i2 = 1; i2 <= count; ++i2) {
            String name = null;
            try {
                name = metaData.getColumnLabel(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String typeName = null;
            try {
                typeName = metaData.getColumnTypeName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int type = 1111;
            try {
                type = metaData.getColumnType(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String clazz = null;
            try {
                clazz = metaData.getColumnClassName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String catalog = null;
            try {
                catalog = metaData.getCatalogName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String schema = null;
            try {
                schema = metaData.getSchemaName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String table = null;
            try {
                table = metaData.getTableName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int precision = -1;
            try {
                precision = metaData.getPrecision(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int scale = -1;
            try {
                scale = metaData.getScale(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dbms.isClickHouse()) {
                if (table != null) {
                    table = StringUtil.trimEnd((String)table, (char)';');
                }
            } else if (dbms.isSqlite()) {
                catalog = "";
            } else if (dbms.isDb2()) {
                schema = schema == null ? null : StringUtil.trimTrailing((String)schema);
            } else if (dbms == Dbms.MYSQL_AURORA && "INTEGER".equalsIgnoreCase(typeName)) {
                typeName = typeName.substring(0, 3);
            }
            columnsDescr[i2 - 1] = new DataConsumer.Column(columnNum++, name, type, typeName, clazz, precision, scale, catalog, schema, table);
        }
        return columnsDescr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcEngineUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcEngineUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldValueBeInlined";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldParticipateInInsert";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnsafeUpdateRolledBackException
    extends Exception {
        public UnsafeUpdateRolledBackException(String message2) {
            super(message2);
        }
    }
}

