/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl;

import com.intellij.serialization.PropertyMapping;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppBinary;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppComponent;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppExecutable;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppSharedLibrary;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppStaticLibrary;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppBinaryImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppExecutableImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppSharedLibraryImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppStaticLibraryImpl;

public class CppComponentImpl
implements CppComponent {
    private final String name;
    private final String baseName;
    private final Set<CppBinary> binaries;

    @PropertyMapping(value={"name", "baseName", "binaries"})
    protected CppComponentImpl(String name, String baseName, Set<? extends CppBinary> binaries) {
        this(name, baseName);
        for (CppBinary cppBinary : binaries) {
            this.binaries.add(CppComponentImpl.newCopy(cppBinary));
        }
    }

    public CppComponentImpl(String name, String baseName) {
        this.name = name;
        this.baseName = baseName;
        this.binaries = new LinkedHashSet<CppBinary>();
    }

    public CppComponentImpl(CppComponent component) {
        this(component.getName(), component.getBaseName(), component.getBinaries());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public Set<? extends CppBinary> getBinaries() {
        return this.binaries;
    }

    public void addBinary(CppBinary binary) {
        this.binaries.add(binary);
    }

    private static CppBinary newCopy(CppBinary binary) {
        if (binary instanceof CppSharedLibrary) {
            return new CppSharedLibraryImpl((CppSharedLibrary)binary);
        }
        if (binary instanceof CppStaticLibrary) {
            return new CppStaticLibraryImpl((CppStaticLibrary)binary);
        }
        if (binary instanceof CppExecutable) {
            return new CppExecutableImpl((CppExecutable)binary);
        }
        return new CppBinaryImpl(binary);
    }
}

