/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.CLionCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing.OCLanguageServiceReparsingPassListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationHolder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDocumentListener;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyYamlLoader;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.YAMLException;

public class ClangTidyAnnotator
extends ExternalAnnotator<ClangTidyAnnotatorInfo, ClangTidyAnnotationHolder> {
    public static final Key<Boolean> RUN_IN_UNIT_TEST_MODE = Key.create((String)"CLANG_TIDY_ANNOTATOR_RUN_IN_UNIT_TEST_MODE");
    public static final Key<Boolean> TAKE_CLION_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_CLION_CONFIG");
    public static final Key<Boolean> TAKE_TIDY_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_TIDY_CONFIG");
    public static final Key<Boolean> COLLECT_DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_COLLECT_DEBUG_INFORMATION");
    public static final Key<String> DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_DEBUG_INFORMATION");
    public static final Key<AtomicBoolean> HAS_DOCUMENT_LISTENER = Key.create((String)"CLANG_TIDY_HAS_DOCUMENT_LISTENER");
    public static final Key<MyMasterReparsingPassListener> REPARSING_PASS_LISTENER = Key.create((String)"CLANG_TIDY_REPARSING_PASS_LISTENER");
    private static final Logger LOG = Logger.getInstance(ClangTidyAnnotator.class);
    private static final ClangTidyDocumentListener DOCUMENT_LISTENER = new ClangTidyDocumentListener();
    private final ClangTidyInspectionBase myPairedInspection;

    public ClangTidyAnnotator() {
        this(null);
    }

    public ClangTidyAnnotator(@Nullable ClangTidyInspectionBase inspection) {
        this.myPairedInspection = inspection;
    }

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(1);
        }
        return this.collectInformationImpl(file, editor);
    }

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(2);
        }
        return this.collectInformationImpl(file, null);
    }

    ClangTidyInspectionBase getInspection(OCPsiFile ocFile, Project project) {
        return this.myPairedInspection != null ? this.myPairedInspection : ClangTidyUtil.getInspection((PsiFile)ocFile, project);
    }

    @Nullable
    private ClangTidyAnnotatorInfo collectInformationImpl(@NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(3);
        }
        Project project = file.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode() && project.getUserData(RUN_IN_UNIT_TEST_MODE) != Boolean.TRUE) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || virtualFile instanceof OCFragmentVirtualFile) {
            return null;
        }
        String inputFileName = PathUtil.getFileName((String)virtualFile.getPath());
        OCPsiFile ocFile = OCLanguageUtils.asOCPsiFile((PsiFile)file);
        if (ocFile == null || !ocFile.isInProjectSources()) {
            return null;
        }
        OCResolveRootAndConfiguration resolveRootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration((VirtualFile)virtualFile, (Project)project);
        OCResolveConfiguration configuration = resolveRootAndConfiguration.getConfiguration();
        VirtualFile rootVirtualFile = resolveRootAndConfiguration.getRootFile();
        OCLanguageKind languageKind = resolveRootAndConfiguration.getKind();
        if (configuration == null || rootVirtualFile == null) {
            return null;
        }
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, virtualFile);
        OCCompilerKind compiler = compilerSettings.getCompilerKind();
        File compilerExecutable = compilerSettings.getCompilerExecutable();
        File compilerWorkingDir = compilerSettings.getCompilerWorkingDir();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches();
        if (compiler == null || compilerExecutable == null || compilerWorkingDir == null || compilerSwitches == null) {
            return null;
        }
        List headerPaths = configuration.getCompilerSettings(languageKind, rootVirtualFile).getHeadersSearchPaths();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        ClangTidyInspectionBase inspection = this.getInspection(ocFile, project);
        if (inspection == null) {
            return null;
        }
        return new ClangTidyAnnotatorInfo(inputFileName, project, ocFile, configuration, compilerSettings, compiler, compilerExecutable, compilerWorkingDir, compilerSwitches, rootVirtualFile, headerPaths, document, inspection, editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ClangTidyAnnotationHolder doAnnotate(@Nullable ClangTidyAnnotatorInfo info) {
        if (info == null) {
            return null;
        }
        ClangTidyAnnotator.tryRegisterDocumentListener(info);
        File workingDirectory = null;
        try {
            workingDirectory = FileUtil.createTempDirectory((String)"clion-clang-tidy", null, (boolean)true);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = ClangTidyAnnotator.executeClangTidy(info, workingDirectory);
            return clangTidyAnnotationHolder;
        }
        catch (com.intellij.execution.ExecutionException | IOException | YAMLException exc) {
            LOG.warn(exc);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = ClangTidyAnnotationHolder.error(exc.getMessage());
            return clangTidyAnnotationHolder;
        }
        finally {
            if (workingDirectory != null) {
                FileUtil.delete((File)workingDirectory);
            }
        }
    }

    public static boolean isAvailable() {
        return ClangTidyAnnotator.isAvailable(ClangTidyAnnotator.getBuiltinClangTidyPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ClangTidyAnnotationHolder executeClangTidy(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory) throws IOException, com.intellij.execution.ExecutionException {
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(4);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(5);
        }
        if (ClangTidyAnnotator.useLanguageService(info)) {
            ClangUtils.traceClangd((Logger)LOG, (String)"Clangd is used for clang-tidy diagnostics");
            ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
            SensitiveProgressWrapper newIndicator = currentIndicator != null ? new SensitiveProgressWrapper(currentIndicator) : new ProgressIndicatorBase();
            Ref result2 = Ref.create();
            MyMasterReparsingPassListener masterListener = ClangTidyAnnotator.trySubscribeForClangReparsingPass(info.getProject());
            MySlaveReparsingPassListener slaveListener = new MySlaveReparsingPassListener((ProgressIndicator)newIndicator, (PsiFile)info.getFile());
            try {
                masterListener.addListener(slaveListener);
                ProgressManager.getInstance().runProcess(() -> {
                    Boolean isFileValid = (Boolean)ReadAction.compute(() -> info.getFile().isValid());
                    if (!isFileValid.booleanValue()) {
                        return;
                    }
                    ClangLanguageService languageService = ClangLanguageServiceProvider.getIfStarted((Project)info.getProject());
                    result2.set((Object)((ClangTidyAnnotationHolder)languageService.computeWithParsed(info.getFile().getVirtualFile(), response -> {
                        if (response == null) {
                            return null;
                        }
                        try {
                            ArrayList<ClangTidyDiagnostic> diagnostics2 = new ArrayList<ClangTidyDiagnostic>();
                            for (Future<Supplier<List<ClangTidyDiagnostic>>> future : ClangTidyAnnotator.getDiagnosticsFutures(response, info.getProject())) {
                                Supplier supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware(future, (long)Long.MAX_VALUE, (String)"Clang-tidy diagnostics");
                                if (supplier != null) {
                                    List diags = (List)supplier.get();
                                    if (diags != null) {
                                        diagnostics2.addAll(diags);
                                        continue;
                                    }
                                    return null;
                                }
                                return null;
                            }
                            return ClangTidyAnnotationHolder.success(diagnostics2);
                        }
                        catch (ExecutionException | TimeoutException exception) {
                            return null;
                        }
                    })));
                }, (ProgressIndicator)newIndicator);
            }
            finally {
                masterListener.removeListener(slaveListener);
            }
            return (ClangTidyAnnotationHolder)result2.get();
        }
        ClangUtils.traceClangd((Logger)LOG, (String)"Clang-tidy is used for clang-tidy diagnostics");
        boolean collectDebugInformation = info.getFile().getUserData(COLLECT_DEBUG_INFORMATION) == Boolean.TRUE;
        StringBuilder debugInformation = new StringBuilder();
        File clangTidyPath = ClangTidyAnnotator.getClangTidyPath();
        ClangTidyInspectionBase inspection = info.getInspection();
        if (!ClangTidyAnnotator.isAvailable(clangTidyPath)) {
            return ClangTidyAnnotationHolder.error(OCInspectionsBundle.message((String)"inspection.clangTidy.not.found", (Object[])new Object[0]));
        }
        Document document = info.getDocument();
        long modificationStampOnStart = document.getModificationStamp();
        File inputFile = new File(info.getFile().getVirtualFile().getPath());
        OverlayMapping overlayMapping = ClangTidyAnnotator.generateVfsOverlays(workingDirectory);
        File vfsOverlay = ClangTidyAnnotator.generateVfsOverlay(overlayMapping, workingDirectory);
        File outputFile = new File(workingDirectory, "output.yaml");
        File compilationDatabase = ClangTidyAnnotator.createCompilationDatabase(info, workingDirectory, inputFile);
        if (collectDebugInformation) {
            ClangTidyAnnotator.putDebugInformation(debugInformation, "Compilation Database", FileUtil.loadFile((File)compilationDatabase));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(clangTidyPath.getAbsolutePath());
        ClangTidyFilesState clangTidyFilesState = (ClangTidyFilesState)info.getProject().getService(ClangTidyFilesState.class);
        if (!inspection.isPreferClangTidyFilesOverIDESettings() || !clangTidyFilesState.hasClangTidyFilesInPath(inputFile)) {
            String checksConfig = ClangTidyAnnotator.getChecksConfigForInspection(inspection);
            commandLine.addParameter("-config=" + checksConfig);
        } else {
            commandLine.addParameter("-checks=-clion-*");
        }
        commandLine.addParameter("-p=" + workingDirectory);
        commandLine.addParameter("-vfsoverlay=" + vfsOverlay);
        commandLine.addParameter("-export-fixes=" + outputFile);
        commandLine.addParameter(inputFile.getAbsolutePath());
        if (collectDebugInformation) {
            ClangTidyAnnotator.putDebugInformation(debugInformation, "Command-Line", commandLine.toString());
        }
        CapturingProcessHandler processHandler = ClangTidyAnnotator.createCapturedProcessHandler(commandLine);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (modificationStampOnStart != document.getModificationStamp()) {
            return null;
        }
        if (progressIndicator != null) {
            processHandler.runProcessWithProgressIndicator(progressIndicator);
        } else {
            processHandler.runProcess();
        }
        if (collectDebugInformation) {
            ClangTidyAnnotator.putDebugInformation(debugInformation, "Output", outputFile.exists() ? FileUtil.loadFile((File)outputFile) : "");
            info.getFile().putUserData(DEBUG_INFORMATION, (Object)debugInformation.toString());
        }
        List<ClangTidyDiagnostic> diagnostics2 = outputFile.exists() ? ClangTidyAnnotator.loadDiagnosticsFromYaml(outputFile, inputFile, overlayMapping) : Collections.emptyList();
        return ClangTidyAnnotationHolder.success(diagnostics2);
    }

    @NlsSafe
    @NotNull
    private static String getChecksConfigForInspection(@NotNull ClangTidyInspectionBase inspection) {
        if (inspection == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(6);
        }
        if (inspection instanceof ClangTidyInspection) {
            ClangTidyInspection clangTidyInspection = (ClangTidyInspection)inspection;
            String string = ClangTidyUtil.getClangTidyConfig(ClangTidyUtil.concatClangTidyChecks(clangTidyInspection.getClangTidyChecks(), "-clion-*"), inspection.getClangTidyCheckOptions());
            if (string == null) {
                ClangTidyAnnotator.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (inspection instanceof MisraInspection) {
            MisraInspection misraInspection = (MisraInspection)inspection;
            String misraChecks = StringUtil.join((String[])new String[]{misraInspection.getAllMisraChecks(), ","});
            String onlyMisraChecks = ClangTidyUtil.concatClangTidyChecks("-*,-clion-*", misraChecks);
            String string = ClangTidyUtil.getClangTidyConfig(onlyMisraChecks, inspection.getClangTidyCheckOptions());
            if (string == null) {
                ClangTidyAnnotator.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = ClangTidyUtil.getClangTidyConfig("", inspection.getClangTidyCheckOptions());
        if (string == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static List<Future<Supplier<List<ClangTidyDiagnostic>>>> getDiagnosticsFutures(@NotNull ClangParseResponse response, @NotNull Project project) {
        if (response == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(11);
        }
        ArrayList<Future<Supplier<List<ClangTidyDiagnostic>>>> futures = new ArrayList<Future<Supplier<List<ClangTidyDiagnostic>>>>();
        if (project.getUserData(TAKE_CLION_CONFIG) == Boolean.TRUE) {
            futures.add(response.getOurTidyDiagnostics());
        }
        if (project.getUserData(TAKE_TIDY_CONFIG) != Boolean.FALSE) {
            futures.add(response.getTidyDiagnostics());
        }
        ArrayList<Future<Supplier<List<ClangTidyDiagnostic>>>> arrayList = futures;
        if (arrayList == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    static OverlayMapping generateVfsOverlays(@NotNull File workingDirectory) throws IOException {
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(13);
        }
        OverlayMapping overlayMapping = new OverlayMapping();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        for (Document unsavedDocument : documentManager.getUnsavedDocuments()) {
            VirtualFile virtualFile = documentManager.getFile(unsavedDocument);
            if (virtualFile == null) continue;
            File sourceFile = new File(virtualFile.getPath());
            File overlayFile = ClangTidyAnnotator.generateMappingFile(sourceFile.getName(), unsavedDocument, workingDirectory);
            overlayMapping.addOverlay(sourceFile, overlayFile);
        }
        return overlayMapping;
    }

    private static File generateMappingFile(@NotNull String fileName, @NotNull Document document, @NotNull File workingDirectory) throws IOException {
        if (fileName == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(14);
        }
        if (document == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(15);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(16);
        }
        File mappingFile = new File(workingDirectory, fileName);
        FileUtil.writeToFile((File)mappingFile, (String)document.getText());
        return mappingFile;
    }

    static File generateVfsOverlay(@NotNull OverlayMapping overlayMapping, @NotNull File workingDirectory) throws IOException {
        if (overlayMapping == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(17);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(18);
        }
        File vfsOverlay = new File(workingDirectory, "overlay.yaml");
        FileUtil.writeToFile((File)vfsOverlay, (String)ClangTidyUtil.generateVfsOverlay(overlayMapping));
        return vfsOverlay;
    }

    public void apply(@NotNull PsiFile file, @Nullable ClangTidyAnnotationHolder annotationHolder, @NotNull AnnotationHolder holder) {
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(19);
        }
        if (holder == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(20);
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (annotationHolder == null || document == null) {
            return;
        }
        ClangTidyAnnotationApplier applier = new ClangTidyAnnotationApplier();
        if (annotationHolder.isSuccess()) {
            applier.applySuccess(file, annotationHolder.getDiagnostics(), holder);
        } else {
            HighlightSeverity severity = annotationHolder.isError() ? HighlightSeverity.ERROR : HighlightSeverity.WARNING;
            applier.applyFail(file, annotationHolder.getFailReason(), severity, holder);
        }
    }

    @NotNull
    public static File getBuiltinClangTidyPath() {
        File file = ClangUtils.getBuiltinClangToolPath((String)(SystemInfo.isWindows ? "clang-tidy.exe" : "clang-tidy"));
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(21);
        }
        return file;
    }

    @NotNull
    static File createCompilationDatabase(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory, @NotNull File inputFile) throws IOException {
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(22);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(23);
        }
        if (inputFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(24);
        }
        ClangUrlConverter converter = new ClangUrlConverter();
        Application application = ApplicationManager.getApplication();
        ArrayList<String> commandLine = new ArrayList<String>();
        Ref compilerExecutableRef = Ref.create();
        Ref preprocessorDefinesRef = Ref.create();
        File macrosFile = new File(workingDirectory, "macros");
        application.runReadAction(() -> {
            OCCompilerKind compilerKind;
            @NotNull OCPsiFile ocFile = info.getFile();
            VirtualFile file = ocFile.getVirtualFile();
            ClangUtils.ResolveInfo resolveInfo = ClangIdeFacadeUtil.Companion.getInstance().getResolveInfoForFile(info.getProject(), ocFile, file);
            @Nullable ClangdCompilationCommand command = ClangUtils.getCompilationCommand((ClangUrlConverter)converter, (Project)info.getProject(), (VirtualFile)file, (String)macrosFile.getPath(), (ClangUtils.ResolveInfo)resolveInfo);
            if (command == null) {
                return null;
            }
            List cmdLine = command.ccParams.getCommandLine();
            cmdLine.remove(cmdLine.size() - 1);
            compilerExecutableRef.set((Object)((String)cmdLine.remove(0)));
            CLionCompilationInfo ccInfo = ClangUtils.getCLionCompilationInfo((Project)ocFile.getProject(), (ClangUtils.ResolveInfo)resolveInfo);
            if (ccInfo != null && (compilerKind = ccInfo.getCompilerKind()) != ClangClCompilerKind.INSTANCE && compilerKind != ClangCompilerKind.INSTANCE) {
                String resourceDir = ClangUtils.getClangHeaderDir().getPath();
                commandLine.add("-I" + resourceDir);
            }
            commandLine.addAll(cmdLine);
            preprocessorDefinesRef.set((Object)command.ppDefines);
            return null;
        });
        if (!preprocessorDefinesRef.isNull()) {
            FileUtil.writeToFile((File)macrosFile, (String)((String)preprocessorDefinesRef.get()));
        }
        File compilationDatabase = new File(workingDirectory, "compile_commands.json");
        FileWriter writer = new FileWriter(compilationDatabase);
        ClangTidyUtil.writeCompilationDatabase(writer, (String)compilerExecutableRef.get(), workingDirectory.getAbsolutePath(), commandLine, inputFile.getAbsolutePath());
        File file = compilationDatabase;
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(25);
        }
        return file;
    }

    @NotNull
    private static File getClangTidyPath() {
        File clangTidyPath = ClangTidyUtil.getCustomClangTidyPath();
        if (clangTidyPath == null) {
            clangTidyPath = ClangTidyAnnotator.getBuiltinClangTidyPath();
        }
        File file = clangTidyPath;
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(26);
        }
        return file;
    }

    static boolean isAvailable(@Nullable File clangTidyPath) {
        try {
            return clangTidyPath != null && clangTidyPath.exists() && clangTidyPath.canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static void putDebugInformation(@NotNull StringBuilder builder, @NotNull String informationHeader, @NotNull String content) {
        if (builder == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(27);
        }
        if (informationHeader == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(28);
        }
        if (content == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(29);
        }
        builder.append("=== ").append(informationHeader).append(" ===").append("\n");
        builder.append(content).append("\n\n");
    }

    @NotNull
    static List<ClangTidyDiagnostic> loadDiagnosticsFromYaml(@NotNull File outputFile, @NotNull File sourceFile, @NotNull OverlayMapping overlayMapping) throws IOException {
        if (outputFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(30);
        }
        if (sourceFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(31);
        }
        if (overlayMapping == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(32);
        }
        String yamlContent = FileUtil.loadFile((File)outputFile);
        ClangTidyYamlLoader yamlLoader = new ClangTidyYamlLoader();
        List<ClangTidyDiagnostic> list = yamlLoader.load(yamlContent, sourceFile.getPath(), overlayMapping);
        if (list == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(33);
        }
        return list;
    }

    static void tryRegisterDocumentListener(@NotNull ClangTidyAnnotatorInfo info) {
        Document document;
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(34);
        }
        if (!((document = info.getDocument()) instanceof UserDataHolderEx)) {
            return;
        }
        UserDataHolderEx dataHolder = (UserDataHolderEx)document;
        AtomicBoolean hasDocumentListener = (AtomicBoolean)dataHolder.getUserData(HAS_DOCUMENT_LISTENER);
        if (hasDocumentListener == null && dataHolder.putUserDataIfAbsent(HAS_DOCUMENT_LISTENER, (Object)(hasDocumentListener = new AtomicBoolean(false))) != hasDocumentListener) {
            return;
        }
        if (hasDocumentListener.compareAndSet(false, true)) {
            document.addDocumentListener((DocumentListener)DOCUMENT_LISTENER);
        }
    }

    @NotNull
    static MyMasterReparsingPassListener trySubscribeForClangReparsingPass(@NotNull Project project) {
        if (project == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(35);
        }
        if (!(project instanceof UserDataHolderEx)) {
            LOG.warn("Unexpected project type: " + project.getClass().getSimpleName());
            return new MyMasterReparsingPassListener();
        }
        MyMasterReparsingPassListener existing = (MyMasterReparsingPassListener)project.getUserData(REPARSING_PASS_LISTENER);
        if (existing != null) {
            MyMasterReparsingPassListener myMasterReparsingPassListener = existing;
            if (myMasterReparsingPassListener == null) {
                ClangTidyAnnotator.$$$reportNull$$$0(36);
            }
            return myMasterReparsingPassListener;
        }
        UserDataHolderEx dataHolderEx = (UserDataHolderEx)project;
        MyMasterReparsingPassListener newMasterListener = new MyMasterReparsingPassListener();
        MyMasterReparsingPassListener existing2 = (MyMasterReparsingPassListener)dataHolderEx.putUserDataIfAbsent(REPARSING_PASS_LISTENER, (Object)newMasterListener);
        if (existing2 == newMasterListener) {
            project.getMessageBus().connect().subscribe(OCLanguageServiceReparsingPassListener.TOPIC, (Object)newMasterListener);
        }
        MyMasterReparsingPassListener myMasterReparsingPassListener = existing2;
        if (myMasterReparsingPassListener == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(37);
        }
        return myMasterReparsingPassListener;
    }

    public String getPairedBatchInspectionShortName() {
        return ClangTidyInspection.getInspectionShortName();
    }

    @NotNull
    static CapturingProcessHandler createCapturedProcessHandler(@NotNull GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
        if (commandLine == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(38);
        }
        return new CapturingProcessHandler(commandLine){

            protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                return new CapturingProcessAdapter(processOutput){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator$1$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
        };
    }

    private static boolean useLanguageService(@NotNull ClangTidyAnnotatorInfo info) {
        Project project;
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(39);
        }
        if (ClangUtils.isClangdOn((Project)(project = info.getProject())) && ClangUtils.isClangTidyViaClangdOn((Project)project)) {
            if (info.getFile().getVirtualFile() == null) {
                return false;
            }
            if (ClangUtils.isClangTidyViaClangdForced((Project)project)) {
                return true;
            }
            return ClangTidyUtil.getCustomClangTidyPath() == null && info.getEditor() != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 21: 
            case 25: 
            case 26: 
            case 33: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 21: 
            case 25: 
            case 26: 
            case 33: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 22: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: 
            case 13: 
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 21: 
            case 25: 
            case 26: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 11: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlayMapping";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "informationHeader";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChecksConfigForInspection";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnosticsFutures";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinClangTidyPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompilationDatabase";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyPath";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDiagnosticsFromYaml";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "trySubscribeForClangReparsingPass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeClangTidy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChecksConfigForInspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 21: 
            case 25: 
            case 26: 
            case 33: 
            case 36: 
            case 37: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDiagnosticsFutures";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateVfsOverlays";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generateMappingFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateVfsOverlay";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createCompilationDatabase";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "putDebugInformation";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadDiagnosticsFromYaml";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "tryRegisterDocumentListener";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "trySubscribeForClangReparsingPass";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createCapturedProcessHandler";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "useLanguageService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 21: 
            case 25: 
            case 26: 
            case 33: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MySlaveReparsingPassListener {
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final PsiFile myFile;

        MySlaveReparsingPassListener(@NotNull ProgressIndicator indicator, @NotNull PsiFile file) {
            if (indicator == null) {
                MySlaveReparsingPassListener.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MySlaveReparsingPassListener.$$$reportNull$$$0(1);
            }
            this.myIndicator = indicator;
            this.myFile = file;
        }

        public void onReparsing(@NotNull PsiFile file) {
            if (file == null) {
                MySlaveReparsingPassListener.$$$reportNull$$$0(2);
            }
            if (file == this.myFile) {
                this.myIndicator.cancel();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator$MySlaveReparsingPassListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onReparsing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MyMasterReparsingPassListener
    implements OCLanguageServiceReparsingPassListener {
        @NotNull
        private final Set<MySlaveReparsingPassListener> mySlaveListeners = Collections.newSetFromMap(new IdentityHashMap());

        MyMasterReparsingPassListener() {
        }

        public synchronized void onReparsing(@NotNull PsiFile file) {
            if (file == null) {
                MyMasterReparsingPassListener.$$$reportNull$$$0(0);
            }
            for (MySlaveReparsingPassListener slave : this.mySlaveListeners) {
                slave.onReparsing(file);
            }
        }

        synchronized void addListener(@NotNull MySlaveReparsingPassListener slave) {
            if (slave == null) {
                MyMasterReparsingPassListener.$$$reportNull$$$0(1);
            }
            this.mySlaveListeners.add(slave);
        }

        synchronized void removeListener(@NotNull MySlaveReparsingPassListener slave) {
            if (slave == null) {
                MyMasterReparsingPassListener.$$$reportNull$$$0(2);
            }
            this.mySlaveListeners.remove(slave);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slave";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator$MyMasterReparsingPassListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onReparsing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

