/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.mssql.MsDialect;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.dialects.mssql._MsLexer;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class MsLexer
extends SqlLexer {
    public MsLexer() {
        super(MsDialect.LazyData.ourClasses, new _MsLexer());
    }

    public MsLexer(TokenClasses tokenClasses, FlexLexer flexLexer) {
        super(tokenClasses, flexLexer);
    }

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            MsLexer.$$$reportNull$$$0(0);
        }
        if (!this.lookAheadSqlCmd(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadSqlCmd(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        char sqlCmd = '\u0000';
        if (SqlTokens.WS_TOKENS.contains(type)) {
            sqlCmd = MsLexer.getSqlCmdAt(lexer, lexer.getTokenEnd());
            if (sqlCmd != '\u0000' && MsLexer.indexOfNLInCurrent(lexer) == -1) {
                sqlCmd = '\u0000';
            }
            if (sqlCmd != '\u0000') {
                this.advanceLexer(lexer);
            }
        } else if (lexer.getTokenStart() == 0) {
            sqlCmd = MsLexer.getSqlCmdAt(lexer, lexer.getTokenStart());
        }
        if (sqlCmd == '!') {
            this.advanceLexer(lexer);
            this.advanceLexer(lexer);
            this.rawTillEOL(lexer);
            return true;
        }
        if (sqlCmd == ':') {
            this.advanceLexer(lexer);
            if (!this.isFollowedByRaw(lexer)) {
                if (!MsLexer.isToken(lexer, "setvar")) {
                    return true;
                }
                this.advanceAs(lexer, this.getSqlTokenType(lexer));
                this.skipWs(lexer);
                if (lexer.getTokenType() != SqlTokens.SQL_IDENT) {
                    return true;
                }
            }
            this.advanceAs(lexer, this.getSqlTokenType(lexer));
            this.rawTillEOL(lexer);
            return true;
        }
        return false;
    }

    private void rawTillEOL(Lexer lexer) {
        this.skipWs(lexer);
        int idx = MsLexer.indexOfNL(lexer, lexer.getBufferEnd());
        if (idx == -1) {
            idx = lexer.getBufferEnd();
        }
        this.addToken(idx, (IElementType)SqlTokens.SQL_RAW_INPUT);
        lexer.start(lexer.getBufferSequence(), idx, lexer.getBufferEnd(), 0);
    }

    private static boolean isToken(Lexer lexer, String text) {
        return StringUtil.equalsIgnoreCase((CharSequence)lexer.getTokenSequence(), (CharSequence)text);
    }

    private boolean isFollowedByRaw(Lexer lexer) {
        IElementType type = this.getSqlTokenType(lexer);
        return type == MsTypes.MSSQL_CONNECT || type == MsTypes.MSSQL_ERROR || type == MsTypes.MSSQL_OUT || MsLexer.isToken(lexer, "r");
    }

    private void skipWs(Lexer lexer) {
        IElementType type = lexer.getTokenType();
        if (SqlTokens.WS_TOKENS.contains(type) && MsLexer.indexOfNLInCurrent(lexer) == -1) {
            this.advanceLexer(lexer);
        }
    }

    private static int indexOfNLInCurrent(Lexer lexer) {
        return MsLexer.indexOfNL(lexer, lexer.getTokenEnd());
    }

    private static int indexOfNL(Lexer lexer, int end) {
        return StringUtil.indexOfAny((CharSequence)lexer.getBufferSequence(), (String)"\r\n", (int)lexer.getTokenStart(), (int)end);
    }

    private static char getSqlCmdAt(Lexer lexer, int pos) {
        CharSequence seq = lexer.getBufferSequence();
        if (StringUtil.startsWith((CharSequence)seq, (int)pos, (CharSequence)"!!:")) {
            return '\u0000';
        }
        if (StringUtil.startsWith((CharSequence)seq, (int)pos, (CharSequence)":")) {
            return ':';
        }
        if (StringUtil.startsWith((CharSequence)seq, (int)pos, (CharSequence)"!!")) {
            return '!';
        }
        return '\u0000';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLexer", "com/intellij/sql/dialects/mssql/MsLexer", "lookAhead"));
    }
}

