/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.bigquery;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.bigquery.BigQueryDdlParsing;
import com.intellij.sql.dialects.bigquery.BigQueryDialect;
import com.intellij.sql.dialects.bigquery.BigQueryDmlParsing;
import com.intellij.sql.dialects.bigquery.BigQueryExpressionParsing;
import com.intellij.sql.dialects.bigquery.BigQueryGeneratedParser;
import com.intellij.sql.dialects.bigquery.BigQueryGeneratedParserUtil;
import com.intellij.sql.dialects.bigquery.BigQueryTokens;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlReferenceElementType;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigQueryParser
extends SqlParser {
    private static final Pattern EXP_TAIL = Pattern.compile("[e|E]\\d+");

    public BigQueryParser() {
        super(BigQueryDialect.INSTANCE);
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return BigQueryGeneratedParser.statement(builder, level);
    }

    @Override
    public boolean parseOdbcSequence(PsiBuilder builder) {
        return false;
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        return BigQueryGeneratedParser.parse_root_(root2, builder, level);
    }

    @Override
    protected boolean parseArgumentListInner(PsiBuilder builder) {
        if (PsiTreeUtil.getParentOfType((PsiElement)SqlLazyElementTypeImpl.getContextElement((PsiBuilder)builder), SqlCreateIndexStatement.class) != null) {
            SqlGeneratedParserUtil.setOn(builder, 0, "FORBID_QUALIFICATION");
        }
        return super.parseArgumentListInner(builder);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return BigQueryGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return BigQueryDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, BigQueryDmlParsing::parenthesized_aliased_join_expression, BigQueryDmlParsing::top_query_expression, BigQueryParser::parseTopQueryExpressionTail, (b, l) -> BigQueryDmlParsing.join_expression(b, l, -1), (b, l) -> BigQueryDmlParsing.join_expression_0(b, l, -1));
    }

    private static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        BigQueryDmlParsing.query_expression_0(builder, level, -1);
        return BigQueryDmlParsing.left_inner_table_op_tail(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return BigQueryDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, BigQueryExpressionParsing::evaluable_expression);
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result2 = super.consumeCustomParameterReference(builder);
        if (result2 != null) {
            return result2;
        }
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_DOLLAR)) {
            return null;
        }
        IElementType type = builder.rawLookup(1);
        if (!this.isIdentifierToken(builder, type, true, false)) {
            return null;
        }
        builder.advanceLexer();
        builder.advanceLexer();
        while (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_COLON)) {
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_COLON);
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_IDENT);
        }
        if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_LEFT_PAREN)) {
            SqlParserUtil.consumeAllTokensUpTo(builder, new IElementType[]{SQL_RIGHT_PAREN, SQL_SEMICOLON});
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_PAREN);
        }
        return SQL_PARAMETER_REFERENCE;
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = BigQueryExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error(SqlBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result2;
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        boolean res2 = super.parseFunctionCallTail(builder, level);
        if (res2) {
            BigQueryGeneratedParser.analytic_clause(builder, level);
        }
        return res2;
    }

    @Override
    @Nullable
    protected IElementType getVariableType(PsiBuilder builder) {
        IElementType paramToken = builder.getTokenType();
        if (this.getLanguage().isOperatorSupported(paramToken)) {
            return null;
        }
        String text = builder.getTokenText();
        if (paramToken == SQL_COLON || Objects.equals(text, "@")) {
            return SQL_PARAMETER_REFERENCE;
        }
        if (Objects.equals(text, "@@")) {
            return SQL_VARIABLE_REFERENCE;
        }
        return null;
    }

    @Override
    protected void consumeParameterReferenceInner(PsiBuilder builder) {
        if (Objects.equals(builder.getTokenText(), "@@")) {
            builder.advanceLexer();
            boolean advance = this.isIdentifierToken(builder, builder.getTokenType(), true, false);
            if (advance) {
                PsiBuilder.Marker identifier = builder.mark();
                PsiBuilder.Marker ident = builder.mark();
                builder.advanceLexer();
                if (builder.getTokenType() == SQL_PERIOD && this.isIdentifierToken(builder, builder.lookAhead(1), true, false)) {
                    builder.advanceLexer();
                    builder.advanceLexer();
                    ident.collapse((IElementType)SQL_IDENT);
                } else {
                    ident.drop();
                }
                identifier.done((IElementType)SQL_IDENTIFIER);
            }
        } else {
            super.consumeParameterReferenceInner(builder);
        }
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return BigQueryGeneratedParser.table_opt_column_list(builder, level);
    }

    @Override
    @NotNull
    public PsiBuilder adaptBuilder(IElementType root2, PsiBuilder initialBuilder) {
        PsiBuilder psiBuilder = BigQueryGeneratedParserUtil.adapt_builder_(root2, initialBuilder, this, this.getExtendsTokenSets());
        if (psiBuilder == null) {
            BigQueryParser.$$$reportNull$$$0(0);
        }
        return psiBuilder;
    }

    @Override
    public boolean allowIdentifierSplit(SqlReferenceElementType refType) {
        return refType == SQL_TABLE_REFERENCE;
    }

    @Override
    public IElementType getSplitIdentifierStart() {
        return BigQueryTokens.BQ_DELIMITED_TOKEN_START;
    }

    @Override
    public IElementType getSplitIdentifierEnd() {
        return BigQueryTokens.BQ_DELIMITED_TOKEN_END;
    }

    @Override
    public boolean parseIdentifierInner(PsiBuilder builder, boolean optional, boolean allowKeywords, boolean allowCharSetSpec, SqlReferenceElementType refType) {
        return this.parsePossiblySplitIdentifier(builder, refType, BigQueryTokens.BQ_DELIMITED_TOKEN_START, BigQueryTokens.BQ_DELIMITED_TOKEN_END, (b, l) -> super.parseIdentifierInner(b, optional, allowKeywords, allowCharSetSpec, refType));
    }

    @Override
    protected boolean consumeIdentifierInner(PsiBuilder builder, boolean allowKeywords, boolean allowString, @Nullable SqlReferenceElementType refType) {
        if (refType == SQL_TABLE_REFERENCE || refType == SQL_VIEW_REFERENCE || refType == SQL_MATERIALIZED_VIEW_REFERENCE) {
            if (builder.getTokenType() == SQL_IDENT_DELIMITED) {
                builder.advanceLexer();
                return true;
            }
            boolean advance = this.isIdentifierToken(builder, builder.getTokenType(), allowKeywords, allowString);
            if (!advance) {
                return false;
            }
            PsiBuilder.Marker mark2 = builder.mark();
            while (builder.rawLookup(1) == SQL_OP_MINUS || this.isIdentifierToken(builder, builder.rawLookup(1), allowKeywords, allowString) || builder.rawLookup(1) == SQL_INTEGER_TOKEN) {
                builder.advanceLexer();
            }
            builder.advanceLexer();
            mark2.collapse((IElementType)SQL_IDENT);
            return true;
        }
        return super.consumeIdentifierInner(builder, allowKeywords, allowString, refType);
    }

    @Override
    protected boolean consumeIntegerToken(PsiBuilder builder, boolean allowFloat) {
        boolean optional = SqlParserUtil.consumeOneOfTokens(builder, true, new IElementType[]{SQL_OP_PLUS, SQL_OP_MINUS}) == null;
        PsiBuilder.Marker mark2 = builder.mark();
        boolean isFloat = false;
        if (builder.getTokenType() == SQL_PERIOD && builder.rawLookup(1) == SQL_INTEGER_TOKEN || builder.getTokenType() == SQL_INTEGER_TOKEN && builder.rawLookup(1) == SQL_PERIOD) {
            if (builder.getTokenType() == SQL_INTEGER_TOKEN) {
                builder.advanceLexer();
            }
            builder.advanceLexer();
            if (builder.getTokenType() == SQL_INTEGER_TOKEN) {
                builder.advanceLexer();
            }
            isFloat = true;
        } else if (!SqlParserUtil.consumeToken(builder, optional, (IElementType)SQL_INTEGER_TOKEN)) {
            mark2.drop();
            return false;
        }
        if (builder.getTokenType() == SQL_IDENT && StringUtil.equalsIgnoreCase((CharSequence)"e", (CharSequence)builder.getTokenText()) && (builder.rawLookup(1) == SQL_OP_MINUS || builder.rawLookup(1) == SQL_OP_PLUS) && builder.rawLookup(2) == SQL_INTEGER_TOKEN) {
            builder.advanceLexer();
            builder.advanceLexer();
            builder.advanceLexer();
            isFloat = true;
        } else if (builder.getTokenType() == SQL_IDENT && EXP_TAIL.matcher(Objects.requireNonNull(builder.getTokenText())).matches()) {
            builder.advanceLexer();
            isFloat = true;
        }
        if (isFloat) {
            mark2.collapse((IElementType)SQL_FLOAT_TOKEN);
        } else {
            mark2.drop();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/bigquery/BigQueryParser", "adaptBuilder"));
    }
}

