/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextLikeDomain;

public class BigQueryDomains
extends BaseDomainRegistry {
    private static final int DECIMAL_MAX_SCALE = 9;
    private static final int DECIMAL_MAX_PRECISION = 38;

    public BigQueryDomains() {
        this.add((Domain)new IntegerDomain("int64", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("float64", ConversionPoint.DOUBLE_PRECISION, Double.MIN_VALUE, Double.MAX_VALUE));
        this.add((Domain)new Number2Domain("numeric", ConversionPoint.NUMBER, 38, 9, false));
        this.add((Domain)new BooleanDomain("bool", ConversionPoint.BOOLEAN));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new TextDomain("string", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add((Domain)new BinaryDomain("bytes", ConversionPoint.BINARY, Integer.MAX_VALUE));
        this.add((Domain)new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add((Domain)new SimpleDomain("datetime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP));
        this.add((Domain)new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 0, -1, false));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, Integer.MAX_VALUE));
        this.add(new SimpleDomain("array", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new SimpleDomain("struct", ConversionPoint.JSON, PhysicalDomainType.UNKNOWN).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new TextLikeDomain("geography", ConversionPoint.GEOGRAPHY, PhysicalDomainType.TEXT));
    }
}

