/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.dialects.base.introspector.QueryStatEntry;
import com.intellij.database.dialects.base.introspector.QueryStatsKt;
import com.intellij.database.util.StringFun;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0001J\u0011\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0003H\u0096\u0001J\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0003J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ\u0006\u0010\u001f\u001a\u00020\u0002J\t\u0010 \u001a\u00020\u0018H\u0096\u0001J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0002R$\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\t0\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0012\u0010\u000e\u001a\u00020\u000fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/database/dialects/base/introspector/QueryStats;", "", "", "Lcom/intellij/database/dialects/base/introspector/QueryStatEntry;", "stats", "", "(Ljava/util/Map;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "turnSequence", "values", "", "getValues", "()Ljava/util/Collection;", "containsKey", "", "key", "containsValue", "value", "get", "getSortedList", "", "getSortedText", "isEmpty", "registerStart", "name", "intellij.database.dialects.base.core"})
public final class QueryStats
implements Map<String, QueryStatEntry>,
KMappedMarker {
    private volatile int turnSequence;
    private final Map<String, QueryStatEntry> stats;

    @NotNull
    public final QueryStatEntry registerStart(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        QueryStatEntry queryStatEntry = this.stats.computeIfAbsent(name2, new Function(this, name2){
            final /* synthetic */ QueryStats this$0;
            final /* synthetic */ String $name;

            @NotNull
            public final QueryStatEntry apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                QueryStats queryStats = this.this$0;
                QueryStats.access$setTurnSequence$p(queryStats, QueryStats.access$getTurnSequence$p(queryStats) + 1);
                return new QueryStatEntry(QueryStats.access$getTurnSequence$p(queryStats), this.$name);
            }
            {
                this.this$0 = queryStats;
                this.$name = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)queryStatEntry, (String)"stats.computeIfAbsent(na\u2026y(++turnSequence, name) }");
        QueryStatEntry e2 = queryStatEntry;
        e2.registerStart();
        return e2;
    }

    @NotNull
    public final List<QueryStatEntry> getSortedList() {
        return CollectionsKt.sortedWith((Iterable)this.stats.values(), (Comparator)QueryStatEntry.DurationComparator.INSTANCE);
    }

    @NotNull
    public final String getSortedText() {
        List<QueryStatEntry> rows = this.getSortedList();
        long totalDuration = 0L;
        for (QueryStatEntry row : rows) {
            totalDuration += row.getDurationSum();
        }
        StringBuilder b = new StringBuilder(1000);
        String horizontalLine = StringFun.replicate$default((String)"-", (int)140, null, null, (int)6, null);
        b.append("Query Performance Statistics:\n");
        b.append(horizontalLine).append('\n');
        b.append("##  count err    T.min     T.avg     T.max     T.sum   %     rows packs  Query \n");
        b.append(horizontalLine).append('\n');
        for (QueryStatEntry row : rows) {
            String nr = StringsKt.padStart$default((String)String.valueOf(row.getTurn()), (int)2, (char)'\u0000', (int)2, null);
            String count = StringsKt.padStart$default((String)String.valueOf(row.getNumberOfFinishes()), (int)5, (char)'\u0000', (int)2, null);
            String errs = StringsKt.padStart$default((String)QueryStatsKt.access$toStringIfNotZero(row.getNumberOfFails()), (int)3, (char)'\u0000', (int)2, null);
            String tMin = QueryStatsKt.access$formatToSeconds(row.getDurationMin());
            String tAvg = QueryStatsKt.access$formatToSeconds(row.getDurationAvg());
            String tMax = QueryStatsKt.access$formatToSeconds(row.getDurationMax());
            String tSum = QueryStatsKt.access$formatToSeconds(row.getDurationSum());
            String percent = StringsKt.padStart$default((String)String.valueOf(totalDuration == 0L ? 0 : MathKt.roundToInt((double)(100.0 * (double)row.getDurationSum() / (double)totalDuration))), (int)3, (char)'\u0000', (int)2, null);
            String nRows = StringsKt.padStart$default((String)QueryStatsKt.access$toStringIfNotZero(row.getFetchedRows()), (int)8, (char)'\u0000', (int)2, null);
            String nPacks = StringsKt.padStart$default((String)QueryStatsKt.access$toStringIfNotZero(row.getFetchedPacks()), (int)5, (char)'\u0000', (int)2, null);
            StringBuilder stringBuilder = b.append(nr);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"b.append(nr)");
            StringBuilder stringBuilder2 = QueryStatsKt.access$space(stringBuilder).append(count);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"b.append(nr).space()\n        .append(count)");
            StringBuilder stringBuilder3 = QueryStatsKt.access$space(stringBuilder2).append(errs);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"b.append(nr).space()\n   \u2026e()\n        .append(errs)");
            StringBuilder stringBuilder4 = QueryStatsKt.access$space(stringBuilder3).append(tMin);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"b.append(nr).space()\n   \u2026e()\n        .append(tMin)");
            StringBuilder stringBuilder5 = QueryStatsKt.access$space(stringBuilder4).append(tAvg);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"b.append(nr).space()\n   \u2026e()\n        .append(tAvg)");
            StringBuilder stringBuilder6 = QueryStatsKt.access$space(stringBuilder5).append(tMax);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"b.append(nr).space()\n   \u2026e()\n        .append(tMax)");
            StringBuilder stringBuilder7 = QueryStatsKt.access$space(stringBuilder6).append(tSum);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"b.append(nr).space()\n   \u2026e()\n        .append(tSum)");
            StringBuilder stringBuilder8 = QueryStatsKt.access$space(stringBuilder7).append(percent);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"b.append(nr).space()\n   \u2026\n        .append(percent)");
            StringBuilder stringBuilder9 = QueryStatsKt.access$space(stringBuilder8).append(nRows);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"b.append(nr).space()\n   \u2026()\n        .append(nRows)");
            StringBuilder stringBuilder10 = QueryStatsKt.access$space(stringBuilder9).append(nPacks);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"b.append(nr).space()\n   \u2026)\n        .append(nPacks)");
            QueryStatsKt.access$space(QueryStatsKt.access$space(stringBuilder10)).append(row.getName()).append('\n');
        }
        b.append(horizontalLine).append('\n');
        b.append("Total duration of all queries: ").append(QueryStatsKt.access$formatToSeconds(totalDuration)).append(" s.");
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"b.toString()");
        return string;
    }

    public QueryStats(@NotNull Map<String, QueryStatEntry> stats) {
        Intrinsics.checkNotNullParameter(stats, (String)"stats");
        this.stats = stats;
    }

    public /* synthetic */ QueryStats(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new HashMap();
        }
        this(map2);
    }

    public QueryStats() {
        this(null, 1, null);
    }

    @NotNull
    public Set<Map.Entry<String, QueryStatEntry>> getEntries() {
        return this.stats.entrySet();
    }

    @NotNull
    public Set<String> getKeys() {
        return this.stats.keySet();
    }

    public int getSize() {
        return this.stats.size();
    }

    @NotNull
    public Collection<QueryStatEntry> getValues() {
        return this.stats.values();
    }

    public boolean containsKey(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.stats.containsKey(key2);
    }

    public boolean containsValue(@NotNull QueryStatEntry value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.stats.containsValue(value);
    }

    @Nullable
    public QueryStatEntry get(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return this.stats.get(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.stats.isEmpty();
    }

    public static final /* synthetic */ int access$getTurnSequence$p(QueryStats $this) {
        return $this.turnSequence;
    }

    public static final /* synthetic */ void access$setTurnSequence$p(QueryStats $this, int n) {
        $this.turnSequence = n;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public QueryStatEntry compute(String string, BiFunction<? super String, ? super QueryStatEntry, ? extends QueryStatEntry> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public QueryStatEntry computeIfAbsent(String string, Function<? super String, ? extends QueryStatEntry> function) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public QueryStatEntry computeIfPresent(String string, BiFunction<? super String, ? super QueryStatEntry, ? extends QueryStatEntry> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public QueryStatEntry merge(String string, QueryStatEntry queryStatEntry, BiFunction<? super QueryStatEntry, ? super QueryStatEntry, ? extends QueryStatEntry> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public QueryStatEntry put(String string, QueryStatEntry queryStatEntry) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void putAll(Map<? extends String, ? extends QueryStatEntry> map2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public QueryStatEntry putIfAbsent(String string, QueryStatEntry queryStatEntry) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Object remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean replace(String string, QueryStatEntry queryStatEntry, QueryStatEntry queryStatEntry2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public QueryStatEntry replace(String string, QueryStatEntry queryStatEntry) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super QueryStatEntry, ? extends QueryStatEntry> biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object compute(Object object, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object computeIfAbsent(Object object, Function function) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object computeIfPresent(Object object, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object merge(Object object, Object object2, BiFunction biFunction) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object put(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object putIfAbsent(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ boolean replace(Object object, Object object2, Object object3) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object replace(Object object, Object object2) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

