/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.dvcs.push.ui.PushUtils;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ModalityUiUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushAfterCommitDialog
extends VcsPushDialog {
    private JCheckBox myDontShowAgainCheckbox;

    public GitPushAfterCommitDialog(@NotNull Project project, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        if (project == null) {
            GitPushAfterCommitDialog.$$$reportNull$$$0(0);
        }
        if (selectedRepositories == null) {
            GitPushAfterCommitDialog.$$$reportNull$$$0(1);
        }
        super(project, selectedRepositories, currentRepo);
    }

    @NotNull
    protected JPanel createOptionsPanel() {
        this.myDontShowAgainCheckbox = new JCheckBox(GitBundle.message("push.dialog.preview.commits.before.push", new Object[0]));
        this.myDontShowAgainCheckbox.setSelected(GitVcsSettings.getInstance(this.myProject).shouldPreviewPushOnCommitAndPush());
        JPanel basePanel = super.createOptionsPanel();
        if (PushUtils.getProhibitedTarget((VcsPushUi)this) != null) {
            JPanel jPanel = basePanel;
            if (jPanel == null) {
                GitPushAfterCommitDialog.$$$reportNull$$$0(2);
            }
            return jPanel;
        }
        basePanel.add(this.myDontShowAgainCheckbox);
        JPanel jPanel = basePanel;
        if (jPanel == null) {
            GitPushAfterCommitDialog.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void push(boolean forcePush) {
        GitVcsSettings settings;
        if (!this.myDontShowAgainCheckbox.isSelected() && (settings = GitVcsSettings.getInstance(this.myProject)).shouldPreviewPushOnCommitAndPush()) {
            settings.setPreviewPushProtectedOnly(true);
        }
        super.push(forcePush);
    }

    public void showOrPush() {
        boolean hasProtectedBranch = PushUtils.getProhibitedTarget((VcsPushUi)this) != null;
        GitVcsSettings vcsSettings = GitVcsSettings.getInstance(this.myProject);
        boolean showDialog = vcsSettings.shouldPreviewPushOnCommitAndPush();
        boolean showOnlyProtected = vcsSettings.isPreviewPushProtectedOnly();
        if (showDialog && (!showOnlyProtected || hasProtectedBranch) || !this.canPush()) {
            this.show();
        } else {
            this.push(false);
        }
    }

    public static void showOrPush(@NotNull Project project, @NotNull Collection<GitRepository> selectedRepositories) {
        if (project == null) {
            GitPushAfterCommitDialog.$$$reportNull$$$0(4);
        }
        if (selectedRepositories == null) {
            GitPushAfterCommitDialog.$$$reportNull$$$0(5);
        }
        ModalityState modality = ModalityState.defaultModalityState();
        TransactionGuard.getInstance().assertWriteSafeContext(modality);
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(selectedRepositories);
        ModalityUiUtil.invokeLaterIfNeeded(() -> new GitPushAfterCommitDialog(project, repositories, GitBranchUtil.getCurrentRepository(project)).showOrPush(), (ModalityState)modality, (Condition)project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepositories";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/checkin/GitPushAfterCommitDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/checkin/GitPushAfterCommitDialog";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showOrPush";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

