/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.utils;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.uml.java.utils.NullabilityUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class UmlKotlinUtils {
    private UmlKotlinUtils() {
    }

    public static boolean isFromKotlin(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            UmlKotlinUtils.$$$reportNull$$$0(0);
        }
        return "kotlin".equals(psiElement.getLanguage().getID());
    }

    public static boolean isInternal(@NotNull PsiMethod method) {
        if (method == null) {
            UmlKotlinUtils.$$$reportNull$$$0(1);
        }
        return UmlKotlinUtils.isFromKotlin((PsiElement)method) && method.getName().contains("$");
    }

    public static boolean isBacktickNamedMethod(@NotNull PsiMethod method) {
        if (method == null) {
            UmlKotlinUtils.$$$reportNull$$$0(2);
        }
        return method.getName().contains(" ");
    }

    public static void appendPresentableNameForKotlinType(@NotNull StringBuilder sb, @NotNull PsiType psiType, @NotNull Project project, boolean isNullable) {
        if (sb == null) {
            UmlKotlinUtils.$$$reportNull$$$0(3);
        }
        if (psiType == null) {
            UmlKotlinUtils.$$$reportNull$$$0(4);
        }
        if (project == null) {
            UmlKotlinUtils.$$$reportNull$$$0(5);
        }
        if (psiType instanceof PsiClassType) {
            String resolvedName;
            PsiClassType classType = (PsiClassType)psiType;
            PsiClass resolved = classType.resolve();
            String string = resolvedName = resolved != null ? resolved.getQualifiedName() : null;
            if ("java.lang.Integer".equals(resolvedName)) {
                sb.append("Int");
                if (isNullable) {
                    sb.append('?');
                }
            } else if (resolvedName != null && resolvedName.startsWith("kotlin.jvm.functions.Function")) {
                boolean isSuspendLambda = Coroutines.isSuspendLambdaType((PsiType)classType);
                PsiType[] typeParameters = classType.getParameters();
                int typeParametersCount = typeParameters.length - 1 - (isSuspendLambda ? 1 : 0);
                if (isNullable) {
                    sb.append('(');
                }
                if (isSuspendLambda) {
                    sb.append("suspend");
                    sb.append(' ');
                }
                sb.append('(');
                for (int i = 0; i < typeParametersCount; ++i) {
                    UmlKotlinUtils.appendPresentableNameForKotlinType(sb, typeParameters[i], project, NullabilityUtils.isNullable((PsiAnnotationOwner)typeParameters[i], project));
                    if (i == typeParametersCount - 1) continue;
                    sb.append(", ");
                }
                sb.append(") -> ");
                PsiType resultType = isSuspendLambda ? Coroutines.getSuspendLambdaPresentableReturnType((PsiType)classType) : typeParameters[typeParameters.length - 1];
                UmlKotlinUtils.appendPresentableNameForKotlinType(sb, resultType, project, NullabilityUtils.isNullable((PsiAnnotationOwner)resultType, project));
                if (isNullable) {
                    sb.append(")?");
                }
            } else {
                sb.append(classType.getClassName());
                PsiType[] typeParameters = classType.getParameters();
                if (typeParameters.length > 0) {
                    sb.append('<');
                }
                for (int i = 0; i < typeParameters.length; ++i) {
                    UmlKotlinUtils.appendPresentableNameForKotlinType(sb, typeParameters[i], project, NullabilityUtils.isNullable((PsiAnnotationOwner)typeParameters[i], project));
                    if (i == typeParameters.length - 1) continue;
                    sb.append(", ");
                }
                if (typeParameters.length > 0) {
                    sb.append('>');
                }
                if (isNullable) {
                    sb.append('?');
                }
            }
        } else if (psiType instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            PsiType componentType = arrayType.getComponentType();
            UmlKotlinUtils.appendPresentableNameForKotlinType(sb, componentType, project, NullabilityUtils.isNullable((PsiAnnotationOwner)componentType, project));
            sb.append("[]");
            if (isNullable) {
                sb.append('?');
            }
        } else if (psiType instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)psiType;
            PsiType typeBound = wildcardType.getBound();
            if (typeBound != null) {
                UmlKotlinUtils.appendPresentableNameForKotlinType(sb, typeBound, project, NullabilityUtils.isNullable((PsiAnnotationOwner)typeBound, project));
            }
        } else if (psiType instanceof PsiPrimitiveType) {
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)psiType;
            String name = primitiveType.getPresentableText();
            if ("void".equals(name)) {
                sb.append("Unit");
            } else {
                sb.append(StringUtil.capitalize((String)name));
            }
        } else {
            sb.append(psiType.getPresentableText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/java/utils/UmlKotlinUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFromKotlin";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInternal";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isBacktickNamedMethod";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendPresentableNameForKotlinType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Coroutines {
        @NotNull
        @NlsSafe
        public static final String SUSPEND_KEYWORD = "suspend";

        public static boolean isSuspendFun(@NotNull PsiMethod psiMethod) {
            PsiParameter[] parameters;
            if (psiMethod == null) {
                Coroutines.$$$reportNull$$$0(0);
            }
            return (parameters = psiMethod.getParameterList().getParameters()).length != 0 && Coroutines.isContinuationType(Coroutines.unwrapBoundType(parameters[parameters.length - 1].getType()));
        }

        public static boolean isSuspendLambdaType(@NotNull PsiType psiType) {
            if (psiType == null) {
                Coroutines.$$$reportNull$$$0(1);
            }
            if (!(psiType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)psiType;
            PsiClass resolved = classType.resolve();
            String resolvedName = resolved != null ? resolved.getQualifiedName() : null;
            PsiType[] typeParameters = classType.getParameters();
            return resolvedName != null && resolvedName.startsWith("kotlin.jvm.functions.Function") && typeParameters.length > 1 && Coroutines.isContinuationType(Coroutines.unwrapBoundType(typeParameters[typeParameters.length - 2]));
        }

        private static boolean isContinuationType(@NotNull PsiType psiType) {
            if (psiType == null) {
                Coroutines.$$$reportNull$$$0(2);
            }
            if (!(psiType instanceof PsiClassType)) {
                return false;
            }
            PsiClass resolved = ((PsiClassType)psiType).resolve();
            return resolved != null && "kotlin.coroutines.Continuation".equals(resolved.getQualifiedName());
        }

        @NotNull
        private static PsiType unwrapBoundType(@NotNull PsiType psiType) {
            if (psiType == null) {
                Coroutines.$$$reportNull$$$0(3);
            }
            if (psiType instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)psiType).getBound();
                PsiType psiType2 = bound != null ? bound : psiType;
                if (psiType2 == null) {
                    Coroutines.$$$reportNull$$$0(4);
                }
                return psiType2;
            }
            PsiType psiType3 = psiType;
            if (psiType3 == null) {
                Coroutines.$$$reportNull$$$0(5);
            }
            return psiType3;
        }

        @NotNull
        public static PsiType getSuspendLambdaPresentableReturnType(@NotNull PsiType psiType) {
            if (psiType == null) {
                Coroutines.$$$reportNull$$$0(6);
            }
            assert (Coroutines.isSuspendLambdaType(psiType));
            PsiType[] parameters = ((PsiClassType)psiType).getParameters();
            PsiClassType continuationType = (PsiClassType)Coroutines.unwrapBoundType(parameters[parameters.length - 2]);
            assert (Coroutines.isContinuationType((PsiType)continuationType));
            return Coroutines.unwrapBoundType(continuationType.getParameters()[0]);
        }

        @NotNull
        public static PsiType getSuspendFunPresentableReturnType(@NotNull PsiMethod suspendFun) {
            if (suspendFun == null) {
                Coroutines.$$$reportNull$$$0(7);
            }
            assert (Coroutines.isSuspendFun(suspendFun));
            PsiParameter[] parameters = suspendFun.getParameterList().getParameters();
            PsiClassType lastParamType = (PsiClassType)parameters[parameters.length - 1].getType();
            return Coroutines.unwrapBoundType(lastParamType.getParameters()[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiType";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/utils/UmlKotlinUtils$Coroutines";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendFun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/utils/UmlKotlinUtils$Coroutines";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrapBoundType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuspendFun";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuspendLambdaType";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isContinuationType";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "unwrapBoundType";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuspendLambdaPresentableReturnType";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuspendFunPresentableReturnType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class DataClasses {
        @NotNull
        @NlsSafe
        public static final String DATA_KEYWORD = "data";

        public static boolean isDataClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                DataClasses.$$$reportNull$$$0(0);
            }
            Object[] methods = psiClass.getMethods();
            return UmlKotlinUtils.isFromKotlin((PsiElement)psiClass) && ContainerUtil.exists((Object[])methods, it -> MethodUtils.isEquals((PsiMethod)it)) && ContainerUtil.exists((Object[])methods, it -> MethodUtils.isToString((PsiMethod)it)) && ContainerUtil.exists((Object[])methods, it -> MethodUtils.isHashCode((PsiMethod)it)) && ContainerUtil.exists((Object[])methods, it -> DataClasses.isGeneratedCopyMethod(it)) && ContainerUtil.exists((Object[])methods, it -> DataClasses.isGeneratedComponentMethod(it));
        }

        @NotNull
        public static Stream<PsiMethod> filterOutDataClassGeneratedMethods(@NotNull Stream<PsiMethod> methods) {
            if (methods == null) {
                DataClasses.$$$reportNull$$$0(1);
            }
            Stream<PsiMethod> stream = methods.filter(it -> it.isPhysical() || !MethodUtils.isEquals((PsiMethod)it) && !MethodUtils.isToString((PsiMethod)it) && !MethodUtils.isHashCode((PsiMethod)it) && !DataClasses.isGeneratedCopyMethod(it) && !DataClasses.isGeneratedComponentMethod(it));
            if (stream == null) {
                DataClasses.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static boolean isGeneratedCopyMethod(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                DataClasses.$$$reportNull$$$0(3);
            }
            return !psiMethod.isPhysical() && psiMethod.getName().equals("copy");
        }

        private static boolean isGeneratedComponentMethod(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                DataClasses.$$$reportNull$$$0(4);
            }
            String name = psiMethod.getName();
            return !psiMethod.isPhysical() && name.startsWith("component") && StringUtil.isNotNegativeNumber((CharSequence)name.substring(9));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methods";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/utils/UmlKotlinUtils$DataClasses";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/utils/UmlKotlinUtils$DataClasses";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterOutDataClassGeneratedMethods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isDataClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filterOutDataClassGeneratedMethods";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isGeneratedCopyMethod";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isGeneratedComponentMethod";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Properties {
        public static boolean isNonPhysicalFieldForDelegatedProperty(@NotNull PsiField psiField) {
            if (psiField == null) {
                Properties.$$$reportNull$$$0(0);
            }
            return psiField.getName().endsWith("$delegate");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/intellij/uml/java/utils/UmlKotlinUtils$Properties", "isNonPhysicalFieldForDelegatedProperty"));
        }
    }

    public static final class TopLevel {
        public static boolean isImplicitClassForTopLevelDeclarations(@NotNull PsiClass psiClass) {
            String name;
            if (psiClass == null) {
                TopLevel.$$$reportNull$$$0(0);
            }
            return (name = psiClass.getName()) != null && name.endsWith("Kt");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/uml/java/utils/UmlKotlinUtils$TopLevel", "isImplicitClassForTopLevelDeclarations"));
        }
    }

    public static final class Objects {
        @NotNull
        @NlsSafe
        public static final String OBJECT_INSTANCE_FIELD_NAME = "INSTANCE";
        @NotNull
        @NlsSafe
        public static final String COMPANION_CLASS_NAME = "Companion";
        @NotNull
        @NlsSafe
        public static final String COMPANION_INSTANCE_FIELD_NAME = "Companion";

        public static boolean isObject(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                Objects.$$$reportNull$$$0(0);
            }
            return UmlKotlinUtils.isFromKotlin((PsiElement)psiClass) && ContainerUtil.exists((Object[])psiClass.getFields(), it -> OBJECT_INSTANCE_FIELD_NAME.equals(it.getName()) && it.hasModifier(JvmModifier.STATIC));
        }

        public static boolean isCompanionObject(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                Objects.$$$reportNull$$$0(1);
            }
            PsiClass containingClass = psiClass.getContainingClass();
            return UmlKotlinUtils.isFromKotlin((PsiElement)psiClass) && containingClass != null && ContainerUtil.exists((Object[])containingClass.getFields(), it -> "Companion".equals(it.getName()) && it.hasModifier(JvmModifier.STATIC)) && "Companion".equals(psiClass.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "psiClass";
            objectArray2[1] = "com/intellij/uml/java/utils/UmlKotlinUtils$Objects";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCompanionObject";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class DefaultImpls {
        @NotNull
        @NlsSafe
        public static final String DEFAULT_IMPLS_NAME = "DefaultImpls";

        public static boolean isDefaultImplsCompanion(@NotNull PsiClass psiClass) {
            PsiClass owner;
            if (psiClass == null) {
                DefaultImpls.$$$reportNull$$$0(0);
            }
            return (owner = psiClass.getContainingClass()) != null && owner.isInterface() && !psiClass.isPhysical() && DEFAULT_IMPLS_NAME.equals(psiClass.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/uml/java/utils/UmlKotlinUtils$DefaultImpls", "isDefaultImplsCompanion"));
        }
    }
}

