/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.dependency;

import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uml.java.JavaUmlRelationships;
import com.intellij.uml.java.dependency.DependenciesConfiguration;
import com.intellij.uml.java.dependency.RelationshipAnalysisSimpleResult;
import com.intellij.uml.java.dependency.RelationshipAnalyzer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaClassDependencyAnalyzer
implements RelationshipAnalyzer<PsiClass, RelationshipAnalysisSimpleResult<PsiClass>> {
    @Override
    @NotNull
    public Collection<RelationshipAnalysisSimpleResult<PsiClass>> compute(PsiClass source) {
        DependenciesConfiguration conf = DependenciesConfiguration.fromUmlConfiguration(DiagramConfiguration.getInstance());
        PsiClass initial = JavaClassDependencyAnalyzer.getClassToStartFrom(source);
        MyDependencyCollectingVisitor visitor = new MyDependencyCollectingVisitor(initial, conf);
        visitor.visitElement((PsiElement)initial);
        List<RelationshipAnalysisSimpleResult<PsiClass>> list = visitor.getCollectedDependencies();
        if (list == null) {
            JavaClassDependencyAnalyzer.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    private static PsiClass getClassToStartFrom(@NotNull PsiClass psiClass) {
        PsiElement element;
        if (psiClass == null) {
            JavaClassDependencyAnalyzer.$$$reportNull$$$0(1);
        }
        if (psiClass instanceof PsiCompiledElement && (element = psiClass.getNavigationElement()) instanceof PsiClass) {
            psiClass = (PsiClass)element;
        }
        PsiClass psiClass2 = psiClass;
        if (psiClass2 == null) {
            JavaClassDependencyAnalyzer.$$$reportNull$$$0(2);
        }
        return psiClass2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/dependency/JavaClassDependencyAnalyzer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "compute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/dependency/JavaClassDependencyAnalyzer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassToStartFrom";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassToStartFrom";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyDependencyCollectingVisitor
    extends JavaRecursiveElementVisitor {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final List<RelationshipAnalysisSimpleResult<PsiClass>> myDependencies;
        @NotNull
        private final DependenciesConfiguration myConf;
        private boolean myIsInsideField;
        private boolean myIsInsideCollection;
        private boolean myIsInsideClassObjectAccess;
        private boolean myIsInsideInner;
        @NotNull
        private static final Set<String> OUR_COLLECTIONS = ContainerUtil.immutableSet((Object[])new String[]{"java.lang.Iterable", "java.util.Map", "java.util.Dictionary", "kotlin.collections.Iterable", "kotlin.collections.Map", "com.google.common.collect.Multimap", "com.google.common.collect.RangeMap", "com.google.common.collect.RangeSet", "com.google.common.collect.Table"});

        private MyDependencyCollectingVisitor(@NotNull PsiClass psiClass, @NotNull DependenciesConfiguration conf) {
            if (psiClass == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (conf == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(1);
            }
            this.myDependencies = new ArrayList<RelationshipAnalysisSimpleResult<PsiClass>>();
            this.myClass = psiClass;
            this.myConf = conf;
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(2);
            }
            if (this.myIsInsideInner || aClass instanceof PsiAnonymousClass) {
                super.visitClass(aClass);
            } else {
                this.myIsInsideInner = true;
                super.visitClass(aClass);
                this.myIsInsideInner = false;
            }
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(3);
            }
            if (!this.myIsInsideInner) {
                this.myIsInsideField = true;
                super.visitField(field);
                this.myIsInsideField = false;
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiClass psiClass;
            if (expression == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(4);
            }
            if (this.myIsInsideInner) {
                return;
            }
            PsiType type = expression.getType();
            if (type != null && (psiClass = MyDependencyCollectingVisitor.findConcreteClass(MyDependencyCollectingVisitor.typeToClass(type))) != null) {
                this.add(psiClass, JavaUmlRelationships.CREATE, null);
            }
            super.visitNewExpression(expression);
        }

        public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression) {
            if (expression == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(5);
            }
            if (!this.myIsInsideInner) {
                this.myIsInsideClassObjectAccess = true;
                super.visitClassObjectAccessExpression(expression);
                this.myIsInsideClassObjectAccess = false;
            }
        }

        public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
            if (typeElement == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(6);
            }
            if (this.myIsInsideInner) {
                return;
            }
            PsiType type = typeElement.getType();
            PsiClass psiClass = MyDependencyCollectingVisitor.typeToClass(type);
            if (psiClass != null && !(psiClass instanceof PsiTypeParameter)) {
                if (this.myIsInsideClassObjectAccess) {
                    this.add(psiClass, JavaUmlRelationships.DEPENDENCY, null);
                } else if (this.myIsInsideField && !this.myIsInsideCollection && !(type instanceof PsiArrayType)) {
                    this.add(psiClass, JavaUmlRelationships.TO_ONE, null);
                } else if (this.myIsInsideField && this.myIsInsideCollection && !(type instanceof PsiArrayType)) {
                    this.add(psiClass, JavaUmlRelationships.TO_MANY, null);
                } else {
                    this.add(psiClass, JavaUmlRelationships.DEPENDENCY, null);
                }
            }
            if (this.myIsInsideField && !this.myIsInsideCollection && MyDependencyCollectingVisitor.isCollection(typeElement)) {
                this.myIsInsideCollection = true;
                super.visitTypeElement(typeElement);
                this.myIsInsideCollection = false;
            } else {
                super.visitTypeElement(typeElement);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(7);
            }
            if (this.myIsInsideInner) {
                return;
            }
            PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
            if (qualifierExpression != null) {
                PsiElement reference;
                PsiReference psiReference = qualifierExpression.getReference();
                if (psiReference != null && (reference = psiReference.resolve()) instanceof PsiClass) {
                    this.add((PsiClass)reference, JavaUmlRelationships.DEPENDENCY, null);
                }
            } else {
                PsiClass aClass;
                PsiElement resolve = referenceExpression.resolve();
                if ((resolve instanceof PsiField || resolve instanceof PsiMethod) && (aClass = ((PsiMember)resolve).getContainingClass()) != null) {
                    this.add(aClass, JavaUmlRelationships.DEPENDENCY, null);
                }
            }
            super.visitReferenceExpression(referenceExpression);
        }

        @NotNull
        private List<RelationshipAnalysisSimpleResult<PsiClass>> getCollectedDependencies() {
            List<RelationshipAnalysisSimpleResult<PsiClass>> list = this.myDependencies;
            if (list == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(8);
            }
            return list;
        }

        private void add(@NotNull PsiClass target, @NotNull DiagramRelationshipInfo relationshipInfo, @Nullable NavigatablePsiElement navigatableElement) {
            if (target == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(9);
            }
            if (relationshipInfo == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(10);
            }
            if (relationshipInfo == JavaUmlRelationships.TO_ONE && !this.myConf.myShowOneToOne || relationshipInfo == JavaUmlRelationships.TO_MANY && !this.myConf.myShowOneToMany || relationshipInfo == JavaUmlRelationships.DEPENDENCY && !this.myConf.myShowUsages || Objects.equals(this.myClass.getQualifiedName(), target.getQualifiedName()) && !this.myConf.myShowCyclic || relationshipInfo == JavaUmlRelationships.CREATE && !this.myConf.myShowNewExpressions) {
                return;
            }
            this.myDependencies.add(new RelationshipAnalysisSimpleResult<PsiClass>(target, relationshipInfo, (PsiElement)navigatableElement));
        }

        @Nullable
        private static PsiClass typeToClass(@NotNull PsiType psiType) {
            PsiClass psiClass;
            PsiType unwrapped;
            if (psiType == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(11);
            }
            PsiType psiType2 = unwrapped = psiType instanceof PsiArrayType ? ((PsiArrayType)psiType).getComponentType().getDeepComponentType() : psiType;
            if (unwrapped instanceof PsiClassType && (psiClass = ((PsiClassType)unwrapped).resolve()) != null) {
                return psiClass;
            }
            return null;
        }

        private static boolean isCollection(@NotNull PsiTypeElement type) {
            if (type == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(12);
            }
            if (type.getType() instanceof PsiArrayType) {
                return true;
            }
            PsiClass aClass = MyDependencyCollectingVisitor.typeToClass(type.getType());
            if (aClass == null) {
                return false;
            }
            List<PsiClass> classes = MyDependencyCollectingVisitor.getAllInterfaces(aClass);
            classes.add(aClass);
            for (PsiClass cl : classes) {
                if (!OUR_COLLECTIONS.contains(cl.getQualifiedName())) continue;
                return true;
            }
            return false;
        }

        @NotNull
        private static List<PsiClass> getAllInterfaces(@NotNull PsiClass psiClass) {
            PsiClass[] inters;
            if (psiClass == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(13);
            }
            ArrayList<PsiClass> interfaces = new ArrayList<PsiClass>();
            for (PsiClass inter : inters = psiClass.getInterfaces()) {
                interfaces.add(inter);
                interfaces.addAll(MyDependencyCollectingVisitor.getAllInterfaces(inter));
            }
            ArrayList<PsiClass> arrayList = interfaces;
            if (arrayList == null) {
                MyDependencyCollectingVisitor.$$$reportNull$$$0(14);
            }
            return arrayList;
        }

        @Nullable
        private static PsiClass findConcreteClass(@Nullable PsiClass psiClass) {
            while (psiClass instanceof PsiAnonymousClass) {
                psiClass = PsiUtil.resolveClassInType((PsiType)((PsiAnonymousClass)psiClass).getBaseClassType());
            }
            return psiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conf";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeElement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceExpression";
                    break;
                }
                case 8: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/uml/java/dependency/JavaClassDependencyAnalyzer$MyDependencyCollectingVisitor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relationshipInfo";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiType";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/uml/java/dependency/JavaClassDependencyAnalyzer$MyDependencyCollectingVisitor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCollectedDependencies";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllInterfaces";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitField";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNewExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassObjectAccessExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTypeElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReferenceExpression";
                    break;
                }
                case 8: 
                case 14: {
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "typeToClass";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isCollection";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllInterfaces";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

