/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PaintingParent;
import com.intellij.uml.components.UmlGraphZoomableViewport;
import com.intellij.uml.dnd.UmlDnDSupport;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class UmlGraphComponent
implements Disposable {
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final DiagramBuilder myBuilder;

    public UmlGraphComponent(@NotNull DiagramBuilder builder, @NotNull ActionToolbar actionToolbar) {
        if (builder == null) {
            UmlGraphComponent.$$$reportNull$$$0(0);
        }
        if (actionToolbar == null) {
            UmlGraphComponent.$$$reportNull$$$0(1);
        }
        this.myBuilder = builder;
        this.myComponent = new PaintingParent.Wrapper((Component)JBUI.Panels.simplePanel((Component)((Object)new UmlGraphZoomableViewport(builder))).addToTop((Component)UmlGraphComponent.createToolbarComponent(builder, actionToolbar)));
        builder.initialize();
        this.addDnDSupport();
        Disposer.register((Disposable)this, (Disposable)builder);
    }

    @NotNull
    private static JComponent createToolbarComponent(@NotNull DiagramBuilder builder, @NotNull ActionToolbar actionToolbar) {
        if (builder == null) {
            UmlGraphComponent.$$$reportNull$$$0(2);
        }
        if (actionToolbar == null) {
            UmlGraphComponent.$$$reportNull$$$0(3);
        }
        JComponent component = actionToolbar.getComponent();
        component.setBackground(builder.getProvider().getColorManager().getToolbarBackground());
        component.setBorder(JBUI.Borders.compound((Border)JBUI.Borders.customLineBottom((Color)JBColor.border()), (Border)JBUI.Borders.empty((int)1, (int)0)));
        JComponent jComponent = component;
        if (jComponent == null) {
            UmlGraphComponent.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @NotNull
    public static ActionToolbar createToolbarPanel(@NotNull DefaultActionGroup actionsGroup) {
        if (actionsGroup == null) {
            UmlGraphComponent.$$$reportNull$$$0(5);
        }
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)actionsGroup);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Diagrams", (ActionGroup)actions, true);
        if (actionToolbar == null) {
            UmlGraphComponent.$$$reportNull$$$0(6);
        }
        return actionToolbar;
    }

    private void addDnDSupport() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        new DropTarget(this.myBuilder.getView().getCanvasComponent(), new UmlDnDSupport(this.myBuilder));
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            UmlGraphComponent.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionToolbar";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/components/UmlGraphComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionsGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/components/UmlGraphComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarComponent";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

