/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.VisibilityLevel;
import com.intellij.util.ArrayUtil;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.Nullable;

@ThreadSafe
public abstract class AbstractUmlVisibilityManager
implements DiagramVisibilityManager {
    @Nullable
    private volatile VisibilityLevel myCurrent = null;

    @Override
    @Nullable
    public VisibilityLevel getCurrentVisibilityLevel() {
        VisibilityLevel[] levels;
        if (this.myCurrent == null && (levels = this.getVisibilityLevels()).length > 0) {
            this.myCurrent = levels[levels.length - 1];
        }
        return this.myCurrent;
    }

    @Override
    public void setCurrentVisibilityLevel(@Nullable VisibilityLevel level) {
        if (ArrayUtil.indexOf((Object[])this.getVisibilityLevels(), (Object)level) >= 0) {
            this.myCurrent = level;
        }
    }

    @Override
    public boolean isRelayoutNeeded() {
        return false;
    }
}

