/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.AbstractIntellijClassfileTransformer;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.NewSamplingInstrumenter;
import com.intellij.rt.coverage.instrumentation.NewTracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.SamplingInstrumenter;
import com.intellij.rt.coverage.instrumentation.TracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.PrivateConstructorOfUtilClassFilter;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageClassfileTransformer
extends AbstractIntellijClassfileTransformer {
    private final ProjectData data;
    private final boolean shouldCalculateSource;
    private final List<Pattern> excludePatterns;
    private final List<Pattern> includePatterns;
    private final ClassFinder cf;
    private final TestTrackingMode testTrackingMode;

    public CoverageClassfileTransformer(ProjectData data, boolean shouldCalculateSource, List<Pattern> excludePatterns, List<Pattern> includePatterns, ClassFinder cf) {
        this(data, shouldCalculateSource, excludePatterns, includePatterns, cf, null);
    }

    public CoverageClassfileTransformer(ProjectData data, boolean shouldCalculateSource, List<Pattern> excludePatterns, List<Pattern> includePatterns, ClassFinder cf, TestTrackingMode testTrackingMode) {
        this.data = data;
        this.shouldCalculateSource = shouldCalculateSource;
        this.excludePatterns = excludePatterns;
        this.includePatterns = includePatterns;
        this.cf = cf;
        this.testTrackingMode = testTrackingMode;
    }

    @Override
    protected ClassVisitor createClassVisitor(String className, ClassLoader loader, ClassReader cr, ClassWriter cw) {
        Instrumenter instrumenter = this.data.isSampling() ? (System.getProperty("idea.new.sampling.coverage") != null ? new NewSamplingInstrumenter(this.data, cw, cr, className, this.shouldCalculateSource) : new SamplingInstrumenter(this.data, cw, className, this.shouldCalculateSource)) : (System.getProperty("idea.new.tracing.coverage") != null ? (this.data.isTestTracking() ? this.testTrackingMode.createInstrumenter(this.data, cw, cr, className, this.shouldCalculateSource) : new NewTracingInstrumenter(this.data, cw, cr, className, this.shouldCalculateSource)) : new TracingInstrumenter(this.data, cw, className, this.shouldCalculateSource));
        ClassVisitor result = instrumenter;
        if (FilterUtils.ignorePrivateConstructorOfUtilClassEnabled()) {
            result = PrivateConstructorOfUtilClassFilter.createWithContext(result, instrumenter);
        }
        return result;
    }

    @Override
    protected boolean shouldExclude(String className) {
        return ClassNameUtil.matchesPatterns(className, this.excludePatterns);
    }

    @Override
    protected AbstractIntellijClassfileTransformer.InclusionPattern getInclusionPattern() {
        return this.includePatterns.isEmpty() ? null : new AbstractIntellijClassfileTransformer.InclusionPattern(){

            public boolean accept(String className) {
                return ClassNameUtil.matchesPatterns(className, CoverageClassfileTransformer.this.includePatterns);
            }
        };
    }

    @Override
    protected void visitClassLoader(ClassLoader classLoader) {
        this.cf.addClassLoader(classLoader);
    }

    @Override
    protected boolean isStopped() {
        return this.data.isStopped();
    }
}

