/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.parser;

import com.intellij.indentation.IndentPsiBuilder;
import com.intellij.indentation.OperationParserHelper;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.parsing.CssParser2;
import com.intellij.psi.css.impl.parsing.IndentPreprocessorParser;
import com.intellij.psi.css.impl.parsing.PreprocessorTokenTypeProvider;
import com.intellij.psi.css.impl.util.CssStylesheetLazyElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.StylusBundle;
import org.jetbrains.plugins.stylus.StylusUtil;
import org.jetbrains.plugins.stylus.parser.StylusPsiBuilder;
import org.jetbrains.plugins.stylus.parser.StylusTokenTypeProvider;
import org.jetbrains.plugins.stylus.psi.StylusElementTypes;
import org.jetbrains.plugins.stylus.psi.StylusStubElementTypes;
import org.jetbrains.plugins.stylus.psi.StylusTokenTypes;

public class StylusParser
extends IndentPreprocessorParser
implements OperationParserHelper.BinaryOperationParser {
    private static final TokenSet WHITESPACES = TokenSet.create((IElementType[])new IElementType[]{StylusTokenTypes.EOL, CssElementTypes.CSS_WHITE_SPACE, StylusTokenTypes.INDENT});
    public static final TokenSet[] OPERATOR_PRIORITY = new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{StylusTokenTypes.AND, StylusTokenTypes.OR, StylusTokenTypes.AND_KEYWORD, StylusTokenTypes.OR_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_PERCENT}), TokenSet.create((IElementType[])new IElementType[]{StylusTokenTypes.POWER, CssElementTypes.CSS_ASTERISK, CssElementTypes.CSS_SLASH}), TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_PLUS, CssElementTypes.CSS_MINUS}), TokenSet.create((IElementType[])new IElementType[]{StylusTokenTypes.GE, CssElementTypes.CSS_GT, StylusTokenTypes.LE, StylusTokenTypes.LT, StylusTokenTypes.EQQ, StylusTokenTypes.NEQ, CssElementTypes.CSS_EQ, StylusTokenTypes.NEQ_KEYWORD, StylusTokenTypes.EQ_KEYWORD, StylusTokenTypes.IN_KEYWORD}), TokenSet.create((IElementType[])new IElementType[]{StylusTokenTypes.PLUS_EQ, StylusTokenTypes.MINUS_EQ, CssElementTypes.CSS_CONTAINS, StylusTokenTypes.DIV_EQ, StylusTokenTypes.PERCENT_EQ, StylusTokenTypes.CONDITIONAL_EQ})};
    private static final TokenSet PREFIX_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{StylusTokenTypes.NOT, CssElementTypes.CSS_TILDA, CssElementTypes.CSS_MINUS});
    private static final IElementType[] OPERATOR_ELEMENT_TYPES = new IElementType[]{StylusElementTypes.EXPRESSION, StylusElementTypes.EXPRESSION, StylusElementTypes.EXPRESSION, StylusElementTypes.EXPRESSION, StylusElementTypes.EXPRESSION, StylusElementTypes.EXPRESSION};
    private boolean firstOperand = false;
    private final List<List<String>> declaredVariables = new ArrayList<List<String>>();

    @NotNull
    protected IndentPsiBuilder createPsiBuilder(@NotNull PsiBuilder builder) {
        if (builder == null) {
            StylusParser.$$$reportNull$$$0(0);
        }
        return new StylusPsiBuilder(builder);
    }

    protected void parseRoot(IElementType root) {
        this.startScope();
        PsiBuilder.Marker rootMarker = this.mark();
        PsiBuilder.Marker stylesheetMarker = this.mark();
        this.parseCharset();
        PsiBuilder.Marker rulesetListMarker = this.mark();
        while (!this.eof()) {
            boolean result;
            int offset = this.getCurrentOffset();
            boolean bl = result = this.parseCssDeclarations(-2) || this.parseCss() || this.parseIf(true) || this.parseFor(true) || this.parseVariableDeclaration() || this.getCurrentIndent() == 0 && (this.parseMixinOrMixinInvocation(true) || this.parseVariableMixin(true)) || this.parseBlockMixinInvocation() || this.parseFontFace() || this.parseScope() || this.parseImport() || this.parseExpressionStatement();
            if (result && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_SEMICOLON})) {
                this.advance();
            }
            if (offset != this.getCurrentOffset()) continue;
            this.error(StylusBundle.message("parsing.error.unexpected.element", new Object[0]));
            this.advance();
        }
        this.done(rulesetListMarker, (IElementType)CssElementTypes.CSS_RULESET_LIST);
        if (root instanceof CssStylesheetLazyElementType) {
            this.done(stylesheetMarker, (IElementType)StylusElementTypes.STYLUS_STYLESHEET);
            this.done(rootMarker, root);
        } else {
            StylusParser.collapse((PsiBuilder.Marker)stylesheetMarker, (IElementType)StylusElementTypes.STYLUS_LAZY_STYLESHEET);
            this.done(rootMarker, root);
        }
        this.endScope();
    }

    protected boolean parseRulesetMedia() {
        if (this.getTokenType() != CssElementTypes.CSS_MEDIA_SYM) {
            return false;
        }
        int indent = this.getCurrentIndent();
        PsiBuilder.Marker media = this.mark();
        this.advance();
        this.parseMediumList();
        this.parseDeclarationBlock(indent);
        media.done((IElementType)CssElementTypes.CSS_MEDIA);
        return true;
    }

    private boolean parseCss() {
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.CSS_BLOCK_KEYWORD})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker cssBlockMarker = this.mark();
            this.advance();
            this.parseDeclarationBlock(indent);
            this.done(cssBlockMarker, StylusElementTypes.CSS_BLOCK);
            return true;
        }
        return false;
    }

    protected IElementType getIndentElementType() {
        return StylusTokenTypes.INDENT;
    }

    protected IElementType getEolElementType() {
        return StylusTokenTypes.EOL;
    }

    protected boolean parseSelectorSuffix() {
        return this.parseClass() || this.parseIdSelector() || this.parsePseudo() || this.parseAttribute();
    }

    protected boolean parseClass() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PERIOD})) {
            PsiBuilder.Marker cssClass = this.mark();
            this.advance();
            if (!this.isNewLine() && this.rawLookup(-1) == CssElementTypes.CSS_PERIOD) {
                if (this.isKeyword()) {
                    this.myBuilder.remapCurrentToken(CssElementTypes.CSS_IDENT);
                }
                this.parseIdentOrInterpolation();
                this.parseInterpolationAfterIdent();
            }
            cssClass.done((IElementType)CssElementTypes.CSS_CLASS);
            return true;
        }
        return false;
    }

    protected List<IElementType> getSelectorPrefixTokenTypes() {
        return Arrays.asList(StylusTokenTypes.AMPERSAND, CssElementTypes.CSS_SLASH);
    }

    protected boolean parseExpression() {
        return this.parseExpression(false);
    }

    protected boolean parseExpression(boolean withMarker) {
        this.firstOperand = true;
        boolean result = false;
        PsiBuilder.Marker expressionMarker = this.mark();
        boolean expressionParsed = OperationParserHelper.callParsingBinaryOperation((OperationParserHelper.BinaryOperationParser)this, (int)(OPERATOR_PRIORITY.length - 1));
        if (expressionParsed) {
            result = true;
        }
        if (expressionParsed) {
            int offset;
            block0: do {
                offset = this.getCurrentOffset();
                if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.QUESTION})) {
                    int valueOffset;
                    this.advance();
                    while (!this.isNewLine() && !this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COLON})) {
                        valueOffset = this.getCurrentOffset();
                        this.parseExpression(true);
                        if (valueOffset != this.getCurrentOffset()) continue;
                        break;
                    }
                    if (!this.expect(CssElementTypes.CSS_COLON)) continue;
                    while (!this.isNewLine()) {
                        valueOffset = this.getCurrentOffset();
                        this.parseExpression(true);
                        if (valueOffset != this.getCurrentOffset()) continue;
                        continue block0;
                    }
                    continue;
                }
                if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{StylusTokenTypes.IF_KEYWORD})) {
                    this.advance();
                    if (this.parseIfCondition()) continue;
                    this.error(StylusBundle.message("parsing.error.condition.expected", new Object[0]));
                    continue;
                }
                if (this.isNewLine() || !this.currentTokenIn(new IElementType[]{StylusTokenTypes.FOR_KEYWORD})) break;
                this.advance();
                this.parseForCondition();
            } while (offset != this.getCurrentOffset());
        }
        if (result && withMarker) {
            this.done(expressionMarker, StylusElementTypes.EXPRESSION);
        } else {
            StylusParser.drop((PsiBuilder.Marker)expressionMarker);
        }
        return result;
    }

    private boolean parseObjectHash() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE}) && (StylusParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{CssElementTypes.CSS_IDENT, CssElementTypes.CSS_STRING_TOKEN}) && StylusParser.tokenIn((IElementType)this.lookAhead(2), (IElementType[])new IElementType[]{CssElementTypes.CSS_COLON}) || StylusParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{CssElementTypes.CSS_RBRACE}))) {
            PsiBuilder.Marker markerObject = this.mark();
            this.advance();
            while (!this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RBRACE}) && this.getTokenType() != null) {
                PsiBuilder.Marker markerObjectItem = this.myBuilder.mark();
                if (!(this.parseObjectItemKey() && this.expect(CssElementTypes.CSS_COLON) && this.parseObjectItemValue())) {
                    StylusParser.drop((PsiBuilder.Marker)markerObjectItem);
                    break;
                }
                this.done(markerObjectItem, StylusElementTypes.OBJECT_HASH_ITEM);
                if (!this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) continue;
                this.advance();
            }
            this.expect(CssElementTypes.CSS_RBRACE);
            this.done(markerObject, StylusElementTypes.OBJECT_HASH);
            return true;
        }
        return false;
    }

    private boolean parseObjectItemValue() {
        PsiBuilder.Marker marker = this.mark();
        if (this.parseTermList(new IElementType[]{CssElementTypes.CSS_RBRACE, CssElementTypes.CSS_COMMA, CssElementTypes.CSS_SEMICOLON})) {
            this.done(marker, StylusElementTypes.OBJECT_HASH_ITEM_VALUE);
            return true;
        }
        StylusParser.drop((PsiBuilder.Marker)marker);
        return false;
    }

    private boolean parseObjectItemKey() {
        PsiBuilder.Marker marker = this.mark();
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT})) {
            this.advance();
            this.done(marker, StylusElementTypes.OBJECT_HASH_ITEM_KEY);
            return true;
        }
        if (this.parseString(false)) {
            this.done(marker, StylusElementTypes.OBJECT_HASH_ITEM_KEY);
            return true;
        }
        StylusParser.drop((PsiBuilder.Marker)marker);
        return false;
    }

    private boolean parseExpressionStatement() {
        PsiBuilder.Marker expressionStatementMarker = this.mark();
        if (this.parseExpression(true)) {
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_EQ})) {
                this.advance();
            }
            while (!this.isNewLine() && this.parseExpression(true)) {
            }
            this.done(expressionStatementMarker, StylusElementTypes.EXPRESSION_STATEMENT);
            this.parseOptionalSemicolon();
            return true;
        }
        StylusParser.drop((PsiBuilder.Marker)expressionStatementMarker);
        return false;
    }

    protected TokenSet getComments() {
        return StylusTokenTypes.COMMENTS;
    }

    protected boolean ruleCouldContainBraces() {
        return true;
    }

    protected PreprocessorTokenTypeProvider getTokenTypeProvider() {
        return StylusTokenTypeProvider.getInstance();
    }

    protected boolean parseIf(boolean root) {
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.IF_KEYWORD})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker ifMarker = this.mark();
            do {
                if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.ELSE_KEYWORD})) {
                    this.advance();
                }
                this.advance();
                this.parseExpression(true);
                if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.IN_KEYWORD})) {
                    this.advance();
                    this.parseExpression(true);
                }
                this.parseDeclarationBlock(indent, true, root);
            } while (this.currentTokenIn(new IElementType[]{StylusTokenTypes.ELSE_KEYWORD}) && !StylusParser.tokenIn((IElementType)this.rawLookup(1), (IElementType[])new IElementType[]{StylusTokenTypes.EOL}) && StylusParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{StylusTokenTypes.IF_KEYWORD}));
            if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.ELSE_KEYWORD})) {
                this.advance();
                this.parseDeclarationBlock(indent, true, root);
            }
            this.done(ifMarker, StylusElementTypes.IF_STATEMENT);
            return true;
        }
        return false;
    }

    protected boolean parseFor(boolean root) {
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.FOR_KEYWORD})) {
            PsiBuilder.Marker forMarker = this.mark();
            int indent = this.getCurrentIndent();
            this.advance();
            this.advance();
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) {
                this.advance();
                if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT, StylusTokenTypes.VARIABLE_TOKEN})) {
                    this.advance();
                } else {
                    this.error(StylusBundle.message("parsing.error.second.variable.expected", new Object[0]));
                }
            }
            if (this.expect(StylusTokenTypes.IN_KEYWORD)) {
                this.parseTermList(new IElementType[]{CssElementTypes.CSS_LBRACE});
                this.parseDeclarationBlock(indent, false, root);
            }
            this.done(forMarker, StylusElementTypes.FOR_CYCLE);
            return true;
        }
        return false;
    }

    protected boolean parseVariableDeclaration() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT, StylusTokenTypes.VARIABLE_TOKEN}) && StylusParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{CssElementTypes.CSS_EQ, StylusTokenTypes.CONDITIONAL_EQ})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker variableDeclarationMarker = this.mark(true);
            PsiBuilder.Marker variableMarker = this.mark();
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT})) {
                this.myBuilder.remapCurrentToken(StylusTokenTypes.VARIABLE_TOKEN);
            }
            this.addVariableInCurrentScope(this.getTokenText());
            this.advance();
            this.done(variableMarker, StylusElementTypes.VARIABLE);
            if (this.isNewLine()) {
                this.rollbackTo(variableDeclarationMarker);
                return false;
            }
            this.advance();
            if (!(!this.isNewLine() && this.parseVariableDeclaration() || this.parseBlock())) {
                if (this.isNewLine()) {
                    this.parseDeclarationBlock(indent);
                } else if (this.parseTermList(new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_RBRACE})) {
                    while (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) {
                        this.advance();
                        this.parseTermList(new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_SEMICOLON});
                    }
                } else if (!this.parseObjectHash()) {
                    this.error(StylusBundle.message("parsing.error.hash.or.term.list.expected", new Object[0]));
                }
            }
            this.done(variableDeclarationMarker, (IElementType)StylusStubElementTypes.VARIABLE_DECLARATION);
            this.parseOptionalSemicolon();
            return true;
        }
        return false;
    }

    protected void startScope() {
        this.declaredVariables.add(new ArrayList());
    }

    protected void endScope() {
        this.declaredVariables.remove(this.declaredVariables.size() - 1);
    }

    protected void addVariableInCurrentScope(@NotNull String variableName) {
        if (variableName == null) {
            StylusParser.$$$reportNull$$$0(1);
        }
        this.declaredVariables.get(this.declaredVariables.size() - 1).add(variableName);
    }

    protected boolean isInScope(String name) {
        for (List<String> scope : this.declaredVariables) {
            if (!scope.contains(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean parseRuleset(int parentIndent) {
        if (parentIndent >= this.getCurrentIndent()) {
            return false;
        }
        PsiBuilder.Marker rulesetMarker = this.mark(true);
        int indent = this.getCurrentIndent();
        if (this.parseSelectorList(indent) && (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE}) || indent < this.getCurrentIndent() || parentIndent == -2) || this.eof()) {
            if (!(this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE}) && !this.isInterpolation() || this.getCurrentIndent() > indent || this.eof())) {
                this.rollbackTo(rulesetMarker);
                return false;
            }
            this.parseDeclarationBlock(indent);
            this.done(rulesetMarker, (IElementType)CssElementTypes.CSS_RULESET);
            return true;
        }
        this.rollbackTo(rulesetMarker);
        return false;
    }

    protected boolean selectorsCouldBeInANewLine(int lineIndent) {
        return this.getCurrentIndent() == lineIndent || this.getCurrentIndent() > lineIndent && this.lookAhead(-1) == CssElementTypes.CSS_COMMA;
    }

    protected boolean parseIdentMergedToAmpersand() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT, CssElementTypes.CSS_MINUS})) {
            this.advance();
            if (this.isInterpolation()) {
                return this.parseInterpolation();
            }
            return true;
        }
        if (this.isInterpolation()) {
            return this.parseInterpolation();
        }
        return this.parseVariable();
    }

    protected boolean parseTagSimpleSelector() {
        boolean result = super.parseTagSimpleSelector();
        if (!result && this.currentTokenIn(new IElementType[]{StylusTokenTypes.VARIABLE_TOKEN}) && StylusParser.tokenIn((IElementType)this.rawLookup(1), (IElementType[])new IElementType[]{StylusTokenTypes.EOL, null})) {
            PsiBuilder.Marker marker = this.mark();
            this.advance();
            this.done(marker, StylusElementTypes.VARIABLE);
            result = true;
        }
        return result;
    }

    protected boolean parseParameter() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT, StylusTokenTypes.VARIABLE_TOKEN})) {
            this.advance();
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_EQ})) {
                this.advance();
                if (!this.parseTermList(new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_RPAREN})) {
                    this.error(StylusBundle.message("parsing.error.term.list.expected", new Object[0]));
                }
            } else if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.SPLAT})) {
                if (this.getTokenText().length() < 3) {
                    this.error(StylusBundle.message("parsing.error.dot.dot.dot.expected", new Object[0]));
                }
                this.advance();
            }
            return true;
        }
        return false;
    }

    protected boolean mediumListAllowLineBreaks() {
        return true;
    }

    protected boolean parseMediaExpression() {
        boolean result = false;
        if (this.getTokenType() == CssElementTypes.CSS_LPAREN) {
            PsiBuilder.Marker mediaExpression = this.mark();
            this.expect(CssElementTypes.CSS_LPAREN, "'('");
            if (this.parseDeclaration(CssElementTypes.CSS_MEDIA_FEATURE)) {
                this.expect(CssElementTypes.CSS_RPAREN, "')");
                result = true;
            }
            mediaExpression.done(CssElementTypes.CSS_MEDIA_EXPRESSION);
        }
        return result;
    }

    protected boolean isInterpolation() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE})) {
            int i = 1;
            IElementType token = this.lookAhead(1);
            if (StylusParser.tokenIn((IElementType)token, (IElementType[])new IElementType[]{CssElementTypes.CSS_RBRACE, CssElementTypes.CSS_LBRACE})) {
                return false;
            }
            while (token != CssElementTypes.CSS_RBRACE && token != null) {
                if (StylusParser.tokenIn((IElementType)token, (IElementType[])new IElementType[]{CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_COLON, StylusTokenTypes.EOL})) {
                    return false;
                }
                token = this.rawLookup(++i);
            }
            return true;
        }
        return false;
    }

    private boolean isSelector() {
        PsiBuilder.Marker marker = this.mark(true);
        int indent = this.getCurrentIndent();
        boolean containsClassElement = false;
        while (!this.eof() && this.getCurrentIndent() == indent) {
            if (this.getTokenType() == CssElementTypes.CSS_PERIOD) {
                containsClassElement = true;
            }
            this.advance();
            if (!this.isNewLine() || containsClassElement) continue;
        }
        boolean result = !this.eof() && indent < this.getCurrentIndent() && containsClassElement;
        this.rollbackTo(marker);
        return result;
    }

    private boolean parseExtend() {
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.EXTEND_KEYWORD})) {
            PsiBuilder.Marker extendMarker = this.mark();
            this.advance();
            if (!this.isNewLine()) {
                boolean parsed = false;
                while (!this.eof() && !this.isNewLine()) {
                    int offset = this.getCurrentOffset();
                    if (this.isSelector() && this.parseSelector() || this.parseExpression() || this.parseSelector() || this.parseTermList(new IElementType[0])) {
                        parsed = true;
                        if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) {
                            this.advance();
                        }
                    }
                    if (offset != this.getCurrentOffset()) continue;
                    break;
                }
                if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_SEMICOLON})) {
                    this.advance();
                }
                if (!parsed) {
                    this.error(StylusBundle.message("parsing.error.ruleset.name.expected", new Object[0]));
                }
                this.done(extendMarker, StylusElementTypes.EXTEND_STATEMENT);
                return true;
            }
            StylusParser.drop((PsiBuilder.Marker)extendMarker);
        }
        return false;
    }

    protected void parseOptionalSemicolon() {
        if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_SEMICOLON})) {
            this.advance();
        }
    }

    private boolean parseFunctionInvocation() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_FUNCTION_TOKEN})) {
            PsiBuilder.Marker functionInvocationMarker = this.mark();
            this.advance();
            this.parseArgumentList();
            this.done(functionInvocationMarker, StylusElementTypes.MIXIN_INVOCATION);
            return true;
        }
        return false;
    }

    private boolean parseVariableMixin(boolean root) {
        int indent = this.getCurrentIndent();
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.VARIABLE_TOKEN})) {
            PsiBuilder.Marker mixinMarker = this.mark(true);
            PsiBuilder.Marker variableDeclarationMarker = this.mark(true);
            PsiBuilder.Marker variableMarker = this.mark();
            this.advance();
            this.done(variableMarker, StylusElementTypes.VARIABLE);
            this.done(variableDeclarationMarker, (IElementType)StylusStubElementTypes.VARIABLE_DECLARATION);
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE}) || this.isNewLine() && this.getCurrentIndent() > indent) {
                this.parseDeclarationBlock(indent, true, root);
                this.done(mixinMarker, (IElementType)StylusStubElementTypes.MIXIN);
                return true;
            }
            this.rollbackTo(mixinMarker);
        }
        return false;
    }

    private boolean parseBlockMixinInvocation() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PLUS}) && StylusParser.tokenIn((IElementType)this.rawLookup(1), (IElementType[])new IElementType[]{CssElementTypes.CSS_FUNCTION_TOKEN})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker invocationMarker = this.mark();
            this.advance();
            this.advance();
            this.parseArgumentList();
            this.parseDeclarationBlock(indent, true, false);
            this.done(invocationMarker, StylusElementTypes.BLOCK_MIXIN_INVOCATION);
            return true;
        }
        return false;
    }

    private boolean parseAnonymousFunction() {
        if (this.getTokenType() != StylusTokenTypes.ANONYMOUS_FUNCTION_TOKEN) {
            return false;
        }
        PsiBuilder.Marker marker = this.mark(true);
        this.advance();
        if (!this.parseArgumentList()) {
            this.rollbackTo(marker);
            return false;
        }
        if (this.getTokenType() != CssElementTypes.CSS_LBRACE) {
            this.error(CssBundle.message((String)"parsing.error.opening.brace.expected", (Object[])new Object[0]));
        } else {
            this.parseDeclarationBlock(-1, true, false);
        }
        this.done(marker, StylusElementTypes.ANONYMOUS_FUNCTION);
        return true;
    }

    private boolean parseMixinOrMixinInvocation(boolean root) {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_FUNCTION_TOKEN})) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker mixinInvocationMarker = this.mark(true);
            this.advance();
            this.parseArgumentList();
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE}) && (!this.isNewLine() || !this.isInterpolation()) || !this.eof() && this.isNewLine() && indent < this.getCurrentIndent()) {
                this.rollbackTo(mixinInvocationMarker);
                PsiBuilder.Marker mixinMarker = this.mark();
                this.advance();
                this.parseParameterList();
                this.parseDeclarationBlock(indent, true, root);
                this.done(mixinMarker, (IElementType)StylusStubElementTypes.MIXIN);
            } else {
                this.parseOptionalSemicolon();
                this.done(mixinInvocationMarker, StylusElementTypes.MIXIN_INVOCATION);
            }
            return true;
        }
        return false;
    }

    private boolean parseScope() {
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.SCOPE_TOKEN})) {
            PsiBuilder.Marker scopeMarker = this.mark();
            this.advance();
            this.parseTermList(new IElementType[0]);
            this.done(scopeMarker, StylusElementTypes.SCOPE_STATEMENT);
            return true;
        }
        return false;
    }

    private boolean parseStylusBlock() {
        boolean result = false;
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE})) {
            PsiBuilder.Marker marker = this.mark(true);
            this.advance();
            if (!this.isNewLine() && this.getTokenText().equals("block") && StylusParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{CssElementTypes.CSS_RBRACE})) {
                this.advance();
                this.advance();
                result = true;
                this.done(marker, StylusElementTypes.BLOCK_INVOCATION);
            } else {
                this.rollbackTo(marker);
            }
        }
        return result;
    }

    private boolean parseBlock() {
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.BLOCK_KEYWORD})) {
            PsiBuilder.Marker blockParameterMarker = this.mark();
            int indent = this.getCurrentIndent();
            this.advance();
            this.parseDeclarationBlock(indent);
            this.done(blockParameterMarker, StylusElementTypes.BLOCK);
            return true;
        }
        return false;
    }

    private void parseDeclarationBlock(int parentIndent, boolean ignoreFirstInterpolation, boolean isRoot) {
        this.startScope();
        boolean withBraces = false;
        PsiBuilder.Marker declarationBlockMarker = this.mark();
        this.parseStylusBlock();
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE}) && (ignoreFirstInterpolation && !this.isNewLine() || !this.isInterpolation())) {
            this.advance();
            withBraces = true;
        }
        int indent = this.getCurrentIndent();
        if (!withBraces && parentIndent >= indent) {
            StylusParser.drop((PsiBuilder.Marker)declarationBlockMarker);
            return;
        }
        while ((withBraces || this.getCurrentIndent() >= indent) && !this.eof() && (this.parseCssDeclarations(withBraces ? -1 : parentIndent) || this.parseStylusDeclarations(isRoot))) {
        }
        if (withBraces) {
            this.expect(CssElementTypes.CSS_RBRACE);
        }
        this.done(declarationBlockMarker, StylusElementTypes.DECLARATION_BLOCK);
        declarationBlockMarker.setCustomEdgeTokenBinders(this.COMMENTS_BEFORE_BINDER, this.WHITE_SPACES_AFTER_BINDER);
        this.endScope();
    }

    private boolean parseCssDeclarations(int parentIndent) {
        return this.isSelector() && this.parseRuleset(parentIndent) || parentIndent >= -1 && this.parseDeclaration() || this.parseRuleset(parentIndent) || this.parsePage() || this.parseCounterStyle() || this.parseDocument() || this.parseRegion() || this.parseKeyframes() || this.parseFontFace() || this.parseViewPort() || this.parseExtend() || this.parseSupports() || this.parsePageMarginRules() || parentIndent < this.getCurrentIndent() && this.parseRulesetMedia();
    }

    private boolean parseStylusDeclarations(boolean isRoot) {
        boolean result;
        boolean bl = result = this.parseStylusBlock() || this.parseMixinOrMixinInvocation(false) || this.parseBlockMixinInvocation() || this.parseVariableMixin(isRoot) || this.parseIf(false) || this.parseFor(false) || this.parseVariableDeclaration() || this.parseScope() || this.parseExtend() || this.parseImport() || this.parseExpressionStatement() || this.parseReturnStatement();
        if (result && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_SEMICOLON})) {
            this.advance();
        }
        return result;
    }

    protected void expectEolOrEof() {
    }

    protected void parseDeclarationBlock(int parentIndent) {
        this.parseDeclarationBlock(parentIndent, false, false);
    }

    protected boolean parsePseudoTerm() {
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.AMPERSAND})) {
            this.advance();
            return true;
        }
        return super.parsePseudoTerm();
    }

    private boolean parseIfCondition() {
        return this.parseExpression();
    }

    private boolean parseForCondition() {
        if (this.parseIdent()) {
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA})) {
                this.advance();
                if (!this.parseIdent()) {
                    this.error(StylusBundle.message("parsing.error.condition.expected", new Object[0]));
                }
            }
            if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.IN_KEYWORD})) {
                this.advance();
                if (!this.parseExpression()) {
                    this.error(CssBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    private static boolean doesTokenDiscardAttribute(@Nullable IElementType tokenType) {
        return tokenType != null && !StylusParser.tokenIn((IElementType)tokenType, (IElementType[])new IElementType[]{CssElementTypes.CSS_MINUS}) && (StylusUtil.isOperationToken(tokenType) || StylusParser.tokenIn((IElementType)tokenType, (IElementType[])new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_PERIOD, CssElementTypes.CSS_LBRACKET, CssElementTypes.CSS_RBRACKET}));
    }

    protected boolean parseDeclaration() {
        return this.parseDeclaration((IElementType)CssElementTypes.CSS_DECLARATION);
    }

    protected boolean parseDeclaration(@NotNull IElementType elementType) {
        if (elementType == null) {
            StylusParser.$$$reportNull$$$0(2);
        }
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT, CssElementTypes.CSS_MINUS}) && !StylusUtil.isOperationToken(this.lookAhead(1)) || this.isInterpolation()) {
            int indent = this.getCurrentIndent();
            PsiBuilder.Marker beforeDeclarationMarker = this.mark(true);
            PsiBuilder.Marker declarationMarker = this.mark();
            if (this.parseIdentOrInterpolation()) {
                while (!(this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COLON, CssElementTypes.CSS_RPAREN}) || StylusParser.tokenIn((IElementType)this.rawLookup(-1), (IElementType[])new IElementType[]{CssElementTypes.CSS_WHITE_SPACE}) || this.isNewLine())) {
                    int offset = this.getCurrentOffset();
                    if (!this.isNewLine() && this.isInterpolation()) {
                        this.parseInterpolation();
                    } else {
                        if (StylusParser.doesTokenDiscardAttribute(this.getTokenType())) {
                            this.rollbackTo(beforeDeclarationMarker);
                            return false;
                        }
                        this.advance();
                    }
                    if (offset != this.getCurrentOffset()) continue;
                    break;
                }
            }
            boolean colonWithSpace = false;
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COLON})) {
                colonWithSpace = StylusParser.tokenIn((IElementType)this.rawLookup(1), (IElementType[])new IElementType[]{CssElementTypes.CSS_WHITE_SPACE});
                do {
                    this.advance();
                    this.parseTermList(new IElementType[]{CssElementTypes.CSS_COMMA, CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_LBRACE});
                } while (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA}));
                if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE}) && !this.isInterpolation()) {
                    this.rollbackTo(beforeDeclarationMarker);
                    return false;
                }
            } else {
                if (StylusParser.doesTokenDiscardAttribute(this.getTokenType()) || this.isNewLine() || this.eof() || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACKET, CssElementTypes.CSS_EQ}) || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE}) && !this.isInterpolation()) {
                    this.rollbackTo(beforeDeclarationMarker);
                    return false;
                }
                this.parseTermList(new IElementType[]{CssElementTypes.CSS_SEMICOLON, CssElementTypes.CSS_PERIOD});
            }
            if (!colonWithSpace && (this.isNewLine() && this.getCurrentIndent() > indent || !this.isNewLine() && StylusParser.doesTokenDiscardAttribute(this.getTokenType()))) {
                this.rollbackTo(beforeDeclarationMarker);
                return false;
            }
            this.done(declarationMarker, elementType);
            if (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_SEMICOLON})) {
                this.advance();
            }
            if (!this.isNewLine() && !this.eof()) {
                if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.IF_KEYWORD})) {
                    this.advance();
                    if (!this.parseIfCondition()) {
                        this.error(StylusBundle.message("parsing.error.condition.expected", new Object[0]));
                    }
                } else if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.FOR_KEYWORD}) && !this.parseForCondition()) {
                    this.error(StylusBundle.message("parsing.error.condition.expected", new Object[0]));
                }
            }
            StylusParser.drop((PsiBuilder.Marker)beforeDeclarationMarker);
            return true;
        }
        return false;
    }

    private boolean parseReturnStatement() {
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.RETURN_KEYWORD})) {
            PsiBuilder.Marker returnMarker = this.mark();
            this.advance();
            if (!this.parseBlock()) {
                this.parseTermList(true, new IElementType[]{CssElementTypes.CSS_SEMICOLON});
            }
            this.parseOptionalSemicolon();
            this.done(returnMarker, StylusElementTypes.RETURN_STATEMENT);
            return true;
        }
        return false;
    }

    protected boolean parseMediaQueryTerm() {
        if (!this.isNewLine()) {
            if (this.parseIdentOrInterpolation()) {
                this.parseInterpolationAfterIdent();
                this.parseIndexesAndProperties();
                return true;
            }
            if (this.parseVariable()) {
                return true;
            }
        }
        return false;
    }

    protected boolean parseArgument() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT, StylusTokenTypes.VARIABLE_TOKEN}) && this.lookAhead(1) == CssElementTypes.CSS_COLON) {
            if (this.getTokenType() == StylusTokenTypes.VARIABLE_TOKEN) {
                PsiBuilder.Marker marker = this.mark();
                this.advance();
                this.done(marker, StylusElementTypes.VARIABLE);
            } else {
                this.advance();
            }
            this.advance();
            this.parseTermList(false, new IElementType[]{CssElementTypes.CSS_COMMA});
            return true;
        }
        if (this.parseBlock()) {
            return true;
        }
        if (this.parseObjectHash()) {
            return true;
        }
        return this.parseTermList(false, new IElementType[]{CssElementTypes.CSS_COMMA});
    }

    private boolean parseKeyframes() {
        if (this.getTokenType() != CssElementTypes.CSS_KEYFRAMES_SYM) {
            return false;
        }
        int keyframesIndent = this.getCurrentIndent();
        PsiBuilder.Marker keyframes = this.mark();
        this.advance();
        if (!this.isNewLine() && this.parseIdentOrInterpolation()) {
            this.parseInterpolationAfterIdent();
        } else {
            this.errorUntilEol(StylusBundle.message("parsing.error.keyframes.name.expected", new Object[0]));
        }
        boolean withBraces = false;
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE})) {
            withBraces = true;
            this.advance();
        }
        if (!withBraces && keyframesIndent >= this.getCurrentIndent()) {
            this.error(StylusBundle.message("parsing.error.keyframes.block.expected", new Object[0]));
        }
        int offset = this.getCurrentOffset();
        while ((withBraces && !this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RBRACE}) || keyframesIndent < this.getCurrentIndent()) && this.parseKeyframesRuleset(keyframesIndent)) {
            if (offset == this.getCurrentOffset()) {
                this.error(StylusBundle.message("parsing.error.unexpected.element", new Object[0]));
                break;
            }
            offset = this.getCurrentOffset();
        }
        if (withBraces) {
            this.expect(CssElementTypes.CSS_RBRACE);
        }
        keyframes.done(CssElementTypes.CSS_KEYFRAMES_RULE);
        return true;
    }

    protected boolean parseKeyframesRuleset(int parentIndent) {
        int rulesetIndent = this.getCurrentIndent();
        if (!this.eof() && this.isNewLine() && rulesetIndent > parentIndent) {
            PsiBuilder.Marker rulesetMarker = this.mark();
            if (this.parseKeyframesSelectorList()) {
                if (!this.eof() && this.isDeclarationBlock()) {
                    this.parseDeclarationBlock(rulesetIndent);
                }
                this.done(rulesetMarker, (IElementType)CssElementTypes.CSS_RULESET);
            } else {
                StylusParser.drop((PsiBuilder.Marker)rulesetMarker);
                this.parseDeclarationBlock(parentIndent);
            }
            return true;
        }
        return false;
    }

    protected boolean isDeclarationBlock() {
        return this.isNewLine() || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACE});
    }

    protected boolean parseIdentOrInterpolation() {
        boolean somethingParsed = false;
        while (!(somethingParsed && StylusParser.tokenIn((IElementType)this.rawLookup(-1), (IElementType[])new IElementType[]{CssElementTypes.CSS_WHITE_SPACE, StylusTokenTypes.INDENT, StylusTokenTypes.EOL}) || !this.isInterpolation() && !this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT, CssElementTypes.CSS_MINUS}))) {
            if (this.isInterpolation()) {
                this.advance();
                while (!(this.eof() || this.isNewLine() || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RBRACE}))) {
                    if (this.parseExpression()) continue;
                    this.advance();
                }
                this.expect(CssElementTypes.CSS_RBRACE);
            } else {
                this.advance();
            }
            somethingParsed = true;
        }
        if (somethingParsed) {
            while (StylusParser.tokenIn((IElementType)this.rawLookup(-1), (IElementType[])new IElementType[]{CssElementTypes.CSS_NUMBER, CssElementTypes.CSS_IDENT, CssElementTypes.CSS_RBRACE}) && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_NUMBER, CssElementTypes.CSS_IDENT})) {
                this.advance();
            }
        }
        return somethingParsed;
    }

    public boolean parseInterpolation() {
        if (this.isInterpolation()) {
            this.advance();
            while (!(this.eof() || this.isNewLine() || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RBRACE}))) {
                this.advance();
            }
            this.expect(CssElementTypes.CSS_RBRACE);
            return true;
        }
        return false;
    }

    public boolean parseInterpolationAfterIdent() {
        if (!this.isNewLine() && this.isInterpolation()) {
            this.advance();
            this.parseExpression(true);
            this.expect(CssElementTypes.CSS_RBRACE);
            return true;
        }
        return false;
    }

    protected IElementType getInterpolationPrefixToken() {
        return CssElementTypes.CSS_LBRACE;
    }

    protected IElementType getInterpolationSuffixToken() {
        return CssElementTypes.CSS_RBRACE;
    }

    protected IElementType getMultiplyToken() {
        return CssElementTypes.CSS_ASTERISK;
    }

    protected TokenSet getPossibleIdentifiers() {
        return TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_IDENT, StylusTokenTypes.AND_KEYWORD});
    }

    private boolean parseSplat() {
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_NUMBER, CssElementTypes.CSS_IDENT, StylusTokenTypes.VARIABLE_TOKEN}) && StylusParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{StylusTokenTypes.SPLAT})) {
            PsiBuilder.Marker splatMarker = this.mark();
            this.advance();
            this.advance();
            if (!this.parseExpression()) {
                this.error(StylusBundle.message("parsing.error.end.splat.expected", new Object[0]));
            }
            this.done(splatMarker, StylusElementTypes.SPLASH_EXPRESSION);
            return true;
        }
        return false;
    }

    private void parseIndexesAndProperties() {
        while (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_LBRACKET, CssElementTypes.CSS_PERIOD})) {
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PERIOD})) {
                this.advance();
                this.parseExpression();
                continue;
            }
            this.advance();
            int offset = this.getCurrentOffset();
            while (this.parseExpression(true) && offset != this.getCurrentOffset()) {
            }
            if (offset == this.getCurrentOffset()) {
                this.error(CssBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
            }
            if (this.expect(CssElementTypes.CSS_RBRACKET)) continue;
            break;
        }
    }

    public boolean parseSimpleExpression() {
        if (!this.isNewLine() || this.firstOperand) {
            if (this.parseSplat() || this.parseFunctionInvocation() || this.parseVariable() || this.parseParenthesis()) {
                this.parseIndexesAndProperties();
                this.firstOperand = false;
                return true;
            }
            if (this.parseVariableDeclaration() || this.parseNumber() || this.parseString(true)) {
                this.firstOperand = false;
                return true;
            }
            if (this.parseIdentOrInterpolation()) {
                this.parseInterpolationAfterIdent();
                this.parseIndexesAndProperties();
                return true;
            }
            if (!this.isInterpolation() && this.parseObjectHash()) {
                return true;
            }
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_URI_START})) {
                return this.parseUri();
            }
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_UNICODE_RANGE, CssElementTypes.CSS_HASH, CssElementTypes.CSS_IMPORTANT})) {
                this.advance();
                return true;
            }
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_URL})) {
                if (this.isInScope(this.getTokenText())) {
                    this.parseVariable();
                } else {
                    this.advance();
                }
                return true;
            }
        }
        return false;
    }

    private boolean parseVariable() {
        if (this.currentTokenIn(new IElementType[]{StylusTokenTypes.VARIABLE_TOKEN}) || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT, CssElementTypes.CSS_URL}) && this.isInScope(this.getTokenText())) {
            PsiBuilder.Marker referenceExpressionMarker = this.mark();
            PsiBuilder.Marker variableMarker = this.mark();
            if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT, CssElementTypes.CSS_URL})) {
                this.myBuilder.remapCurrentToken(StylusTokenTypes.VARIABLE_TOKEN);
            }
            this.advance();
            this.done(variableMarker, StylusElementTypes.VARIABLE);
            while (!this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_PERIOD})) {
                this.advance();
                if (this.isNewLine() || !this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_IDENT})) break;
                this.advance();
            }
            this.done(referenceExpressionMarker, StylusElementTypes.REFERENCE_EXPRESSION);
            return true;
        }
        return false;
    }

    public TokenSet getWhitespaceTokenSet() {
        return WHITESPACES;
    }

    public TokenSet getPrefixOperators() {
        return PREFIX_ELEMENT_TYPES;
    }

    public TokenSet getPostfixOperators() {
        return TokenSet.EMPTY;
    }

    protected boolean parseTerm() {
        PsiBuilder.Marker termMarker;
        boolean result = super.parseTerm();
        if (!result && !this.isNewLine() && this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_FUNCTION_TOKEN})) {
            termMarker = this.mark();
            this.advance();
            this.parseArgumentList();
            this.done(termMarker, CssElementTypes.CSS_TERM);
            result = true;
        }
        if (!result && this.getTokenType() == StylusTokenTypes.ANONYMOUS_FUNCTION_TOKEN) {
            termMarker = this.mark(true);
            if (this.parseAnonymousFunction()) {
                this.done(termMarker, CssElementTypes.CSS_TERM);
                result = true;
            } else {
                this.rollbackTo(termMarker);
            }
        }
        return result;
    }

    protected boolean parseUri() {
        if (this.getTokenType() == CssElementTypes.CSS_URI_START) {
            PsiBuilder.Marker uriMarker = this.mark();
            this.advance();
            this.expect(CssElementTypes.CSS_LPAREN);
            if (this.getTokenType() == CssElementTypes.CSS_URL && this.lookAhead(1) == CssElementTypes.CSS_RPAREN) {
                this.parseSimpleExpression();
            } else {
                boolean somethingParsed = false;
                while (!this.isNewLine() && this.parseExpression()) {
                    somethingParsed = true;
                }
                if (!somethingParsed) {
                    this.errorUntil(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_RPAREN}), CssBundle.message((String)"parsing.error.url.or.string.expected", (Object[])new Object[0]));
                }
            }
            this.expect(CssElementTypes.CSS_RPAREN);
            this.done(uriMarker, CssElementTypes.CSS_URI);
            return true;
        }
        return false;
    }

    protected boolean parseSupportsTopLevelCondition() {
        return super.parseSupportsTopLevelCondition() || this.parseExpression();
    }

    protected boolean parseImportDestination() {
        if (this.parseUri()) {
            return true;
        }
        boolean somethingParsed = false;
        while (!this.isNewLine() && !this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_COMMA}) && !CssParser2.isSupportsClause((IElementType)this.getTokenType(), (String)this.getTokenText()) && this.parseExpression()) {
            somethingParsed = true;
        }
        return somethingParsed;
    }

    protected boolean parseSelfSufficientHierarchySelector() {
        if (this.getTokenType() == StylusTokenTypes.RELATIVE_REF) {
            this.advance();
            while (this.getTokenType() == StylusTokenTypes.RELATIVE_REF) {
                this.advance();
            }
            return true;
        }
        if (this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_HAT}) && StylusParser.tokenIn((IElementType)this.lookAhead(1), (IElementType[])new IElementType[]{CssElementTypes.CSS_LBRACKET})) {
            this.advance();
            PsiBuilder.Marker partialReferenceMarker = this.mark();
            this.advance();
            while (!(this.eof() || this.isNewLine() || this.currentTokenIn(new IElementType[]{CssElementTypes.CSS_RBRACKET}))) {
                this.advance();
            }
            this.expect(CssElementTypes.CSS_RBRACKET);
            this.done(partialReferenceMarker, StylusElementTypes.REFERENCE_EXPRESSION);
            return true;
        }
        return super.parseSelfSufficientHierarchySelector();
    }

    public TokenSet @NotNull [] getOperatorsByPriority() {
        if (OPERATOR_PRIORITY == null) {
            StylusParser.$$$reportNull$$$0(3);
        }
        return OPERATOR_PRIORITY;
    }

    @Nullable
    public IElementType getPostfixExpressionElementType() {
        return StylusElementTypes.EXPRESSION;
    }

    @Nullable
    public IElementType getPrefixExpressionElementType() {
        return StylusElementTypes.PREFIX_EXPRESSION;
    }

    public IElementType @NotNull [] getOperationElementTypes() {
        if (OPERATOR_ELEMENT_TYPES == null) {
            StylusParser.$$$reportNull$$$0(4);
        }
        return OPERATOR_ELEMENT_TYPES;
    }

    public boolean isKeyword() {
        return this.currentTokenIn(new IElementType[]{StylusTokenTypes.IF_KEYWORD, StylusTokenTypes.ELSE_KEYWORD, StylusTokenTypes.FOR_KEYWORD, StylusTokenTypes.IN_KEYWORD, StylusTokenTypes.RETURN_KEYWORD, StylusTokenTypes.EQ_KEYWORD, StylusTokenTypes.AND_KEYWORD, StylusTokenTypes.NEQ_KEYWORD, StylusTokenTypes.OR_KEYWORD, StylusTokenTypes.NOT_KEYWORD, StylusTokenTypes.ONLY_KEYWORD});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/stylus/parser/StylusParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/stylus/parser/StylusParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatorsByPriority";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPsiBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addVariableInCurrentScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseDeclaration";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

