/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.scripts.rml.DomainTypeReference;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtPrint;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Expression;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class StatementComplexPrint
extends Nonterm {
    public Expression expr;
    private HashSet<String> wasSorted = new HashSet();
    private List<String> ids = new ArrayList<String>();
    private StmtPrint.RelationPrintBundle bundle = new StmtPrint.RelationPrintBundle();

    public StatementComplexPrint(Context context) {
        super(context);
    }

    public StmtPrint.RelationPrintBundle getBundle() {
        return this.bundle;
    }

    public void id(TokenInfo token) throws ParseException {
        String id = token.getString();
        this.ids.add(id);
        if (this.context.variablesManager.containsDomain(id)) {
            throw new ParseException(token.location, Messages.getString(StatementComplexPrint.class.getName() + "-0") + id + Messages.getString(StatementComplexPrint.class.getName() + "-1"));
        }
        this.context.variablesManager.addDomain(id, null);
    }

    public void sort(TokenInfo token) throws ParseException {
        String domain = token.getString();
        if (this.wasSorted.contains(domain)) {
            throw new ParseException(token.location, Messages.getString(StatementComplexPrint.class.getName() + "-2"));
        }
        this.wasSorted.add(domain);
        this.bundle.sortOrder.add(domain);
    }

    public void max(TokenInfo token) throws ParseException {
        this.bundle.maxTuples = token.getValue();
        if (this.bundle.maxTuples < 0) {
            throw new ParseException(token.location, Messages.getString(StatementComplexPrint.class.getName() + "-3"));
        }
    }

    public void finish() throws ParseException {
        if (this.expr.type != 0) {
            throw new ParseException(this.expr.location, Messages.getString(StatementComplexPrint.class.getName() + "-4"));
        }
        this.bundle.expr = this.expr.relExpr;
        this.bundle.domainNames = this.ids;
        for (String name : this.ids) {
            if (!this.context.variablesManager.wasDomainUsed(name)) {
                throw new ParseException(this.expr.location, Messages.getString(StatementComplexPrint.class.getName() + "-5") + name + Messages.getString(StatementComplexPrint.class.getName() + "-6"));
            }
            DomainType type = this.context.variablesManager.getDomain(name);
            if (type == null) {
                throw new ParseException(this.expr.location, Messages.getString(StatementComplexPrint.class.getName() + "-7") + name + "\"");
            }
            DomainTypeReference ref = this.context.variablesManager.getDomainTypeReference(type.getName());
            if (type.isGeneric() && ref != null) {
                this.bundle.domainTypes.add(ref);
                continue;
            }
            if (!type.isGeneric()) {
                this.bundle.domainTypes.add(type);
                continue;
            }
            throw new RuntimeException(Messages.getString(StatementComplexPrint.class.getName() + "-9"));
        }
        for (int i = this.ids.size() - 1; i >= 0; --i) {
            this.context.variablesManager.removeDomain(this.ids.get(i));
        }
    }
}

