/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HostData {
    @Nullable
    private final String myId;
    @NotNull
    private final SshConfig mySshConfig;

    public HostData(@NotNull SshConfig sshConfig) {
        if (sshConfig == null) {
            HostData.$$$reportNull$$$0(0);
        }
        this(null, sshConfig);
    }

    public HostData(@Nullable String id, @NotNull SshConfig sshConfig) {
        if (sshConfig == null) {
            HostData.$$$reportNull$$$0(1);
        }
        this.myId = id;
        this.mySshConfig = sshConfig;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    @NotNull
    public SshConfig getSshConfig() {
        SshConfig sshConfig = this.mySshConfig;
        if (sshConfig == null) {
            HostData.$$$reportNull$$$0(2);
        }
        return sshConfig;
    }

    public HostData copy() {
        return new HostData(this.myId, this.mySshConfig.clone());
    }

    public HostData update(@NotNull SshConfig sshConfig) {
        if (sshConfig == null) {
            HostData.$$$reportNull$$$0(3);
        }
        return new HostData(this.myId, sshConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostData host = (HostData)o;
        return Objects.equals(this.myId, host.myId) && Objects.equals(this.mySshConfig, host.mySshConfig);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.mySshConfig);
    }

    public static HostData updateHostData(@Nullable HostData newHostData, @Nullable HostData curHostData, @NotNull String hostName, boolean save2) {
        if (hostName == null) {
            HostData.$$$reportNull$$$0(4);
        }
        if (save2) {
            if (newHostData == null) {
                HostData.deleteRemoteHost(curHostData);
            } else {
                newHostData = HostData.storeHostData(hostName, newHostData);
            }
        }
        return newHostData;
    }

    @NotNull
    public static HostData updateHostData(@Nullable HostData curHostData, @NotNull SshConfig sshConfig, @NotNull @NonNls String hostName) {
        if (sshConfig == null) {
            HostData.$$$reportNull$$$0(5);
        }
        if (hostName == null) {
            HostData.$$$reportNull$$$0(6);
        }
        if (curHostData != null && curHostData.myId != null) {
            RemoteDeploymentHelper.updateRemoteHost(curHostData.myId, sshConfig);
            HostData hostData = curHostData.update(sshConfig);
            if (hostData == null) {
                HostData.$$$reportNull$$$0(7);
            }
            return hostData;
        }
        return HostData.storeHostData(hostName, sshConfig);
    }

    @NotNull
    private static HostData storeHostData(@NotNull String hostName, @NotNull HostData hostData) {
        if (hostName == null) {
            HostData.$$$reportNull$$$0(8);
        }
        if (hostData == null) {
            HostData.$$$reportNull$$$0(9);
        }
        String hostId = hostData.getId();
        SshConfig sshConfig = hostData.getSshConfig();
        if (hostId != null) {
            RemoteDeploymentHelper.updateRemoteHost(hostId, hostName, sshConfig);
            HostData hostData2 = hostData;
            if (hostData2 == null) {
                HostData.$$$reportNull$$$0(10);
            }
            return hostData2;
        }
        return HostData.storeHostData(hostName, sshConfig);
    }

    @NotNull
    public static HostData storeHostData(@NotNull String hostName, @NotNull RemoteCredentials credentials) {
        if (hostName == null) {
            HostData.$$$reportNull$$$0(11);
        }
        if (credentials == null) {
            HostData.$$$reportNull$$$0(12);
        }
        SshUiData sshUiData = new SshUiData(new SshConfig(true));
        sshUiData.loadFromCredentials(credentials);
        sshUiData = SshConfigManager.getInstance(null).register(sshUiData);
        return HostData.storeHostData(hostName, sshUiData.getConfig());
    }

    @NotNull
    public static HostData storeHostData(@NotNull String hostName, @NotNull SshConfig sshConfig) {
        if (hostName == null) {
            HostData.$$$reportNull$$$0(13);
        }
        if (sshConfig == null) {
            HostData.$$$reportNull$$$0(14);
        }
        String id = RemoteDeploymentHelper.addRemoteHost(hostName, sshConfig);
        return new HostData(id, sshConfig);
    }

    public static void deleteRemoteHost(@Nullable HostData hostData) {
        String id;
        if (hostData != null && (id = hostData.getId()) != null) {
            RemoteDeploymentHelper.deleteRemoteHost(id);
        }
    }

    @Nullable
    public static SshConfig getSshConfig(@Nullable HostData hostData) {
        return hostData == null ? null : hostData.getSshConfig();
    }

    @Nullable
    public static String getSshConfigName(@Nullable HostData hostData) {
        SshConfig sshConfig = hostData == null ? null : hostData.getSshConfig();
        return sshConfig != null ? sshConfig.getName() : null;
    }

    @Nullable
    public static String getId(@Nullable HostData hostData) {
        return hostData == null ? null : hostData.getId();
    }

    @Nullable
    public static HostData readHostData(@Nullable String hostId) {
        if (hostId == null) {
            return null;
        }
        SshConfig sshConfig = RemoteDeploymentHelper.getSshConfig(hostId);
        return sshConfig == null ? null : new HostData(hostId, sshConfig);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfig";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/HostData";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostData";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/HostData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshConfig";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "updateHostData";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "storeHostData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateHostData";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "storeHostData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

