/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCompilerSwitchesUtil {
    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static CidrCompilerSwitches filterClangdCUDAFlags(@Nullable CidrCompilerSwitches compilerSwitches, @NotNull OCLanguageKind languageKind) {
        if (languageKind == null) {
            CidrCompilerSwitchesUtil.$$$reportNull$$$0(0);
        }
        if (compilerSwitches == null) {
            return null;
        }
        if (!languageKind.isCuda()) {
            return compilerSwitches;
        }
        final List<String> skipSwitches = Arrays.asList("--cuda-gpu-arch", "--cuda-path", "-g");
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(){
            boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                boolean tokenIsSwitch = parameter.startsWith("-");
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (skipSwitches.contains(parameter)) {
                    this.skipOptionValue = true;
                    return false;
                }
                if (skipSwitches.stream().anyMatch(it -> parameter.startsWith((String)it))) {
                    return false;
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions((BiFunction<? super String, ? super String, Boolean>)argumentsFilter2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageKind", "com/jetbrains/cidr/lang/toolchains/CidrCompilerSwitchesUtil", "filterClangdCUDAFlags"));
    }
}

