/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDB
extends CidrExecutableTool {
    public static final String EXECUTABLE_NAME = SystemInfo.isWindows ? "gdb.exe" : "gdb";
    private static final Pattern[] VERSION_PATTERNS = new Pattern[]{GDBDriver.VERSION_PATTERN, CPPToolchainsUtil.VERSION_PATTERN};
    public static final Version MIN_VERSION = new Version(7, 8, -1);
    public static final Version MAX_VERSION = new Version(10, 2, -1);
    @NotNull
    private final CPPEnvironment myEnv;
    @NotNull
    private final CPPToolSet myToolSet;

    public GDB(@NotNull CPPEnvironment env, @NotNull File executable) {
        if (env == null) {
            GDB.$$$reportNull$$$0(0);
        }
        if (executable == null) {
            GDB.$$$reportNull$$$0(1);
        }
        super(executable);
        this.myEnv = env;
        this.myToolSet = env.getToolSet();
    }

    @Override
    @Nullable
    public String readVersion() {
        ToolVersion version = this.readToolVersion();
        return version == null ? null : version.toCompactString();
    }

    @Override
    @Nullable
    public ToolVersion readToolVersion() {
        String displayVersion = null;
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            this.myToolSet.prepareEnvironment(commandLine, CidrToolEnvironment.PrepareFor.RUN, Collections.emptyList());
            commandLine.setExePath(this.myExecutable.getPath());
            commandLine.addParameter("--version");
            HostMachine host = this.myEnv.getHostMachine();
            ProcessOutput output = host.runProcess(commandLine, 10000);
            displayVersion = (String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)output.getStdout()));
            displayVersion = StringUtil.nullize((String)displayVersion, (boolean)true);
        }
        catch (ProcessCanceledException commandLine) {
        }
        catch (Exception e) {
            CPPLog.LOG.info("Cannot read GDB version: ", (Throwable)e);
        }
        if (CPPLog.LOG.isDebugEnabled()) {
            CPPLog.logReadVersion("GDB", this.myExecutable, displayVersion);
        }
        if (displayVersion == null) {
            return null;
        }
        return GDB.parseVersion(displayVersion);
    }

    @NotNull
    public static ToolVersion parseVersion(@NotNull String displayVersion) {
        if (displayVersion == null) {
            GDB.$$$reportNull$$$0(2);
        }
        ToolVersion toolVersion = ToolVersion.parse((String)displayVersion, (Pattern[])VERSION_PATTERNS);
        if (toolVersion == null) {
            GDB.$$$reportNull$$$0(3);
        }
        return toolVersion;
    }

    @Nls
    @Nullable
    public static String checkVersion(@NotNull ToolVersion version) {
        if (version == null) {
            GDB.$$$reportNull$$$0(4);
        }
        return CPPToolchainsUtil.checkVersion(MIN_VERSION, MAX_VERSION, version);
    }

    public static boolean hasBundledGDB() {
        return CidrDebuggerPathManager.getBundledGDBBinary().exists();
    }

    @NotNull
    public static GDB getBundledGDB(@NotNull CPPEnvironment env) {
        if (env == null) {
            GDB.$$$reportNull$$$0(5);
        }
        return new GDB(env, CidrDebuggerPathManager.getBundledGDBBinary());
    }

    @Nullable
    public static ToolVersion readToolVersion(@NotNull CPPEnvironment env, @Nullable File execPath) {
        if (env == null) {
            GDB.$$$reportNull$$$0(6);
        }
        return execPath == null ? null : new GDB(env, execPath).readToolVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayVersion";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/GDB";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/GDB";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBundledGDB";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readToolVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

