/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.util.Consumer;
import com.intellij.util.PathMapper;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.UnmodifiableHashMap;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSetWithHome;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import com.jetbrains.cidr.cpp.toolchains.Make;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.cpp.toolchains.WSLCidrUtil;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostData;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.PathMapperWrapper;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHost;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.system.SystemUtil;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.CidrTool;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CPPEnvironment
extends CidrToolEnvironment {
    @NotNull
    protected final CPPToolchains.Toolchain myToolchain;
    @NotNull
    protected final CPPToolSet myToolSet;
    @NotNull
    protected final List<CPPToolSet.Option> myToolSetOptions;
    @Nullable
    private static Consumer<? super GeneralCommandLine> myAdditionalPreparationInTest;
    @NotNull
    private final Map<CMakeExecutableTool.ToolKind, ToolWithProblem<CMakeExecutableTool>> myCMakeTools;
    @NotNull
    private final ToolWithProblem<Make> myMake;
    @NotNull
    private volatile ToolWithProblem<GDB> myGDB;
    @NotNull
    private final HostMachine myHostMachine;
    public static final DataKey<CPPEnvironment> KEY;

    public CPPEnvironment(@NotNull CPPToolchains.Toolchain toolchain) {
        if (toolchain == null) {
            CPPEnvironment.$$$reportNull$$$0(0);
        }
        this(toolchain, null, null);
    }

    public CPPEnvironment(@NotNull CPPToolchains.Toolchain toolchain, @Nullable Project project, @Nullable File projectDir) {
        if (toolchain == null) {
            CPPEnvironment.$$$reportNull$$$0(1);
        }
        this.myToolchain = toolchain;
        this.myToolSet = toolchain.getToolSet();
        this.myToolSetOptions = toolchain.getToolSetOptions();
        this.myCMakeTools = this.createCMakeTools();
        this.myMake = new ToolWithProblem(this, (CidrExecutableTool)CPPEnvironment.createMake(this), ToolchainsBundle.message("make", new Object[0]));
        this.myGDB = this.initGDB();
        this.myHostMachine = this.createHost(toolchain.getHostData(), project, projectDir);
    }

    @NotNull
    private Map<CMakeExecutableTool.ToolKind, ToolWithProblem<CMakeExecutableTool>> createCMakeTools() {
        HashMap<CMakeExecutableTool.ToolKind, ToolWithProblem> tools = new HashMap<CMakeExecutableTool.ToolKind, ToolWithProblem>();
        for (CMakeExecutableTool.ToolKind tool : CMakeExecutableTool.ToolKind.values()) {
            tools.put(tool, new ToolWithProblem(this, (CidrExecutableTool)CPPEnvironment.createCMakeExecutableTool(this, tool), ToolchainsBundle.message("cmake", new Object[0])));
        }
        UnmodifiableHashMap unmodifiableHashMap = UnmodifiableHashMap.fromMap(tools);
        if (unmodifiableHashMap == null) {
            CPPEnvironment.$$$reportNull$$$0(2);
        }
        return unmodifiableHashMap;
    }

    @NotNull
    private ToolWithProblem<GDB> initGDB() {
        return new ToolWithProblem(this, (CidrExecutableTool)CPPEnvironment.createGDB(this), ToolchainsBundle.message("cpp.toolchains.debugger", new Object[0]));
    }

    private HostMachine createHost(@Nullable HostData hostData, @Nullable Project project, @Nullable File projectDir) {
        boolean isRemote;
        if (this.myToolSet.isWSL()) {
            return new WSLCidrUtil.WSLHost((WSL)this.myToolSet);
        }
        boolean bl = isRemote = hostData != null;
        if (isRemote) {
            String hostId = hostData.getId();
            SshConfig sshConfig = hostData.getSshConfig();
            if (hostId != null && !RemoteDeploymentHelper.isDeploymentConfigAvailable(hostId)) {
                RemoteDeploymentHelper.updateRemoteHost(hostId, this.myToolchain.getName(), sshConfig);
            }
            OSType osType = OSType.LINUX;
            PathMapper mapper = RemoteDeploymentHelper.getOrCreatePathMapper(hostId, sshConfig, project, projectDir);
            PathMapper pathMapper = PathMapperWrapper.wrapOnWindows((PathMapper)mapper);
            return new RemoteHost(hostId, sshConfig, osType, pathMapper, project);
        }
        return LocalHost.INSTANCE;
    }

    @NotNull
    public CPPToolchains.Toolchain getToolchain() {
        CPPToolchains.Toolchain toolchain = this.myToolchain;
        if (toolchain == null) {
            CPPEnvironment.$$$reportNull$$$0(3);
        }
        return toolchain;
    }

    @NotNull
    public CPPToolSet getToolSet() {
        CPPToolSet cPPToolSet = this.myToolSet;
        if (cPPToolSet == null) {
            CPPEnvironment.$$$reportNull$$$0(4);
        }
        return cPPToolSet;
    }

    public boolean isMSVC() {
        return this.myToolSet.isMSVC();
    }

    public boolean isCygwin() {
        return this.myToolSet.isCygwin();
    }

    public boolean isMinGW() {
        return this.myToolSet.isMinGW();
    }

    @NotNull
    public static Charset getCharset() {
        CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
        Charset charset = toolchain != null && toolchain.getCygwin() == null ? Charset.defaultCharset() : StandardCharsets.UTF_8;
        if (charset == null) {
            CPPEnvironment.$$$reportNull$$$0(5);
        }
        return charset;
    }

    public boolean useWindowsConsole() {
        return this.isMinGW() || this.isMSVC();
    }

    @Nullable
    public CMakeExecutableTool getCMake() {
        return this.getCMakeTool(CMakeExecutableTool.ToolKind.CMAKE);
    }

    @Nullable
    public CMakeExecutableTool getCMakeTool(CMakeExecutableTool.ToolKind toolKind) {
        return (CMakeExecutableTool)this.myCMakeTools.get((Object)((Object)toolKind)).myTool;
    }

    @Nullable
    public CMakeExecutableTool getCMakeChecked(@Nullable Project project, @NotNull EnvironmentProblems problems) {
        if (problems == null) {
            CPPEnvironment.$$$reportNull$$$0(6);
        }
        return this.myCMakeTools.get((Object)CMakeExecutableTool.ToolKind.CMAKE).check(project, problems);
    }

    @Nullable
    public static CMakeExecutableTool createCMakeExecutableTool(@NotNull CPPEnvironment owner, CMakeExecutableTool.ToolKind toolKind) {
        Path path;
        String customCMakePath;
        if (owner == null) {
            CPPEnvironment.$$$reportNull$$$0(7);
        }
        if ((customCMakePath = owner.myToolchain.getCustomCMakePath()) == null) {
            return owner.myToolchain.supportsBundledCMake() ? new CMakeExecutableTool(CMakeExecutableTool.getBundledCMakeToolBinary(owner.isCygwin(), toolKind), owner) : null;
        }
        try {
            path = Paths.get(customCMakePath, new String[0]);
            if (toolKind != CMakeExecutableTool.ToolKind.CMAKE) {
                if ((path = path.getParent()) == null) {
                    return null;
                }
                path = Paths.get(path.toString(), toolKind.getExecutableName(owner.getToolSet()));
            }
        }
        catch (Throwable ignore) {
            return null;
        }
        return new CMakeExecutableTool(path.toFile(), owner);
    }

    @Nullable
    public Make getMake() {
        return (Make)this.myMake.myTool;
    }

    @Nullable
    public Make getMakeChecked(@Nullable Project project, @NotNull EnvironmentProblems problems) {
        if (problems == null) {
            CPPEnvironment.$$$reportNull$$$0(8);
        }
        return this.myMake.check(project, problems);
    }

    @Nullable
    private static Make createMake(@NotNull CPPEnvironment owner) {
        String customMakePath;
        if (owner == null) {
            CPPEnvironment.$$$reportNull$$$0(9);
        }
        return (customMakePath = owner.myToolchain.getCustomMakeToolPath()) != null ? new Make(new File(customMakePath), owner) : null;
    }

    @Nullable
    public GDB getGDB() {
        return (GDB)this.myGDB.myTool;
    }

    @Nullable
    public GDB getGDBChecked(@Nullable Project project, @NotNull EnvironmentProblems problems) {
        if (problems == null) {
            CPPEnvironment.$$$reportNull$$$0(10);
        }
        if (!this.checkGDBEqualsToGDBInToolchain()) {
            this.myGDB = this.initGDB();
        }
        return this.myGDB.check(project, problems);
    }

    private boolean checkGDBEqualsToGDBInToolchain() {
        GDB gdb = this.getGDB();
        GDB newGdb = CPPEnvironment.createGDB(this);
        return gdb == null && newGdb == null || gdb != null && newGdb != null && gdb.getExecutablePath().equals(newGdb.getExecutablePath());
    }

    @Nullable
    private static GDB createGDB(@NotNull CPPEnvironment owner) {
        if (owner == null) {
            CPPEnvironment.$$$reportNull$$$0(11);
        }
        CPPDebugger debugger = owner.myToolchain.getDebugger();
        switch (debugger.getKind()) {
            case CUSTOM_GDB: {
                return debugger.getGdbExecutable() != null ? new GDB(owner, debugger.getGdbExecutable()) : null;
            }
            case BUNDLED_GDB: {
                return owner.myToolchain.supportsBundledGDB() ? GDB.getBundledGDB(owner) : null;
            }
        }
        return null;
    }

    @NotNull
    public String calcToolchainHash() {
        StringBuilder result = new StringBuilder();
        String location = this.myToolSet.isRemote() ? " (remote)" : " (local)";
        result.append("ToolSet: ").append(this.myToolSet.readVersion()).append(location);
        if (this.myToolSet instanceof CPPToolSetWithHome) {
            result.append("@").append(((CPPToolSetWithHome)this.myToolSet).getHome()).append("\n");
        }
        result.append("Options: ");
        StringUtil.join(this.myToolSetOptions, CPPToolSet.Option::getUniqueID, (String)", ", (StringBuilder)result);
        result.append("\n");
        String string = result.toString();
        if (string == null) {
            CPPEnvironment.$$$reportNull$$$0(12);
        }
        return string;
    }

    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        if (this.myToolSet instanceof Cygwin) {
            return Cygwin.toLocalPath(localBaseDir, absoluteOrRelativeEnvPath, (Cygwin)this.myToolSet);
        }
        if (this.myToolSet instanceof WSL) {
            return ((WSL)this.myToolSet).toLocalPath(localBaseDir, absoluteOrRelativeEnvPath);
        }
        if (this.myHostMachine.isRemote() && this.myHostMachine instanceof MappedHost) {
            PathMapper pathMapper = ((MappedHost)this.myHostMachine).getPathMapper();
            return SystemUtil.toLocalPath(pathMapper, localBaseDir, absoluteOrRelativeEnvPath);
        }
        return super.toLocalPath(localBaseDir, absoluteOrRelativeEnvPath);
    }

    public String toEnvPath(@Nullable String localPath) {
        if (localPath == null) {
            return null;
        }
        if (this.myToolSet instanceof Cygwin) {
            return Cygwin.toCygwinPath(localPath, (Cygwin)this.myToolSet);
        }
        if (this.myToolSet instanceof WSL) {
            return ((WSL)this.myToolSet).toEnvPath(localPath);
        }
        if (this.myHostMachine.isRemote() && this.myHostMachine instanceof MappedHost) {
            PathMapper pathMapper = ((MappedHost)this.myHostMachine).getPathMapper();
            return SystemUtil.toEnvPath(pathMapper, localPath);
        }
        return super.toEnvPath(localPath);
    }

    public boolean isEnvAbsolute(@NotNull String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            CPPEnvironment.$$$reportNull$$$0(13);
        }
        if (this.myToolSet instanceof Cygwin) {
            return Cygwin.isAbsolutePath(absoluteOrRelativeEnvPath);
        }
        if (this.myToolSet instanceof WSL) {
            return ((WSL)this.myToolSet).isAbsolutePath(absoluteOrRelativeEnvPath);
        }
        if (this.myHostMachine.isRemote()) {
            return SystemUtil.isAbsolute(this.myHostMachine, absoluteOrRelativeEnvPath);
        }
        return super.isEnvAbsolute(absoluteOrRelativeEnvPath);
    }

    @NotNull
    public CidrFileSeparators getSupportedFileSeparators() {
        CidrFileSeparators cidrFileSeparators = this.myToolSet.getSupportedFileSeparators();
        if (cidrFileSeparators == null) {
            CPPEnvironment.$$$reportNull$$$0(14);
        }
        return cidrFileSeparators;
    }

    @NotNull
    public ExecutablePathResult resolveEnvPathToLocalExecutable(@Nullable Path workingDir, @Nullable String absoluteOrRelativeEnvPath) throws ExecutionException {
        return CPPEnvironment.doResolveShortWinPath(this.doResolveEnvPathToLocalExecutable(workingDir, absoluteOrRelativeEnvPath, true));
    }

    @NotNull
    public ExecutablePathResult resolveEnvPathToLocalExecutable(@Nullable File workingDir, @Nullable String absoluteOrRelativeEnvPath) throws ExecutionException {
        ExecutablePathResult executablePathResult = this.resolveEnvPathToLocalExecutable(workingDir, absoluteOrRelativeEnvPath, true);
        if (executablePathResult == null) {
            CPPEnvironment.$$$reportNull$$$0(15);
        }
        return executablePathResult;
    }

    @NotNull
    ExecutablePathResult resolveEnvPathToLocalExecutable(@Nullable File workingDir, @Nullable String absoluteOrRelativeEnvPath, boolean checkIfExecutable) throws ExecutionException {
        Path path = workingDir != null ? workingDir.toPath() : null;
        return CPPEnvironment.doResolveShortWinPath(this.doResolveEnvPathToLocalExecutable(path, absoluteOrRelativeEnvPath, checkIfExecutable));
    }

    @NotNull
    private static ExecutablePathResult doResolveShortWinPath(@NotNull ExecutablePathResult localPathResult) {
        if (localPathResult == null) {
            CPPEnvironment.$$$reportNull$$$0(16);
        }
        if (localPathResult.path != null) {
            try {
                String resolved = FileUtil.resolveShortWindowsName((String)localPathResult.path);
                return new ExecutablePathResult(resolved, localPathResult.isResolvedToExecutable);
            }
            catch (IOException ex) {
                ExecutablePathResult executablePathResult = localPathResult;
                if (executablePathResult == null) {
                    CPPEnvironment.$$$reportNull$$$0(17);
                }
                return executablePathResult;
            }
        }
        ExecutablePathResult executablePathResult = localPathResult;
        if (executablePathResult == null) {
            CPPEnvironment.$$$reportNull$$$0(18);
        }
        return executablePathResult;
    }

    @NotNull
    private ExecutablePathResult doResolveEnvPathToLocalExecutable(@Nullable Path workingDir, @Nullable String absoluteOrRelativeEnvPath, boolean checkIfExecutable) throws ExecutionException {
        boolean isSeparatorFirst;
        if (absoluteOrRelativeEnvPath == null) {
            return new ExecutablePathResult(null, false);
        }
        if (this.myHostMachine.isRemote()) {
            String result;
            String resolvedPath = this.isEnvAbsolute(absoluteOrRelativeEnvPath) ? absoluteOrRelativeEnvPath : ((result = RemoteUtil.resolveToExecutable(this.getHostMachine(), absoluteOrRelativeEnvPath)) != null ? result : absoluteOrRelativeEnvPath);
            return new ExecutablePathResult(resolvedPath, SystemUtil.isExecutable(this.myHostMachine, resolvedPath));
        }
        Predicate<File> isExecutable = file -> file != null && (checkIfExecutable ? file.isFile() && file.canExecute() : file.exists());
        boolean isPosix = this.myHostMachine.getOSType() != OSType.WIN || this.isCygwin();
        int separatorIndex = StringUtil.indexOfAny((String)absoluteOrRelativeEnvPath, (String)(isPosix ? "/" : "/\\"));
        boolean isNameOnly = separatorIndex == -1;
        boolean bl = isSeparatorFirst = separatorIndex == 0;
        if (isPosix && absoluteOrRelativeEnvPath.startsWith("~/")) {
            File result = new File(FileUtil.expandUserHome((String)absoluteOrRelativeEnvPath));
            return new ExecutablePathResult(result.getPath(), isExecutable.test(result));
        }
        List<String> lookupNames = this.isWindows && !isSeparatorFirst ? Arrays.asList(absoluteOrRelativeEnvPath, absoluteOrRelativeEnvPath + ".exe") : Collections.singletonList(absoluteOrRelativeEnvPath);
        for (String eachLookupName : lookupNames) {
            File result;
            if (this.isEnvAbsolute(eachLookupName)) {
                result = new File(this.toLocalPath(eachLookupName));
                if (!isExecutable.test(result)) continue;
                return new ExecutablePathResult(result.getPath(), true);
            }
            if (workingDir != null && (isPosix ? !isNameOnly : !isSeparatorFirst) && isExecutable.test(result = new File(this.toLocalPath(workingDir.toFile(), eachLookupName)))) {
                return new ExecutablePathResult(result.getPath(), true);
            }
            if (!isNameOnly) continue;
            GeneralCommandLine cl = new GeneralCommandLine();
            this.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            String pathVariable = (String)cl.getEffectiveEnvironment().get("PATH");
            File result2 = PathEnvironmentVariableUtil.findInPath((String)eachLookupName, (String)pathVariable, null);
            if (result2 != null) {
                String resultPath = result2.getPath();
                String resultExtension = PathUtil.getFileExtension((String)resultPath);
                if (this.isCygwin() && (resultExtension == null || resultExtension.isEmpty())) {
                    resultPath = Cygwin.toLocalPathUnchecked(resultPath, (Cygwin)this.myToolSet);
                    result2 = new File(resultPath);
                }
                if (isExecutable.test(result2)) {
                    return new ExecutablePathResult(resultPath, true);
                }
            }
            if (result2 == null || !isExecutable.test(result2)) continue;
            return new ExecutablePathResult(result2.getPath(), true);
        }
        return new ExecutablePathResult(absoluteOrRelativeEnvPath, false);
    }

    public void prepare(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor) throws ExecutionException {
        if (cl == null) {
            CPPEnvironment.$$$reportNull$$$0(19);
        }
        if (prepareFor == null) {
            CPPEnvironment.$$$reportNull$$$0(20);
        }
        super.prepare(cl, prepareFor);
        this.myToolSet.prepareEnvironment(cl, prepareFor, this.myToolSetOptions);
        if (myAdditionalPreparationInTest != null) {
            myAdditionalPreparationInTest.consume((Object)cl);
        }
    }

    public void convertPathVariableToEnv(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CPPEnvironment.$$$reportNull$$$0(21);
        }
        if (this.myToolSet instanceof Cygwin) {
            Cygwin.convertPathVariableToCygwin(cl, (Cygwin)this.myToolSet);
        }
    }

    @NotNull
    public HostMachine getHostMachine() {
        HostMachine hostMachine = this.myHostMachine;
        if (hostMachine == null) {
            CPPEnvironment.$$$reportNull$$$0(22);
        }
        return hostMachine;
    }

    @TestOnly
    public static void setAdditionalPreparationInTest(@Nullable Consumer<? super GeneralCommandLine> additionalPreparationInTest) {
        myAdditionalPreparationInTest = additionalPreparationInTest;
    }

    public void applyEnvironmentFromFile(@NotNull String environmentFile, @NotNull GeneralCommandLine cmd) throws ExecutionException {
        if (environmentFile == null) {
            CPPEnvironment.$$$reportNull$$$0(23);
        }
        if (cmd == null) {
            CPPEnvironment.$$$reportNull$$$0(24);
        }
        try {
            cmd.withEnvironment(this.isCygwin() ? this.readEnvironmentFileInCygwin(environmentFile) : this.myHostMachine.readEnvironmentFile(environmentFile));
        }
        catch (ExecutionException ex) {
            throw ex;
        }
        catch (NoSuchFileException ex) {
            throw new ExecutionException(ToolchainsBundle.message("error.loading.environment.file.not.found", ex.getMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new ExecutionException(ToolchainsBundle.message("error.loading.environment.file", environmentFile, ex.getMessage()), (Throwable)ex);
        }
    }

    @NotNull
    private Map<String, String> readEnvironmentFileInCygwin(@NotNull String environmentFile) throws IOException, ExecutionException {
        Map map2;
        if (environmentFile == null) {
            CPPEnvironment.$$$reportNull$$$0(25);
        }
        Cygwin cygwin = (Cygwin)this.myToolSet;
        String convertedPath = this.toEnvPath(environmentFile);
        try {
            map2 = CidrToolsUtil.readLinuxEnvironmentFromFile((String)convertedPath, (HostMachine)this.myHostMachine, (String)cygwin.getSubFilePath("bin/bash"), (String)cygwin.getSubFilePath("bin/env"));
        }
        catch (IOException ex) {
            if (!convertedPath.matches("[a-zA-Z0-9]*")) {
                throw new ExecutionException(ToolchainsBundle.message("cygwin.error.pathname.contains.unsupported.chars", convertedPath), (Throwable)ex);
            }
            throw ex;
        }
        if (map2 == null) {
            CPPEnvironment.$$$reportNull$$$0(26);
        }
        return map2;
    }

    static {
        KEY = DataKey.create((String)"cpp_environment");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPEnvironment";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativeEnvPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPathResult";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCMakeTools";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchain";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcToolchainHash";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveEnvPathToLocalExecutable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveShortWinPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostMachine";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnvironmentFileInCygwin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 26: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeChecked";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCMakeExecutableTool";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMakeChecked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createMake";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getGDBChecked";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createGDB";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEnvAbsolute";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doResolveShortWinPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "convertPathVariableToEnv";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyEnvironmentFromFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readEnvironmentFileInCygwin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ExecutablePathResult {
        @Nullable
        public final String path;
        public final boolean isResolvedToExecutable;

        public ExecutablePathResult(@Nullable String path, boolean isResolvedToExecutable) {
            this.path = path;
            this.isResolvedToExecutable = isResolvedToExecutable;
        }

        public String toString() {
            return "{path='" + this.path + "', resolved=" + this.isResolvedToExecutable + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutablePathResult result = (ExecutablePathResult)o;
            if (this.isResolvedToExecutable != result.isResolvedToExecutable) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(result.path) : result.path != null);
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + (this.isResolvedToExecutable ? 1 : 0);
            return result;
        }
    }

    private static class ToolWithProblem<T extends CidrExecutableTool> {
        @Nullable
        private final T myTool;
        @NlsSafe
        @NotNull
        private final String myToolName;
        private final @NotNull NullableLazyValue<@NlsContexts.DialogMessage String> myProblemValue;
        final /* synthetic */ CPPEnvironment this$0;

        ToolWithProblem(@NotNull T tool, String toolName) {
            if (toolName == null) {
                ToolWithProblem.$$$reportNull$$$0(0);
            }
            this.this$0 = var1_1;
            this.myProblemValue = AtomicNullableLazyValue.createValue(this::doCheck);
            this.myTool = tool;
            this.myToolName = toolName;
        }

        @Nullable
        private T check(@Nullable Project project, @NotNull EnvironmentProblems problems) {
            String problem;
            if (problems == null) {
                ToolWithProblem.$$$reportNull$$$0(1);
            }
            if ((problem = (String)this.myProblemValue.getValue()) != null) {
                problems.addProblem(problem, CPPToolchains.getGenericToolchainsFix(project, this.this$0.getToolchain()));
            }
            return this.myTool;
        }

        @NlsContexts.DialogMessage
        @Nullable
        private synchronized String doCheck() {
            String version;
            boolean exists;
            if (this.myTool == null) {
                return ToolchainsBundle.message("dialog.message.executable.not.specified", this.myToolName);
            }
            HostMachine host = this.this$0.getHostMachine();
            String executablePath = ((CidrExecutableTool)this.myTool).getExecutablePath();
            Path toolPath = host.getPath(FileUtil.toSystemIndependentName((String)executablePath), new String[0]);
            boolean bl = exists = host instanceof WSLCidrUtil.WSLHost ? WSLCidrUtil.exists(toolPath) : Files.exists(toolPath, new LinkOption[0]);
            if (!exists) {
                return ToolchainsBundle.message("dialog.message.executable.not.found", this.myToolName, toolPath);
            }
            String string = ApplicationManager.getApplication().isDispatchThread() ? (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.myTool.readVersion(), ToolchainsBundle.message("cpp.toolchains.checking.tool.version", this.myToolName), true, null) : (version = ((CidrTool)this.myTool).readVersion());
            if (version == null) {
                return ToolchainsBundle.message("dialog.message.executable.incorrect", this.myToolName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPEnvironment$ToolWithProblem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

