/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a \u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a1\u0010\u000f\u001a\u00020\u0004*\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u00042\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"CDATA_BEGIN", "", "CDATA_END", "guessFormattedLength", "", "project", "Lcom/intellij/openapi/project/Project;", "response", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "guessFormattedLengthForJson", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "indentSize", "guessFormattedLengthForXml", "indexOfFirstNot", "from", "predicate", "Lkotlin/Function2;", "", "intellij.restClient"})
@JvmName(name="HttpClientExecutionUtil")
public final class HttpClientExecutionUtil {
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";

    public static final int guessFormattedLength(@NotNull Project project, @NotNull String response, @NotNull FileType fileType) {
        int n;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettingsManager, (String)"CodeStyleSettingsManager.getInstance(project)");
        CodeStyleSettings codeStyleSettings = codeStyleSettingsManager.getMainProjectCodeStyle();
        if (codeStyleSettings == null) {
            codeStyleSettings = CodeStyleSettings.getDefaults();
        }
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"CodeStyleSettingsManager\u2026yleSettings.getDefaults()");
        CodeStyleSettings settings = codeStyleSettings;
        int indentSize = settings.useTabCharacter(fileType) ? 1 : settings.getIndentSize(fileType);
        String string = fileType.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileType.name");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)string4, (CharSequence)"json", (boolean)false, (int)2, null)) {
            n = HttpClientExecutionUtil.guessFormattedLengthForJson(response, settings, indentSize);
        } else {
            String string5 = fileType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"fileType.name");
            string2 = string5;
            bl = false;
            String string6 = string2;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
            n = StringsKt.contains$default((CharSequence)string7, (CharSequence)"xml", (boolean)false, (int)2, null) ? HttpClientExecutionUtil.guessFormattedLengthForXml(response, settings, indentSize) : response.length();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final int guessFormattedLengthForJson(String response, CodeStyleSettings settings, int indentSize) {
        JsonCodeStyleSettings jsonCodeStyleSettings = (JsonCodeStyleSettings)settings.getCustomSettingsIfCreated(JsonCodeStyleSettings.class);
        boolean spaceAfterColon = jsonCodeStyleSettings == null || jsonCodeStyleSettings.SPACE_AFTER_COLON;
        boolean spaceBeforeColon = jsonCodeStyleSettings != null && jsonCodeStyleSettings.SPACE_BEFORE_COLON;
        int newWhitespaces = 0;
        int indent = 0;
        int containedWhitespaces = 0;
        for (int i = 0; i < response.length(); ++i) {
            char currentChar = response.charAt(i);
            if (CharsKt.isWhitespace((char)currentChar)) {
                ++containedWhitespaces;
                continue;
            }
            if (currentChar == '\"') {
                void $this$indexOfFirstNot$iv;
                int j$iv;
                String string = response;
                int from$iv = i + 1;
                boolean $i$f$indexOfFirstNot = false;
                for (j$iv = from$iv; j$iv < $this$indexOfFirstNot$iv.length(); ++j$iv) {
                    void j;
                    int n = j$iv;
                    void str = $this$indexOfFirstNot$iv;
                    boolean bl = false;
                    if (!(str.charAt((int)j) != '\"' || str.charAt((int)(j - true)) == '\\')) break;
                }
                i = j$iv;
                continue;
            }
            if (currentChar == ':') {
                if (spaceAfterColon) {
                    ++newWhitespaces;
                }
                if (!spaceBeforeColon) continue;
                ++newWhitespaces;
                continue;
            }
            if (currentChar == '{' || currentChar == ',' || currentChar == '[') {
                ++newWhitespaces;
                if (currentChar == '{' || currentChar == '[') {
                    ++indent;
                }
                newWhitespaces += indentSize * indent;
                continue;
            }
            if (currentChar != '}' && currentChar != ']') continue;
            newWhitespaces += 1 + indentSize * --indent;
        }
        return response.length() + newWhitespaces - containedWhitespaces;
    }

    /*
     * WARNING - void declaration
     */
    private static final int guessFormattedLengthForXml(String response, CodeStyleSettings settings, int indentSize) {
        XmlCodeStyleSettings xmlSettings;
        XmlCodeStyleSettings xmlCodeStyleSettings = xmlSettings = (XmlCodeStyleSettings)settings.getCustomSettingsIfCreated(XmlCodeStyleSettings.class);
        boolean spacesAroundEquality = xmlCodeStyleSettings != null && xmlCodeStyleSettings.XML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE;
        int newWhitespaces = 0;
        int indent = 0;
        boolean insideTag = false;
        int containedWhitespaces = 0;
        int heightOfLastOpen = 0;
        for (int i = 0; i < response.length(); ++i) {
            int j$iv;
            int j;
            String $this$indexOfFirstNot$iv;
            int j$iv2;
            boolean $i$f$indexOfFirstNot;
            int from$iv;
            Character c;
            int n;
            char currentChar = response.charAt(i);
            Object object = i;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)object).intValue();
            boolean bl3 = false;
            Object object2 = it < response.length() - 1 ? object : null;
            if (object2 != null) {
                object = object2;
                bl = false;
                bl2 = false;
                it = ((Number)object).intValue();
                n = 0;
                c = Character.valueOf(response.charAt(it + 1));
            } else {
                c = null;
            }
            Character nextChar = c;
            if (CharsKt.isWhitespace((char)currentChar)) {
                ++containedWhitespaces;
                continue;
            }
            if (currentChar == '\"' && insideTag) {
                object = response;
                from$iv = i + 1;
                $i$f$indexOfFirstNot = false;
                for (j$iv2 = from$iv; j$iv2 < $this$indexOfFirstNot$iv.length(); ++j$iv2) {
                    n = j$iv2;
                    String str = $this$indexOfFirstNot$iv;
                    boolean bl4 = false;
                    if (!(str.charAt(j) != '\"')) break;
                }
                i = j$iv2;
                continue;
            }
            if (currentChar == '\'' && insideTag) {
                $this$indexOfFirstNot$iv = response;
                from$iv = i + 1;
                $i$f$indexOfFirstNot = false;
                for (j$iv2 = from$iv; j$iv2 < $this$indexOfFirstNot$iv.length(); ++j$iv2) {
                    j = j$iv2;
                    String str = $this$indexOfFirstNot$iv;
                    boolean bl5 = false;
                    if (!(str.charAt(j) != '\'')) break;
                }
                i = j$iv2;
                continue;
            }
            if (StringsKt.startsWith$default((String)response, (String)CDATA_BEGIN, (int)i, (boolean)false, (int)4, null)) {
                $this$indexOfFirstNot$iv = response;
                from$iv = i + CDATA_BEGIN.length();
                $i$f$indexOfFirstNot = false;
                for (j$iv2 = from$iv; j$iv2 < $this$indexOfFirstNot$iv.length(); ++j$iv2) {
                    j = j$iv2;
                    String str = $this$indexOfFirstNot$iv;
                    boolean bl6 = false;
                    if (!(!StringsKt.startsWith$default((String)str, (String)CDATA_END, (int)j, (boolean)false, (int)4, null))) break;
                }
                i = j$iv2 + CDATA_END.length() - 1;
                continue;
            }
            if (currentChar == '<') {
                Character c2 = nextChar;
                if (c2 != null && c2.charValue() == '/') {
                    if (heightOfLastOpen == --indent) continue;
                    newWhitespaces += indent * indentSize + 1;
                    continue;
                }
            }
            if (currentChar == '<') {
                heightOfLastOpen = indent;
                newWhitespaces += indentSize * indent + 1;
                ++indent;
                insideTag = true;
                continue;
            }
            if (currentChar == '/') {
                Character c3 = nextChar;
                if (c3 != null && c3.charValue() == '>') {
                    insideTag = false;
                    --indent;
                    continue;
                }
            }
            if (currentChar == '=' && insideTag) {
                newWhitespaces += spacesAroundEquality ? 3 : 1;
                continue;
            }
            if (currentChar != '>') continue;
            insideTag = false;
            $this$indexOfFirstNot$iv = response;
            boolean $i$f$indexOfFirstNot2 = false;
            for (j$iv = i; j$iv < $this$indexOfFirstNot$iv.length(); ++j$iv) {
                void j2;
                j$iv2 = j$iv;
                String str = $this$indexOfFirstNot$iv;
                boolean bl7 = false;
                if (!(j2 < StringsKt.getLastIndex((CharSequence)str) && str.charAt((int)(j2 + true)) != '<')) break;
            }
            i = j$iv;
        }
        return response.length() - containedWhitespaces + newWhitespaces - (newWhitespaces != 0 ? 1 : 0);
    }

    private static final int indexOfFirstNot(String $this$indexOfFirstNot, int from, Function2<? super String, ? super Integer, Boolean> predicate) {
        int j;
        int $i$f$indexOfFirstNot = 0;
        for (j = from; j < $this$indexOfFirstNot.length() && ((Boolean)predicate.invoke((Object)$this$indexOfFirstNot, (Object)j)).booleanValue(); ++j) {
        }
        return j;
    }

    static /* synthetic */ int indexOfFirstNot$default(String $this$indexOfFirstNot, int from, Function2 predicate, int n, Object object) {
        int j;
        if ((n & 1) != 0) {
            from = 0;
        }
        boolean $i$f$indexOfFirstNot = false;
        for (j = from; j < $this$indexOfFirstNot.length() && ((Boolean)predicate.invoke((Object)$this$indexOfFirstNot, (Object)j)).booleanValue(); ++j) {
        }
        return j;
    }
}

