/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.microservices;

import com.intellij.httpClient.actions.microservices.HttpRequestMicroservicesUtil;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlSpecialSegmentMarker;
import com.intellij.microservices.url.references.PathSegmentHandler;
import com.intellij.microservices.url.references.UrlExtractors;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReferenceInjector;
import com.intellij.microservices.url.references.UrlPksParser;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.SplitEscaper;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class HttpRequestSegmentsReferenceContributor
extends PsiReferenceContributor {
    private static final String PLACEHOLDER = "{{$placeholder}}";
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("\\s*([\\p{Alpha}\\d_-]+)\\s*");
    private static final UrlSpecialSegmentMarker VARIABLE_MARKER = new UrlSpecialSegmentMarker("{{", "}}", VARIABLE_NAME_PATTERN);

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            HttpRequestSegmentsReferenceContributor.$$$reportNull$$$0(0);
        }
        final UrlPathReferenceInjector injector = UrlPathReferenceInjector.forPartialStringFrom((UrlPksParser)HttpRequestSegmentsReferenceContributor.getParser(), o -> new PartiallyKnownString(o.getText(), o, ElementManipulators.getValueTextRange((PsiElement)o))).withDefaultRootContextProviderFactory(psiElement -> {
            UrlPathContext provider = UrlPathContext.supportingSchemes((List)UrlConstants.HTTP_SCHEMES);
            PsiElement httpRequest = psiElement.getParent();
            if (httpRequest instanceof HttpRequest) {
                String method = ((HttpRequest)httpRequest).getHttpMethod();
                provider = provider.withMethod(method);
            }
            return provider;
        }).withPathSegmentHandler(new PathSegmentHandler(){

            @NotNull
            public String render(@NotNull UrlPath.PathSegment segment) {
                if (segment == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = HttpRequestMicroservicesUtil.HTTP_REQUEST_RENDERER.patternMatch(segment);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public List<UrlPath.PathSegment> getExactPrefix(@NotNull UrlPath path) {
                if (path == null) {
                    1.$$$reportNull$$$0(2);
                }
                List list = path.getSegments();
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "segment";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "render";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExactPrefix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "render";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getExactPrefix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        injector.getUrlParser().setShouldHaveScheme(false);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(HttpRequestTarget.class), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = injector.buildFullUrlReference((Object)element, element);
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @NotNull
    private static UrlPksParser getParser() {
        return new UrlPksParser((s, c) -> SplitEscaper.AcceptAll.INSTANCE, s -> HttpRequestSegmentsReferenceContributor.extractSegment(s));
    }

    @NotNull
    private static UrlPath.PathSegment extractSegment(@NotNull String segmentStr) {
        UrlPath.PathSegment placeholder;
        if (segmentStr == null) {
            HttpRequestSegmentsReferenceContributor.$$$reportNull$$$0(1);
        }
        if ((placeholder = UrlExtractors.extractPlaceholder((String)segmentStr, (String)PLACEHOLDER)) != null) {
            UrlPath.PathSegment pathSegment = placeholder;
            if (pathSegment == null) {
                HttpRequestSegmentsReferenceContributor.$$$reportNull$$$0(2);
            }
            return pathSegment;
        }
        UrlPath.PathSegment variables = UrlExtractors.extractPathVariable((String)segmentStr, (UrlSpecialSegmentMarker)VARIABLE_MARKER);
        if (variables != null) {
            UrlPath.PathSegment pathSegment = variables;
            if (pathSegment == null) {
                HttpRequestSegmentsReferenceContributor.$$$reportNull$$$0(3);
            }
            return pathSegment;
        }
        return new UrlPath.PathSegment.Exact(segmentStr);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentStr";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestSegmentsReferenceContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractSegment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractSegment";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

