/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.legacy;

import com.intellij.httpClient.actions.AddHttpRequestAction;
import com.intellij.httpClient.converters.legacy.LegacyRestClientFileToNewAction;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientSerializer;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import icons.RestClientIcons;
import java.io.IOException;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0007H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/converters/legacy/LegacyRestClientFileToNewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiRequest", "", "getName", "attempt", "", "getNonexistentFileName", "directory", "Lcom/intellij/psi/PsiDirectory;", "saveFile", "update", "e", "Companion", "intellij.restClient"})
public final class LegacyRestClientFileToNewAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(Companion.isSingleRestClientRequest(files));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        VirtualFile file2 = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || file2 == null) {
            return;
        }
        try {
            this.saveFile(file2);
            String psiRequest = Companion.convertFileToPsiRequest(file2);
            PsiFile psiFile = this.createFile(project, file2, psiRequest);
            if (psiFile == null) {
                return;
            }
            PsiFile newFile = psiFile;
            OpenFileAction.openFile((VirtualFile)newFile.getVirtualFile(), (Project)project);
        }
        catch (RestClientSerializer.RestClientSerializationException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            AddHttpRequestAction.showErrorBalloon(event, string);
        }
    }

    private final void saveFile(VirtualFile file2) {
        block0: {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
            FileDocumentManager documentManager = fileDocumentManager;
            Document document = documentManager.getDocument(file2);
            if (document == null) break block0;
            Document document2 = document;
            boolean bl = false;
            boolean bl2 = false;
            Document it = document2;
            boolean bl3 = false;
            documentManager.saveDocument(it);
        }
    }

    private final PsiFile createFile(Project project, VirtualFile file2, String psiRequest) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiManager psiManager2 = psiManager;
        PsiFile psiFile = psiManager2.findFile(file2);
        if (psiFile == null || (psiFile = psiFile.getParent()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiManager.findFile(file)?.parent ?: return null");
        PsiFile directory = psiFile;
        String string = this.getNonexistentFileName(file2, (PsiDirectory)directory);
        if (string == null) {
            return null;
        }
        String fileName = string;
        return (PsiFile)WriteCommandAction.writeCommandAction((Project)project).withName(RestClientBundle.message("rest.clien.ui.deprecation.convert.action", new Object[0])).compute(new ThrowableComputable((PsiDirectory)directory, fileName, project, psiRequest){
            final /* synthetic */ PsiDirectory $directory;
            final /* synthetic */ String $fileName;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $psiRequest;

            /*
             * WARNING - void declaration
             */
            public final PsiFile compute() {
                void var1_1;
                block0: {
                    PsiFile psiFile = this.$directory.createFile(this.$fileName);
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"directory.createFile(fileName)");
                    PsiFile resultFile = psiFile;
                    Document document = PsiDocumentManager.getInstance((Project)this.$project).getDocument(resultFile);
                    if (document == null) break block0;
                    document.insertString(0, (CharSequence)this.$psiRequest);
                }
                return var1_1;
            }
            {
                this.$directory = psiDirectory;
                this.$fileName = string;
                this.$project = project;
                this.$psiRequest = string2;
            }
        });
    }

    private final String getNonexistentFileName(VirtualFile file2, PsiDirectory directory) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Object)0, (Function1)getNonexistentFileName.1.INSTANCE), (int)100), (Function1)((Function1)new Function1<Integer, String>(this, file2){
                final /* synthetic */ LegacyRestClientFileToNewAction this$0;
                final /* synthetic */ VirtualFile $file;

                @NotNull
                public final String invoke(int it) {
                    return LegacyRestClientFileToNewAction.access$getName(this.this$0, this.$file, it);
                }
                {
                    this.this$0 = legacyRestClientFileToNewAction;
                    this.$file = virtualFile;
                    super(1);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(directory.findFile(it) == null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final String getName(VirtualFile file2, int attempt) {
        String string = file2.getNameWithoutExtension() + (attempt == 0 ? "" : "" + '-' + attempt);
        HttpRequestFileType httpRequestFileType = HttpRequestFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)httpRequestFileType), (String)"HttpRequestFileType.INSTANCE");
        String string2 = PathUtil.makeFileName((String)string, (String)httpRequestFileType.getDefaultExtension());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PathUtil.makeFileName(\n \u2026ANCE.defaultExtension\n  )");
        return string2;
    }

    public LegacyRestClientFileToNewAction() {
        super((Supplier)1.INSTANCE, (Supplier)2.INSTANCE, RestClientIcons.Http_requests_filetype);
    }

    public static final /* synthetic */ String access$getName(LegacyRestClientFileToNewAction $this, VirtualFile file2, int attempt) {
        return $this.getName(file2, attempt);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001b\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/converters/legacy/LegacyRestClientFileToNewAction$Companion;", "", "()V", "convertFileToPsiRequest", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isSingleRestClientRequest", "", "files", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Z", "intellij.restClient"})
    public static final class Companion {
        public final boolean isSingleRestClientRequest(@Nullable VirtualFile[] files) {
            boolean bl;
            if (files == null || files.length != 1) {
                return false;
            }
            VirtualFile file2 = files[0];
            if (Intrinsics.areEqual((Object)file2.getFileType(), (Object)XmlFileType.INSTANCE) ^ true) {
                return false;
            }
            try {
                XmlFileHeader xmlFileHeader = NanoXmlUtil.parseHeaderWithException((VirtualFile)file2);
                Intrinsics.checkNotNullExpressionValue((Object)xmlFileHeader, (String)"NanoXmlUtil.parseHeaderWithException(file)");
                XmlFileHeader header = xmlFileHeader;
                bl = Intrinsics.areEqual((Object)"RestClientRequest", (Object)header.getRootTagLocalName());
            }
            catch (IOException e) {
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final String convertFileToPsiRequest(@NotNull VirtualFile file2) throws RestClientSerializer.RestClientSerializationException {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            $this$buildString.append("# ");
            $this$buildString.append(file2.getPresentableUrl());
            $this$buildString.append("\n");
            try {
                $this$buildString.append(HttpRequestPsiConverter.toPsiHttpRequest(RestClientSerializer.loadFromFile(file2), null, true));
            }
            catch (ClassCastException e) {
                throw (Throwable)new RestClientSerializer.RestClientSerializationException(RestClientBundle.message("rest.client.ui.xml.file.unknown.error", new Object[0]));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

