/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.en.VariantInfo;
import org.languagetool.rules.en.translation.BeoLingusTranslator;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.rules.translation.Translator;
import org.languagetool.tools.StringTools;

public abstract class AbstractEnglishSpellerRule
extends MorfologikSpellerRule {
    private static final Set<String> lcDoNotSuggestWords = new HashSet<String>(Arrays.asList("asshole", "assholes", "bullshit", "bullshitted", "bullshitter", "bullshitters", "bullshitting", "chickenshit", "chickenshits", "cocksucker", "cocksuckers", "coon", "cunt", "fuck", "fucker", "fuckhead", "fuckheads", "horseshit", "kraut", "krauts", "motherfucker", "motherfuckers", "motherfucking", "nigga", "niggas", "niggaz", "nigger", "niggers", "shit", "shits", "shitfaced", "shithead", "shitheads", "shitload", "shitted", "shitting", "shitty", "wop", "wops", "niggard", "niggardly"));
    private final BeoLingusTranslator translator;
    protected final Map<String, List<String>> topSuggestions;
    protected final Map<String, List<String>> topSuggestionsIgnoreCase;

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null, Collections.emptyList());
    }

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        this(messages, language, null, userConfig, altLanguages, null, null);
    }

    protected List<SuggestedReplacement> filterNoSuggestWords(List<SuggestedReplacement> l) {
        return l.stream().filter(k -> !lcDoNotSuggestWords.contains(k.getReplacement().toLowerCase())).collect(Collectors.toList());
    }

    protected static Map<String, String> loadWordlist(String path, int column) {
        if (column != 0 && column != 1) {
            throw new IllegalArgumentException("Only column 0 and 1 are supported: " + column);
        }
        HashMap<String, String> words = new HashMap<String, String>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] parts = line.split(";");
            if (parts.length != 2) {
                throw new RuntimeException("Unexpected format in " + path + ": " + line + " - expected two parts delimited by ';'");
            }
            words.put(parts[column].toLowerCase(), parts[column == 1 ? 0 : 1]);
        }
        return words;
    }

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, GlobalConfig globalConfig, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel, Language motherTongue) throws IOException {
        super(messages, language, globalConfig, userConfig, altLanguages, languageModel, motherTongue);
        this.ignoreWordsWithLength = 1;
        this.setCheckCompound(true);
        this.addExamplePair(Example.wrong((String)"This <marker>sentenc</marker> contains a spelling mistake."), Example.fixed((String)"This <marker>sentence</marker> contains a spelling mistake."));
        String languageSpecificIgnoreFile = this.getSpellingFileName().replace(".txt", "_" + language.getShortCodeWithCountryAndVariant() + ".txt");
        for (String ignoreWord : this.wordListLoader.loadWords(languageSpecificIgnoreFile)) {
            this.addIgnoreWords(ignoreWord);
        }
        this.translator = BeoLingusTranslator.getInstance(globalConfig);
        this.topSuggestions = AbstractEnglishSpellerRule.getTopSuggestions();
        this.topSuggestionsIgnoreCase = AbstractEnglishSpellerRule.getTopSuggestionsIgnoreCase();
    }

    protected List<SuggestedReplacement> filterSuggestions(List<SuggestedReplacement> suggestions) {
        List result = super.filterSuggestions(suggestions);
        ArrayList<SuggestedReplacement> clean = new ArrayList<SuggestedReplacement>();
        for (SuggestedReplacement suggestion : result) {
            if (suggestion.getReplacement().matches(".* (b|c|d|e|f|g|h|j|k|l|m|n|o|p|q|r|s|t|v|w|y|z|ll|ve)")) continue;
            clean.add(suggestion);
        }
        return clean;
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int idx, AnalyzedTokenReadings[] tokens) throws IOException {
        List ruleMatches = super.getRuleMatches(word, startPos, sentence, ruleMatchesSoFar, idx, tokens);
        if (ruleMatches.size() > 0) {
            IrregularForms forms = this.getIrregularFormsOrNull(word);
            if (forms != null) {
                String message = "Possible spelling mistake. Did you mean <suggestion>" + forms.forms.get(0) + "</suggestion>, the " + forms.formName + " form of the " + forms.posName + " '" + forms.baseform + "'?";
                this.addFormsToFirstMatch(message, sentence, ruleMatches, forms.forms);
            } else {
                VariantInfo variantInfo = this.isValidInOtherVariant(word);
                if (variantInfo != null) {
                    String message = "Possible spelling mistake. '" + word + "' is " + variantInfo.getVariantName() + ".";
                    String suggestion = StringTools.startsWithUppercase((String)word) ? StringTools.uppercaseFirstChar((String)variantInfo.otherVariant()) : variantInfo.otherVariant();
                    this.replaceFormsOfFirstMatch(message, sentence, ruleMatches, suggestion);
                }
            }
        }
        return ruleMatches.stream().map(m -> {
            RuleMatch copy = new RuleMatch(m);
            copy.setLazySuggestedReplacements(() -> AbstractEnglishSpellerRule.cleanSuggestions(m));
            return copy;
        }).collect(Collectors.toList());
    }

    private static List<SuggestedReplacement> cleanSuggestions(RuleMatch ruleMatch) {
        return ruleMatch.getSuggestedReplacementObjects().stream().filter(k -> !k.getReplacement().startsWith("re ") && !k.getReplacement().startsWith("en ") && !k.getReplacement().toLowerCase().startsWith("co ") && !k.getReplacement().toLowerCase().startsWith("de ") && !k.getReplacement().toLowerCase().startsWith("mid ") && !k.getReplacement().toLowerCase().startsWith("non ") && !k.getReplacement().toLowerCase().startsWith("bio ") && !k.getReplacement().toLowerCase().startsWith("bi ") && !k.getReplacement().toLowerCase().startsWith("con ") && !k.getReplacement().startsWith("ins ") && !k.getReplacement().toLowerCase().startsWith("pre ") && !k.getReplacement().toLowerCase().startsWith("inter ") && !k.getReplacement().toLowerCase().startsWith("multi ") && !k.getReplacement().toLowerCase().startsWith("retro ") && !k.getReplacement().toLowerCase().startsWith("extra ") && !k.getReplacement().toLowerCase().startsWith("meta ") && !k.getReplacement().toLowerCase().startsWith("uni ") && !k.getReplacement().toLowerCase().startsWith("anti ") && !k.getReplacement().toLowerCase().startsWith("necro ") && !k.getReplacement().toLowerCase().startsWith("photo ") && !k.getReplacement().toLowerCase().startsWith("post ") && !k.getReplacement().toLowerCase().startsWith("sub ") && !k.getReplacement().toLowerCase().startsWith("auto ") && !k.getReplacement().startsWith("sh ") && !k.getReplacement().startsWith("li ") && !k.getReplacement().startsWith("ha ") && !k.getReplacement().startsWith("st ") && !k.getReplacement().toLowerCase().startsWith("dis ") && !k.getReplacement().toLowerCase().startsWith("mono ") && !k.getReplacement().toLowerCase().startsWith("trans ") && !k.getReplacement().toLowerCase().startsWith("neuro ") && !k.getReplacement().toLowerCase().startsWith("ultra ") && !k.getReplacement().toLowerCase().startsWith("mini ") && !k.getReplacement().toLowerCase().startsWith("hyper ") && !k.getReplacement().toLowerCase().startsWith("micro ") && !k.getReplacement().toLowerCase().startsWith("counter ") && !k.getReplacement().toLowerCase().startsWith("cyber ") && !k.getReplacement().toLowerCase().startsWith("ergo ") && !k.getReplacement().toLowerCase().startsWith("fore ") && !k.getReplacement().toLowerCase().startsWith("geo ") && !k.getReplacement().toLowerCase().startsWith("pseudo ") && !k.getReplacement().toLowerCase().startsWith("psycho ") && !k.getReplacement().toLowerCase().startsWith("nano ") && !k.getReplacement().toLowerCase().startsWith("ans ") && !k.getReplacement().toLowerCase().startsWith("semi ") && !k.getReplacement().toLowerCase().startsWith("infra ") && !k.getReplacement().toLowerCase().startsWith("lo ") && !k.getReplacement().toLowerCase().startsWith("ed ") && !k.getReplacement().toLowerCase().startsWith("ac ") && !k.getReplacement().toLowerCase().startsWith("al ") && !k.getReplacement().toLowerCase().startsWith("mu ") && !k.getReplacement().toLowerCase().startsWith("ma ") && !k.getReplacement().toLowerCase().startsWith("bis ") && !k.getReplacement().toLowerCase().startsWith("k ") && !k.getReplacement().toLowerCase().startsWith("e ") && !k.getReplacement().toLowerCase().startsWith("c ") && !k.getReplacement().toLowerCase().startsWith("v ") && !k.getReplacement().toLowerCase().startsWith("s ") && !k.getReplacement().toLowerCase().startsWith("h ") && !k.getReplacement().toLowerCase().startsWith("r ") && !k.getReplacement().toLowerCase().startsWith("um ") && !k.getReplacement().endsWith(" able") && !k.getReplacement().endsWith(" less") && !k.getReplacement().endsWith(" sly") && !k.getReplacement().endsWith(" OO") && !k.getReplacement().endsWith(" HHH") && !k.getReplacement().endsWith(" ally") && !k.getReplacement().endsWith(" ize") && !k.getReplacement().endsWith(" sh") && !k.getReplacement().endsWith(" st") && !k.getReplacement().endsWith(" ward") && !k.getReplacement().endsWith(" ability") && !k.getReplacement().endsWith(" ting") && !k.getReplacement().endsWith(" ion") && !k.getReplacement().endsWith(" ions") && !k.getReplacement().endsWith(" cal") && !k.getReplacement().endsWith(" ted") && !k.getReplacement().endsWith(" sphere") && !k.getReplacement().endsWith(" ell") && !k.getReplacement().endsWith(" con") && !k.getReplacement().endsWith(" sis") && !k.getReplacement().endsWith(" like") && !k.getReplacement().endsWith(" full") && !k.getReplacement().endsWith(" en") && !k.getReplacement().endsWith(" ed") && !k.getReplacement().endsWith(" al") && !k.getReplacement().endsWith(" ans") && !k.getReplacement().endsWith(" ti") && !k.getReplacement().endsWith(" de") && !k.getReplacement().endsWith(" re") && !k.getReplacement().endsWith(" e") && !k.getReplacement().endsWith(" c") && !k.getReplacement().endsWith(" v") && !k.getReplacement().endsWith(" h") && !k.getReplacement().endsWith(" s") && !k.getReplacement().endsWith(" r") && !k.getReplacement().endsWith(" um") && !k.getReplacement().endsWith(" na") && !k.getReplacement().endsWith(" ma")).collect(Collectors.toList());
    }

    @Nullable
    protected VariantInfo isValidInOtherVariant(String word) {
        return null;
    }

    private void addFormsToFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, List<String> forms) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch((Rule)this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        newMatch.setLazySuggestedReplacements(() -> new ArrayList(Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)forms, SuggestedReplacement::new), (Iterable)oldMatch.getSuggestedReplacementObjects()))));
        ruleMatches.set(0, newMatch);
    }

    private void replaceFormsOfFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, String suggestion) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch((Rule)this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        SuggestedReplacement sugg = new SuggestedReplacement(suggestion);
        sugg.setShortDescription(this.language.getName());
        newMatch.setSuggestedReplacementObjects(Collections.singletonList(sugg));
        ruleMatches.set(0, newMatch);
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word) {
        IrregularForms irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("ed"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("d"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "s", Arrays.asList("s"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "es", Arrays.asList("es"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "er", Arrays.asList("er"), "JJR", "adjective", "comparative");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "est", Arrays.asList("est"), "JJS", "adjective", "superlative");
        return irregularFormsOrNull;
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word, String wordSuffix, List<String> suffixes, String posTag, String posName, String formName) {
        try {
            for (String suffix : suffixes) {
                if (!word.endsWith(wordSuffix)) continue;
                String baseForm = word.substring(0, word.length() - suffix.length());
                String[] forms = Objects.requireNonNull(this.language.getSynthesizer()).synthesize(new AnalyzedToken(word, null, baseForm), posTag);
                ArrayList<String> result = new ArrayList<String>();
                for (String form : forms) {
                    if (this.speller1.isMisspelled(form)) continue;
                    result.add(form);
                }
                result.remove(word);
                result.remove("badder");
                result.remove("baddest");
                result.remove("spake");
                if (result.size() <= 0) continue;
                return new IrregularForms(baseForm, posName, formName, result);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Map<String, List<String>> getTopSuggestionsIgnoreCase() {
        HashMap<String, List<String>> s = new HashMap<String, List<String>>();
        s.put("json", Arrays.asList("Jason"));
        s.put("bmps", Arrays.asList("BMPs"));
        s.put("ppts", Arrays.asList("PPTs"));
        s.put("italia", Arrays.asList("Italy"));
        s.put("copenhague", Arrays.asList("Copenhagen"));
        s.put("applepay", Arrays.asList("Apple Pay"));
        s.put("&&", Arrays.asList("&"));
        s.put("wensday", Arrays.asList("Wednesday"));
        s.put("interweb", Arrays.asList("internet"));
        s.put("interwebs", Arrays.asList("internet"));
        s.put("srilanka", Arrays.asList("Sri Lanka"));
        s.put("pcs", Arrays.asList("PCs"));
        s.put("oconnor", Arrays.asList("O'Connor"));
        s.put("oconor", Arrays.asList("O'Conor"));
        s.put("obrien", Arrays.asList("O'Brien"));
        s.put("odonnell", Arrays.asList("O'Donnell"));
        s.put("oneill", Arrays.asList("O'Neill"));
        s.put("oneil", Arrays.asList("O'Neil"));
        s.put("oconnell", Arrays.asList("O'Connell"));
        s.put("todo", Arrays.asList("To-do", "To do"));
        s.put("todos", Arrays.asList("To-dos"));
        s.put("elearning", Arrays.asList("e-learning"));
        s.put("g-mail", Arrays.asList("Gmail"));
        s.put("playstation", Arrays.asList("PlayStation"));
        s.put("iam", Arrays.asList("I am", "I'm"));
        s.put("kpop", Arrays.asList("K-pop"));
        s.put("trumpian", Arrays.asList("Trumpist"));
        s.put("trumpians", Arrays.asList("Trumpists"));
        return s;
    }

    protected static Map<String, List<String>> getTopSuggestions() {
        HashMap<String, List<String>> s = new HashMap<String, List<String>>();
        s.put("hiphop", Arrays.asList("hip-hop"));
        s.put("Hiphop", Arrays.asList("Hip-hop", "Hip-Hop"));
        s.put("ap", Arrays.asList("app", "up", "AP"));
        s.put("Ap", Arrays.asList("App", "Up", "AP"));
        s.put("aps", Arrays.asList("apps"));
        s.put("Aps", Arrays.asList("Apps"));
        s.put("hehe", Arrays.asList("he-he"));
        s.put("Hehe", Arrays.asList("He-he"));
        s.put("defacto", Arrays.asList("de facto"));
        s.put("Defacto", Arrays.asList("De facto"));
        s.put("differently-abled", Arrays.asList("differently abled"));
        s.put("Differently-abled", Arrays.asList("Differently abled"));
        s.put("data-uri", Arrays.asList("data URI"));
        s.put("Ppl", Arrays.asList("People"));
        s.put("Si", Arrays.asList("Is"));
        s.put("si", Arrays.asList("is"));
        s.put("pcs", Arrays.asList("PCs"));
        s.put("constits", Arrays.asList("consists"));
        s.put("ect", Arrays.asList("etc"));
        s.put("fastly", Arrays.asList("fast"));
        s.put("carrie", Arrays.asList("carry"));
        s.put("bare-bone", Arrays.asList("bare-bones", "bare-boned"));
        s.put("Bare-bone", Arrays.asList("Bare-bones", "Bare-boned"));
        s.put("mae", Arrays.asList("make", "MAE", "may", "May", "man"));
        s.put("transportion", Arrays.asList("transportation"));
        s.put("Transportion", Arrays.asList("Transportation"));
        s.put("presention", Arrays.asList("presentation"));
        s.put("Presention", Arrays.asList("Presentation"));
        s.put("presension", Arrays.asList("presentation"));
        s.put("Presension", Arrays.asList("Presentation"));
        s.put("realtime", Arrays.asList("real-time"));
        s.put("Realtime", Arrays.asList("Real-time"));
        s.put("morphium", Arrays.asList("morphine"));
        s.put("Morphium", Arrays.asList("Morphine"));
        s.put("morphiums", Arrays.asList("morphines"));
        s.put("Morphiums", Arrays.asList("Morphines"));
        s.put("approvement", Arrays.asList("approval"));
        s.put("Approvement", Arrays.asList("Approval"));
        s.put("approvements", Arrays.asList("approvals"));
        s.put("Approvements", Arrays.asList("Approvals"));
        s.put("ciggarets", Arrays.asList("cigarettes"));
        s.put("Ciggarets", Arrays.asList("Cigarettes"));
        s.put("pro-bono", Arrays.asList("pro bono"));
        s.put("Pro-bono", Arrays.asList("Pro bono"));
        s.put("probono", Arrays.asList("pro bono"));
        s.put("Probono", Arrays.asList("Pro bono"));
        s.put("pro-rata", Arrays.asList("pro rata"));
        s.put("Pro-rata", Arrays.asList("Pro rata"));
        s.put("prorata", Arrays.asList("pro rata"));
        s.put("Prorata", Arrays.asList("Pro rata"));
        s.put("electronical", Arrays.asList("electronic", "electronically"));
        s.put("Electronical", Arrays.asList("Electronic", "Electronically"));
        s.put("unpolite", Arrays.asList("impolite"));
        s.put("armys", Arrays.asList("armies"));
        s.put("Armys", Arrays.asList("Armies"));
        s.put("tarrif", Arrays.asList("tariff"));
        s.put("Tarrif", Arrays.asList("Tariff"));
        s.put("tarrifs", Arrays.asList("tariffs"));
        s.put("Tarrifs", Arrays.asList("Tariffs"));
        s.put("techy", Arrays.asList("techie"));
        s.put("Techy", Arrays.asList("Techie"));
        s.put("techys", Arrays.asList("techies"));
        s.put("Techys", Arrays.asList("Techies"));
        s.put("non-techy", Arrays.asList("non-techie"));
        s.put("pharmasuitable", Arrays.asList("pharmaceutical"));
        s.put("storie", Arrays.asList("story", "store", "stories"));
        s.put("Storie", Arrays.asList("Story", "Store", "Stories"));
        s.put("ensuite", Arrays.asList("en suite"));
        s.put("Ensuite", Arrays.asList("En suite"));
        s.put("insite", Arrays.asList("insight"));
        s.put("insites", Arrays.asList("insights"));
        s.put("Insite", Arrays.asList("Insight"));
        s.put("Insites", Arrays.asList("Insights"));
        s.put("thouraly", Arrays.asList("thoroughly"));
        s.put("heiaracky", Arrays.asList("hierarchy"));
        s.put("on-prem", Arrays.asList("on-premise"));
        s.put("sin-off", Arrays.asList("sign-off"));
        s.put("sin-offs", Arrays.asList("sign-offs"));
        s.put("Sin-off", Arrays.asList("Sign-off"));
        s.put("Sin-offs", Arrays.asList("Sign-offs"));
        s.put("Alot", Arrays.asList("A lot"));
        s.put("alot", Arrays.asList("a lot"));
        s.put("DDOS", Arrays.asList("DDoS"));
        s.put("disencouraged", Arrays.asList("discouraged"));
        s.put("Disencouraged", Arrays.asList("Discouraged"));
        s.put("async", Arrays.asList("asynchronous", "asynchronously"));
        s.put("Async", Arrays.asList("Asynchronous", "Asynchronously"));
        s.put("endevours", Arrays.asList("endeavours"));
        s.put("endevors", Arrays.asList("endeavors"));
        s.put("endevour", Arrays.asList("endeavour"));
        s.put("endevor", Arrays.asList("endeavor"));
        s.put("industrys", Arrays.asList("industries", "industry's", "industry"));
        s.put("Industrys", Arrays.asList("Industries", "Industry's", "Industry"));
        s.put("partys", Arrays.asList("parties", "party's", "party"));
        s.put("Partys", Arrays.asList("Parties", "Party's", "Party"));
        s.put("countrys", Arrays.asList("countries", "country's", "country"));
        s.put("Countrys", Arrays.asList("Countries", "Country's", "Country"));
        s.put("bodys", Arrays.asList("bodies", "body's", "body"));
        s.put("Bodys", Arrays.asList("Bodies", "Body's", "Body"));
        s.put("ladys", Arrays.asList("ladies", "lady's", "lady"));
        s.put("Ladys", Arrays.asList("Ladies", "Lady's", "Lady"));
        s.put("citys", Arrays.asList("cities", "city's", "city"));
        s.put("Citys", Arrays.asList("Cities", "City's", "City"));
        s.put("batterys", Arrays.asList("batteries", "battery's", "battery"));
        s.put("Batterys", Arrays.asList("Batteries", "Battery's", "Battery"));
        s.put("technologys", Arrays.asList("technologies", "technology's", "technology"));
        s.put("Technologys", Arrays.asList("Technologies", "Technology's", "Technology"));
        s.put("childrens", Arrays.asList("children's", "children"));
        s.put("Childrens", Arrays.asList("Children's", "Children"));
        s.put("countys", Arrays.asList("counties", "county's", "county"));
        s.put("Countys", Arrays.asList("Counties", "County's", "County"));
        s.put("familys", Arrays.asList("families", "family's", "family"));
        s.put("Familys", Arrays.asList("Families", "Family's", "Family"));
        s.put("dieing", Arrays.asList("dying"));
        s.put("Dieing", Arrays.asList("Dying"));
        s.put("dem", Arrays.asList("them"));
        s.put("Dem", Arrays.asList("Them"));
        s.put("infact", Arrays.asList("in fact"));
        s.put("Infact", Arrays.asList("In fact"));
        s.put("ad-hoc", Arrays.asList("ad hoc"));
        s.put("adhoc", Arrays.asList("ad hoc"));
        s.put("Ad-hoc", Arrays.asList("Ad hoc"));
        s.put("Adhoc", Arrays.asList("Ad hoc"));
        s.put("ad-on", Arrays.asList("add-on"));
        s.put("add-o", Arrays.asList("add-on"));
        s.put("acc", Arrays.asList("account", "accusative"));
        s.put("Acc", Arrays.asList("Account", "Accusative"));
        s.put("\u00baC", Arrays.asList("\u00b0C"));
        s.put("jus", Arrays.asList("just", "juice"));
        s.put("Jus", Arrays.asList("Just", "Juice"));
        s.put("sayed", Arrays.asList("said"));
        s.put("sess", Arrays.asList("says", "session", "cess"));
        s.put("Addon", Arrays.asList("Add-on"));
        s.put("Addons", Arrays.asList("Add-ons"));
        s.put("ios", Arrays.asList("iOS"));
        s.put("yrs", Arrays.asList("years"));
        s.put("standup", Arrays.asList("stand-up"));
        s.put("standups", Arrays.asList("stand-ups"));
        s.put("Standup", Arrays.asList("Stand-up"));
        s.put("Standups", Arrays.asList("Stand-ups"));
        s.put("Playdough", Arrays.asList("Play-Doh"));
        s.put("playdough", Arrays.asList("Play-Doh"));
        s.put("biggy", Arrays.asList("biggie"));
        s.put("lieing", Arrays.asList("lying"));
        s.put("preffered", Arrays.asList("preferred"));
        s.put("preffering", Arrays.asList("preferring"));
        s.put("reffered", Arrays.asList("referred"));
        s.put("reffering", Arrays.asList("referring"));
        s.put("passthrough", Arrays.asList("pass-through"));
        s.put("&&", Arrays.asList("&"));
        s.put("cmon", Arrays.asList("c'mon"));
        s.put("Cmon", Arrays.asList("C'mon"));
        s.put("da", Arrays.asList("the"));
        s.put("Da", Arrays.asList("The"));
        s.put("Vue", Arrays.asList("Vue.JS"));
        s.put("errornous", Arrays.asList("erroneous"));
        s.put("brang", Arrays.asList("brought"));
        s.put("brung", Arrays.asList("brought"));
        s.put("thru", Arrays.asList("through"));
        s.put("pitty", Arrays.asList("pity"));
        s.put("barbwire", Arrays.asList("barbed wire"));
        s.put("barbwires", Arrays.asList("barbed wires"));
        s.put("monkie", Arrays.asList("monkey"));
        s.put("Monkie", Arrays.asList("Monkey"));
        s.put("monkies", Arrays.asList("monkeys"));
        s.put("Monkies", Arrays.asList("Monkeys"));
        s.put("Daddys", Arrays.asList("Daddy's", "Daddies"));
        s.put("Mommys", Arrays.asList("Mommy's", "Mommies"));
        s.put("daddys", Arrays.asList("daddy's", "daddies"));
        s.put("mommys", Arrays.asList("mommy's", "mommies"));
        s.put("speach", Arrays.asList("speech"));
        s.put("icecreem", Arrays.asList("ice cream"));
        s.put("math", Arrays.asList("maths"));
        s.put("fora", Arrays.asList("for a"));
        s.put("fomr", Arrays.asList("form", "from"));
        s.put("lotsa", Arrays.asList("lots of"));
        s.put("tryna", Arrays.asList("trying to"));
        s.put("coulda", Arrays.asList("could have"));
        s.put("shoulda", Arrays.asList("should have"));
        s.put("woulda", Arrays.asList("would have"));
        s.put("tellem", Arrays.asList("tell them"));
        s.put("Tellem", Arrays.asList("Tell them"));
        s.put("Webex", Arrays.asList("WebEx"));
        s.put("didint", Arrays.asList("didn't"));
        s.put("Didint", Arrays.asList("Didn't"));
        s.put("wasint", Arrays.asList("wasn't"));
        s.put("hasint", Arrays.asList("hasn't"));
        s.put("doesint", Arrays.asList("doesn't"));
        s.put("ist", Arrays.asList("is"));
        s.put("Boing", Arrays.asList("Boeing"));
        s.put("te", Arrays.asList("the"));
        s.put("todays", Arrays.asList("today's"));
        s.put("Todays", Arrays.asList("Today's"));
        s.put("todo", Arrays.asList("to-do", "to do"));
        s.put("todos", Arrays.asList("to-dos", "to do"));
        s.put("heres", Arrays.asList("here's"));
        s.put("Heres", Arrays.asList("Here's"));
        s.put("aways", Arrays.asList("always"));
        s.put("McDonalds", Arrays.asList("McDonald's"));
        s.put("ux", Arrays.asList("UX"));
        s.put("ive", Arrays.asList("I've"));
        s.put("infos", Arrays.asList("informations"));
        s.put("Infos", Arrays.asList("Informations"));
        s.put("prios", Arrays.asList("priorities"));
        s.put("Prio", Arrays.asList("Priority"));
        s.put("prio", Arrays.asList("priority"));
        s.put("Ecommerce", Arrays.asList("E-Commerce"));
        s.put("ezine", Arrays.asList("e-zine"));
        s.put("Ezine", Arrays.asList("E-zine"));
        s.put("ezines", Arrays.asList("e-zines"));
        s.put("Ezines", Arrays.asList("E-zines"));
        s.put("ebook", Arrays.asList("e-book"));
        s.put("ebooks", Arrays.asList("e-books"));
        s.put("eBook", Arrays.asList("e-book"));
        s.put("eBooks", Arrays.asList("e-books"));
        s.put("Ebook", Arrays.asList("E-Book"));
        s.put("Ebooks", Arrays.asList("E-Books"));
        s.put("Esport", Arrays.asList("E-Sport"));
        s.put("Esports", Arrays.asList("E-Sports"));
        s.put("R&B", Arrays.asList("R & B", "R 'n' B"));
        s.put("ie", Arrays.asList("i.e."));
        s.put("eg", Arrays.asList("e.g."));
        s.put("ppl", Arrays.asList("people"));
        s.put("kiddin", Arrays.asList("kidding"));
        s.put("doin", Arrays.asList("doing"));
        s.put("nothin", Arrays.asList("nothing"));
        s.put("SPOC", Arrays.asList("SpOC"));
        s.put("Thx", Arrays.asList("Thanks"));
        s.put("thx", Arrays.asList("thanks"));
        s.put("ty", Arrays.asList("thank you", "thanks"));
        s.put("Sry", Arrays.asList("Sorry"));
        s.put("sry", Arrays.asList("sorry"));
        s.put("im", Arrays.asList("I'm"));
        s.put("spoilt", Arrays.asList("spoiled"));
        s.put("Lil", Arrays.asList("Little"));
        s.put("lil", Arrays.asList("little"));
        s.put("gmail", Arrays.asList("Gmail"));
        s.put("Sucka", Arrays.asList("Sucker"));
        s.put("sucka", Arrays.asList("sucker"));
        s.put("whaddya", Arrays.asList("what are you", "what do you"));
        s.put("Whaddya", Arrays.asList("What are you", "What do you"));
        s.put("sinc", Arrays.asList("sync"));
        s.put("sweety", Arrays.asList("sweetie"));
        s.put("sweetys", Arrays.asList("sweeties"));
        s.put("sowwy", Arrays.asList("sorry"));
        s.put("Sowwy", Arrays.asList("Sorry"));
        s.put("grandmum", Arrays.asList("grandma", "grandmother"));
        s.put("grandmom", Arrays.asList("grandma", "grandmother"));
        s.put("Grandmum", Arrays.asList("Grandma", "Grandmother"));
        s.put("Grandmom", Arrays.asList("Grandma", "Grandmother"));
        s.put("Hongkong", Arrays.asList("Hong Kong"));
        s.put("enlighting", Arrays.asList("enlightening"));
        s.put("Enlighting", Arrays.asList("Enlightening"));
        s.put("center", Arrays.asList("centre"));
        s.put("ur", Arrays.asList("your", "you are"));
        s.put("Ur", Arrays.asList("Your", "You are"));
        s.put("ure", Arrays.asList("your", "you are"));
        s.put("Ure", Arrays.asList("Your", "You are"));
        s.put("mins", Arrays.asList("minutes", "min"));
        s.put("geo", Arrays.asList("geography"));
        s.put("Geo", Arrays.asList("Geography"));
        s.put("addon", Arrays.asList("add-on"));
        s.put("addons", Arrays.asList("add-ons"));
        s.put("afterparty", Arrays.asList("after-party"));
        s.put("Afterparty", Arrays.asList("After-party"));
        s.put("wellbeing", Arrays.asList("well-being"));
        s.put("cuz", Arrays.asList("because"));
        s.put("Cuz", Arrays.asList("Because"));
        s.put("coz", Arrays.asList("because"));
        s.put("Coz", Arrays.asList("Because"));
        s.put("pls", Arrays.asList("please"));
        s.put("Pls", Arrays.asList("Please"));
        s.put("plz", Arrays.asList("please"));
        s.put("Plz", Arrays.asList("Please"));
        s.put("addendums", Arrays.asList("addenda"));
        s.put("algas", Arrays.asList("algae"));
        s.put("alumnas", Arrays.asList("alumnae"));
        s.put("alumnuses", Arrays.asList("alumni"));
        s.put("analysises", Arrays.asList("analyses"));
        s.put("appendixs", Arrays.asList("appendices"));
        s.put("axises", Arrays.asList("axes"));
        s.put("bacilluses", Arrays.asList("bacilli"));
        s.put("bacteriums", Arrays.asList("bacteria"));
        s.put("basises", Arrays.asList("bases"));
        s.put("beaus", Arrays.asList("beaux"));
        s.put("bisons", Arrays.asList("bison"));
        s.put("buffalos", Arrays.asList("buffaloes"));
        s.put("calfs", Arrays.asList("calves"));
        s.put("Childs", Arrays.asList("Children", "Child's"));
        s.put("childs", Arrays.asList("children", "child's"));
        s.put("crisises", Arrays.asList("crises"));
        s.put("criterions", Arrays.asList("criteria"));
        s.put("curriculums", Arrays.asList("curricula"));
        s.put("datums", Arrays.asList("data"));
        s.put("deers", Arrays.asList("deer"));
        s.put("diagnosises", Arrays.asList("diagnoses"));
        s.put("echos", Arrays.asList("echoes"));
        s.put("elfs", Arrays.asList("elves"));
        s.put("ellipsises", Arrays.asList("ellipses"));
        s.put("embargos", Arrays.asList("embargoes"));
        s.put("erratums", Arrays.asList("errata"));
        s.put("firemans", Arrays.asList("firemen"));
        s.put("fishs", Arrays.asList("fishes", "fish"));
        s.put("genuses", Arrays.asList("genera"));
        s.put("gooses", Arrays.asList("geese"));
        s.put("halfs", Arrays.asList("halves"));
        s.put("heros", Arrays.asList("heroes"));
        s.put("indexs", Arrays.asList("indices", "indexes"));
        s.put("lifes", Arrays.asList("lives"));
        s.put("mans", Arrays.asList("men", "man's"));
        s.put("mens", Arrays.asList("men", "men's"));
        s.put("matrixs", Arrays.asList("matrices"));
        s.put("meanses", Arrays.asList("means"));
        s.put("mediums", Arrays.asList("media"));
        s.put("memorandums", Arrays.asList("memoranda"));
        s.put("mooses", Arrays.asList("moose"));
        s.put("mosquitos", Arrays.asList("mosquitoes"));
        s.put("moskitos", Arrays.asList("mosquitoes"));
        s.put("moskito", Arrays.asList("mosquito"));
        s.put("neurosises", Arrays.asList("neuroses"));
        s.put("nucleuses", Arrays.asList("nuclei"));
        s.put("oasises", Arrays.asList("oases"));
        s.put("ovums", Arrays.asList("ova"));
        s.put("oxs", Arrays.asList("oxen"));
        s.put("oxes", Arrays.asList("oxen"));
        s.put("paralysises", Arrays.asList("paralyses"));
        s.put("potatos", Arrays.asList("potatoes"));
        s.put("radiuses", Arrays.asList("radii"));
        s.put("selfs", Arrays.asList("selves"));
        s.put("serieses", Arrays.asList("series"));
        s.put("sheeps", Arrays.asList("sheep"));
        s.put("shelfs", Arrays.asList("shelves"));
        s.put("scissorses", Arrays.asList("scissors"));
        s.put("specieses", Arrays.asList("species"));
        s.put("stimuluses", Arrays.asList("stimuli"));
        s.put("stratums", Arrays.asList("strata"));
        s.put("tableaus", Arrays.asList("tableaux"));
        s.put("thats", Arrays.asList("those"));
        s.put("thesises", Arrays.asList("theses"));
        s.put("thiefs", Arrays.asList("thieves"));
        s.put("thises", Arrays.asList("these"));
        s.put("tomatos", Arrays.asList("tomatoes"));
        s.put("tooths", Arrays.asList("teeth"));
        s.put("torpedos", Arrays.asList("torpedoes"));
        s.put("vertebras", Arrays.asList("vertebrae"));
        s.put("vetos", Arrays.asList("vetoes"));
        s.put("vitas", Arrays.asList("vitae"));
        s.put("watchs", Arrays.asList("watches"));
        s.put("wifes", Arrays.asList("wives", "wife's"));
        s.put("womans", Arrays.asList("women", "woman's"));
        s.put("Womans", Arrays.asList("Women", "Woman's"));
        s.put("womens", Arrays.asList("women's"));
        s.put("Womens", Arrays.asList("Women's"));
        s.put("deauthorized", Arrays.asList("unauthorized"));
        s.put("tippy-top", Arrays.asList("tip-top", "top most"));
        s.put("tippytop", Arrays.asList("tip-top", "top most"));
        s.put("imma", Arrays.asList("I'm going to", "I'm a"));
        s.put("Imma", Arrays.asList("I'm going to", "I'm a"));
        s.put("dontcha", Arrays.asList("don't you"));
        s.put("tobe", Arrays.asList("to be"));
        s.put("Gi", Arrays.asList("Hi"));
        s.put("Ji", Arrays.asList("Hi"));
        s.put("Dontcha", Arrays.asList("don't you"));
        s.put("greatfruit", Arrays.asList("grapefruit", "great fruit"));
        s.put("Insta", Arrays.asList("Instagram"));
        s.put("IO", Arrays.asList("I/O"));
        s.put("wierd", Arrays.asList("weird"));
        s.put("Wierd", Arrays.asList("Weird"));
        s.put("hiphop", Arrays.asList("hip-hop"));
        s.put("HipHop", Arrays.asList("Hip-Hop"));
        s.put("gove", Arrays.asList("love", "give", "gave", "move"));
        s.put("birdseye", Arrays.asList("bird's-eye"));
        s.put("Birdseye", Arrays.asList("Bird's-eye"));
        s.put("al", Arrays.asList("all", "Al"));
        s.put("publically", Arrays.asList("publicly"));
        s.put("fo", Arrays.asList("for"));
        s.put("shawty", Arrays.asList("shorty"));
        s.put("Shawty", Arrays.asList("Shorty"));
        s.put("savy", Arrays.asList("savvy"));
        s.put("Savy", Arrays.asList("Savvy"));
        s.put("automization", Arrays.asList("automatization"));
        s.put("automisation", Arrays.asList("automatisation"));
        s.put("Automization", Arrays.asList("Automatization"));
        s.put("Automisation", Arrays.asList("Automatisation"));
        s.put("aswell", Arrays.asList("as well"));
        s.put("Continuesly", Arrays.asList("Continuously"));
        s.put("continuesly", Arrays.asList("continuously"));
        s.put("humain", Arrays.asList("humane", "human"));
        s.put("protene", Arrays.asList("protein"));
        s.put("throught", Arrays.asList("thought", "through", "throat"));
        s.put("specifity", Arrays.asList("specificity"));
        s.put("specicity", Arrays.asList("specificity"));
        s.put("Specifity", Arrays.asList("Specificity"));
        s.put("Specicity", Arrays.asList("Specificity"));
        s.put("specifities", Arrays.asList("specificities"));
        s.put("specicities", Arrays.asList("specificities"));
        s.put("Specifities", Arrays.asList("Specificities"));
        s.put("Specicities", Arrays.asList("Specificities"));
        s.put("Neonazi", Arrays.asList("Neo-Nazi"));
        s.put("Neonazis", Arrays.asList("Neo-Nazis"));
        s.put("neonazi", Arrays.asList("neo-Nazi"));
        s.put("neonazis", Arrays.asList("neo-Nazis"));
        s.put("fiveteen", Arrays.asList("fifteen"));
        s.put("Fiveteen", Arrays.asList("Fifteen"));
        s.put("critism", Arrays.asList("criticism"));
        s.put("Critism", Arrays.asList("Criticism"));
        s.put("Hobbie", Arrays.asList("Hobby"));
        s.put("hobbie", Arrays.asList("hobby"));
        s.put("Hobbys", Arrays.asList("Hobbies"));
        s.put("hobbys", Arrays.asList("hobbies"));
        s.put("Copie", Arrays.asList("Copy"));
        s.put("Copys", Arrays.asList("Copies"));
        s.put("copie", Arrays.asList("copy"));
        s.put("copys", Arrays.asList("copies"));
        s.put("rideshare", Arrays.asList("ride-share"));
        s.put("Rideshare", Arrays.asList("Ride-share"));
        s.put("Rideshares", Arrays.asList("Ride-shares"));
        s.put("bonafide", Arrays.asList("bona fide"));
        s.put("Bonafide", Arrays.asList("Bona fide"));
        s.put("dropoff", Arrays.asList("drop-off"));
        s.put("Dropoff", Arrays.asList("Drop-off"));
        s.put("reportings", Arrays.asList("reports", "reporting"));
        s.put("Reportings", Arrays.asList("Reports", "Reporting"));
        s.put("luv", Arrays.asList("love"));
        s.put("luvs", Arrays.asList("loves"));
        s.put("Luv", Arrays.asList("Love"));
        s.put("Luvs", Arrays.asList("Loves"));
        s.put("islam", Arrays.asList("Islam"));
        s.put("wud", Arrays.asList("what", "mud", "bud"));
        s.put("Wud", Arrays.asList("What", "Mud", "Bud"));
        s.put("fablet", Arrays.asList("phablet", "tablet"));
        s.put("Fablet", Arrays.asList("Phablet", "Tablet"));
        s.put("companys", Arrays.asList("companies", "company's", "company"));
        s.put("Companys", Arrays.asList("Companies", "Company's", "Company"));
        s.put("unencode", Arrays.asList("decode"));
        s.put("unencodes", Arrays.asList("decodes"));
        s.put("unencoded", Arrays.asList("decoded"));
        s.put("unencoding", Arrays.asList("decoding"));
        s.put("cheq", Arrays.asList("check"));
        s.put("southwest", Arrays.asList("south-west"));
        s.put("southeast", Arrays.asList("south-east"));
        s.put("northwest", Arrays.asList("north-west"));
        s.put("northeast", Arrays.asList("north-east"));
        s.put("Marylin", Arrays.asList("Marilyn"));
        s.put("blest", Arrays.asList("blessed"));
        s.put("yeld", Arrays.asList("yelled"));
        s.put("os", Arrays.asList("OS", "is", "so"));
        s.put("abel", Arrays.asList("able"));
        return s;
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        String suggestion;
        ArrayList curatedSuggestions = new ArrayList();
        curatedSuggestions.addAll(this.topSuggestions.getOrDefault(word, Collections.emptyList()));
        curatedSuggestions.addAll(this.topSuggestionsIgnoreCase.getOrDefault(word.toLowerCase(), Collections.emptyList()));
        if (!curatedSuggestions.isEmpty()) {
            return SuggestedReplacement.convert(curatedSuggestions);
        }
        if (word.endsWith("ys") && !this.speller1.isMisspelled(suggestion = word.replaceFirst("ys$", "ies"))) {
            return SuggestedReplacement.convert(Arrays.asList(suggestion));
        }
        return super.getAdditionalTopSuggestions(suggestions, word);
    }

    protected Translator getTranslator(GlobalConfig globalConfig) {
        return this.translator;
    }

    protected boolean tokenizeNewWords() {
        return false;
    }

    private static class IrregularForms {
        final String baseform;
        final String posName;
        final String formName;
        final List<String> forms;

        private IrregularForms(String baseform, String posName, String formName, List<String> forms) {
            this.baseform = baseform;
            this.posName = posName;
            this.formName = formName;
            this.forms = forms;
        }
    }
}

