/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.RefCountingRecordsTable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RefCountingContentStorage
extends AbstractStorage {
    private final Map<Integer, Future<?>> myPendingWriteRequests;
    private int myPendingWriteRequestsSize;
    private final ExecutorService myWriteRequestExecutor;
    private final boolean myUseContentHashes;
    private final boolean myDoNotZipCaches;
    private static final int MAX_PENDING_WRITE_SIZE = 0x1400000;

    public RefCountingContentStorage(@NotNull Path path, @Nullable CapacityAllocationPolicy capacityAllocationPolicy, @NotNull ExecutorService writeRequestExecutor, boolean doNotZipCaches, boolean useContentHashes) throws IOException {
        if (path == null) {
            RefCountingContentStorage.$$$reportNull$$$0(0);
        }
        if (writeRequestExecutor == null) {
            RefCountingContentStorage.$$$reportNull$$$0(1);
        }
        super(path, capacityAllocationPolicy);
        this.myPendingWriteRequests = new ConcurrentHashMap();
        this.myDoNotZipCaches = doNotZipCaches;
        this.myWriteRequestExecutor = writeRequestExecutor;
        this.myUseContentHashes = useContentHashes;
    }

    @Override
    protected void doDeleteRecord(int record) throws IOException {
        if (this.myUseContentHashes) {
            throw new UnsupportedEncodingException("Records can't be released completely with enabled content hashes support");
        }
        super.doDeleteRecord(record);
    }

    @Override
    public DataInputStream readStream(int record) throws IOException {
        if (this.myDoNotZipCaches) {
            return super.readStream(record);
        }
        BufferExposingByteArrayOutputStream stream = this.internalReadStream(record);
        return new DataInputStream(stream.toInputStream());
    }

    @Override
    protected byte[] readBytes(int record) throws IOException {
        if (this.myDoNotZipCaches) {
            return super.readBytes(record);
        }
        return this.internalReadStream(record).toByteArray();
    }

    private BufferExposingByteArrayOutputStream internalReadStream(int record) throws IOException {
        this.waitForPendingWriteForRecord(record);
        byte[] result = this.withReadLock(() -> super.readBytes(record));
        try (CustomInflaterInputStream in = new CustomInflaterInputStream(result);){
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream();
            StreamUtil.copy(in, outputStream);
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = outputStream;
            return bufferExposingByteArrayOutputStream;
        }
    }

    private void waitForPendingWriteForRecord(int record) {
        Future<?> future = this.myPendingWriteRequests.get(record);
        if (future != null) {
            try {
                future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void appendBytes(int record, ByteArraySequence bytes) {
        throw new IncorrectOperationException("Appending is not supported");
    }

    @Override
    public void writeBytes(int record, ByteArraySequence bytes, boolean fixedSize) throws IOException {
        if (this.myDoNotZipCaches) {
            super.writeBytes(record, bytes, fixedSize);
            return;
        }
        this.waitForPendingWriteForRecord(record);
        this.withWriteLock(() -> {
            this.myPendingWriteRequestsSize += bytes.getLength();
            if (this.myPendingWriteRequestsSize > 0x1400000) {
                this.zipAndWrite(bytes, record, fixedSize);
            } else {
                this.myPendingWriteRequests.put(record, this.myWriteRequestExecutor.submit(() -> {
                    this.zipAndWrite(bytes, record, fixedSize);
                    return null;
                }));
            }
        });
    }

    private void zipAndWrite(ByteArraySequence bytes, int record, boolean fixedSize) throws IOException {
        BufferExposingByteArrayOutputStream s = new BufferExposingByteArrayOutputStream();
        try (DeflaterOutputStream out = new DeflaterOutputStream(s);){
            out.write(bytes.getInternalBuffer(), bytes.getOffset(), bytes.getLength());
        }
        this.withWriteLock(() -> {
            this.doWrite(record, fixedSize, s);
            this.myPendingWriteRequestsSize -= bytes.getLength();
            this.myPendingWriteRequests.remove(record);
        });
    }

    private void doWrite(int record, boolean fixedSize, BufferExposingByteArrayOutputStream s) throws IOException {
        super.writeBytes(record, s.toByteArraySequence(), fixedSize);
    }

    @Override
    protected AbstractRecordsTable createRecordsTable(PagePool pool, @NotNull Path recordsFile) throws IOException {
        if (recordsFile == null) {
            RefCountingContentStorage.$$$reportNull$$$0(2);
        }
        return new RefCountingRecordsTable(recordsFile, pool);
    }

    public int acquireNewRecord() throws IOException {
        return this.withWriteLock(() -> {
            int record = this.myRecordsTable.createNewRecord();
            ((RefCountingRecordsTable)this.myRecordsTable).incRefCount(record);
            return record;
        });
    }

    public int getRecordsCount() throws IOException {
        return this.myRecordsTable.getRecordsCount();
    }

    public void acquireRecord(int record) {
        this.waitForPendingWriteForRecord(record);
        this.withWriteLock(() -> ((RefCountingRecordsTable)this.myRecordsTable).incRefCount(record));
    }

    public void releaseRecord(int record) throws IOException {
        this.waitForPendingWriteForRecord(record);
        this.withWriteLock(() -> {
            if (((RefCountingRecordsTable)this.myRecordsTable).decRefCount(record) && !this.myUseContentHashes) {
                this.doDeleteRecord(record);
            }
        });
    }

    public int getRefCount(int record) {
        this.waitForPendingWriteForRecord(record);
        return this.withReadLock(() -> ((RefCountingRecordsTable)this.myRecordsTable).getRefCount(record));
    }

    @Override
    public void force() {
        this.flushPendingWrites();
        super.force();
    }

    @Override
    public boolean isDirty() {
        return !this.myPendingWriteRequests.isEmpty() || super.isDirty();
    }

    @Override
    public boolean flushSome() {
        this.flushPendingWrites();
        return super.flushSome();
    }

    @Override
    public void dispose() {
        this.flushPendingWrites();
        super.dispose();
    }

    @Override
    public void checkSanity(int record) {
        this.flushPendingWrites();
        super.checkSanity(record);
    }

    private void flushPendingWrites() {
        for (Map.Entry<Integer, Future<?>> entry : this.myPendingWriteRequests.entrySet()) {
            try {
                entry.getValue().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeRequestExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordsFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/storage/RefCountingContentStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRecordsTable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CustomInflaterInputStream
    extends InflaterInputStream {
        CustomInflaterInputStream(byte[] compressedData) {
            super(new UnsyncByteArrayInputStream(compressedData), new Inflater(), 1);
            this.buf = compressedData;
            this.len = -1;
        }

        @Override
        protected void fill() throws IOException {
            if (this.len >= 0) {
                throw new EOFException();
            }
            this.len = this.buf.length;
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.inf.end();
        }
    }
}

