/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginId
implements Comparable<PluginId> {
    public static final PluginId[] EMPTY_ARRAY = new PluginId[0];
    private static final ConcurrentHashMap<String, PluginId> registeredIds = new ConcurrentHashMap();
    @NotNull
    private final String idString;

    @NotNull
    public static PluginId getId(@NotNull String idString) {
        if (idString == null) {
            PluginId.$$$reportNull$$$0(0);
        }
        PluginId pluginId = registeredIds.computeIfAbsent(idString, PluginId::new);
        if (pluginId == null) {
            PluginId.$$$reportNull$$$0(1);
        }
        return pluginId;
    }

    @Nullable
    public static PluginId findId(@NotNull String idString) {
        if (idString == null) {
            PluginId.$$$reportNull$$$0(2);
        }
        return registeredIds.get(idString);
    }

    @Nullable
    public static PluginId findId(String ... idStrings) {
        if (idStrings == null) {
            PluginId.$$$reportNull$$$0(3);
        }
        for (String idString : idStrings) {
            PluginId pluginId = registeredIds.get(idString);
            if (pluginId == null) continue;
            return pluginId;
        }
        return null;
    }

    @NotNull
    public static Set<PluginId> getRegisteredIds() {
        Set<PluginId> set = Collections.unmodifiableSet(new HashSet<PluginId>(registeredIds.values()));
        if (set == null) {
            PluginId.$$$reportNull$$$0(4);
        }
        return set;
    }

    private PluginId(@NotNull String idString) {
        if (idString == null) {
            PluginId.$$$reportNull$$$0(5);
        }
        this.idString = idString;
    }

    @NotNull
    public String getIdString() {
        String string = this.idString;
        if (string == null) {
            PluginId.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginId)) {
            return false;
        }
        PluginId pluginId = (PluginId)o;
        return this.idString.equals(pluginId.idString);
    }

    public int hashCode() {
        return this.idString.hashCode();
    }

    @Override
    public int compareTo(@NotNull PluginId o) {
        if (o == null) {
            PluginId.$$$reportNull$$$0(7);
        }
        return this.idString.compareTo(o.idString);
    }

    public String toString() {
        return this.idString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idString";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/PluginId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idStrings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/PluginId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredIds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

