/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.pty4j.windows.WinPtyProcess;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jvnet.winp.WinProcess;
import org.jvnet.winp.WinpException;

public final class OSProcessUtil {
    private static final Logger LOG = Logger.getInstance(OSProcessUtil.class);
    private static String ourPid;

    public static ProcessInfo @NotNull [] getProcessList() {
        ProcessInfo[] processInfoArray = ProcessListUtil.getProcessList();
        if (processInfoArray == null) {
            OSProcessUtil.$$$reportNull$$$0(0);
        }
        return processInfoArray;
    }

    public static boolean killProcessTree(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isWindows) {
            try {
                if (process2 instanceof WinPtyProcess) {
                    int pid = ((WinPtyProcess)process2).getChildProcessId();
                    if (pid == -1) {
                        return true;
                    }
                    boolean res = WinProcessManager.kill(pid, true);
                    process2.destroy();
                    return res;
                }
                if (Registry.is("disable.winp", false)) {
                    return WinProcessManager.kill(process2, true);
                }
                if (!process2.isAlive()) {
                    OSProcessUtil.logSkippedActionWithTerminatedProcess(process2, "killProcessTree", null);
                    return true;
                }
                OSProcessUtil.createWinProcess(process2).killRecursively();
                return true;
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process tree", e);
            }
        } else if (SystemInfo.isUnix) {
            return UnixProcessManager.sendSigKillToProcessTree(process2);
        }
        return false;
    }

    public static void killProcess(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(2);
        }
        OSProcessUtil.killProcess(OSProcessUtil.getProcessID(process2));
    }

    public static void killProcess(int pid) {
        if (SystemInfo.isWindows) {
            try {
                if (!Registry.is("disable.winp", false)) {
                    try {
                        OSProcessUtil.createWinProcess(pid).kill();
                        return;
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to kill process with winp, fallback to default logic", e);
                    }
                }
                WinProcessManager.kill(pid, false);
            }
            catch (Throwable e) {
                LOG.info("Cannot kill process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal(pid, 9);
        }
    }

    public static void terminateProcessGracefully(int pid) throws RuntimeException {
        if (SystemInfo.isWindows) {
            if (Registry.is("disable.winp")) {
                throw new UnsupportedOperationException("Cannot terminate process, disable.winp=true");
            }
            try {
                OSProcessUtil.createWinProcess(pid).sendCtrlC();
            }
            catch (WinpException e) {
                throw new UnsupportedOperationException("Failed to terminate process", e);
            }
        } else if (SystemInfo.isUnix) {
            UnixProcessManager.sendSignal(pid, 2);
        } else {
            throw new UnsupportedOperationException("Graceful termination is not supported for " + SystemInfo.getOsNameAndVersion());
        }
    }

    static void logSkippedActionWithTerminatedProcess(@NotNull Process process2, @NotNull String actionName, @Nullable String commandLine) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(3);
        }
        if (actionName == null) {
            OSProcessUtil.$$$reportNull$$$0(4);
        }
        Integer pid = null;
        try {
            pid = OSProcessUtil.getProcessID(process2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOG.info("Cannot " + actionName + " already terminated process (pid: " + pid + ", command: " + commandLine + ")");
    }

    public static int getProcessID(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(5);
        }
        return (int)process2.pid();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static int getProcessID(@NotNull Process process2, Boolean disableWinp) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(6);
        }
        return (int)process2.pid();
    }

    @NotNull
    static WinProcess createWinProcess(@NotNull Process process2) {
        if (process2 == null) {
            OSProcessUtil.$$$reportNull$$$0(7);
        }
        if (process2 instanceof WinPtyProcess) {
            return new WinProcess(((WinPtyProcess)process2).getPid());
        }
        return new WinProcess(process2);
    }

    @NotNull
    private static WinProcess createWinProcess(int pid) {
        return new WinProcess(pid);
    }

    public static int getCurrentProcessId() {
        return (int)ProcessHandle.current().pid();
    }

    public static String getApplicationPid() {
        if (ourPid == null) {
            ourPid = String.valueOf(OSProcessUtil.getCurrentProcessId());
        }
        return ourPid;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/OSProcessUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/OSProcessUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "killProcess";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logSkippedActionWithTerminatedProcess";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProcessID";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createWinProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

