/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class OptionsMessageDialog
extends OptionsDialog {
    private final @NlsContexts.Label String myMessage;
    private final Icon myIcon;

    protected OptionsMessageDialog(Project project, @NlsContexts.Label String message, @NlsContexts.DialogTitle String title, Icon icon2) {
        super(project);
        this.myMessage = message;
        this.myIcon = icon2;
        this.setTitle(title);
    }

    @NlsActions.ActionText
    protected abstract String getOkActionName();

    @NlsActions.ActionText
    protected abstract String getCancelActionName();

    @Override
    protected Action @NotNull [] createActions() {
        Action okAction = this.getOKAction();
        Action cancelAction = this.getCancelAction();
        OptionsMessageDialog.assignMnemonic(this.getOkActionName(), okAction);
        OptionsMessageDialog.assignMnemonic(this.getCancelActionName(), cancelAction);
        Action[] actionArray = new Action[]{okAction, cancelAction};
        if (actionArray == null) {
            OptionsMessageDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    protected static void assignMnemonic(@NlsActions.ActionText String option, Action action2) {
        String mnemoChar;
        action2.putValue("Name", option);
        int mnemoPos = option.indexOf("&");
        if (mnemoPos >= 0 && mnemoPos < option.length() - 2 && (mnemoChar = option.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
            action2.putValue("MnemonicKey", new Integer(mnemoChar.charAt(0)));
        }
    }

    @Override
    @NotNull
    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(15, 0));
        if (this.myIcon != null) {
            JLabel iconLabel = new JLabel(this.myIcon);
            Container container = new Container();
            container.setLayout(new BorderLayout());
            container.add((Component)iconLabel, "North");
            panel2.add((Component)container, "West");
        }
        if (this.myMessage != null) {
            JLabel textLabel = new JLabel(this.myMessage);
            textLabel.setUI(new MultiLineLabelUI());
            panel2.add((Component)textLabel, "Center");
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            OptionsMessageDialog.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    protected JComponent createCenterPanel() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/ui/OptionsMessageDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNorthPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

