/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.containers.FList;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpeedSearchUtil {
    private SpeedSearchUtil() {
    }

    public static void applySpeedSearchHighlighting(@NotNull JComponent speedSearchEnabledComponent, @NotNull SimpleColoredComponent coloredComponent, boolean mainTextOnly, boolean selected) {
        SpeedSearchSupply speedSearch;
        if (speedSearchEnabledComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(0);
        }
        if (coloredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(1);
        }
        Iterable<TextRange> ranges2 = (speedSearch = SpeedSearchSupply.getSupply(speedSearchEnabledComponent)) == null ? null : speedSearch.matchingFragments(coloredComponent.getCharSequence(mainTextOnly).toString());
        SpeedSearchUtil.applySpeedSearchHighlighting(coloredComponent, ranges2, selected);
    }

    public static void applySpeedSearchHighlighting(@NotNull SimpleColoredComponent coloredComponent, Iterable<TextRange> ranges2, boolean selected) {
        Iterator<TextRange> rangesIterator;
        if (coloredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(2);
        }
        Iterator<TextRange> iterator = rangesIterator = ranges2 != null ? ranges2.iterator() : null;
        if (rangesIterator == null || !rangesIterator.hasNext()) {
            return;
        }
        Color bg = UIUtil.getTreeBackground((boolean)selected, (boolean)true);
        SimpleColoredComponent.ColoredIterator coloredIterator = coloredComponent.iterator();
        TextRange range2 = rangesIterator.next();
        block0: while (coloredIterator.hasNext()) {
            coloredIterator.next();
            int offset = coloredIterator.getOffset();
            int endOffset = coloredIterator.getEndOffset();
            if (!range2.intersectsStrict(offset, endOffset)) continue;
            SimpleTextAttributes attributes = coloredIterator.getTextAttributes();
            SimpleTextAttributes highlighted = new SimpleTextAttributes(bg, attributes.getFgColor(), null, attributes.getStyle() | 0x40);
            do {
                if (range2.getStartOffset() > offset) {
                    offset = coloredIterator.split(range2.getStartOffset() - offset, attributes);
                }
                if (range2.getEndOffset() <= endOffset) {
                    offset = coloredIterator.split(range2.getEndOffset() - offset, highlighted);
                    if (!rangesIterator.hasNext()) break block0;
                } else {
                    coloredIterator.split(endOffset - offset, highlighted);
                    continue block0;
                }
                range2 = rangesIterator.next();
            } while (range2.intersectsStrict(offset, endOffset));
        }
    }

    public static void appendFragmentsForSpeedSearch(@NotNull JComponent speedSearchEnabledComponent, @NotNull @NlsContexts.Label String text2, @NotNull SimpleTextAttributes attributes, boolean selected, @NotNull SimpleColoredComponent simpleColoredComponent) {
        Iterable<TextRange> fragments2;
        SpeedSearchSupply speedSearch;
        if (speedSearchEnabledComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            SpeedSearchUtil.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            SpeedSearchUtil.$$$reportNull$$$0(5);
        }
        if (simpleColoredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(6);
        }
        if ((speedSearch = SpeedSearchSupply.getSupply(speedSearchEnabledComponent)) != null && (fragments2 = speedSearch.matchingFragments(text2)) != null) {
            SpeedSearchUtil.appendSpeedSearchColoredFragments(simpleColoredComponent, text2, fragments2, attributes, selected);
            return;
        }
        simpleColoredComponent.append(text2, attributes);
    }

    public static void appendColoredFragmentForMatcher(@NotNull @NlsContexts.Label String text2, SimpleColoredComponent component, @NotNull SimpleTextAttributes attributes, @Nullable Matcher matcher, Color selectedBg, boolean selected) {
        if (text2 == null) {
            SpeedSearchUtil.$$$reportNull$$$0(7);
        }
        if (attributes == null) {
            SpeedSearchUtil.$$$reportNull$$$0(8);
        }
        if (!(matcher instanceof MinusculeMatcher) || Registry.is((String)"ide.highlight.match.in.selected.only") && !selected) {
            component.append(text2, attributes);
            return;
        }
        FList iterable = ((MinusculeMatcher)matcher).matchingFragments(text2);
        component.setDynamicSearchMatchHighlighting(iterable != null);
        if (iterable != null) {
            Color fg = attributes.getFgColor();
            int style = attributes.getStyle();
            SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
            SimpleTextAttributes highlighted = new SimpleTextAttributes(selectedBg, fg, null, style | 0x40);
            SpeedSearchUtil.appendColoredFragments(component, text2, (Iterable<? extends TextRange>)iterable, plain, highlighted);
        } else {
            component.append(text2, attributes);
        }
    }

    public static void appendSpeedSearchColoredFragments(@NotNull SimpleColoredComponent simpleColoredComponent, @NotNull @NlsContexts.Label String text2, @NotNull Iterable<? extends TextRange> colored, @NotNull SimpleTextAttributes attributes, boolean selected) {
        if (simpleColoredComponent == null) {
            SpeedSearchUtil.$$$reportNull$$$0(9);
        }
        if (text2 == null) {
            SpeedSearchUtil.$$$reportNull$$$0(10);
        }
        if (colored == null) {
            SpeedSearchUtil.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            SpeedSearchUtil.$$$reportNull$$$0(12);
        }
        Color fg = attributes.getFgColor();
        Color bg = UIUtil.getTreeBackground((boolean)selected, (boolean)true);
        int style = attributes.getStyle();
        SimpleTextAttributes plain = new SimpleTextAttributes(style, fg);
        SimpleTextAttributes highlighted = new SimpleTextAttributes(bg, fg, null, style | 0x40);
        SpeedSearchUtil.appendColoredFragments(simpleColoredComponent, text2, colored, plain, highlighted);
    }

    public static void appendColoredFragments(SimpleColoredComponent simpleColoredComponent, @Nls String text2, Iterable<? extends TextRange> colored, SimpleTextAttributes plain, SimpleTextAttributes highlighted) {
        ArrayList<Pair> searchTerms = new ArrayList<Pair>();
        for (TextRange textRange : colored) {
            searchTerms.add(Pair.create((Object)textRange.substring(text2), (Object)textRange.getStartOffset()));
        }
        int lastOffset = 0;
        for (Pair pair : searchTerms) {
            if ((Integer)pair.second > lastOffset) {
                simpleColoredComponent.append(text2.substring(lastOffset, (Integer)pair.second), plain);
            }
            simpleColoredComponent.append(text2.substring((Integer)pair.second, (Integer)pair.second + ((String)pair.first).length()), highlighted);
            lastOffset = (Integer)pair.second + ((String)pair.first).length();
        }
        if (lastOffset < text2.length()) {
            simpleColoredComponent.append(text2.substring(lastOffset), plain);
        }
    }

    public static void applySpeedSearchHighlightingFiltered(JTree tree, Object value2, ColoredTreeCellRenderer coloredTreeCellRenderer, boolean mainTextOnly, boolean selected) {
        SpeedSearchSupply speedSearch = SpeedSearchSupply.getSupply(tree);
        if (speedSearch != null && !speedSearch.isObjectFilteredOut(value2)) {
            SpeedSearchUtil.applySpeedSearchHighlighting(tree, coloredTreeCellRenderer, mainTextOnly, selected);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "speedSearchEnabledComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleColoredComponent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colored";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/speedSearch/SpeedSearchUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applySpeedSearchHighlighting";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendFragmentsForSpeedSearch";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "appendColoredFragmentForMatcher";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpeedSearchColoredFragments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

