/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathsList;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public abstract class OrderEnumerator {
    @NotNull
    public abstract OrderEnumerator productionOnly();

    @NotNull
    public abstract OrderEnumerator compileOnly();

    @NotNull
    public abstract OrderEnumerator runtimeOnly();

    @NotNull
    public abstract OrderEnumerator withoutSdk();

    @NotNull
    public abstract OrderEnumerator withoutLibraries();

    @NotNull
    public abstract OrderEnumerator withoutDepModules();

    @NotNull
    public abstract OrderEnumerator withoutModuleSourceEntries();

    @NotNull
    public OrderEnumerator librariesOnly() {
        OrderEnumerator orderEnumerator = this.withoutSdk().withoutDepModules().withoutModuleSourceEntries();
        if (orderEnumerator == null) {
            OrderEnumerator.$$$reportNull$$$0(0);
        }
        return orderEnumerator;
    }

    @NotNull
    public OrderEnumerator sdkOnly() {
        OrderEnumerator orderEnumerator = this.withoutDepModules().withoutLibraries().withoutModuleSourceEntries();
        if (orderEnumerator == null) {
            OrderEnumerator.$$$reportNull$$$0(1);
        }
        return orderEnumerator;
    }

    public VirtualFile @NotNull [] getAllLibrariesAndSdkClassesRoots() {
        VirtualFile[] virtualFileArray = this.withoutModuleSourceEntries().withoutDepModules().recursively().exportedOnly().classes().usingCache().getRoots();
        if (virtualFileArray == null) {
            OrderEnumerator.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getAllSourceRoots() {
        VirtualFile[] virtualFileArray = this.recursively().exportedOnly().sources().usingCache().getRoots();
        if (virtualFileArray == null) {
            OrderEnumerator.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    @NotNull
    public abstract OrderEnumerator recursively();

    @NotNull
    public abstract OrderEnumerator exportedOnly();

    @NotNull
    public abstract OrderEnumerator satisfying(@NotNull Condition<? super OrderEntry> var1);

    @NotNull
    public abstract OrderEnumerator using(@NotNull RootModelProvider var1);

    public abstract boolean shouldRecurse(@NotNull ModuleOrderEntry var1, @NotNull List<? extends OrderEnumerationHandler> var2);

    @NotNull
    public abstract OrderRootsEnumerator classes();

    @NotNull
    public abstract OrderRootsEnumerator sources();

    @NotNull
    public abstract OrderRootsEnumerator roots(@NotNull OrderRootType var1);

    @NotNull
    public abstract OrderRootsEnumerator roots(@NotNull NotNullFunction<? super OrderEntry, ? extends OrderRootType> var1);

    public VirtualFile @NotNull [] getClassesRoots() {
        VirtualFile[] virtualFileArray = this.classes().getRoots();
        if (virtualFileArray == null) {
            OrderEnumerator.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getSourceRoots() {
        VirtualFile[] virtualFileArray = this.sources().getRoots();
        if (virtualFileArray == null) {
            OrderEnumerator.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    @NotNull
    public PathsList getPathsList() {
        PathsList pathsList = this.classes().getPathsList();
        if (pathsList == null) {
            OrderEnumerator.$$$reportNull$$$0(6);
        }
        return pathsList;
    }

    @NotNull
    public PathsList getSourcePathsList() {
        PathsList pathsList = this.sources().getPathsList();
        if (pathsList == null) {
            OrderEnumerator.$$$reportNull$$$0(7);
        }
        return pathsList;
    }

    public abstract void forEach(@NotNull Processor<? super OrderEntry> var1);

    public abstract void forEachLibrary(@NotNull Processor<? super Library> var1);

    public abstract void forEachModule(@NotNull Processor<? super Module> var1);

    public abstract <R> R process(@NotNull RootPolicy<R> var1, R var2);

    @NotNull
    public static OrderEnumerator orderEntries(@NotNull Module module) {
        if (module == null) {
            OrderEnumerator.$$$reportNull$$$0(8);
        }
        OrderEnumerator orderEnumerator = ModuleRootManager.getInstance(module).orderEntries();
        if (orderEnumerator == null) {
            OrderEnumerator.$$$reportNull$$$0(9);
        }
        return orderEnumerator;
    }

    @NotNull
    public static OrderEnumerator orderEntries(@NotNull Project project) {
        if (project == null) {
            OrderEnumerator.$$$reportNull$$$0(10);
        }
        OrderEnumerator orderEnumerator = ProjectRootManager.getInstance(project).orderEntries();
        if (orderEnumerator == null) {
            OrderEnumerator.$$$reportNull$$$0(11);
        }
        return orderEnumerator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/OrderEnumerator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "librariesOnly";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkOnly";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibrariesAndSdkClassesRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSourceRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcePathsList";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/OrderEnumerator";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "orderEntries";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "orderEntries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

