/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import a.d.la;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.toolchains.OSType;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessOutputReaders {
    private final AtomicReference<MyOutputReader[]> myReaders;
    private final String myPresentableName;
    private final Charset myCharset;
    private static final long a = la.a(-1353905337216482507L, -4878293135878302638L, MethodHandles.lookup().lookupClass()).a(61152984385415L);

    public ProcessOutputReaders(@NotNull GeneralCommandLine commandLine, boolean usePtyOnUnix) throws ExecutionException {
        if (commandLine == null) {
            ProcessOutputReaders.a(0);
        }
        this(CommandLineUtil.extractPresentableName((String)commandLine.getCommandLineString()), commandLine.getCharset(), usePtyOnUnix);
    }

    public ProcessOutputReaders(@NotNull String presentableName, @NotNull Charset charset, boolean usePtyOnUnix) throws ExecutionException {
        if (presentableName == null) {
            ProcessOutputReaders.a(1);
        }
        if (charset == null) {
            ProcessOutputReaders.a(2);
        }
        this(LocalHost.INSTANCE, presentableName, charset, usePtyOnUnix);
    }

    public ProcessOutputReaders(@NotNull HostMachine host, @NotNull GeneralCommandLine commandLine, boolean usePtyOnUnix) throws ExecutionException {
        if (host == null) {
            ProcessOutputReaders.a(3);
        }
        if (commandLine == null) {
            ProcessOutputReaders.a(4);
        }
        this(host, CommandLineUtil.extractPresentableName((String)commandLine.getCommandLineString()), commandLine.getCharset(), usePtyOnUnix);
    }

    private ProcessOutputReaders(@NotNull HostMachine host, @NotNull String presentableName, @NotNull Charset charset, boolean usePtyOnUnix) throws ExecutionException {
        long l2 = a ^ 0x7BC844927D23L;
        if (host == null) {
            ProcessOutputReaders.a(5);
        }
        if (presentableName == null) {
            ProcessOutputReaders.a(6);
        }
        if (charset == null) {
            ProcessOutputReaders.a(7);
        }
        this.myReaders = new AtomicReference<MyOutputReader[]>(new MyOutputReader[2]);
        this.myPresentableName = presentableName;
        this.myCharset = charset;
        OSType oSType = host.getOSType();
        try {
            MyOutputReader[] myOutputReaderArray = this.getReaders();
            if (oSType == OSType.WIN) {
                myOutputReaderArray[0] = new MyWinPipeOutputReader(this, ProcessOutputTypes.STDOUT);
                myOutputReaderArray[1] = new MyWinPipeOutputReader(this, ProcessOutputTypes.STDERR);
            } else if (usePtyOnUnix && host.isRemote()) {
                myOutputReaderArray[0] = new MyRemoteUnixPipeOutputReader(host.openNamedPipe(), ProcessOutputTypes.STDOUT);
                myOutputReaderArray[1] = new MyRemoteUnixPipeOutputReader(host.openNamedPipe(), ProcessOutputTypes.STDERR);
            } else if (usePtyOnUnix) {
                myOutputReaderArray[0] = new MyUnixPtyOutputReader(this, ProcessOutputTypes.STDOUT);
                myOutputReaderArray[1] = new MyUnixPtyOutputReader(this, ProcessOutputTypes.STDERR);
            } else {
                myOutputReaderArray[0] = new MyFileOutputReader(this, ProcessOutputTypes.STDOUT);
                myOutputReaderArray[1] = new MyFileOutputReader(this, ProcessOutputTypes.STDERR);
            }
        }
        catch (IOException iOException) {
            throw new ExecutionException("Cannot create output file", (Throwable)iOException);
        }
    }

    public String getOutFileAbsolutePath() throws ExecutionException {
        return this.getReader(0).getFileAbsolutePath();
    }

    public String getErrFileAbsolutePath() throws ExecutionException {
        return this.getReader(1).getFileAbsolutePath();
    }

    protected MyOutputReader[] getReaders() {
        return this.myReaders.get();
    }

    protected MyOutputReader getReader(int num) throws ExecutionException {
        long l2 = a ^ 0x197DD09192A1L;
        MyOutputReader[] myOutputReaderArray = this.getReaders();
        if (ArrayUtil.isEmpty((Object[])myOutputReaderArray)) {
            throw new ExecutionException("Reader is closed");
        }
        return myOutputReaderArray[num];
    }

    protected boolean doWaitFor(MyOutputReader[] readers) {
        for (MyOutputReader myOutputReader : readers) {
            try {
                myOutputReader.waitFor();
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                return false;
            }
        }
        return true;
    }

    protected boolean doWaitFor(MyOutputReader[] readers, long timeout, TimeUnit unit) {
        for (MyOutputReader myOutputReader : readers) {
            try {
                myOutputReader.waitFor(timeout, unit);
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                return false;
            }
            catch (TimeoutException timeoutException) {
                return false;
            }
        }
        return true;
    }

    public boolean waitFor() {
        return this.doWaitFor(this.getReaders());
    }

    public boolean waitFor(long timeout, TimeUnit unit) {
        return this.doWaitFor(this.getReaders(), timeout, unit);
    }

    public void close() {
        MyOutputReader[] myOutputReaderArray;
        for (MyOutputReader myOutputReader : myOutputReaderArray = this.myReaders.getAndSet(new MyOutputReader[0])) {
            myOutputReader.stop();
        }
        this.doWaitFor(myOutputReaderArray);
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull Key var2);

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = a ^ 0x41985EE95F1BL;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "commandLine";
                break;
            }
            case 1: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "presentableName";
                break;
            }
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "charset";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "host";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ReaderOptions
    extends BaseOutputReader.Options {
        private final BaseDataReader.SleepingPolicy myPolicy;

        public ReaderOptions(BaseDataReader.SleepingPolicy policy) {
            this.myPolicy = policy;
        }

        public BaseDataReader.SleepingPolicy policy() {
            return this.myPolicy;
        }

        public boolean withSeparators() {
            return true;
        }

        public boolean splitToLines() {
            return false;
        }

        public boolean sendIncompleteLines() {
            return true;
        }
    }

    protected class MyWinPipeOutputReader
    extends MyOutputReader {
        @NotNull
        private final WinPipe myPipe;
        final /* synthetic */ ProcessOutputReaders this$0;
        private static final long a = la.a(1295911488754165084L, 2951269546547698627L, MethodHandles.lookup().lookupClass()).a(204127778302328L);

        protected MyWinPipeOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyWinPipeOutputReader.b(0);
            }
            this(this$0, WinPipe.createInboundPipe(type.toString()), type);
        }

        protected MyWinPipeOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull WinPipe pipe, Key type) {
            if (pipe == null) {
                MyWinPipeOutputReader.b(1);
            }
            if (type == null) {
                MyWinPipeOutputReader.b(2);
            }
            this.this$0 = this$0;
            super(type, pipe.getName(), pipe.getInputStream(), BaseDataReader.SleepingPolicy.NON_BLOCKING);
            this.myPipe = pipe;
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.myPipe.close();
            }
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x5B9BD2AEF5B9L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pipe";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyWinPipeOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyRemoteUnixPipeOutputReader
    extends MyOutputReader {
        private static final long a = la.a(3910048973198951990L, 4296983573372843848L, MethodHandles.lookup().lookupClass()).a(148286722105279L);

        protected MyRemoteUnixPipeOutputReader(@NotNull NamedPipe pipe, Key type) throws IOException {
            if (pipe == null) {
                MyRemoteUnixPipeOutputReader.b(0);
            }
            if (type == null) {
                MyRemoteUnixPipeOutputReader.b(1);
            }
            super(type, pipe.getName(), pipe.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x4FBE5933A9F5L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pipe";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyRemoteUnixPipeOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyUnixPtyOutputReader
    extends MyOutputReader {
        final /* synthetic */ ProcessOutputReaders this$0;
        private static final long a = la.a(-75422004775612877L, -1711507545267274548L, MethodHandles.lookup().lookupClass()).a(102676652811764L);

        protected MyUnixPtyOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyUnixPtyOutputReader.b(0);
            }
            this(this$0, new Pty(true), type);
        }

        protected MyUnixPtyOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull Pty pty, Key type) {
            if (pty == null) {
                MyUnixPtyOutputReader.b(1);
            }
            if (type == null) {
                MyUnixPtyOutputReader.b(2);
            }
            this.this$0 = this$0;
            super(type, pty.getSlaveName(), (InputStream)pty.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x2FD3AAC70EC8L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pty";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyUnixPtyOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyFileOutputReader
    extends MyOutputReader {
        @NotNull
        private final File myFileToDelete;
        final /* synthetic */ ProcessOutputReaders this$0;
        private static final long a = la.a(967927171576712308L, 512233241112578811L, MethodHandles.lookup().lookupClass()).a(11866934939135L);

        protected MyFileOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyFileOutputReader.b(0);
            }
            this(this$0, FileUtil.createTempFile((String)this$0.getClass().getSimpleName(), (String)type.toString(), (boolean)true), type);
        }

        protected MyFileOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull File file, Key type) throws IOException {
            if (file == null) {
                MyFileOutputReader.b(1);
            }
            if (type == null) {
                MyFileOutputReader.b(2);
            }
            this.this$0 = this$0;
            super(type, file.getAbsolutePath(), new FileInputStream(file), BaseDataReader.SleepingPolicy.NON_BLOCKING);
            this.myFileToDelete = file;
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                FileUtil.delete((File)this.myFileToDelete);
            }
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x6413DE45FF81L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyFileOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyOutputReader
    extends BaseOutputReader {
        @NotNull
        private final Key myType;
        @NotNull
        private final String myFileAbsolutePath;
        private static final long b = la.a(511001708980966290L, 8756584535437514019L, MethodHandles.lookup().lookupClass()).a(115013438633170L);

        protected MyOutputReader(@NotNull Key type, @NotNull String fileAbsolutePath, InputStream stream2, BaseDataReader.SleepingPolicy sleepingPolicy) {
            if (type == null) {
                MyOutputReader.a(0);
            }
            if (fileAbsolutePath == null) {
                MyOutputReader.a(1);
            }
            if (stream2 == null) {
                MyOutputReader.a(2);
            }
            super(stream2, ProcessOutputReaders.this.myCharset, (BaseOutputReader.Options)new ReaderOptions(sleepingPolicy));
            this.myType = type;
            this.myFileAbsolutePath = fileAbsolutePath;
            this.start(ProcessOutputReaders.this.myPresentableName);
        }

        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                MyOutputReader.a(3);
            }
            text = StringUtil.trimEnd((String)text, (String)"\r");
            text = StringUtil.convertLineSeparators((String)text);
            ProcessOutputReaders.this.onTextAvailable(text, this.myType);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                MyOutputReader.a(4);
            }
            Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
            if (future == null) {
                MyOutputReader.a(5);
            }
            return future;
        }

        public void stop() {
            super.stop();
            if (this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING) {
                try {
                    this.waitFor(this.mySleepingPolicy.getTimeToSleep(false), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException exception) {
                    try {
                        this.close();
                    }
                    catch (IOException iOException) {
                        CidrLogService.LOG.error((Throwable)iOException);
                    }
                }
            }
        }

        @NotNull
        public String getFileAbsolutePath() {
            String string = this.myFileAbsolutePath;
            if (string == null) {
                MyOutputReader.a(6);
            }
            return string;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = b ^ 0x6A5FFB2F6F11L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAbsolutePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyOutputReader";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyOutputReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileAbsolutePath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

