/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import a.d.la;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommentLineData {
    protected String line;
    int commentOffset;
    int textStartOffset;
    boolean startsWithLetter;
    private final List<TextRange> unbreakableRanges;
    private static final long a = la.a(8633209125361647144L, -8517044446819182434L, MethodHandles.lookup().lookupClass()).a(98996283807718L);

    public CommentLineData(@NotNull String line) {
        if (line == null) {
            CommentLineData.a(0);
        }
        this.commentOffset = -1;
        this.textStartOffset = -1;
        this.startsWithLetter = false;
        this.unbreakableRanges = new ArrayList<TextRange>();
        this.line = line;
    }

    public void addUnbreakableRange(@NotNull TextRange range) {
        if (range == null) {
            CommentLineData.a(1);
        }
        this.unbreakableRanges.add(range);
    }

    protected int calcWrapPos(int rightMargin) {
        if (!this.hasText()) {
            return -1;
        }
        int n2 = this.a(rightMargin);
        String string = this.line.substring(0, n2);
        int n3 = string.lastIndexOf(32);
        if (n3 < this.textStartOffset && (n3 = this.line.indexOf(32, this.textStartOffset)) != this.b(n3)) {
            return -1;
        }
        return n3;
    }

    public boolean hasText() {
        return this.textStartOffset > this.commentOffset;
    }

    public boolean canBeMergedWithPrevious() {
        return this.hasText() && this.startsWithLetter;
    }

    @NotNull
    public String getText() {
        if (this.hasText()) {
            String string = this.line.substring(this.textStartOffset);
            if (string == null) {
                CommentLineData.a(2);
            }
            return string;
        }
        return "";
    }

    public void merge(@NotNull CommentLineData lineData) {
        if (lineData == null) {
            CommentLineData.a(3);
        }
        for (TextRange textRange : lineData.unbreakableRanges) {
            this.unbreakableRanges.add(textRange.shiftRight(this.line.length() + 1));
        }
        this.line = this.line + " " + lineData.getText();
    }

    public int getLineLength() {
        int n2 = 0;
        for (int i10 = 0; i10 < this.line.length(); ++i10) {
            char c10 = this.line.charAt(i10);
            n2 = this.a(n2, c10);
        }
        return n2;
    }

    @Nullable
    public Pair<String, String> splitLine(int rightMargin) {
        int n2 = this.calcWrapPos(rightMargin);
        if (n2 >= 0) {
            return new Pair((Object)this.line.substring(0, n2), (Object)this.line.substring(n2));
        }
        return null;
    }

    @NotNull
    public String getLine() {
        String string = this.line;
        if (string == null) {
            CommentLineData.a(4);
        }
        return string;
    }

    public boolean isTagLine() {
        return false;
    }

    public void setTagLine(boolean isTagLine) {
    }

    @NotNull
    public String getLinePrefix() {
        return "";
    }

    protected abstract int getTabSize();

    private int a(int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            if (n4 < this.line.length()) {
                char c10 = this.line.charAt(n4);
                if ((n3 = this.a(n3, c10)) > n2) break;
                ++n4;
                continue;
            }
            --n4;
            break;
        }
        return this.b(n4);
    }

    private int b(int n2) {
        for (TextRange textRange : this.unbreakableRanges) {
            if (!textRange.contains(n2)) continue;
            return textRange.getStartOffset();
        }
        return n2;
    }

    private int a(int n2, char c10) {
        return n2 + (c10 == '\t' ? this.getTabSize() : 1);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x32889757E297L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/CommentLineData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/CommentLineData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addUnbreakableRange";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

