/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import a.d.la;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.scale.JBUIScale;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="CoverageViewManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public final class CoverageViewManager
implements PersistentStateComponent<StateBean>,
Disposable {
    private static final Logger LOG;
    @NonNls
    public static final String TOOLWINDOW_ID = "Coverage";
    private final Project myProject;
    private ContentManager myContentManager;
    private StateBean myStateBean;
    private final Map<String, CoverageView> myViews;
    private boolean myReady;
    private static final long a;

    public CoverageViewManager(@NotNull Project project) {
        if (project == null) {
            CoverageViewManager.a(0);
        }
        this.myStateBean = new StateBean();
        this.myViews = new HashMap<String, CoverageView>();
        this.myProject = project;
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
            long l2 = a ^ 0x476F4EEEBED3L;
            RegisterToolWindowTask registerToolWindowTask = RegisterToolWindowTask.closableSecondary((String)TOOLWINDOW_ID, CoverageBundle.messagePointer("coverage.view.title", new Object[0]), (Icon)AllIcons.Toolwindows.ToolWindowCoverage, (ToolWindowAnchor)ToolWindowAnchor.RIGHT);
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(registerToolWindowTask);
            toolWindow.setHelpId("reference.toolWindows.Coverage");
            this.myContentManager = toolWindow.getContentManager();
            ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)this.myContentManager);
        });
    }

    public void dispose() {
    }

    public StateBean getState() {
        return this.myStateBean;
    }

    public void loadState(@NotNull StateBean state) {
        if (state == null) {
            CoverageViewManager.a(1);
        }
        this.myStateBean = state;
    }

    public CoverageView getToolwindow(CoverageSuitesBundle suitesBundle) {
        return this.myViews.get(CoverageViewManager.getDisplayName(suitesBundle));
    }

    public void activateToolwindow(@NotNull CoverageView view, boolean requestFocus) {
        long l2 = a ^ 0x744EB3EE2471L;
        if (view == null) {
            CoverageViewManager.a(2);
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOLWINDOW_ID);
        if (requestFocus) {
            this.myContentManager.setSelectedContent(this.myContentManager.getContent((JComponent)((Object)view)));
            LOG.assertTrue(toolWindow != null);
            toolWindow.activate(null, false);
        }
    }

    public static CoverageViewManager getInstance(@NotNull Project project) {
        if (project == null) {
            CoverageViewManager.a(3);
        }
        return (CoverageViewManager)project.getService(CoverageViewManager.class);
    }

    public void createToolWindow(@NlsSafe String displayName, boolean defaultFileProvider) {
        CoverageView coverageView = new CoverageView(this.myProject, CoverageDataManager.getInstance(this.myProject), this.myStateBean);
        this.myViews.put(displayName, coverageView);
        Content content = this.myContentManager.getFactory().createContent((JComponent)((Object)coverageView), displayName, false);
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        if (CoverageOptionsProvider.getInstance(this.myProject).activateViewOnRun() && defaultFileProvider) {
            this.activateToolwindow(coverageView, true);
        }
    }

    void closeView(String displayName) {
        CoverageView coverageView = this.myViews.remove(displayName);
        if (coverageView != null) {
            coverageView.saveSize();
            Content content = this.myContentManager.getContent((JComponent)((Object)coverageView));
            ApplicationManager.getApplication().invokeLater(() -> {
                if (content != null) {
                    this.myContentManager.removeContent(content, false);
                }
            });
        }
        this.setReady(false);
    }

    public boolean isReady() {
        return this.myReady;
    }

    public void setReady(boolean ready) {
        this.myReady = ready;
    }

    public static String getDisplayName(CoverageSuitesBundle suitesBundle) {
        RunConfigurationBase runConfigurationBase = suitesBundle.getRunConfiguration();
        return runConfigurationBase != null ? runConfigurationBase.getName() : suitesBundle.getPresentableName();
    }

    static {
        a = la.a(-3143822317089334166L, -4249019551939590879L, MethodHandles.lookup().lookupClass()).a(177270437690837L);
        LOG = Logger.getInstance(CoverageViewManager.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x565FE5ED099FL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/view/CoverageViewManager";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "activateToolwindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class StateBean {
        public boolean myFlattenPackages = false;
        public boolean myAutoScrollToSource = false;
        public boolean myAutoScrollFromSource = false;
        public int myElementSize = JBUIScale.scale((int)200);
    }
}

