/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.model.ConfigurationDataImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsagesCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.util.BooleanFunction;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.statistics.GradleSettingsCollector;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/statistics/GradleSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "anonymizeGradleVersion", "", "version", "Lorg/gradle/util/GradleVersion;", "getGroupId", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getVersion", "", "intellij.gradle.common"})
public final class GradleSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.gradle.state";
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        v0 = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"GradleSettings.getInstance(project)");
        gradleSettings = v0;
        v1 = gradleSettings.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"gradleSettings.linkedProjectsSettings");
        projectsSettings = v1;
        if (projectsSettings.isEmpty()) {
            return SetsKt.emptySet();
        }
        var5_4 = false;
        usages = new LinkedHashSet<E>();
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasGradleProject", (boolean)true));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"offlineWork", (boolean)gradleSettings.isOfflineWork()));
        var5_5 = gradleSettings.getServiceDirectoryPath();
        var6_7 = false;
        var7_9 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasCustomServiceDirectoryPath", (boolean)((var5_5 == null || StringsKt.isBlank((CharSequence)var5_5) != false) == false)));
        var5_5 = gradleSettings.getGradleVmOptions();
        var6_7 = false;
        var7_9 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasCustomGradleVmOptions", (boolean)((var5_5 == null || StringsKt.isBlank((CharSequence)var5_5) != false) == false)));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"showSelectiveImportDialogOnInitialImport", (boolean)gradleSettings.showSelectiveImportDialogOnInitialImport()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"storeProjectFilesExternally", (boolean)gradleSettings.getStoreProjectFilesExternally()));
        var6_8 = gradleSettings.getLinkedProjectsSettings().iterator();
        while (var6_8.hasNext()) {
            v2 = setting = (GradleProjectSettings)var6_8.next();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"setting");
            projectPath = v2.getExternalProjectPath();
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"isUseQualifiedModuleNames", (boolean)setting.isUseQualifiedModuleNames()));
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"createModulePerSourceSet", (boolean)setting.isResolveModulePerSourceSet()));
            usages.add(MetricEventFactoryKt.newMetric((String)"distributionType", (Enum)setting.getDistributionType()));
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"isCompositeBuilds", (boolean)(setting.getCompositeBuild() != null)));
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"disableWrapperSourceDistributionNotification", (boolean)setting.isDisableWrapperSourceDistributionNotification()));
            usages.add(ExternalSystemUsagesCollector.Companion.getJRETypeUsage("gradleJvmType", setting.getGradleJvm()));
            usages.add(ExternalSystemUsagesCollector.Companion.getJREVersionUsage(project, "gradleJvmVersion", setting.getGradleJvm()));
            Intrinsics.checkNotNullExpressionValue((Object)setting.resolveGradleVersion(), (String)"setting.resolveGradleVersion()");
            if (gradleVersion.isSnapshot()) {
                v3 = new StringBuilder();
                v4 = gradleVersion.getBaseVersion();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"gradleVersion.baseVersion");
                usages.add(MetricEventFactoryKt.newMetric((String)"gradleVersion", (String)v3.append(this.anonymizeGradleVersion(v4)).append(".SNAPSHOT").toString()));
            } else {
                usages.add(MetricEventFactoryKt.newMetric((String)"gradleVersion", (String)this.anonymizeGradleVersion(gradleVersion)));
            }
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"delegateBuildRun", (boolean)GradleProjectSettings.isDelegatedBuildEnabled(project, projectPath)));
            usages.add(MetricEventFactoryKt.newMetric((String)"preferredTestRunner", (Enum)GradleProjectSettings.getTestRunner(project, projectPath)));
            v5 = ProjectDataManager.getInstance().getExternalProjectData(project, GradleConstants.SYSTEM_ID, projectPath);
            if (v5 == null || (v5 = v5.getExternalProjectStructure()) == null) ** GOTO lbl-1000
            var10_13 = v5;
            var11_14 = false;
            var12_15 = false;
            dataNode = var10_13;
            $i$a$-let-GradleSettingsCollector$getMetrics$hasNonEmptyIntellijConfig$1 = false;
            v5 = ExternalSystemApiUtil.findFirstRecursively((DataNode)dataNode, (BooleanFunction)getMetrics.hasNonEmptyIntellijConfig.1.1.INSTANCE);
            if (v5 == null) ** GOTO lbl-1000
            var10_13 = v5;
            var11_14 = false;
            var12_15 = false;
            it = var10_13;
            $i$a$-let-GradleSettingsCollector$getMetrics$hasNonEmptyIntellijConfig$2 = false;
            v6 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
            v7 = v6.getData();
            if (!(v7 instanceof ConfigurationDataImpl)) {
                v7 = null;
            }
            if ((v5 = (ConfigurationDataImpl)v7) != null) {
                var10_13 = v5;
                var11_14 = false;
                var12_15 = false;
                it = var10_13;
                $i$a$-let-GradleSettingsCollector$getMetrics$hasNonEmptyIntellijConfig$3 = false;
                v8 = it.getJsonString().length() > 2;
            } else lbl-1000:
            // 3 sources

            {
                v8 = false;
            }
            hasNonEmptyIntellijConfig = v8;
            usages.add(MetricEventFactoryKt.newBooleanMetric((String)"ideaSpecificConfigurationUsed", (boolean)hasNonEmptyIntellijConfig));
        }
        return usages;
    }

    private final String anonymizeGradleVersion(GradleVersion version) {
        Object object = Version.parseVersion((String)version.getVersion());
        if (object == null || (object = object.toCompactString()) == null) {
            object = "unknown";
        }
        return object;
    }

    public int getVersion() {
        return 2;
    }
}

